//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/aliaattr.hxx#1 $
//

// aliaattr.hxx - Header file for UtAliasAttr

//----------------------------------------------------------------------
#ifndef CXXUTIL_ALIASATTR_HXX
#define CXXUTIL_ALIASATTR_HXX

//----------------------------------------------------------------------
#ifndef CXXUTIL_BASEATTR_HXX
#include "baseattr.hxx"
#endif

//----------------------------------------------------------------------
//  Protected base class for the attribute system
//----------------------------------------------------------------------
class UtAliasAttr : public UtBaseAttr
//----------------------------------------------------------------------
{
  public:
    UtAliasAttr(const char *name, const char *aliasName);

    const char *aliasName() const {return _aliasName;}

    // Make a new of my type without knowing type
    virtual UtBaseAttr *newOf();

  private:

    // Set state
    virtual UtBaseAttr *setState(UtAttrState);
    
    // Clear changed state
    virtual UtBaseAttr *clearChangedState();

    const char *_aliasName;
};

#endif
