//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/array.hxx#1 $
//

// array.hxx - Header file for UtArrayRep and UtArray

//----------------------------------------------------------------------

#ifndef CXXUTIL_ARRAY_HXX
#define CXXUTIL_ARRAY_HXX

#ifndef CXXUTIL_PORT_HXX
#include <avs/cxxutl/port.hxx>
#endif

#ifndef CXXUTIL_MISC_HXX
#include "misc.hxx"
#endif

// Forward declaration of UtArray which is the container class
template <class TYPE> class UtArray;

//----------------------------------------------------------------------
// Typedef for user supplied function to free user supplied data
//----------------------------------------------------------------------
typedef void UtArrayFree(void *dataPtr);

//----------------------------------------------------------------------
// Internal representation of template class for array of any type
//----------------------------------------------------------------------
template <class TYPE>
class UtArrayRep
//----------------------------------------------------------------------
{
    friend class UtArray<TYPE>;

  protected:

    UtArrayRep();
    UtArrayRep(xp_long size);
    UtArrayRep(const TYPE *array, xp_long size, UtArrayFree *freeData);
    UtArrayRep(const TYPE *array, xp_long size, int readOnly=0);

    ~UtArrayRep();

    // Set array
    void _set(const TYPE *array, xp_long size);

    // return extremes of array, return value !=0 if invalid
    void _updateExtremes();

    // Resize please note that setting it to 0 is legal
    void _resize(xp_long newSize);

    // Calculate how much to add when expanding array size
    // Expand 10% or at least 5
    int _addSize() {
        return UtMax((int) 5, (int) ((_numAlloc*10)/100));
    }

    // Extend size
    void _extendSize(xp_long index);

    // Data members
    xp_long _size, _numAlloc;
    int _readOnly;
    TYPE *_array;
    int _refCount;
    TYPE _min, _max;
    int _extremesValid;
    UtArrayFree *_freeData;

  private:

};
//----------------------------------------------------------------------
// Template class for array of any type
// When copied or passed as an argument the data is not copied
// but a reference count is incremented
// Not before an attemp to change the array is done then new memory is
// allocated and the original is copied to the new memory
//----------------------------------------------------------------------
template <class TYPE>
class UtArray
//----------------------------------------------------------------------
{

  public:

    UtArray();
    UtArray(xp_long size);
    UtArray(const TYPE *array, xp_long size, int readOnly=0);
    UtArray(const TYPE *array, xp_long size, UtArrayFree *freeData);

    // Copy contructor
    UtArray(const UtArray<TYPE> &from);

    virtual ~UtArray();

    void _delete();

    // Assignment operator
    virtual UtArray<TYPE> &operator=(const UtArray<TYPE> &from);

    // Set array
    virtual void set(const TYPE *array, xp_long size, int readOnly=0);
    virtual void set(const TYPE *array, xp_long size, UtArrayFree *freeData);

    // Return current size
    xp_long size() const {
        return _arrayRep->_size;
    }

    // Index function for unsafe assign to operations
    // Fast but dangerous and should only be used where speed is an issue
    TYPE &operator()(xp_long index) {
        return _arrayRep->_array[index];
    }

    // Index function (read only for const objects only)
    const TYPE operator[](xp_long index) const {
        return _arrayRep->_array[index];
    }

    // Index function for safe assign to operations
    // It will automatically extend size and realloc memory when needed
    TYPE &operator[](xp_long index);

    // Return a pointer to the array data
    TYPE *data() const {
        return _arrayRep->_array;
    }

    // Return a pointer to the array data
    operator TYPE*() const {
        return _arrayRep->_array;
    }

    // return extremes of array
    virtual const TYPE min();
    virtual const TYPE max();

    // Remove all from array
    virtual void clear();

    // Resize please note that setting it to 0 is legal
    // The resize function will preserve any existing data
    // in index [0] - [newSize-1]
    virtual void resize(xp_long newSize);

  protected:

    // Data members
    UtArrayRep<TYPE> *_arrayRep;

  private:

};

// This is neccesary for "modern" template instantiation techniques
#ifdef CXX_TEMPLATES_INCLUDE_CXX_FILE
#include "array.cxx"
#endif

#endif // DON'T ADD ANYTHING AFTER THIS #endif
