//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/attrmgr.hxx#1 $
//

// attrmgr.hxx - Header file for UtAttrMgr class

//----------------------------------------------------------------------
#ifndef CXXUTIL_ATTRMGR_HXX
#define CXXUTIL_ATTRMGR_HXX

#ifndef CXXUTIL_PTRSARR_HXX
#include "ptrsarr.hxx"
#endif

#ifndef CXXUTIL_BASEATTR_HXX
#include "baseattr.hxx"
#endif

#ifndef CXXUTIL_ALIASATTR_HXX
#include "aliaattr.hxx"
#endif

//----------------------------------------------------------------------
// Search type for findAttr
//----------------------------------------------------------------------
enum UtAttrSearchType 
//----------------------------------------------------------------------
{
    UtGET_LOCAL,        // Look in local attributes only
    UtDO_SET_CALCULATED,// Doing a set calculated in local attributes
    UtGET_NEW,          // Look in new attributes only
    UtDO_CHANGE,        // Used when changing a value, will set changed state
    UtIS_USER_SET,      // Look recursively up for user set attribute
    UtIS_SET            // Look recursively up for any set attribute

    // The following is not implemented yet
//    UtDO_CHANGE_DOWN    // As DO_CHANGE but will unset in all childrens
};

//----------------------------------------------------------------------
// Class to handle atttribute management
//----------------------------------------------------------------------
class UtAttrMgr 
//----------------------------------------------------------------------
{
  public:

    virtual UtBaseAttr *findAttr(const char *name, 
                                 UtAttrSearchType search);

    // Check if given attribute is set by user
    int isAttrUserSet(const char *name) {
        return (findAttr(name, UtIS_USER_SET) != 0);
    }

    // Check if given attribute has been changed by user
    int isAttrChanged(const char *name) {
        return (findAttr(name, UtGET_NEW)->isState(UtATTR_CHANGED));
    }

    // Check if given attribute is unset in given search scope
    int isAttrUnset(const char *name, UtAttrSearchType search=UtGET_LOCAL) {
        return (findAttr(name, search)->isState(UtATTR_UNSET));
    }

    // Call user update function and reset all updated-flags to set-flags
    void updateAttr();

  protected:
    UtAttrMgr() : _attributes(1), _newAttributes(1) {}
    virtual ~UtAttrMgr() {}
    
    // Find attribute recursively
    virtual UtBaseAttr *_findRecursiveUpAttr(const char *name, 
                                             UtAttrState findFlag);

    // Find attribute skipping through aliases and return real attr name
    UtBaseAttr* _findRealAttr(UtPtrSortedArray<UtBaseAttr> &attributes,
        const char *name, char **realName);

    // For users of UtAttrMgr to define an update function
    virtual void _userUpdateAttr() = 0;

    virtual UtAttrMgr *_parentUtAttrMgr() const {return 0;}

    void _addAttr(UtBaseAttr *baseAttr, int checkUpdate = 0);

    void _addAliasAttr(const char *name, const char *aliasName) {
        _addAttr(new UtAliasAttr(name, aliasName));
    }

    // The storage for the attributes is a sorted array of pointers
    UtPtrSortedArray<UtBaseAttr> _attributes;

    // The storage for the newly changed attributes 
    UtPtrSortedArray<UtBaseAttr> _newAttributes;

    // The list of internal default attributes
    static UtPtrSortedArray<UtBaseAttr> _defaultAttributes;

  private:

    // Private copy and assignment functions to make copying illegal
    // At a later state these should be turned into to public
    // functions doing the "right" thing
    UtAttrMgr(const UtAttrMgr&) : _attributes(0), _newAttributes(0) {}
    UtAttrMgr &operator= (const UtAttrMgr&) {
        return *this;
    }

    static UtBaseAttr _findAttr;
};
#endif

