//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/baseattr.hxx#1 $
//

// baseattr.hxx - Header file for UtBaseAttr

//----------------------------------------------------------------------
#ifndef CXXUTIL_BASEATTR_HXX
#define CXXUTIL_BASEATTR_HXX

//----------------------------------------------------------------------
#include <string.h>

//----------------------------------------------------------------------
// Attribute state
// Please note that bits are used like 1, 2, 4 etc
//----------------------------------------------------------------------
enum UtAttrState 
//----------------------------------------------------------------------
{
    UtATTR_UNSET=1,             // Not set at all
    UtATTR_USER_SET=2,          // Set by user
    UtATTR_CALCULATED=4,        // Set by (calculated by) program
    UtATTR_INIT=8,              // Has init value
    UtATTR_CHANGED=64,          // Used in newAttributes to indicate change
    UtATTR_ALIAS=128,            // This an alias attribute
    // The following masks are NOT for individual setting but for matching
    UtATTR_SET=2+4+8,           // Set either by user or program
    UtATTR_NOT_USER_SET=1+4+8,  // Not set by user
    UtATTR_SET_CHANGED=2+64     // Set and changed
};

//----------------------------------------------------------------------
// Protected base class for the attribute system
// This class DOES NOT store any value
//----------------------------------------------------------------------
class UtBaseAttr
//----------------------------------------------------------------------
{
    friend class UtAttrMgr;

  public:

    UtBaseAttr(const char *name);

    const char *name() const {return _name;}

    // Compare function -1(<), 0(==), 1(>)
    int compare(const UtBaseAttr *other) const;

    UtAttrState getState() const {return _state;}

    int isState(UtAttrState checkState) const {
        return (_state & checkState);
    }
    
    // This virtual destructor is needed because we delete objects 
    // derived from UtBaseAttr by using a pointer to UtBaseAttr
    virtual ~UtBaseAttr();

    // Set state
    virtual UtBaseAttr *setState(UtAttrState s);

    // Clear changed state
    virtual UtBaseAttr *clearChangedState();

    // Make a new of my type without knowing type
    virtual UtBaseAttr *newOf();

    // Init to default values as defined in attribute class
    // The real init is to be defined in either UtAttr or UtPtrAttr
    // This function SHOULD NOT be defined anywhere else than in 
    // UtAttr and UtPtrAttr
    // This function will call _init
    virtual void init();

  protected:

    // This is the virtual validate function
    virtual void _validate();

    // This is the local init for each attribute which 
    // sets the actual value(s)
    virtual void _init();

    // The state flag MUST NOT be more than one bit set at a time
    // except for the changed bit
    UtAttrState _state;

  private:
    const char *_name;
};

#endif
