//			Copyright (c) 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/map.hxx#1 $
//

// Header file for UtMap template class (no source file)

//----------------------------------------------------------------------

#ifndef CXXUTIL_MAP_HXX
#define CXXUTIL_MAP_HXX

#ifndef CXXUTIL_PORT_HXX
#include <avs/cxxutl/port.hxx>
#endif

#ifndef CXXUTIL_VECTOR_HXX
#include <avs/cxxutl/vector.hxx>
#endif


template <class T1, class T2>
struct UtPair {

  UtPair( ) : first(T1()), second(T2()) {}
  UtPair( const T1& _first, const T2& _second ) : first(_first), second(_second) {}

  T1 first;
  T2 second;
};


//----------------------------------------------------------------------
// Map template class patterned after the STL version.
//
// Should be able to swap in the real STL version when all
// platforms/compilers support the STL.
//
//----------------------------------------------------------------------

template <class Key, class Data>
class UtMap
{
  typedef UtMap<Key, Data> self;

  public:

    typedef Key key_type;
    typedef Data data_type;
    typedef UtPair<Key,Data> value_type;
    typedef value_type* pointer;
    typedef const value_type* const_pointer;
    typedef value_type& reference;
    typedef const value_type& const_reference;

    typedef size_t size_type;

  private:
    typedef UtVector<value_type> impl_type;

  public:
#ifdef CXX_TYPENAME
    typedef typename impl_type::iterator iterator;
    typedef typename impl_type::const_iterator const_iterator;
#else
    typedef impl_type::iterator iterator;
    typedef impl_type::const_iterator const_iterator;
#endif

    // default constructor
    UtMap( ) {}

    // destructor
    ~UtMap( ) {}

    // copy constructor
    UtMap( const self& m ) : _container( m._container ) {}

    // assignment operator
    self& operator=( const self& m ) { 
        _container = m._container;
        return *this;
    }

    void swap( self& m ) {
         _container.swap( m._container );
    }

    //UtPair<iterator, bool> insert( const value_type& x );
    void insert( const value_type& x ) {
#ifdef CXX_TYPENAME
        typename impl_type::iterator iter = find( x.first );
#else
        impl_type::iterator iter = find( x.first );
#endif
        if( iter != end( ) ) { 
            iter->second = x.second;
            return;
        }
        // if not in map, add it.
        _container.push_back( x );
    }

    //iterator insert( iterator pos, const value_type& x );

    void erase( iterator pos ) {
        _container.erase( pos );
    }

    //size_type erase( const key_type& k ) {
    void erase( const key_type& k ) {
#ifdef CXX_TYPENAME
        typename impl_type::iterator iter = find( k );
#else
        impl_type::iterator iter = find( k );
#endif
        if( iter != end( ) ) 
            erase( iter );
    }
 
    //void erase( iterator first, iterator last ) {
    //    _container.erase( first, last );
    //}

    iterator find( const key_type& k ) {
#ifdef CXX_TYPENAME
        typename impl_type::iterator iter = _container.begin( );
        typename impl_type::iterator iend = _container.end( );
#else
        impl_type::iterator iter = _container.begin( );
        impl_type::iterator iend = _container.end( );
#endif
        // search for key.
        for( ; iter != iend; ++iter ) {
            if( k == iter->first ) {
                return iter;
            }
        }
        // not in map,
        return _container.end( );
    }

    const_iterator find( const key_type& k ) const {
#ifdef CXX_TYPENAME
        typename impl_type::const_iterator iter = _container.begin( );
        typename impl_type::const_iterator iend = _container.end( );
#else
        impl_type::const_iterator iter = _container.begin( );
        impl_type::const_iterator iend = _container.end( );
#endif
        // search for key.
        for( ; iter != iend; ++iter ) {
            if( k == iter->first ) {
                return iter;
            }
        }
        // not in map,
        return _container.end( );
    }

    iterator begin( ) { return _container.begin( ); }
    const_iterator begin( ) const { return _container.begin( ); }
    iterator end( ) { return _container.end( ); }
    const_iterator end( ) const { return _container.end( ); }

    // In a map, this should never be more than 1.
    size_type count( const key_type& k ) {
#ifdef CXX_TYPENAME
        typename impl_type::iterator iter = _container.begin( );
        typename impl_type::iterator iend = _container.end( );
#else
        impl_type::iterator iter = _container.begin( );
        impl_type::iterator iend = _container.end( );
#endif
        size_type cnt = 0;

        for( ; iter != iend; ++iter ) {
            if( k == iter->first ) ++cnt;
        }
        return cnt;
    }

    size_type size( ) const { return _container.size( ); }
    bool empty() const { return _container.empty( ); }

    data_type& operator[]( const key_type& k ) {
#ifdef CXX_TYPENAME
        typename impl_type::iterator iter = _container.begin( );
        typename impl_type::iterator iend = _container.end( );
#else
        impl_type::iterator iter = _container.begin( );
        impl_type::iterator iend = _container.end( );
#endif
        // search to see if the key is already in the map
        for( ; iter != iend; ++iter ) {
            if( k == iter->first ) {
                return iter->second;  // return reference to data element;
            }
        }
        // if not in map, add it.
        _container.push_back( value_type( k, data_type( ) ) );
        // assume new element is at the end.
        return _container.back().second;  // return reference to data element.
    }

  private:

    impl_type _container;
};
#endif

