//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/ptrlist.cxx#1 $
//

// ptrlist.cxx - Source file for UtPtrList, UtPtrSortedList 
//               and UtPtrListIter classes

#ifndef CXXUTIL_PTRLIST_CXX
#define CXXUTIL_PTRLIST_CXX

//----------------------------------------------------------------------
#ifndef CXXUTIL_PTRLIST_HXX
#include "ptrlist.hxx"
#endif

//----------------------------------------------------------------------
// Destructor check for delete of elements
//----------------------------------------------------------------------
template <class TYPE>
UtPtrList<TYPE>::~UtPtrList() 
//----------------------------------------------------------------------
{
    clear(_doDelete);
}

//----------------------------------------------------------------------
// Add element to end of list
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrList<TYPE>::addLast(
    TYPE *element) 
//----------------------------------------------------------------------
{
    UtPtrListObj::addLast(_first, _last, (void*)element);
}

//----------------------------------------------------------------------
// Add element to beginning of list
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrList<TYPE>::addFirst(
    TYPE *element) 
//----------------------------------------------------------------------
{
    UtPtrListObj::addFirst(_first, _last, (void*)element);
}

//----------------------------------------------------------------------
// Remove first (if any) element from list
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrList<TYPE>::removeFirst() 
//----------------------------------------------------------------------
{
    UtPtrListObj::removeFirst(_first, _last);
}

//----------------------------------------------------------------------
// Remove last (if any) element from list
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrList<TYPE>::removeLast() 
//----------------------------------------------------------------------
{
    UtPtrListObj::removeLast(_first, _last);
}

//----------------------------------------------------------------------
// Remove given element by searching the list from the beginning
// If not found then do nothing
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrList<TYPE>::remove(
    TYPE *element) 
//----------------------------------------------------------------------
{
    UtPtrListObj::remove(_first, _last, (void*)element);
}

//----------------------------------------------------------------------
// return first element in list or 0 in empty list
//----------------------------------------------------------------------
template <class TYPE> 
TYPE*
UtPtrList<TYPE>::getFirst() 
const 
//----------------------------------------------------------------------
{
    TYPE *value=0;
    if (_first) {
        value = (TYPE*)_first->_element;
    }
    return value;
}


//----------------------------------------------------------------------
// return last element in list or 0 in empty list
//----------------------------------------------------------------------
template <class TYPE> 
TYPE*
UtPtrList<TYPE>::getLast() 
const 
//----------------------------------------------------------------------
{
    TYPE *value=0;
    if (_last) {
        value = (TYPE*)_last->_element;
    }
    return value;
}

//----------------------------------------------------------------------
// Remove all elements from UtPtrList
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrList<TYPE>::clear(int doDelete) 
//----------------------------------------------------------------------
{

    UtPtrListObj *next = _first, *remove;

    while (next) {
        remove = next;
        next = remove->_next;
        if (doDelete) delete (TYPE*)remove->_element;
        delete remove;
    }
    _first = _last = 0;
}

//----------------------------------------------------------------------
// Add sorted after any of same value before any of higher value
//----------------------------------------------------------------------
template <class TYPE> 
void 
UtPtrSortedList<TYPE>::addSorted(
    TYPE *element) 
//----------------------------------------------------------------------
{
    // Empty list
    if (!this->_first) {
        addFirst(element);
    }
    // if first element in list is bigger than new element then also insert
    // at the beginning of the list
    // N.B. The cast must be from a pointer to a pointer. RWO - 8/28/97
    else if (*(TYPE*)(this->_first->_element) > *(TYPE*)element) {
        addFirst(element);
    }
    // if last element in list is <= value of new element then insert at end
    // N.B. The cast must be from a pointer to a pointer. RWO - 8/28/97
    else if (*(TYPE*)(this->_last->_element) <= *(TYPE*)element) {
        addLast(element);
    }
    // Find place to insert and insert in sorted order
    else {
        UtPtrListObj *search = this->_first;
        while (search) {
            // is this the place to insert
            // N.B. The cast must be from a pointer to a pointer. RWO - 8/28/97
            if (*(TYPE*)(search->_element) > *(TYPE*)element) {
                UtPtrListObj *insert = new UtPtrListObj;
                insert->_element = element;
                insert->_previous = search->_previous;
                insert->_next = search;
                insert->_previous->_next = insert;
                search->_previous = insert;
                break;
            }
            search = search->_next;
        }
    }
}

//----------------------------------------------------------------------
// UtPtrListIter constructors
//----------------------------------------------------------------------
template <class TYPE> 
UtPtrListIter<TYPE>::UtPtrListIter(
    const UtPtrList<TYPE> &list)
        : _current(0), _list(list) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
template <class TYPE> 
UtPtrListIter<TYPE>::UtPtrListIter(
    const UtPtrSortedList<TYPE> &list)
        : _current(0), _list((UtPtrList<TYPE>&)list) 
//----------------------------------------------------------------------
{}


//----------------------------------------------------------------------
// iterate from begining
//----------------------------------------------------------------------
template <class TYPE>
TYPE* 
UtPtrListIter<TYPE>::next() 
//----------------------------------------------------------------------
{
    // first time or restart from beginning
    if (_current == 0) {
        _current = _list._first;
    } 
    // in iteration
    else {
        _current = _current->_next;
    }
    if (_current) {
        return (TYPE*)_current->_element;
    } else {
        return 0;
    }
}

//----------------------------------------------------------------------
// iterate from end
//----------------------------------------------------------------------
template <class TYPE>
TYPE* 
UtPtrListIter<TYPE>::previous() 
//----------------------------------------------------------------------
{
    // first time or restart from beginning
    if (_current == 0) {
        _current = _list._last;
    } 
    // in iteration
    else {
        _current = _current->_previous;
    }
    if (_current) {
        return (TYPE*)_current->_element;
    } else {
        return 0;
    }
}

#endif
