//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/ptrlist.hxx#1 $
//

// ptrlist.hxx - Header file for UtPtrList, UtPtrSortedList 
//               and UtPtrListIter classes

//----------------------------------------------------------------------

#ifndef CXXUTIL_PTRLIST_HXX
#define CXXUTIL_PTRLIST_HXX

#ifndef CXXUTIL_PORT_HXX
#include <avs/cxxutl/port.hxx>
#endif

#include "ptrlisto.hxx"

// Forward class declarations
template <class TYPE> class UtPtrList;
template <class TYPE> class UtPtrSortedList;
template <class TYPE> class UtPtrListIter;

//----------------------------------------------------------------------
// Double pointed list of pointers
//----------------------------------------------------------------------
template <class TYPE> 
class UtPtrList 
//----------------------------------------------------------------------
{
    friend class UtPtrListIter<TYPE>;
    
  public:
    // When doDelete is set then all elements are deleted in destructor
    UtPtrList(int doDelete=1) 
        : _first(0), _last(0), _doDelete(doDelete) {}
    virtual ~UtPtrList();

    // Add as last element in UtPtrList
    void addLast(TYPE *element);

    // Add as first element in UtPtrList
    void addFirst(TYPE *element);
    
    // Remove first element in UtPtrList
    void removeFirst();
    
    // Remove last element in UtPtrList
    void removeLast();
    
    // Search list for given element and remove first (if any) which is found 
    void remove(TYPE *element);

    // Remove all elements from UtPtrList
    void clear(int doDelete=1);
    
    // Get first element in UtPtrList
    TYPE *getFirst() const;

    // Get last element in UtPtrList
    TYPE *getLast() const;

    // is UtPtrList empty ?
    int isEmpty() const {return _first == 0;}
    
    // copy constructor creates empty UtPtrList
    UtPtrList(const UtPtrList<TYPE>&) {
        _first = _last = 0;
    }
    
    // Assignment has no effect .i.e leaves UtPtrList intact
    UtPtrList<TYPE> &operator=(const UtPtrList<TYPE>&) {
        return *this;
    }

  protected:
    
    UtPtrListObj *_first, *_last;
    int _doDelete;
    
};

//----------------------------------------------------------------------
// Sorted double pointed list of any type
// Please note the private inheritance
//----------------------------------------------------------------------
template <class TYPE> 
class UtPtrSortedList : private UtPtrList<TYPE> 
//----------------------------------------------------------------------
{
    friend class UtPtrListIter<TYPE>;

  public:
    UtPtrSortedList(int doDelete=1) : UtPtrList<TYPE>(doDelete) {}
    // Add sorted after last of same value before any of higher value
    void addSorted(TYPE *element);
    // Access specifiers makes the following public
    UtPtrList<TYPE>::clear;
    UtPtrList<TYPE>::remove;
    UtPtrList<TYPE>::isEmpty;
    
};

//----------------------------------------------------------------------
// Iterator for UtPtrList and UtPtrSortedList
//----------------------------------------------------------------------
template <class TYPE> 
class UtPtrListIter 
//----------------------------------------------------------------------
{

  public:
    UtPtrListIter(const UtPtrList<TYPE> &list); 
    UtPtrListIter(const UtPtrSortedList<TYPE> &list) ;

    // iterate from begining
    TYPE *next();

    // iterate from end
    TYPE *previous();
	    
  private:
    // in iteration ?
    UtPtrListObj *_current;
    const UtPtrList<TYPE> &_list;
};
    

// This is neccesary for "modern" template instantiation techniques
#ifdef CXX_TEMPLATES_INCLUDE_CXX_FILE
#include "ptrlist.cxx"
#endif

#endif
