//			Copyright (c) 1993, 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/string.hxx#1 $
//

// Header file for UtString class

//----------------------------------------------------------------------

#ifndef CXXUTIL_STRING_HXX
#define CXXUTIL_STRING_HXX

#ifndef CXXUTIL_PORT_HXX
#include <avs/cxxutl/port.hxx>
#endif

#include <stddef.h>    // needed for size_t on some platforms

#ifdef XP_STD_IOSTREAM
#include <iostream>
using std::istream;
using std::ostream;
#else
#include <iostream.h>
#endif

//----------------------------------------------------------------------
class UtString 
//----------------------------------------------------------------------
{
//----------------------------------------------------------------------
  public:
//----------------------------------------------------------------------
    UtString();
    UtString(const char*);
    UtString(const char* string, size_t numChar);
    UtString(const UtString&);
    UtString(const UtString&, size_t pos, size_t len);
    UtString(size_t numChar, char c);

    ~UtString();

    char operator[](size_t elem) const { return _str[elem]; }
    char& operator[](size_t elem) { return _str[elem]; }
    //char operator[](int elem) const { return _str[elem]; }
    //char& operator[](int elem) { return _str[elem]; }

    UtString& operator=(const UtString&);
    UtString& operator=(const char*);

    const char * c_str() const { return _str ? _str : ""; }

    UtString& operator+=(const UtString&);
    UtString& operator+=(const char *);
    UtString& operator+=(char c) { return append( c ); }
    UtString& append(char c);

    UtString  substr(size_t, size_t);

    size_t    size( )   const { return _size; }
    size_t    length( ) const { return size(); }
    size_t    capacity() const { return _capacity; }
    bool      empty( )  const { return size() == 0; }

    void      reserve( size_t new_capacity );

    UtString& collapse();  // not std
    UtString& trim();      // not std
    UtString& lower();     // not std
    UtString& upper();     // not std

    // Standard string iterators

    typedef char * iterator;

    iterator  begin( ) { return _str; }
    const iterator begin( ) const { return _str; }
    iterator  end( ) { return _str + _size; }
    const iterator end( ) const { return _str + _size; }

//----------------------------------------------------------------------
  private:
//----------------------------------------------------------------------

    void alloc_copy( size_t new_capacity );
    void alloc_no_copy( size_t new_capacity );

    char *_str;
    size_t _size;
    size_t _capacity;
};


bool operator==(const UtString& s1, const UtString& s2);
bool operator==(const UtString& s1, const char *s2);
inline int operator==(const char *s1, const UtString &s2) { return( s2 == s1 ); }

bool operator!=(const UtString& s1, const UtString& s2);
bool operator!=(const UtString& s1, const char *s2);
inline int operator!=(const char *s1, const UtString &s2) { return( s2 != s1 ); }

bool operator<(const UtString& s1, const UtString& s2);
bool operator<(const UtString& s1, const char *s2);
bool operator<(const char *s1, const UtString &s2);

//bool operator<=(const UtString& s1, const UtString& s2);
//bool operator<=(const UtString& s1, const char *s2);
//bool operator<=(const char *s1, const UtString &s2);

bool operator>(const UtString& s1, const UtString& s2);
bool operator>(const UtString& s1, const char *s2);
bool operator>(const char *s1, const UtString &s2);

//bool operator>=(const UtString& s1, const UtString& s2);
//bool operator>=(const UtString& s1, const char *s2);
//bool operator>=(const char *s1, const UtString &s2); 

UtString operator+(const UtString&, const UtString&);
UtString operator+(const UtString&, const char*);

istream& operator>>(istream&, UtString&);
ostream& operator<<(ostream&, const UtString&);

#endif

