//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/typeattr.hxx#1 $
//

// typeattr.hxx - Header file for basic type attributes

//----------------------------------------------------------------------
#ifndef CXXUTIL_TYPEATTR_HXX
#define CXXUTIL_TYPEATTR_HXX

#ifndef CXXUTIL_ATTR_HXX
#include "attr.hxx"
#endif

#ifndef CXXUTIL_PTRATTR_HXX
#include "ptrattr.hxx"
#endif

#ifndef CXXUTIL_ENUM_HXX
#include "enum.hxx"
#endif

#ifndef CXXUTIL_STRING_HXX
#include "string.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class for enum attribute types 
// Allowing for set of char* and int
//----------------------------------------------------------------------
class UtBaseEnumAttr : public UtAttr<UtBaseEnum>
//----------------------------------------------------------------------
{
  public:
    void set(int value);
    void set(const char *value);
    void set(const UtBaseEnum &value);

  protected:
    UtBaseEnumAttr(const char *name);
    virtual void _validate();
};

//----------------------------------------------------------------------
// Protected base class for boolean
//----------------------------------------------------------------------
class UtBooleanAttr : public UtAttr<int>
//----------------------------------------------------------------------
{
  protected:
    UtBooleanAttr(const char *name);
    virtual void _validate();
};

//----------------------------------------------------------------------
// Protected base class for string attribute types
//----------------------------------------------------------------------
class UtStringAttr : public UtPtrAttr<UtString>
//----------------------------------------------------------------------
{
  protected:
    UtStringAttr(const char *name);
    virtual void _validate();
};

#endif
