/*
                Copyright (c) 1999 by
                Advanced Visual Systems Inc.
                All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/data_utils.h#1 $
*/

#ifndef DATA_UTILS_INCLUDED
#define DATA_UTILS_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

int UTILdouble_to_type( void *dst, double src, int dtype );
int UTILfloat_to_type( void *dst, float src, int dtype );
int UTILxp_long_to_type( void *dst, xp_long src, int dtype );
int UTILint_to_type( void *dst, int src, int dtype );
int UTILshort_to_type( void *dst, short src, int dtype );
int UTILchar_to_type( void *dst, char src, int dtype );

int UTILtype_to_double( double *dst, const void *src, int dtype );
int UTILtype_to_float( float *dst, const void *src, int dtype );
int UTILtype_to_xp_long( xp_long *dst, const void *src, int dtype );
int UTILtype_to_int( int *dst, const void *src, int dtype );
int UTILtype_to_short( short *dst, const void *src, int dtype );
int UTILtype_to_char( char *dst, const void *src, int dtype );

int UTILcopy_array( void *dst, const void *src, size_t n, int dtype );
int UTILinit_array( void *dst, size_t n, double val, int dtype );

int UTILcheck_list( xp_long *list, xp_long size, xp_long min_val, xp_long max_val,
                    xp_long *bad_index, xp_long *bad_value );

#ifdef WORDLENGTH_64
int UTILcheck_list_n( int *list, int size, int min_val, int max_val,
                    int *bad_index, int *bad_value );
#endif

int UTILcalc_minmax( size_t n, int veclen, void *data, int dtype, int null_flag,
                     void* null_value, void *min, void *max);
int UTILcalc_min( size_t n, int veclen, void *data, int dtype, 
                  int null_flag, double null_value, void *min );
int UTILcalc_max( size_t n, int veclen, void *data, int dtype, 
                  int null_flag, double null_value, void *max );
int UTILcalc_mag( size_t n, int veclen, void *data, int dtype, void *mag );
int UTILcalc_mag_minmax( size_t n, int veclen, void *data, int dtype, int null_flag,
                         void *null_value, void *min, void *max );
int UTILcalc_std_deviation( size_t n, void *data, int dtype, double *dev );

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
   #define	UTILcheck_list		UTILcheck_list_n
#endif

#ifdef __cplusplus
}
#endif

#endif
