/*
			Copyright (c) 1999 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/dbil.h#1 $
*/

/* Start dbil.h */

#ifndef DB_TYPES_DEFINED
	#define DB_TYPES_DEFINED 1

	/* ------------------------------------------------------------------ */
	/*                            DEFINITIONS                             */
	/* ------------------------------------------------------------------ */


	#ifndef TRUE
		#define TRUE                          1
	#endif

	#ifndef FALSE  
		#define FALSE                         0
	#endif

	/* return codes >0 failed request but can reissue */

	#define SUCCESS                       0   /* (but maybe no data or dupe key) */
	#define USER_ERROR                    1   /* Invalid SQL */
	#define INVALID_REQUEST               2   /* Invalid request */
	#define OUT_OF_MEMORY                 3   /* Insufficient memory for request */
	#define RECOVERABLE_DATABASE_ERROR    4   /* Recoverable database error */
	#define FATAL_DATABASE_ERROR          5   /* Fatal database error */
	#define NOT_YET_IMPLEMENTED           6   /* functionality not present */
	#define UNKNOWN_ERROR					  7   /* other misc errors */

	static const char *SQL_RETURN_STRING[]={"Success", "Invalid SQL statement", "Invalid request",
						"Insufficient memory for request", "Recoverable database error",
						"Fatal database error", "Functionality not implemented",
						"Unknown error"};



	/* 'C' datatypes used as hostvars */

	#define UNSUPPORTED_TYPE              0   /* e.g blob data > 255 bytes */
	#define INT_TYPE		      1   /* signed integer */
	#define SHORT_TYPE                    2   /* signed short */
	#define TINYINT_TYPE                  3   /* signed char */
	#define UNSIGNED_INT_TYPE             4   /* unsigned int */
	#define FLOAT_TYPE                    5   /* float */
	#define DOUBLE_TYPE                   6   /* double precision */
	#define STRING_TYPE                   7   /* null terminated string */
	#define BYTE_ARRAY_TYPE               8   /* fixed length byte array */
						  /* with no terminating nulls*/


	/* Oracle sql return codes used  - note these are cda.rc codes*/
	/* Just some of the more common ones */

	#define LENGTH_TOO_LONG             910
	#define INVALID_CHARACTER           911  /* normally a semi-colon - not wanted */
	#define TOO_MANY_VALUES             913
	#define VAR_NOT_IN_LIST            1007
	#define NOT_LOGGED_ON              1012
	#define USER_REQUESTED_CANCEL      1013
	#define VALUE_TOO_BIG_TO_INSERT    1401
	#define NO_DATA_FOUND              1403  /* end of ofen */
	#define NULL_VALUE_RETURNED        1405  /* returned by ofen at column level */ 
	#define FETCHED_VAL_TRUNCATED      1406       
	#define NUMERIC_OVERFLOW           1426  /* e.g overloading a float */
	#define FIXED_OVERFLOW             1455  /* e.g overloading an int */
	#define UNSELECTABLE_DATATYPE      3115


	/* Constants */

	#define MAX_INPUT_VARIABLES           1  /* max input bound variables */
	#define MAX_OUTPUT_VARIABLES        256  /* max output bound variables */
	#define MAX_SQL_IDENTIFIER_LENGTH    50  /* max sql column identifier length */
	#define MAX_SQL_STATEMENT_SIZE    32000  /* max bytes for sql statement */
	#define ERRLEN                     1024  /* max bytes for error messages */

	/* Max size of fetchbuf for any column  (max data item size * rows_per_fetch) */

	#define ORACLE_MAX_ARRAY_BYTES    32000  /* OCI 7.1 won't support more */
	#define SYBASE_MAX_ARRAY_BYTES   512000  /* ..rest are arbitrary */  
	#define INFORMIX_MAX_ARRAY_BYTES 512000  
	#define ODBC_MAX_ARRAY_BYTES     512000  

	/* Max length of longest retrievable field */
	#define MAX_ORACLE_CHAR_LENGTH     2000  /* VARCHAR2     */
	#define MAX_SYBASE_CHAR_LENGTH      255  /* CHAR & VARCHAR */
	#define MAX_INFORMIX_CHAR_LENGTH  32767  /* CHAR         */  
	#define MAX_ODBC_CHAR_LENGTH        254  /* SQL_CHAR & SQL_VARCHAR  */

	/* REQUESTS - Sql requests supported */
	/*
	#define CONNECT                       1   
	#define DISCONNECT                    2   
	#define SELECT                        3     
	#define FETCH                         4     
	#define INSERT                        5     
	#define UPDATE                        6     
	#define DELETE                        7  
	#define COMMIT                        8
	#define ROLLBACK                      9 
	#define MISCSQL                      79
	*/
	/* REQUESTS - non-sql control requests supported      */
	/* Both CANCEL and RELEASE release all fetch&userbufs */

	#define CANCEL                       90  /* cancel select or fetch + release */
	#define RELEASE                      91  /* release all fetch & userbufs */


	/* db_engine_types */

	#define ORACLE                        1  /* including Oracle MD */
	#define SYBASE                        2
	#define INFORMIX                      3
	#define ODBC                          4


	/* dbil defined isolation levels */
	/* use these in dbv->isolation level - will
		be translated to dbspecific value by
		dbspecific module */


	#define ISOLATION_READ_UNCOMMITTED  1
	#define ISOLATION_READ_COMMITTED    2
	#define ISOLATION_REPEATABLE_READ   3
	#define ISOLATION_SERIALIZABLE      4
	#define ISOLATION_VERSIONING	    5

	typedef void *(*PFV) ();

	// Turn off 'inheritance via dominance warnings for VC++ 5.0
	//   OMX generated stuff causes tons of these warnings
	//
	#ifdef MSDOS
		#pragma warning(disable:4250)
	#endif

	#define DBIL_SELECT_PRIVILEGE 0x01
	#define DBIL_UPDATE_PRIVILEGE 0x02
	#define DBIL_INSERT_PRIVILEGE 0x04
	#define DBIL_DELETE_PRIVILEGE 0x08

	// Define supported APIs
	//
	#define NUM_OF_DRIVERS 4

	typedef enum {
		DBIL_Unknown_API = 0,
		DBIL_SDE_API,
		DBIL_SDO_API,
		DB_ORACLE_API,
		DB_ODBC_API
	} DBIL_Supported_APIs;

	// Define possible return codes
	//
	typedef enum {
		DBIL_OK = 0,
		DBIL_Unsupported,
		DBIL_Error,
		DBIL_Canceled,
		DBIL_No_Data,
		DBIL_Complete,
		DBIL_No_Memory,
		DBIL_Unsupported_Datatype,
		DBIL_Null_Data,
		DBIL_Bad_Shape,
		DBIL_Timeout,
		DBIL_Buffer_Full
	} DBIL_Status;

	// Define data types to deal with
	//
	typedef enum DBIL_DATA_TYPES {
		DBIL_BYTE_TYPE = 0,
		DBIL_SMALLINT_TYPE,
		DBIL_UINT_TYPE,
		DBIL_INTEGER_TYPE,
		DBIL_FLOAT_TYPE,
		DBIL_DOUBLE_TYPE,
		DBIL_STRING_TYPE,
		DBIL_RAW_TYPE,
		DBIL_LONG_TYPE,
		DBIL_LONGRAW_TYPE,
		DBIL_DATE_TYPE,
		DBIL_SHAPE_TYPE,
		DBIL_BLOB_TYPE,
		DBIL_CLOB_TYPE
	} DBIL_DATA_TYPES;

	// Define what 'type' of shapes we can handle
	//
	typedef enum DBIL_SHAPES {
		DBIL_UNKNOWN_SHAPE = 0,
		DBIL_POINT_SHAPE,
		DBIL_LINE_SHAPE,
		DBIL_AREA_SHAPE
	} DBIL_SHAPES;

	// Supported spatial filter methods
	//
	typedef enum DBIL_FILTER_METHODS {
		DBIL_NO_FILTER_METHOD = 0,
		DBIL_ENVELOPE_METHOD,
		DBIL_COMMON_POINT_METHOD, 
		DBIL_LINE_CROSS_METHOD, 
		DBIL_COMMON_EDGE_METHOD,
		DBIL_CP_OR_LCROSS_METHOD,
		DBIL_II_OR_ET_METHOD,
		DBIL_AI_METHOD,
		DBIL_AI_NO_ET_METHOD,
		DBIL_PC_METHOD,
		DBIL_SC_METHOD,
		DBIL_PC_NO_ET_METHOD,
		DBIL_SC_NO_ET_METHOD,
		DBIL_PIP_METHOD,
		DBIL_IDENTICAL_METHOD
	} DBIL_FILTER_METHODS;

	// Supported spatial filter types
	//
	typedef enum DBIL_FILTER_TYPES {
		DBIL_FILTER_TYPE_NOTSET = 0,
		DBIL_FILTER_SHAPE,
		DBIL_FILTER_ID
	} DBIL_FILTER_TYPES;

	#ifndef BOOL
		#define BOOL int
	#endif

	// Structure to hold column description
	//
	typedef struct DBIL_Column_Def {
		char *column_name;
		int dbil_type;
		int size;
		int decimal_digits;
		BOOL nulls_allowed;
	} DBIL_COLUMN_DEF;

	// Status callback
	//
	typedef void (*DBIL_Status_Callback)( int, int* );
	typedef void (*DB_Status_Callback)( int, void*, int* );

	typedef void (*DBIL_Free_Ptr) ( void *);
	typedef DBIL_Free_Ptr funcp;

	typedef struct DB_Output_Stat {
		int               num_fetches_for_query;
		int	            rows_processed;
		int					total_rows_retrieved;
		int               userbuf_rows_allocated;
		int               userbuf_rows_used;
		int               userbuf_bytes_allocated;
		int					statement_error_offset;
		int					row_specific_error_cnt;
		char *            db_specific_error_message;
		int               db_specific_error_code;
	} DB_OUTPUT_STAT;

	// Global array of instance functions
	// Currently there are 4 interfaces defines, only the last 2 active
	// The first Instancer[0] is a dummy one. See DBIL_Supported_APIs for the list
	extern	PFV	Instancer[NUM_OF_DRIVERS+1];

#endif
