/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/dbxx/elem_c.h#1 $
*/
#if !defined(dbxx_h) || !defined(dbxx_elem_c_h)
#define dbxx_h         1
#define dbxx_elem_c_h     1

#ifndef DB_INCLUDED
#include <avs/db.h>
#endif

#ifndef True
#    define True         1
#endif

#ifndef False
#    define False        0
#endif

#ifdef CRAY
typedef long            Boolean;
#else
typedef char            Boolean;
#endif



/////////////////////////////////////
class DBcallback {
/////////////////////////////////////
  public:
                        DBcallback (
                            DBpfi,
                            void *clientData,
                            DBtype_id type = 0,
                            const char *name = "");
                        ~DBcallback ();

                        operator DBelem_id () const;
  private:
      DBelem_id         _id;
};

inline
DBcallback::DBcallback (
    DBpfi func, void *clientData, DBtype_id type, const char *name)
{
    _id = DBcreate_callback_elem (DBstr_to_name (name), func, type, clientData);
}

inline
DBcallback::~DBcallback ()
{
    if (!DBis_null_elem(_id)) (void) DBdestroy_elem(_id,0);
}

inline
DBcallback::operator DBelem_id () const
{
    return _id;
}

/////////////////////////////////////
class DBelem_c {
/////////////////////////////////////
  public:
                        DBelem_c (
                            DBelem_id id,
                            const char *name = 0,
                            int mode = DB_ELEM_RW);
                        DBelem_c (
                            const char *objType,
                            const char *name = "",
                            DBelem_id parent = DBinst_elem,
                            int mode = DB_ELEM_RW);
    virtual                ~DBelem_c ();

    DBelem_id           id () const;

    int                 destroy ();

    const char *        name () const;
    void                print (FILE *fp = 0) const;

    virtual             operator DBelem_id () const;
    Boolean             operator== (DBelem_id rhs) const;
    Boolean             operator!= (DBelem_id rhs) const;

    virtual Boolean     isNil () const;
    Boolean             isValid () const;
    Boolean             inSameProcess (DBelem_id) const;
    unsigned int        getSeq (
                            int flags = DB_SEQ_VAL,
                            DBelem_id tmplt = DBnull_elem
                        );

    virtual Boolean     match (DBelem_id matchElem, int mode = DB_MATCH_POSS);
    virtual Boolean     match (const char * tmplClass, int mode = DB_MATCH_POSS);

    void                pushCtx ();
    void                popCtx ();

    void                addNotify (
                        DBcallback *cb,
                        DBelem_id context = DBnull_elem,
                        unsigned int mask = DB_EVENT_VAL,
                        DBelem_id tplt = DBnull_elem,
                        int mode = 0);
    void                delNotify (
                            DBcallback *cb,
                            DBelem_id context = DBnull_elem,
                            unsigned int mask = DB_EVENT_VAL,
                            DBelem_id tplt = DBnull_elem,
                            int mode = 0);

    int                 getIntSubelem (
			    const char *name,
			    int &valret,
			    int dflt = 0);
    int                 setIntSubelem (const char *name, int val);

    int                 getLongSubelem (
			    const char *name,
			    xp_long &valret,
			    xp_long dflt = 0);
    int                 setLongSubelem (const char *name, xp_long val);

    int                 getRealSubelem (
			    const char *name,
			    double &valret,
			    double dflt = 0.);
    int                 setRealSubelem (const char *name, double val);

    int                 getStringSubelem (
			    const char *name,
			    char **valret,
			    char *dflt = 0);
    int                 setStringSubelem (const char *name, const char *val);

    int                 getRefSubelem (
			    const char *name,
			    DBelem_id &elemret,
			    DBelem_id &dflt = DBnull_elem);
    int                 setRefSubelem (const char *name, DBelem_id &val);

  private:
    DBelem_id           _id;
};

// In-line functions for DBelem_c

inline
DBelem_id DBelem_c::id () const
{
   return _id;
}

inline
Boolean  DBelem_c::operator == (DBelem_id rhs) const
{
    return (_id.proc_id == rhs.proc_id) && (_id.elem_id == rhs.elem_id);
}

inline
Boolean  DBelem_c::operator != (DBelem_id rhs) const
{
    return !((_id.proc_id == rhs.proc_id) && (_id.elem_id == rhs.elem_id));
}

inline
Boolean DBelem_c::isValid () const
{
    return DBvalid_elem (_id, DBnull_elem, 0);
}

inline
Boolean DBelem_c::isNil () const
{
    return DBis_null_elem (id ());
}

inline
Boolean DBelem_c::inSameProcess (DBelem_id elemId) const
{
    return _id.proc_id == elemId.proc_id;
}

inline
void DBelem_c::print (FILE *fp) const
{
    DBprint_elem_mode(_id, fp, 0);
}

inline
void DBelem_c::pushCtx ()
{
    DBpush_ctx (_id,DB_STATE_USR,0,0);
}

inline
void DBelem_c::popCtx ()
{
    DBpop_ctx (_id);
}


inline
unsigned int DBelem_c::getSeq (int flags, DBelem_id tmplt)
{
    return DBget_elem_seq (_id, tmplt, flags);
}

class DBfunc : public DBelem_c {
  public:
             DBfunc (DBelem_id id, const char *name = 0) : DBelem_c (id, name) {}
    virtual ~DBfunc ();
    DBpfi  getFunc ();
    int    setFunc (DBpfi function);
};

#endif /* dbxx_h || dbxx_elem_c_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/int.h#1 $
*/
#ifndef dbxx_int_h
#define	dbxx_int_h		1

/////////////////////////////////////
class DBint: public DBelem_c {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBint (
                            DBelem_id elemId,
                            const char *name = 0,
                            int mode = DB_ELEM_RD);
                        ~DBint ();

    // getting and setting
    int			getValue (int &value, int dflt = 0) const;
    int			setValue (int v);

    			operator int () const;
    DBint & 		operator= (int rhs);
    int  		operator += (int rhs);
    int  		operator -= (int rhs);
    int  		operator == (int rhs) const;
    int  		operator != (int rhs) const;
    int  		operator < (int rhs) const;
    int  		operator <= (int rhs) const;
    int  		operator > (int rhs) const;
    int  		operator >= (int rhs) const;
};

inline
DBint::operator int () const { int value;  getValue (value); return value; }

inline
DBint & DBint::operator= (int rhs) { setValue (rhs); return *this; }

inline
int DBint::operator == (int rhs) const { return operator int () == rhs; }

inline
int DBint::operator != (int rhs) const { return operator int () != rhs; }

inline
int DBint::operator < (int rhs) const { return operator int () < rhs; }

inline
int DBint::operator <= (int rhs) const { return operator int () <= rhs; }

inline
int DBint::operator > (int rhs) const { return operator int () > rhs; }

inline
int DBint::operator >= (int rhs) const { return operator int () >= rhs; }

#endif /* dbxx_int_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/long.h#1 $
*/
#ifndef dbxx_long_h
#define dbxx_long_h	1

/////////////////////////////////////
class DBlong: public DBelem_c {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBlong (
                            DBelem_id elemId,
                            const char *name = 0,
                            int mode = DB_ELEM_RD);
                        ~DBlong ();

    // getting and setting
    int		    getValue (xp_long &value, xp_long dflt = 0) const;
    int			setValue (xp_long v);

    			operator xp_long () const;
    DBlong & 		operator= (xp_long rhs);
    xp_long		operator+= (xp_long rhs);
    xp_long		operator-= (xp_long rhs);
    int			operator== (xp_long rhs) const;
    int			operator!= (xp_long rhs) const;
    int			operator < (xp_long rhs) const;
    int			operator <= (xp_long rhs) const;
    int			operator > (xp_long rhs) const;
    int			operator >= (xp_long rhs) const;
};

inline
DBlong::operator xp_long () const { xp_long v; getValue (v); return v; }

inline
DBlong & DBlong::operator= (xp_long rhs) { setValue (rhs); return *this; }

inline int
DBlong::operator == (xp_long rhs) const { return operator xp_long () == rhs; }

inline int
DBlong::operator != (xp_long rhs) const { return operator xp_long () != rhs; }

inline int
DBlong::operator < (xp_long rhs) const { return operator xp_long () < rhs; }

inline int
DBlong::operator <= (xp_long rhs) const { return operator xp_long () <= rhs; }

inline int
DBlong::operator > (xp_long rhs) const { return operator xp_long () > rhs; }

inline int
DBlong::operator >= (xp_long rhs) const { return operator xp_long () >= rhs; }

#endif /* dbxx_long_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/real.h#1 $
*/
#ifndef dbxx_real_h
#define dbxx_real_h	1

/////////////////////////////////////
class DBreal: public DBelem_c {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBreal (
                            DBelem_id elemId,
                            const char *name = 0,
                            int mode = DB_ELEM_RD);
                        ~DBreal ();

    // getting and setting
    double		getValue (double &value, double dflt = 0.) const;
    int			setValue (double v);

    			operator double () const;
    DBreal & 		operator= (double rhs);
    double		operator+= (double rhs);
    double		operator-= (double rhs);
    int			operator== (double rhs) const;
    int			operator!= (double rhs) const;
    int			operator < (double rhs) const;
    int			operator <= (double rhs) const;
    int			operator > (double rhs) const;
    int			operator >= (double rhs) const;
};

inline
DBreal::operator double () const { double v; getValue (v); return v; }

inline
DBreal & DBreal::operator= (double rhs) { setValue (rhs); return *this; }

inline int
DBreal::operator == (double rhs) const { return operator double () == rhs; }

inline int
DBreal::operator != (double rhs) const { return operator double () != rhs; }

inline int
DBreal::operator < (double rhs) const { return operator double () < rhs; }

inline int
DBreal::operator <= (double rhs) const { return operator double () <= rhs; }

inline int
DBreal::operator > (double rhs) const { return operator double () > rhs; }

inline int
DBreal::operator >= (double rhs) const { return operator double () >= rhs; }

#endif /* dbxx_real_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/ptr.h#1 $
*/
#ifndef dbxx_ptr_h
#define dbxx_ptr_h		1

/////////////////////////////////////
class DBpointer: public DBelem_c {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBpointer (DBelem_id elemId, const char *name = 0);
    virtual		~DBpointer ();

    // getting and setting

    DBelem_id &		getElemVal (DBelem_id &dflt = DBnull_elem);
    int			setElemVal (DBelem_id elem);
    virtual		operator DBelem_id () const;
    DBpointer &		operator= (DBelem_id elem_id);

    virtual Boolean	isNil () const;

    virtual Boolean	match (DBelem_id matchElem, int mode = DB_MATCH_POSS);
    virtual Boolean	match (const char * tmplClass, int mode = DB_MATCH_POSS);

  private:
    DBelem_id		_value;
};

inline
DBpointer & DBpointer::operator= (DBelem_id elem_id)
    { setElemVal (elem_id); return *this; }

inline
DBpointer::operator DBelem_id () const { return _value; }

#endif /* dbxx_ptr_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/dbstring.h#1 $
*/
#ifndef dbxx_dbstring_h
#define dbxx_dbstring_h	1

/////////////////////////////////////
class DBstring: public DBelem_c {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBstring (
                           DBelem_id elemId,
                           const char *name = 0,
                           int mode = DB_ELEM_RD);
                        ~DBstring ();

    // getting and setting
    int                 setValue (const char *str);
    int                 getValue (char **value, char *dflt = 0) const;
			operator char * () const;
    DBstring &		operator= (const char *rhs);
};

// In-line functions for DBstring

inline
DBstring::operator char * () const { char *v;  getValue (&v); return v; }

inline
DBstring & DBstring::operator= (const char *rhs)
{
    setValue ((char *) rhs);
    return *this;
}

#endif /* dbxx_dbstring_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/vctr.h#1 $
*/
#ifndef dbxx_vctr_h
#define dbxx_vctr_h	1

/////////////////////////////////////
class DBvector: public DBelem_c {
/////////////////////////////////////
  public:
    // Constructor and Destructor
                         DBvector (
			    DBelem_id elemId,
			    const char *name = 0,
			    const char *dimname = "dims");
                         ~DBvector () {};

    // getting and setting
    xp_long             size ();
    virtual void        reshape (xp_long size);

    // Public Methods that need to be implemented for subclasses
    //  T operator [] (int i)
    //  T atGet (int i)
    //  void atSet (int i, T val)
  private:
    DBlong                _dims;
};

// In-line functions for DBvector

#endif /* dbxx_vctr_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/sarray.h#1 $
*/
#ifndef dbxx_sarray_h
#define dbxx_sarray_h	1

/////////////////////////////////////
class DBstringArray: public DBvector {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBstringArray (
			    DBelem_id elemId,
			    const char *name = 0,
			    const char *dimname = "dims");
    virtual		~DBstringArray ();

    // getting and setting
    void		atSet (xp_long index, const char *val);
    char *		atGet (xp_long index);
    void                add (const char *s);
    void                add (const char **s, xp_long count);
    char *		operator [] (xp_long index);
};

// In-line functions for DBintVector

inline
DBstringArray::DBstringArray (DBelem_id elemId,
                              const char *name,
                              const char *dimname) :
    DBvector (elemId, name, dimname)
{
    // Empty
}

inline
char * DBstringArray::operator [] (xp_long index)
{
    return atGet (index);
}

#endif /* dbxx_sarray_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/elemvctr.h#1 $
*/
#ifndef dbxx_elemvctr_h
#define dbxx_elemvctr_h	1

/////////////////////////////////////
class DBelemVector: public DBvector {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBelemVector (
			    DBelem_id elemId,
			    const char *name = 0,
			    const char *dimname = "dims");
    virtual		~DBelemVector ();

    // getting and setting
    void		atSet (xp_long index, DBelem_id idToAdd);
    DBelem_id		atGet (xp_long index);
    DBelem_id		operator [] (xp_long index);
    void		add (DBelem_id idToAdd);
    void		remove (DBelem_id idToRemove);
  private:
};

// In-line functions for DBelemVector

#endif /* dbxx_elevctr_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/intvctr.h#1 $
*/
#ifndef dbxx_intvctr_h
#define dbxx_intvctr_h	1

/////////////////////////////////////
class DBintVector: public DBvector {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBintVector (
			    DBelem_id elemId,
			    const char *name = 0,
			    const char *dimname = "dims");
    virtual		~DBintVector ();

    // getting and setting
    void		atSet (xp_long index, int val);
    int			atGet (xp_long index);
    int			operator [] (xp_long index);
  private:
    static int		_type;
};

// In-line functions for DBintVector

inline
DBintVector::DBintVector (DBelem_id elemId, const char *name, const char *dimname) :
    DBvector (elemId, name, dimname)
{
    // Empty
}

inline
int DBintVector::operator [] (xp_long index)
{
    return atGet (index);
}

#endif /* dbxx_intvctr_h */
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/dbxx/longvctr.h#1 $
*/
#ifndef dbxx_longvctr_h
#define dbxx_longvctr_h	1

/////////////////////////////////////
class DBlongVector: public DBvector {
/////////////////////////////////////
  public:
    // Constructor and Destructor
			DBlongVector (
			    DBelem_id elemId,
			    const char *name = 0,
			    const char *dimname = "dims");
    virtual		~DBlongVector ();

    // getting and setting
    void		atSet (xp_long index, xp_long val);
    xp_long		atGet (xp_long index);
    xp_long		operator [] (xp_long index);
  private:
    static int		_type;
};

// In-line functions for DBlongVector

inline
DBlongVector::DBlongVector (DBelem_id elemId, const char *name, const char *dimname) :
    DBvector (elemId, name, dimname)
{
    // Empty
}

inline
xp_long DBlongVector::operator [] (xp_long index)
{
    return atGet (index);
}

#endif /* dbxx_longvctr_h */
