/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/dtx.h#1 $
*/
#ifndef DTX_INCLUDED
#define DTX_INCLUDED

#include <avs/port.h>

typedef int DTint;	 /* must be a 32 bit int */
typedef xp_long DTlong;

typedef struct _DTdouble {
   unsigned char dbytes[8];
} DTdouble;

DTdouble DTXdouble (double);
double DTdoubleX (DTdouble);

/*
#ifdef AVS_LITTLEENDIAN
#define DT_BYTE_SWAP
#else
#ifndef AVS_BIGENDIAN
XXX error in this case...
#endif
#endif
*/

#ifdef AVS_BIGENDIAN
#define DT_BYTE_SWAP
#else
#ifndef AVS_LITTLEENDIAN
XXX error in this case...
#endif
#endif

#ifdef DT_BYTE_SWAP

void DTXbyte_swap_array (int type, void *dst, const void *src, size_t nvals);

#define DTXint(V)	AVS_SWAP_INT(V)
#define DTintX(V)	AVS_SWAP_INT(V)

#define DTXlong(V)	AVS_SWAP_WORD(V)
#define DTlongX(V)	AVS_SWAP_WORD(V)


#define DTXarray(T,D,S,N) DTXbyte_swap_array(T,D,S,N)
#define DTarrayX(T,D,S,N) DTXbyte_swap_array(T,D,S,N)

#else

#define DTXint(V)	(V)
#define DTintX(V)	(V)

#define DTXlong(V)	(V)
#define DTlongX(V)	(V)

#define DTXarray(T,D,S,N) memcpy(D,S,DTYPEtype_size[T]*N);
#define DTarrayX(T,D,S,N) memcpy(D,S,DTYPEtype_size[T]*N);

#endif

#endif
