/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/err.h#1 $
*/
#ifndef XP_ERR_INCLUDED
#define XP_ERR_INCLUDED

#include <stdarg.h>
#include <stdio.h>
#include <avs/port.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef ERR_EXTERN
#ifdef XP_INTERNAL_GLOBALS
#define ERR_EXTERN extern
#else
#define ERR_EXTERN DLL_IMPORT
#endif
#endif

#define ERR_FLUSH	0x1
#define ERR_PRINT	0x2
#define ERR_DIALOG	0x4

#define ERR_ORIG 	(ERR_ERROR)
#define ERR_CHAIN 	(ERR_ERROR)

/*
 * Error is an error, warning or informational message
 */
#define ERR_ERROR	ERR_PRINT
#define ERR_WARNING	0x10
#define ERR_INFO	0x20
#define ERR_INTERNAL	0x80

/* Don't print a header/footer with the error */
#define ERR_NO_HEADER	0x40

ERR_EXTERN int ERRerror_index, ERRerror_squashed, ERRerror_batched,
	       ERRerror_squash_override;

#define ERRflush() ERRerror_index = 0
#define ERRsquash_start() ERRerror_squashed++;
#define ERRsquash_end()   ERRerror_squashed--;
#define ERRsquash_override_start() ERRerror_squash_override = 1;
#define ERRsquash_override_end()   ERRerror_squash_override = 0;
#define ERRbatch_start() ERRerror_batched++;
#define ERRbatch_end(P,M) \
   {if (--ERRerror_batched == 0 && P) ERR_batch_end(P,M);}

/* Return true if any errors are pending */
#define ERRpending() (ERRerror_index != 0)
#define ERRsquashed() (ERRerror_squashed != 0)
#define ERRbatched() (ERRerror_batched != 0)

#if defined(__sgi) && defined(__cplusplus) && defined(_COMPILER_VERSION)
#if _COMPILER_VERSION >= 740
/* The header files that come with version 7.4 of the SGI MIPS compilers
 * have the nasty property that the definition of va_list changes depending
 * on whether or not stdarg.h comes first or stdio.h comes first.  The
 * problem only affects C++ code.  Don't know about compiler versions past 7.4.
 */
#define SGI_VA_LIST_BUG
#endif
#endif

void ERRinit (void);

void ERRverror (const char *package, int mode,
		const char *format, ...);
#ifndef SGI_VA_LIST_BUG
void ERRverror_v (const char *package, int mode,
		  const char *format, va_list ap);
#endif
void ERRerror (const char *package, int count, int mode, const char *format, ...);
void ERRdump (const char *package);
void ERR_batch_end (const char *package, int mode);
void ERRprint (const char *buf);
void ERRpush_error_ctx (int (*func) (void *, char *, int),
			const char *str, void *data);
void ERRpop_error_ctx (int (*func) (void *, char *, int), void *data);
void ERRhandle_formatted_error (int mode, char *formatted_buf);
void ERRpush_error_dlg (int (*func) (void *, char *, int),
                        const char *str, void *data);
void ERRpop_error_dlg (int (*func) (void *,char *,int));
void ERRset_error_stream (FILE *);

void ERRset_yesno_dialog_handler (int (*func)(const char *, const char *, ...));
int  ERRsync_yesno_dialog (int, const char *, const char *, ...);

void ERRset_outofmem_dialog_handler (int (*)(const char *, ...));
int  ERRsync_outofmem_dialog (int, const char *, ...);

void ERRinit_reserve_memory (void);
void ERRout_of_memory (const char *);

#ifdef __cplusplus
}
#endif

#endif
