/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/field.h#1 $
*/
#ifndef F77
/*		@(#)field.h	8.5 AVS 92/10/11	*/
#endif /* F77 */

#ifndef _FIELD_H_defined
#define _FIELD_H_defined

#include <avs/mem_defs.h>

#ifndef F77
typedef struct {
   int ndim;			/* Number of dimensions in the field */
   int nspace;			/* Number of physical coordinates per point */
   int veclen;			/* number of components at each point */
   int type;			/* data type (see below for values) */
   int size;			/* size of each element */
   int single_block;		/* internal, 1 if the field is a single malloc */
				/* 2 if using shared memory */
				/* This also contains other flags for */
				/* internal use only which are explained */
				/* in field.c. */
#define FIELD_SINGLE_BLOCK 0x1
#define FIELD_IN_SHM 0x2
#define FIELD_RO 0x4
#define FIELD_RW_EXTENT 0x8

   int uniform;			/* UNIFORM, RECTILINEAR, or IRREGULAR */
   int flags;			/* internal, data validity flags */
   int *dimensions;		/* dimension along each axis, len is ndim */
   float *points;		/* real-world coords for non-uniform fields */
   union {			/* the field itself */
	   unsigned char *field_data_char; 
	   float         *field_data_float_u; 
	   double        *field_data_double_u; 
	   int           *field_data_int_u; 
	   short         *field_data_short_u; 
   } field_union;
   float *min_extent;		/* range of the data, len is nspace */
   float *max_extent;		/* range of the data, len is nspace */
   char  *labels;		/* labels for each component */
   union {			/* minimum data values for each component */
	   unsigned char *field_data_char;
	   float	 *field_data_float_u;
	   double	 *field_data_double_u;
	   int		 *field_data_int_u;
	   short	 *field_data_short_u;
   } minimum;
   union {			/* maximum data values for each component */
	   unsigned char *field_data_char;
	   float	 *field_data_float_u;
	   double	 *field_data_double_u;
	   int		 *field_data_int_u;
	   short	 *field_data_short_u;
   } maximum;
				/* next 3 used only when single_block is 2 */
   int shm_key;			/* shared memory key */
   int shm_id;			/* shared memory identifier */
   char *shm_base;		/* shared memory base address */
   char  *units;		/* units for each component */
   int shm_size;		/* shared memory segment size */
   int mesh_id;			/* unique id for the "points" information */
   int refcnt;			/* how many "allocations" of this field */
} AVSfield;

#define field_data 	     field_union.field_data_char
#define field_data_float     field_union.field_data_float_u
#define field_data_double    field_union.field_data_double_u
#define field_data_int	     field_union.field_data_int_u
#define field_data_short     field_union.field_data_short_u

#define min_data 	     minimum.field_data_char
#define min_data_float       minimum.field_data_float_u
#define min_data_double      minimum.field_data_double_u
#define min_data_int	     minimum.field_data_int_u
#define min_data_short	     minimum.field_data_short_u

#define max_data 	     maximum.field_data_char
#define max_data_float       maximum.field_data_float_u
#define max_data_double      maximum.field_data_double_u
#define max_data_int	     maximum.field_data_int_u
#define max_data_short	     maximum.field_data_short_u

typedef struct {
   int ndim;			/* Number of dimensions in the field */
   int nspace;			/* Number of physical coordinates per point */
   int veclen;			/* number of components at each point */
   int type;			/* data type (see below for values) */
   int size;			/* size of each element */
   int single_block;		/* internal, 1 if field is a single malloc */
				/* 2 if using shared memory */
   int uniform;			/* UNIFORM, RECTILINEAR, or IRREGULAR */
   int flags;                   /* internal, data validity flags */
   int *dimensions;		/* dimension along each axis, len is ndim */
   float *points;		/* real-world coords for non-uniform fields */
   float *data;			/* the field itself as floats */
   float *min_extent;		/* range of the data, len is nspace */
   float *max_extent;		/* range of the data, len is nspace */
   char  *labels;		/* labels for each component */
   float *minimum;   		/* minimum data values for each component */
   float *maximum;   		/* maximum data values for each component */
   int shm_key;			/* shared memory key */
   int shm_id;			/* shared memory identifier */
   char *shm_base;		/* shared memory base address */
   char  *units;		/* units for each component */
   int shm_size;		/* shared memory segment size */
   int mesh_id;			/* unique id for the "points" information */
   int refcnt;			/* how many "allocations" of this field */
} AVSfield_float;

typedef struct {
   int ndim;			/* Number of dimensions in the field */
   int nspace;			/* Number of physical coordinates per point */
   int veclen;			/* number of components at each point */
   int type;			/* data type (see below for values) */
   int size;			/* size of each element */
   int single_block;		/* internal, 1 if field is a single malloc */
				/* 2 if using shared memory */
   int uniform;			/* UNIFORM, RECTILINEAR, or IRREGULAR */
   int flags;                   /* internal, data validity flags */
   int *dimensions;		/* dimension along each axis, len is ndim */
   float *points;		/* real-world coords for non-uniform fields */
   double *data;		/* the field itself as doubles */
   float *min_extent;		/* range of the data, len is nspace */
   float *max_extent;		/* range of the data, len is nspace */
   char  *labels;		/* labels for each component */
   double *minimum;   		/* minimum data values for each component */
   double *maximum;   		/* maximum data values for each component */
   int shm_key;			/* shared memory key */
   int shm_id;			/* shared memory identifier */
   char *shm_base;		/* shared memory base address */
   char  *units;		/* units for each component */
   int shm_size;		/* shared memory segment size */
   int mesh_id;			/* unique id for the "points" information */
   int refcnt;			/* how many "allocations" of this field */
} AVSfield_double;

typedef struct {
   int ndim;			/* Number of dimensions in the field */
   int nspace;			/* Number of physical coordinates per point */
   int veclen;			/* number of components at each point */
   int type;			/* data type (see below for values) */
   int size;			/* size of each element */
   int single_block;		/* internal, 1 if field is a single malloc */
				/* 2 if using shared memory */
   int uniform;			/* UNIFORM, RECTILINEAR, or IRREGULAR */
   int flags;                   /* internal, data validity flags */
   int *dimensions;		/* dimension along each axis, len is ndim */
   float *points;		/* real-world coords for non-uniform fields */
   int *data;			/* the field itself as ints */
   float *min_extent;		/* range of the data, len is nspace */
   float *max_extent;		/* range of the data, len is nspace */
   char  *labels;		/* labels for each component */
   int *minimum;   		/* minimum data values for each component */
   int *maximum;   		/* maximum data values for each component */
   int shm_key;			/* shared memory key */
   int shm_id;			/* shared memory identifier */
   char *shm_base;		/* shared memory base address */
   char  *units;		/* units for each component */
   int shm_size;		/* shared memory segment size */
   int mesh_id;			/* unique id for the "points" information */
   int refcnt;			/* how many "allocations" of this field */
} AVSfield_int;

typedef struct {
   int ndim;			/* Number of dimensions in the field */
   int nspace;			/* Number of physical coordinates per point */
   int veclen;			/* number of components at each point */
   int type;			/* data type (see below for values) */
   int size;			/* size of each element */
   int single_block;		/* internal, 1 if field is a single malloc */
				/* 2 if using shared memory */
   int uniform;			/* UNIFORM, RECTILINEAR, or IRREGULAR */
   int flags;                   /* internal, data validity flags */
   int *dimensions;		/* dimension along each axis, len is ndim */
   float *points;		/* real-world coords for non-uniform fields */
   unsigned char *data;		/* the field itself as chars */
   float *min_extent;		/* range of the data, len is nspace */
   float *max_extent;		/* range of the data, len is nspace */
   char  *labels;		/* labels for each component */
   unsigned char *minimum;   	/* minimum data values for each component */
   unsigned char *maximum;   	/* maximum data values for each component */
   int shm_key;			/* shared memory key */
   int shm_id;			/* shared memory identifier */
   char *shm_base;		/* shared memory base address */
   char  *units;		/* units for each component */
   int shm_size;		/* shared memory segment size */
   int mesh_id;			/* unique id for the "points" information */
   int refcnt;			/* how many "allocations" of this field */
} AVSfield_char;

typedef struct {
   int ndim;			/* Number of dimensions in the field */
   int nspace;			/* Number of physical coordinates per point */
   int veclen;			/* number of components at each point */
   int type;			/* data type (see below for values) */
   int size;			/* size of each element */
   int single_block;		/* internal, 1 if field is a single malloc */
				/* 2 if using shared memory */
   int uniform;			/* UNIFORM, RECTILINEAR, or IRREGULAR */
   int flags;                   /* internal, data validity flags */
   int *dimensions;		/* dimension along each axis, len is ndim */
   float *points;		/* real-world coords for non-uniform fields */
   short *data;			/* the field itself as chars */
   float *min_extent;		/* range of the data, len is nspace */
   float *max_extent;		/* range of the data, len is nspace */
   char  *labels;		/* labels for each component */
   short *minimum;   		/* minimum data values for each component */
   short *maximum;   		/* maximum data values for each component */
   int shm_key;			/* shared memory key */
   int shm_id;			/* shared memory identifier */
   char *shm_base;		/* shared memory base address */
   char  *units;		/* units for each component */
   int shm_size;		/* shared memory segment size */
   int mesh_id;			/* unique id for the "points" information */
   int refcnt;			/* how many "allocations" of this field */
} AVSfield_short;

#endif /* F77 */

/* definitions for the uniform field above 
   These definitions are for AVSbuild_field and for the flags passed in
   when we are processing generalized fields in our modules. */

#define UNIFORM		0	/*_F77_s: AFUNFM - fields with implicit coordinates  */
#define RECTILINEAR	1	/*_F77_s: AFRECT - fields with rectilinear coords    */
#define IRREGULAR	2	/*_F77_s: AFIRRG - fields with irregular coordinates */


#define AVS_FIELD_LABEL_LEN  1024 /*_F77_s: AFLLEN - max length of labels in field */
#define AVS_FIELD_UNIT_LEN  1024 /*_F77_s: AFULEN - max length of units in field */

#define AVS_FIELD_NDIM   1 /*_F77_s: AFNDIM - Number of dimensions */
#define AVS_FIELD_NSPACE 2 /*_F77_s: AFNSPC - Number of physical coordinates per point */
#define AVS_FIELD_VECLEN 3 /*_F77_s: AFVLEN - Number of components at each point */
#define AVS_FIELD_TYPE   4 /*_F77_s: AFTYPE - Data type (see below for values) */
#define AVS_FIELD_SIZE   5 /*_F77_s: AFSIZE - Size of each element */
#define AVS_FIELD_UNIFORM 6 /*_F77_s: AFUFRM - Uniformity of data space */
#define AVS_FIELD_FLAGS  7 /*_F77_s: AFFLAG - Internal, data validity flags */

#ifndef F77
#define UNIFORM_DONTCARE -1	/* used in templates, not in real data */

#define AVS_VALID_EXTENT 0x01   /* flag for valid field min/max extents  */
#define AVS_VALID_LABELS 0x02   /* flag for valid field labels           */
#define AVS_VALID_MINMAX 0x04   /* flag for valid field min/max values   */
#define AVS_VALID_UNITS  0x08   /* flag for valid field units            */
#define AVS_ALLOC_CHECK  0x10   /* flag to check extents, labels, etc    */
/* 
 * The following flags are set when we have a reference to outside data
 * that we should not free when we free the field.
 * 
 * They are currently set by AVSbuild_field and its friends.
 */
#define AVS_REF_POINTS 0x100
#define AVS_REF_DATA   0x200

/* macro to check that a AVSfield* is of a certain type */

#define FIELD_TYPE(field, ndimv, typev, uniformv) \
	(((ndimv) == (field)->ndim) && ((typev) == (field)->type) && \
	 (((uniformv) == UNIFORM_DONTCARE) || ((uniformv) == (field)->uniform)))

/* Indexing macros - note FORTRAN index ordering. */

#define I2D(field, i, j) \
	(((field)->data)[(field)->dimensions[0]*(j) + (i)])

#define I3D(field, i, j, k) \
	(((field)->data)[ ((field)->dimensions[0] * \
				  ((field)->dimensions[1]*(k) + (j))) + (i) ])

#define I4D(field, i, j, k, l) \
	(((field)->data)[ ((field)->dimensions[0] * \
			   (((field)->dimensions[1] * \
			     ((field)->dimensions[2]*(l) + (k))) + (j))) + (i)])

/* These are the vector field versions of the indexing macros */

#define I1DV(field, i) ((field)->data + (field)->veclen * (i))

#define I2DV(field, i, j) \
    (((field)->data) + ((field)->veclen * ((field)->dimensions[0]*(j) + (i))))

#define I3DV(field, i, j, k) \
    (((field)->data)+ ((field)->veclen * (((field)->dimensions[0] * \
					   ((field)->dimensions[1]*(k) + (j)))\
					  + (i)) ))

#define I4DV(field, i, j, k, l) \
	(((field)->data) + ((field)->veclen * (((field)->dimensions[0] * \
					       (((field)->dimensions[1] * \
						((field)->dimensions[2]*(l) \
						 + (k))) + (j))) + (i))))


/* Macros to determine a maximum in a particular dimension */

#define MAXX(field) ((field)->dimensions[0])
#define MAXY(field) ((field)->dimensions[1])
#define MAXZ(field) ((field)->dimensions[2])

/* Macros to get the rectilinear axes for the first three dimensions */

#define RECT_X(field) ((field)->points)
#define RECT_Y(field) ((field)->points + (field)->dimensions[0])
#define RECT_Z(field) ((field)->points + (field)->dimensions[0]\
		       + (field)->dimensions[1])

/* Macros to return the physical coordinate for a particular i, j, k combo */
/* NOTE: These only work for 3D 3-space data! If there is some other
   dimensionality or space, you want to use UTILget_coord(field, i, j, k, &x, &y, &z)
*/
#define COORD_X_3D(field, i, j, k) \
	((field)->uniform == UNIFORM ? (i) : \
	 (field)->uniform == RECTILINEAR ? (field)->points[(i)] : \
	 (((field)->points)[ ((field)->dimensions[0] * \
				 ((field)->dimensions[1] * \
				  (k) + (j))) + (i) ]))

#define COORD_Y_3D(field, i, j, k) \
	((field)->uniform == UNIFORM ? (j) : \
	 (field)->uniform == RECTILINEAR ? \
	    (field)->points[(field)->dimensions[0] + (j)] : \
	 (((field)->points)[ ((field)->dimensions[0] * \
				 (((field)->dimensions[1] * \
				  ((field)->dimensions[2] + (k))) + (j))) + (i) ]))

#define COORD_Z_3D(field, i, j, k) \
	((field)->uniform == UNIFORM ? (k) : \
	 (field)->uniform == RECTILINEAR ? \
	    (field)->points[(field)->dimensions[0] + (field)->dimensions[1] + (k)] : \
	 (((field)->points)[ ((field)->dimensions[0] * \
				 (((field)->dimensions[1] * \
				  ((field)->dimensions[2]*2 + (k))) + (j))) + (i) ]))

AVSfield  *AVSbuild_field_real();


#ifndef avsargs_h
#include <avs/avsargs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

AVS_EXTERN( AVSfield *AVSbuild_2d_field, (float *f, int nx, int ny));
AVS_EXTERN( AVSfield *AVSbuild_3d_field, (float *f, int nx, int ny, int nz));
#ifdef STDARG
/* 
 * Even if we aren't using avs prototypes, we need to declare this guy 
 * because there's no way to use stdargs without this kind of description
 * and we can't compile the function that uses this guy in this case...
 */
#ifdef USE_PROTOS 
AVSfield *AVSbuild_field PTARGS((int, int, int, int, int, ...)); 
#else
AVS_EXTERN( AVSfield *AVSbuild_field, (int, int, int, int, int, ...));
#endif
#else
AVS_EXTERN( AVSfield *AVSbuild_field, ());
#endif

AVS_EXTERN( char *AVSfield_alloc, (AVSfield *mytemplate, int *dims));
AVS_EXTERN( AVSfield *AVSfield_equiv_to_input, (AVSfield *in_field));
AVS_EXTERN( int AVSfield_copy_points, (AVSfield *field_in, AVSfield *field_out));
AVS_EXTERN( void AVSfield_free, (AVSfield *field));
AVS_EXTERN( void AVSfield_make_template, (AVSfield *field_in, AVSfield *mytemplate));
AVS_EXTERN( void *AVSfield_data_ptr, (AVSfield *field));
AVS_EXTERN( int AVSfield_get_dimensions, (AVSfield *field, int *dimensions));
AVS_EXTERN( int AVSfield_get_extent, (AVSfield *field, float *min_extent, float *max_extent));
AVS_EXTERN( int AVSfield_get_int, (AVSfield *field, int selector));
AVS_EXTERN( int AVSfield_get_label, (AVSfield *field, int number, char *label));
AVS_EXTERN( int AVSfield_get_labels, (AVSfield *field, char *labels, char *delimiter));
AVS_EXTERN( int AVSfield_get_minmax, (AVSfield *field, char *min, char *max));
AVS_EXTERN( int AVSfield_get_unit, (AVSfield *field, int number, char *unit));
AVS_EXTERN( int AVSfield_get_units, (AVSfield *field, char *units, char *delimiter));
AVS_EXTERN( void AVSfield_invalid_minmax, (AVSfield *field));
AVS_EXTERN( void *AVSfield_points_ptr, (AVSfield *field));
AVS_EXTERN( void AVSfield_reset_minmax, (AVSfield *field));
AVS_EXTERN( void AVSfield_set_extent, (AVSfield *field, float *min_extent, float *max_extent));
AVS_EXTERN( int AVSfield_set_int, (AVSfield *field, int selector, int value));
AVS_EXTERN( void AVSfield_set_labels, (AVSfield *field, char *labels, char *delimiter));
AVS_EXTERN( void AVSfield_set_minmax, (AVSfield *field, char *min, char *max));
AVS_EXTERN( void AVSfield_set_units, (AVSfield *field, char *units, char *delimiter));

#ifdef __cplusplus
}
#endif

#endif /* F77 */
#endif /* _FIELD_H_defined */
	
#ifndef _BYTE_TABLE_defined

#define _BYTE_TABLE_defined
/* this is the new, preferred way of specifying byte tables */
#define  BYTE_TABLE      256
/* this is the old way as used  to be referenced in vex.h */
#define  DATA_RESOLUTION 256

#endif /* _BYTE_TABLE_defined */

