/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/fld.h#1 $
*/
#ifndef XP_FLD_INCLUDED
#define XP_FLD_INCLUDED

#include <avs/om.h>

#ifdef __cplusplus
extern "C" {
#endif
/* access.c */
FUNC_PREFIX OMobj_id FLDadd_elem (OMobj_id field, const char *temp_name, const char *elem_name);
FUNC_PREFIX int FLDadd_int (OMobj_id field, const char *name);
FUNC_PREFIX int FLDset_int (OMobj_id field, const char *name, int val);
FUNC_PREFIX int FLDget_int (OMobj_id field, const char *name, int *val);
FUNC_PREFIX int FLDadd_long (OMobj_id field, const char *name);
FUNC_PREFIX int FLDset_long (OMobj_id field, const char *name, xp_long val);
FUNC_PREFIX int FLDget_long (OMobj_id field, const char *name, xp_long *val);
FUNC_PREFIX int FLDadd_real (OMobj_id field, const char *name);
FUNC_PREFIX int FLDset_real (OMobj_id field, const char *name, double val);
FUNC_PREFIX int FLDget_real (OMobj_id field, const char *name, double *val);
FUNC_PREFIX int FLDadd_int_array (OMobj_id field, const char *name, xp_long size);
FUNC_PREFIX int FLDset_array_int (OMobj_id field, const char *name, xp_long size, int *array, int mode);
FUNC_PREFIX int FLDget_array_int (OMobj_id field, const char *name, int **array, xp_long *size, int mode);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_array_int_n (OMobj_id field, const char *name, int **array, int *size, int mode);
#endif
FUNC_PREFIX int FLDadd_long_array (OMobj_id field, const char *name, xp_long size);
FUNC_PREFIX int FLDset_array_long (OMobj_id field, const char *name, xp_long size, xp_long *array, int mode);
FUNC_PREFIX int FLDget_array_long (OMobj_id field, const char *name, xp_long **array, xp_long *size, int mode);
FUNC_PREFIX int FLDadd_float_array (OMobj_id field, const char *name, xp_long size);
FUNC_PREFIX int FLDset_array_float (OMobj_id field, const char *name, xp_long size, float *array, int mode);
FUNC_PREFIX int FLDget_array_float (OMobj_id field, const char *name, float **array, xp_long *size, int mode);
FUNC_PREFIX int FLDget_array_size (OMobj_id e, xp_long *size);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_array_float_n (OMobj_id field, const char *name, float **array, int *size, int mode);
FUNC_PREFIX int FLDget_array_size_n (OMobj_id e, int *size);
#endif
FUNC_PREFIX int FLDequal (OMobj_id e1, OMobj_id e2);
FUNC_PREFIX int FLDget_parent_val (OMobj_id e, OMobj_id *parent);
FUNC_PREFIX int FLDget_subelem (OMobj_id field, const char *name, OMobj_id *elem);
FUNC_PREFIX int FLDget_subelem_seq (OMobj_id field, const char *temp_name);
FUNC_PREFIX OMobj_id FLDcreate (OMobj_id parent_id, const char *field_desc, const char *name);
FUNC_PREFIX int FLDdestroy (OMobj_id field);
FUNC_PREFIX int FLDdelete (OMobj_id field, const char *name);
FUNC_PREFIX int FLDcopy_elem_ref (OMobj_id ref, OMobj_id base);
FUNC_PREFIX int FLDcopy_subelem_ref (OMobj_id ref, OMobj_id base);
FUNC_PREFIX int FLDget_function (OMobj_id elem, const char *name, OMpfi *func);
FUNC_PREFIX int FLDget_methods (OMobj_id elem, int n, const char *names[], OMpfi *func);
FUNC_PREFIX int FLDget_grid_type (OMobj_id field, int *grid_type);
FUNC_PREFIX int FLDset_grid_type (OMobj_id field, int grid_type);
FUNC_PREFIX int FLDget_ndim (OMobj_id field, int *ndim);
FUNC_PREFIX int FLDset_ndim (OMobj_id field, int ndim);
FUNC_PREFIX int FLDget_nnodes (OMobj_id field, xp_long *nnodes);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_nnodes_n (OMobj_id field, int *nnodes);
#endif
FUNC_PREFIX int FLDset_nnodes (OMobj_id field, xp_long nnodes);
FUNC_PREFIX int FLDget_dims (OMobj_id field, xp_long **dims, int *ndim);
FUNC_PREFIX int FLDset_dims (OMobj_id field, xp_long *dims);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_dims_n (OMobj_id field, int **dims, int *ndim);
FUNC_PREFIX int FLDset_dims_n (OMobj_id field, int *dims);
#endif
FUNC_PREFIX int FLDget_xform (OMobj_id field, float *xform);
FUNC_PREFIX int FLDset_xform (OMobj_id field, float *xform);
FUNC_PREFIX int FLDget_rspace (OMobj_id field, int *rspace);
FUNC_PREFIX int FLDset_rspace (OMobj_id field, int rspace);
FUNC_PREFIX int FLDget_npoints (OMobj_id field, xp_long *npoints);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_npoints_n (OMobj_id field, int *npoints);
#endif
FUNC_PREFIX int FLDset_npoints (OMobj_id field, xp_long npoints);
FUNC_PREFIX int FLDget_nspace (OMobj_id field, int *nspace);
FUNC_PREFIX int FLDset_nspace (OMobj_id field, int nspace);
FUNC_PREFIX int FLDget_coord (OMobj_id field, float **coord_array, xp_long *size, int mode);
FUNC_PREFIX int FLDget_sub_coord (OMobj_id field, int ndim, xp_long *dims, xp_long *min_rng, xp_long *max_rng, float *coord_array);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_coord_n (OMobj_id field, float **coord_array, int *size, int mode);
FUNC_PREFIX int FLDget_sub_coord_n (OMobj_id field, int ndim, int *dims, int *min_rng, int *max_rng, float *coord_array);
#endif
FUNC_PREFIX int FLDset_coord (OMobj_id field, float *coord_array, xp_long size, int mode);
FUNC_PREFIX int FLDreset_point_extent (OMobj_id field);
FUNC_PREFIX int FLDreset_coord_extent (OMobj_id field);
FUNC_PREFIX int FLDset_coord_extent (OMobj_id field, float *min_extent, float *max_extent, int nspace);
FUNC_PREFIX int FLDget_coord_extent (OMobj_id field, float *min_extent, float *max_extent);
FUNC_PREFIX int FLDget_points (OMobj_id field, float **points, xp_long *size, int mode);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_points_n (OMobj_id field, float **points, int *size, int mode);
#endif
FUNC_PREFIX int FLDset_points (OMobj_id field, float *points, xp_long size, int mode);
FUNC_PREFIX int FLDget_coord_units (OMobj_id field, char *units, int size);
FUNC_PREFIX int FLDset_coord_units (OMobj_id field, const char *units);
FUNC_PREFIX int FLDget_node_data_ncomp (OMobj_id field, int *nnode_comp);
FUNC_PREFIX int FLDset_node_data_ncomp (OMobj_id field, int nnode_comp);
FUNC_PREFIX int FLDset_node_data_comp (OMobj_id field, int comp, int veclen, const char *label, const char *units);
FUNC_PREFIX int FLDget_node_data_veclen (OMobj_id field, int comp, int *veclen);
FUNC_PREFIX int FLDset_node_data_veclen (OMobj_id field, int comp, int veclen);
FUNC_PREFIX int FLDget_node_data_type (OMobj_id field, int comp, int *type);
FUNC_PREFIX int FLDset_node_data_type (OMobj_id field, int comp, int type);
FUNC_PREFIX int FLDget_node_data (OMobj_id field, int comp, int *type, char **node_data, xp_long *size, int mode);
FUNC_PREFIX int FLDget_typed_node_data (OMobj_id field, int comp, int *type, char **node_data, xp_long *size, int mode);
FUNC_PREFIX int FLDget_sub_node_data (OMobj_id field, int comp, int *type, int ndim, xp_long *dims, xp_long *min_rng, xp_long *max_rng, char *node_data);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_node_data_n (OMobj_id field, int comp, int *type, char **node_data, int *size, int mode);
FUNC_PREFIX int FLDget_typed_node_data_n (OMobj_id field, int comp, int *type, char **node_data, int *size, int mode);
FUNC_PREFIX int FLDget_sub_node_data_n (OMobj_id field, int comp, int *type, int ndim, int *dims, int *min_rng, int *max_rng, char *node_data);
#endif
FUNC_PREFIX int FLDset_node_data (OMobj_id field, int comp, char *node_data, int type, xp_long size, int mode);
FUNC_PREFIX int FLDget_node_data_minmax_vec (OMobj_id field, int comp, char **min, char **max, int *type, int mode);
FUNC_PREFIX int FLDcopy_node_minmax_vec (OMobj_id in_field, OMobj_id out_field, int in_comp, int out_comp);
FUNC_PREFIX int FLDget_node_data_minmax (OMobj_id field, int comp, char *min, char *max);
FUNC_PREFIX int FLDset_node_data_minmax (OMobj_id field, int comp, const char *min, const char *max, int dtype);
FUNC_PREFIX int FLDcopy_node_minmax (OMobj_id in_field, OMobj_id out_field, int in_comp, int out_comp);
FUNC_PREFIX int FLDreset_node_minmax (OMobj_id in_field, int comp);
FUNC_PREFIX int FLDreset_node_minmax_vec (OMobj_id in_field, int comp);
FUNC_PREFIX int FLDget_node_data_label (OMobj_id field, int comp, char *label, int size);
FUNC_PREFIX int FLDset_node_data_label (OMobj_id field, int comp, const char *label);
FUNC_PREFIX int FLDget_node_data_units (OMobj_id field, int comp, char *units, int size);
FUNC_PREFIX int FLDset_node_data_units (OMobj_id field, int comp, const char *units);
FUNC_PREFIX int FLDget_node_data_id (OMobj_id field, int comp, int *id);
FUNC_PREFIX int FLDset_node_data_id (OMobj_id field, int comp, int id);
FUNC_PREFIX int FLDget_node_null_data (OMobj_id field, int comp, int *null_flag, char *null_value);
FUNC_PREFIX int FLDset_node_null_data (OMobj_id field, int comp, char *null_value, int type);
FUNC_PREFIX int FLDset_node_null_flag (OMobj_id field, int comp, int null_flag);
FUNC_PREFIX int FLDget_cell_data_ncomp (OMobj_id cell_set, int *ncell_comp);
FUNC_PREFIX int FLDset_cell_data_ncomp (OMobj_id cell_set, int ncell_comp);
FUNC_PREFIX int FLDset_cell_data_comp (OMobj_id cell_set, int comp, int veclen, const char *label, const char *units);
FUNC_PREFIX int FLDset_cell_data_veclen (OMobj_id cell_set, int comp, int veclen);
FUNC_PREFIX int FLDget_cell_data_veclen (OMobj_id cell_set, int comp, int *veclen);
FUNC_PREFIX int FLDget_cell_data (OMobj_id cell_set, int comp, int *type, char **cell_data, xp_long *size, int mode);
FUNC_PREFIX int FLDget_typed_cell_data (OMobj_id cell_set, int comp, int *type, char **cell_data, xp_long *size, int mode);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_cell_data_n (OMobj_id cell_set, int comp, int *type, char **cell_data, int *size, int mode);
FUNC_PREFIX int FLDget_typed_cell_data_n (OMobj_id cell_set, int comp, int *type, char **cell_data, int *size, int mode);
#endif
FUNC_PREFIX int FLDset_cell_data (OMobj_id cell_set, int comp, char *cell_data, int type, xp_long size, int mode);
FUNC_PREFIX int FLDget_cell_data_minmax_vec (OMobj_id cell_set, int comp, char **min, char **max, int *type, int mode);
FUNC_PREFIX int FLDcopy_cell_minmax_vec (OMobj_id in_cell_set, OMobj_id out_cell_set, int in_comp, int out_comp);
FUNC_PREFIX int FLDget_cell_data_minmax (OMobj_id cell_set, int comp, char *min, char *max);
FUNC_PREFIX int FLDget_cell_data_minmax_total (OMobj_id field, int comp, char *min, char* max);
FUNC_PREFIX int FLDset_cell_data_minmax (OMobj_id cell_set, int comp, const char *min, const char *max, int dtype);
FUNC_PREFIX int FLDreset_cell_minmax (OMobj_id cell_set, int comp);
FUNC_PREFIX int FLDreset_cell_minmax_vec (OMobj_id in_cell_set, int comp);
FUNC_PREFIX int FLDcopy_cell_minmax (OMobj_id in_cell_set, OMobj_id out_cell_set, int in_comp, int out_comp);
FUNC_PREFIX int FLDget_cell_data_label (OMobj_id cell_set, int comp, char *label, int size);
FUNC_PREFIX int FLDset_cell_data_label (OMobj_id cell_set, int comp, const char *label);
FUNC_PREFIX int FLDget_cell_data_units (OMobj_id cell_set, int comp, char *units, int size);
FUNC_PREFIX int FLDset_cell_data_units (OMobj_id cell_set, int comp, const char *units);
FUNC_PREFIX int FLDget_cell_data_id (OMobj_id cell_set, int comp, int *id);
FUNC_PREFIX int FLDset_cell_data_id (OMobj_id cell_set, int comp, int id);
FUNC_PREFIX int FLDget_cell_data_type (OMobj_id cell_set, int comp, int *type);
FUNC_PREFIX int FLDset_cell_data_type (OMobj_id cell_set, int comp, int type);
FUNC_PREFIX int FLDget_cell_null_data (OMobj_id cell_set, int comp, int *null_flag, char *null_value);
FUNC_PREFIX int FLDset_cell_null_data (OMobj_id cell_set, int comp, char *null_value, int type);
FUNC_PREFIX int FLDset_cell_null_flag (OMobj_id cell_set, int comp, int null_flag);
FUNC_PREFIX int FLDget_cell_set (OMobj_id field, int i, OMobj_id *cell_set);
FUNC_PREFIX int FLDget_cell_set_name (OMobj_id cell_set, char *name, int size);
FUNC_PREFIX int FLDget_cell_set_user_name (OMobj_id cell_set, char *name, int size);
FUNC_PREFIX int FLDset_cell_set_user_name (OMobj_id cell_set, const char *name);
FUNC_PREFIX int FLDset_cell_set (OMobj_id cell_set, const char *cell_set_name);
FUNC_PREFIX int FLDadd_cell_set (OMobj_id field, const char *cell_set_name);
FUNC_PREFIX int FLDdel_cell_set (OMobj_id field, OMobj_id cell_set);
FUNC_PREFIX int FLDget_ncell_sets (OMobj_id field, int *ncell_sets);
FUNC_PREFIX int FLDset_ncell_sets (OMobj_id field, int ncell_sets);
FUNC_PREFIX int FLDget_ncells (OMobj_id cell_set, xp_long *ncells);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_ncells_n (OMobj_id cell_set, int *ncells);
#endif
FUNC_PREFIX int FLDset_ncells (OMobj_id cell_set, xp_long ncells);
FUNC_PREFIX int FLDget_npolys (OMobj_id cell_set, xp_long *npolys);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_npolys_n (OMobj_id cell_set, int *npolys);
#endif
FUNC_PREFIX int FLDset_npolys (OMobj_id cell_set, xp_long npolys);
FUNC_PREFIX int FLDget_poly_flag (OMobj_id cell_set, int *poly_flag);
FUNC_PREFIX int FLDset_poly_flag (OMobj_id cell_set, int poly_flag);
FUNC_PREFIX int FLDget_cell_ndim (OMobj_id cell_set, int *ndim);
FUNC_PREFIX int FLDget_cell_order (OMobj_id cell_set, int *order);
FUNC_PREFIX int FLDget_cell_type (OMobj_id cell_set, int *cell_type);
FUNC_PREFIX int FLDset_cell_type (OMobj_id cell_set, int cell_type);
FUNC_PREFIX int FLDget_cell_set_nnodes (OMobj_id cell_set, int *cell_nnodes);
FUNC_PREFIX int FLDget_cell_corner_nnodes (OMobj_id cell_set, int *cell_nnodes);
FUNC_PREFIX int FLDget_cell_set_nfaces (OMobj_id cell_set, int *cell_nfaces);
FUNC_PREFIX int FLDget_cell_faces (OMobj_id cell_set, int *cell_nfaces, int **face_nnodes, int **face_corner_nnodes, xp_long **node_list, int *size);
FUNC_PREFIX int FLDget_node_connect (OMobj_id cell_set, xp_long **node_conn_array, xp_long *size, int mode);
FUNC_PREFIX int FLDset_node_connect (OMobj_id cell_set, xp_long *node_conn_array, xp_long size, int mode);
FUNC_PREFIX int FLDget_poly_connect (OMobj_id cell_set, xp_long **poly_conn_array, xp_long *size, int mode);
FUNC_PREFIX int FLDset_poly_connect (OMobj_id cell_set, xp_long *poly_conn_array, xp_long size, int mode);
FUNC_PREFIX int FLDget_poly_nnodes (OMobj_id cell_set, int **poly_conn_array, xp_long *size, int mode);
FUNC_PREFIX int FLDset_poly_nnodes (OMobj_id cell_set, int *poly_conn_array, xp_long size, int mode);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_cell_faces_n (OMobj_id cell_set, int *cell_nfaces, int **face_nnodes, int **face_corner_nnodes, int **node_list, int *size);
FUNC_PREFIX int FLDget_node_connect_w (OMobj_id cell_set, xp_long **node_conn_array, xp_long *size, int mode);
FUNC_PREFIX int FLDget_node_connect_n (OMobj_id cell_set, int **node_conn_array, int *size, int mode);
FUNC_PREFIX int FLDset_node_connect_w (OMobj_id cell_set, xp_long *node_conn_array, xp_long size, int mode);
FUNC_PREFIX int FLDset_node_connect_n (OMobj_id cell_set, int *node_conn_array, int size, int mode);
FUNC_PREFIX int FLDget_poly_connect_w (OMobj_id cell_set, xp_long **poly_conn_array, xp_long *size, int mode);
FUNC_PREFIX int FLDget_poly_connect_n (OMobj_id cell_set, int **poly_conn_array, int *size, int mode);
FUNC_PREFIX int FLDset_poly_connect_w (OMobj_id cell_set, xp_long *poly_conn_array, xp_long size, int mode);
FUNC_PREFIX int FLDset_poly_connect_n (OMobj_id cell_set, int *poly_conn_array, int size, int mode);
FUNC_PREFIX int FLDget_poly_nnodes_n (OMobj_id cell_set, int **poly_conn_array, int *size, int mode);
#endif
FUNC_PREFIX int FLDget_cell_node_uvw (OMobj_id cell_set, float **uvw);
FUNC_PREFIX int FLDget_cell_nprops (OMobj_id cell_set, int *nprops);
FUNC_PREFIX int FLDset_cell_nprops (OMobj_id cell_set, int nprops);
FUNC_PREFIX int FLDget_cell_props (OMobj_id cell_set, float **props, int *size, int mode);
FUNC_PREFIX int FLDcheck_cell_connect (OMobj_id cell_set, xp_long nnodes, xp_long *bad_index, xp_long *bad_value);
FUNC_PREFIX int FLDcheck_mesh_connect (OMobj_id cell_set, xp_long *bad_index, xp_long *bad_value);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDcheck_cell_connect_n (OMobj_id cell_set, int nnodes, int *bad_index, int *bad_value);
FUNC_PREFIX int FLDcheck_mesh_connect_n (OMobj_id cell_set, int *bad_index, int *bad_value);
#endif

/* dfuncs.c */
FUNC_PREFIX void FLDfunc_init (void);
FUNC_PREFIX int FLDget_coords_dims (OMobj_id elem_id, int *ndim, xp_long *dims);
FUNC_PREFIX int FLDget_coords_unif (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_rect (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_cyl_unif (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_cyl_rect (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_spher_unif (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_spher_rect (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, float *array);
FUNC_PREFIX int FLDget_connect_dims (OMobj_id elem_id, int *req_ndim, xp_long *req_dims);
FUNC_PREFIX int FLDget_connect_struct (OMobj_id elem_id, int req_ndim, xp_long *idims, xp_long *imin_rng, xp_long *imax_rng, xp_long *array);
FUNC_PREFIX int get_coords_unif (int ndim, xp_long *dims, float *points, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int get_coords_rect (int ndim, xp_long *dims, float *points, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int get_coords_cyl_unif (int ndim, xp_long *dims, float *points, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int get_coords_cyl_rect (int ndim, xp_long *dims, float *points, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int get_coords_spher_unif (int ndim, xp_long *dims, float *points, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int get_coords_spher_rect (int ndim, xp_long *dims, float *points, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int get_connect_struct (int ndim, xp_long *dims, xp_long min_cell, xp_long max_cell, xp_long *array);
#ifdef WORDLENGTH_64
FUNC_PREFIX int FLDget_coords_dims_n (OMobj_id elem_id, int *ndim, int *dims);
FUNC_PREFIX int FLDget_coords_unif_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_rect_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_cyl_unif_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_cyl_rect_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_spher_unif_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, float *array);
FUNC_PREFIX int FLDget_coords_spher_rect_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, float *array);
FUNC_PREFIX int FLDget_connect_dims_n (OMobj_id elem_id, int *req_ndim, int *req_dims);
FUNC_PREFIX int FLDget_connect_struct_n (OMobj_id elem_id, int req_ndim, int *idims, int *imin_rng, int *imax_rng, int *array);
FUNC_PREFIX int get_coords_unif_n (int ndim, int *dims, float *points, int *min_rng, int *max_rng, float *array);
FUNC_PREFIX int get_coords_rect_n (int ndim, int *dims, float *points, int *min_rng, int *max_rng, float *array);
FUNC_PREFIX int get_coords_cyl_unif_n (int ndim, int *dims, float *points, int *min_rng, int *max_rng, float *array);
FUNC_PREFIX int get_coords_cyl_rect_n (int ndim, int *dims, float *points, int *min_rng, int *max_rng, float *array);
FUNC_PREFIX int get_coords_spher_unif_n (int ndim, int *dims, float *points, int *min_rng, int *max_rng, float *array);
FUNC_PREFIX int get_coords_spher_rect_n (int ndim, int *dims, float *points, int *min_rng, int *max_rng, float *array);
FUNC_PREFIX int get_connect_struct_n (int ndim, int *dims, int min_cell, int max_cell, int *array);
#endif
/* fld_init.c */
FUNC_PREFIX int FLDinit (void);
/* fld_util.c */
FUNC_PREFIX int get_coord_func (char *field_table, float **coord);
FUNC_PREFIX int get_points_func (char *field_table, float **points);
FUNC_PREFIX int get_connect_func(char *field_table, int set, xp_long **node_list);
FUNC_PREFIX int get_sub_coord_func (char *field_table, xp_long *min_rng, xp_long *max_rng, float *array);
FUNC_PREFIX int FLDget_mesh_info (OMobj_id fld, char **fld_tbl);
FUNC_PREFIX int FLDfree_mesh_info (char *fld_tbl);
FUNC_PREFIX OMobj_id FLDadd_block_table (OMobj_id fld);
FUNC_PREFIX int FLDinterp_init (OMobj_id fld, char *field_table, char **block_table);
FUNC_PREFIX int FLDinterp_end (char *block_tbl);

FUNC_PREFIX int FLDget_time_nsteps (OMobj_id field, int *nsteps);
FUNC_PREFIX int FLDset_time_nsteps (OMobj_id field, int nsteps);
FUNC_PREFIX int FLDget_time_values (OMobj_id field, double **time, int *size, int mode);
FUNC_PREFIX int FLDset_time_values (OMobj_id field, double *time, int size, int mode);
FUNC_PREFIX int FLDget_time_coordinates (OMobj_id field, int step, OMobj_id *coordinates);
FUNC_PREFIX int FLDget_time_node_data (OMobj_id field, int step, OMobj_id *node_data);
FUNC_PREFIX int FLDget_time_cell_data (OMobj_id cell_set, int step, OMobj_id *cell_data);

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
/* access.c */
   #define   FLDget_array_int           FLDget_array_int_n
   #define   FLDget_array_float         FLDget_array_float_n
   #define   FLDget_array_size          FLDget_array_size_n
   #define   FLDget_nnodes              FLDget_nnodes_n
   #define   FLDget_dims                FLDget_dims_n
   #define   FLDset_dims                FLDset_dims_n
   #define   FLDget_npoints             FLDget_npoints_n
   #define   FLDget_coord               FLDget_coord_n
   #define   FLDget_sub_coord           FLDget_sub_coord_n
   #define   FLDget_points              FLDget_points_n
   #define   FLDget_node_data           FLDget_node_data_n
   #define   FLDget_typed_node_data     FLDget_typed_node_data_n
   #define   FLDget_sub_node_data       FLDget_sub_node_data_n
   #define   FLDget_cell_data           FLDget_cell_data_n
   #define   FLDget_typed_cell_data     FLDget_typed_cell_data_n
   #define   FLDget_ncells              FLDget_ncells_n
   #define   FLDget_npolys              FLDget_npolys_n
   #define   FLDget_cell_faces          FLDget_cell_faces_n
   #define   FLDget_node_connect        FLDget_node_connect_n
   #define   FLDset_node_connect        FLDset_node_connect_n
   #define   FLDget_poly_connect        FLDget_poly_connect_n
   #define   FLDset_poly_connect        FLDset_poly_connect_n
   #define   FLDget_poly_nnodes         FLDget_poly_nnodes_n
   #define   FLDcheck_cell_connect      FLDcheck_cell_connect_n
   #define   FLDcheck_mesh_connect      FLDcheck_mesh_connect_n

/* dfuncs.c */
   #define   FLDget_coords_dims         FLDget_coords_dims_n
   #define   FLDget_coords_unif         FLDget_coords_unif_n
   #define   FLDget_coords_rect         FLDget_coords_rect_n
   #define   FLDget_coords_cyl_unif     FLDget_coords_cyl_unif_n
   #define   FLDget_coords_cyl_rect     FLDget_coords_cyl_rect_n
   #define   FLDget_coords_spher_unif   FLDget_coords_spher_unif_n
   #define   FLDget_coords_spher_rect   FLDget_coords_spher_rect_n
   #define   FLDget_connect_dims        FLDget_connect_dims_n
   #define   FLDget_connect_struct      FLDget_connect_struct_n
   #define   get_coords_unif            get_coords_unif_n
   #define   get_coords_rect            get_coords_rect_n
   #define   get_coords_cyl_unif        get_coords_cyl_unif_n
   #define   get_coords_cyl_rect        get_coords_cyl_rect_n
   #define   get_coords_spher_unif      get_coords_spher_unif_n
   #define   get_coords_spher_rect      get_coords_spher_rect_n
   #define   get_connect_struct         get_connect_struct_n
   
#endif

#if !defined(WORDLENGTH_64)
   #define   FLDget_node_connect_w      FLDget_node_connect
   #define   FLDset_node_connect_w      FLDset_node_connect
   #define   FLDget_poly_connect_w      FLDget_poly_connect
   #define   FLDset_poly_connect_w      FLDset_poly_connect
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* XP_FLD_INCLUDED */
