/*
		Copyright (c) 1994 by
		Advanced Visual Systems Inc.
		All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/fld_info.h#1 $
*/

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*PFI)();
typedef void (*PFV)();

#define MAX_FIELD_FUNC   256
#define NUM_FIELD_FUNC   21
#define FIELD_FUNC_interp_init   0
#define FIELD_FUNC_find_cell     1
#define FIELD_FUNC_interp_cell   2
#define FIELD_FUNC_interp_data   3
#define FIELD_FUNC_cell_extent   4
#define FIELD_FUNC_coord_list    5
#define FIELD_FUNC_data_list     6
#define FIELD_FUNC_isosurf       7
#define FIELD_FUNC_isoline       8
#define FIELD_FUNC_cut           9
#define FIELD_FUNC_eval_coord    10
#define FIELD_FUNC_glyph         11
#define FIELD_FUNC_thresh_null   12
#define FIELD_FUNC_rslice        13
#define FIELD_FUNC_grad          14
#define FIELD_FUNC_curl          15
#define FIELD_FUNC_div           16
#define FIELD_FUNC_deriv3d       17
#define FIELD_FUNC_deriv2d       18
#define FIELD_FUNC_contour       19
#define FIELD_FUNC_cell_to_node  20

#define MAX_SET_FUNC   256
#define NUM_SET_FUNC   13
#define SET_FUNC_shape         0
#define SET_FUNC_sh_deriv      1
#define SET_FUNC_rev_par       2
#define SET_FUNC_slice         3
#define SET_FUNC_cut           4
#define SET_FUNC_isoline       5
#define SET_FUNC_vol_integr    6
#define SET_FUNC_contour       7
#define SET_FUNC_tesselate     8
#define SET_FUNC_slice_tesselate         9
#define SET_FUNC_cut_tesselate           10
#define SET_FUNC_isoline_tesselate       11
#define SET_FUNC_contour_tesselate       12

typedef struct _Field_Table {
	char*  field_id;
	int  ndim;
	xp_long  *dims;
	int  nspace;
	xp_long  nnodes;
	float *points;
	float *coord;
	float min_ext[3];
	float max_ext[3];
	PFI  *field_func;
	PFI  coord_func;
	PFI  sub_coord_func;
	PFI  points_func;

	int  nsets;
	xp_long  tot_cells;
	xp_long  *set_beg;
	xp_long  *ncells;
	int  *cell_nnodes;
	int  *cell_ndim;
	int  *cell_order;
	xp_long  **node_list;
	float **node_uvw;
	PFI  *set_func;
	PFI  connect_func;
} Field_Table;

typedef struct _Block_Table {
	xp_long *blocks;
	xp_long  nblocks;
	int  grid_size;
	int  nspace;
	float min_xyz[3];
	float max_xyz[3];
	xp_long *cell_list;
	xp_long *link;
	xp_long list_size;
	int  incr;
	xp_long loc;
	int  exist;
} Block_Table;

#define  FIget_ndim(TBL, NDIM) 	NDIM = TBL->ndim;
#define  FIget_dims(TBL, DIMS) 	DIMS = TBL->dims;
#define  FIget_nspace(TBL, NSPACE) NSPACE = TBL->nspace;
#define  FIget_nnodes(TBL, NNODES) NNODES = TBL->nnodes;
#define  FIget_coord(TBL, COORD) \
{ \
	  COORD = TBL->coord; \
          if (!COORD) { \
		  if ((*(TBL->coord_func))(TBL, &COORD) < 1) { \
			  TBL->coord = (float *)0; \
			  ERRerror("fld_info", 0, ERR_ORIG, "unable to get field coordinates"); \
			  return(0); \
		  } \
	  } \
	  TBL->coord = COORD; \
}

#define  FIget_sub_coord(TBL, MIN, MAX, COORD) \
	if ((*(TBL->sub_coord_func))(TBL, MIN, MAX, COORD) < 1) { \
	            ERRerror("fld_info", 0, ERR_ORIG, "unable to get field sub-coordinates"); \
	            return(0); \
	}

#define  FIget_points(TBL, POINTS) \
{ \
	  POINTS = TBL->points; \
          if (!POINTS) { \
		  if ((*(TBL->points_func))(TBL, &POINTS) < 1) { \
			  TBL->points = (float *)0; \
			  ERRerror("fld_info", 0, ERR_ORIG, "unable to get field points"); \
			  return(0); \
		  } \
	  } \
	  TBL->points = POINTS; \
}

#define  FIget_extent(TBL, MIN_EXT, MAX_EXT) \
{ \
	  MIN_EXT = TBL->min_ext; \
	  MAX_EXT = TBL->max_ext; \
}

#define  FIget_field_func(TBL, FUNC_ID, FUNC) FUNC = (PFI)TBL->field_func[FUNC_ID];

#define  FIget_nsets(TBL, NSETS) NSETS = TBL->nsets;
#define  FIget_tot_ncells(TBL, NCELLS) NCELLS = TBL->tot_cells;
#define  FIget_cell_beg(TBL, SET, BEG) BEG = TBL->set_beg[SET];
#define  FIget_ncells(TBL, SET, NCELLS) NCELLS = TBL->ncells[SET];
#define  FIget_cell_nnodes(TBL, SET, NNODES) NNODES = TBL->cell_nnodes[SET];
#define  FIget_cell_ndim(TBL, SET, NDIM) NDIM = TBL->cell_ndim[SET];
#define  FIget_cell_order(TBL, SET, NDIM) NDIM = TBL->cell_order[SET];
#define  FIget_cell_node_uvw(TBL, SET, UVW) UVW = TBL->node_uvw[SET];

#define  FIget_node_list(TBL, SET, NODE_LIST) \
{ \
	  NODE_LIST = TBL->node_list[SET]; \
          if (!NODE_LIST) { \
		  if ((*(TBL->connect_func))(TBL, SET, &NODE_LIST) < 1) { \
			  ERRerror("fld_info", 0, ERR_ORIG, "unable to get cell set connect list"); \
			  return(0); \
		  } \
	  } \
	  TBL->node_list[SET] = NODE_LIST; \
}

#define  FIget_set_func(TBL, SET, FUNC_ID, FUNC) FUNC = (PFI)TBL->set_func[SET*MAX_SET_FUNC+FUNC_ID];

#ifdef __cplusplus
} /* End of extern "C" */
#endif

