/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/gd_def.h#1 $
*/

#ifdef __cplusplus
extern "C" {
#endif

#define FEPS	1e-10		/* constant for FP error test */

	/* defines for returns from GDxxx_set routines */
#define GD_STAT_SUCCESS		1
#define GD_STAT_ERROR		0

	/* defines for view update modes */
#define GD_VIEW_MANUAL_UPDATE	0
#define GD_VIEW_AUTO_UPDATE	1
#define GD_VIEW_MAX_UPDATE	2

	/* defines for various renderers */
#define GD_SWX_RENDERER		0
#define GD_GL_RENDERER		1
#define GD_XGL_RENDERER		2	/* obsolete */
#define GD_PEX_RENDERER		3	/* obsolete */
#define GD_XIL_RENDERER		4
/* IAC/MPU: added define for MPU renderer */
#define GD_MPU_RENDERER		5
/* IAC/MPU: incremented subsequent defines by 1 */
#define GD_PRT_RENDERER		6
#define GD_VRML_RENDERER        7
#define GD_VPS_RENDERER         8
#define GD_MAX_RENDERERS        9
  /* Currently, all the renderers are cached, but I rather like the idea
   * of saving memory by not caching the file-writing renderers.  Speeding
   * up the render step is pointless when the real bottleneck is file IO.
   */
/* IAC/MPU: increased to 9 to include MPU renderer */
#define GD_MAX_CACHED_RENDERERS 9


        /* constants for type of GDoutput */
#define GD_OUTPUT_FIELD         0
#define GD_OUTPUT_FILE          1
#define GD_OUTPUT_PRT           2
#define GD_OUTPUT_VRML          3
#define GD_OUTPUT_VPS           4


	/* constants for type of GDview */
#define GD_VIEW_NOT_ACCEL	0
#define GD_VIEW_ACCEL		1
#define GD_VIEW_MAX_ACCEL	2

	/* constants for single/double buffer */
#define GD_VIEW_SINGLE_BUFFER	0
#define GD_VIEW_DB_MBX		1
#define GD_VIEW_DB_PIXMAP	2
#define GD_VIEW_MAX_BUFFER	3

	/* constants for view aspect - used with the view
	   window is resize.
        */
#define GD_VIEW_ASPECT_BIGGEST	0
#define GD_VIEW_ASPECT_SMALLEST	1

	/* view configuration flag bits - set/unset according to
	 * renderer, framebuffer, whatever capability
	 */
#define GD_VIEW_CONFIG_STEREO	    1	/* can do stereo */
#define GD_VIEW_CONFIG_STEREO_FULL  2	/* do full screen stereo */
#define GD_VIEW_CONFIG_VIDEO_LIVE   4	/* runtime switchable video mode */
#define GD_VIEW_CONFIG_VLTM         8	/* can do VLTM style tmapping */

	/* view geometry flipbook mode */
#define GD_VIEW_GEOM_FLIPBOOK_OFF	    0
#define GD_VIEW_GEOM_FLIPBOOK_RECORD	1
#define GD_VIEW_GEOM_FLIPBOOK_PLAYBACK	2

        /* light types */
#define GD_MAX_LIGHTS           16
#define GD_LIGHT_DIR            0
#define GD_LIGHT_PT             1
#define GD_LIGHT_SPOT           2
#define GD_LIGHT_BIDIR          3
#define GD_LIGHT_MAX_TYPE       4

	/* defines for view update modes */
#define GD_CAMERA_MANUAL_UPDATE	0
#define GD_CAMERA_AUTO_UPDATE	1
#define GD_CAMERA_MAX_UPDATE	2

	/* constants for type of GDcamera */
#define GD_CAMERA_3D		0
#define GD_CAMERA_2D		1
#define GD_CAMERA_MAX_TYPE	2

	/* constants for extents of GDcamera */
#define GD_CAMERA_COMPUTE_EXTENT	0
#define GD_CAMERA_USE_WINDOW		1
#define GD_CAMERA_EXTENTS_MAX		2

	/* constants for mapping of GDcamera */
#define GD_CAMERA_MAP_WORLD	0
#define GD_CAMERA_MAP_PIXELS	1
#define GD_CAMERA_MAX_MAP	2

	/* defines for dithering */
#define GD_TECH_DITHER		0
#define GD_TECH_RAMP		1
#define GD_TECH_NONE		2
#define GD_TECH_MONOCHROME	3
#define GD_TECH_MAX		4

	/* define for track roll queue size */
#define GD_TRACK_QSIZE		100

/* define for transform mode */
#define GD_XFORM_MODE_NORMAL    0
#define GD_XFORM_MODE_PARENT    1
#define GD_XFORM_MODE_ALT       2
#define GD_XFORM_MODE_LOCKED	3
#define GD_XFORM_MODE_MAX       4

	/* defines for surface conversion */
#define	GD_SURF_CONV_SIMPLE	0
#define GD_SURF_CONV_OPTIMAL	1
#define GD_SURF_CONV_NONE	2
#define GD_SURF_CONV_MAX	3

/* The edge table built by the graph conversion code
   for converting surfaces will be about 23 Mbytes for
   100000 triangles.
   number of edges for 100K trianges is 600K
   each edge entry is 40 bytes.
*/
#define GD_SURF_CHUNK_MIN	100
#define GD_SURF_CHUNK_MAX	100000
#define GD_LINE_CHUNK_MIN	100
#define GD_LINE_CHUNK_MAX	100000

	/* constants for render flags in GDobject */
#define GD_REN_FLAG_UNIFMESH 1
#define GD_REN_FLAG_VOLUME   2
#define GD_REN_FLAG_TILE_VOL 4

	/* constants for type of GDobject */
#define GD_OBJ_STATIC		0
#define GD_OBJ_DYNAMIC		1
#define GD_OBJ_MAX_TYPE		2

	/* bit mask constants for GDobjects */
#define GD_OBJS_ACTIVE			0x1
#define GD_OBJS_3D			0x2
#define GD_OBJS_3D_CHANGED		0x4
#define GD_OBJS_3D_TRANSP		0x8
#define GD_OBJS_3D_TRANSP_CHANGED	0x10
#define GD_OBJS_3D_DYNAMIC		0x20

#define GD_OBJS_2D			0x40
#define GD_OBJS_2D_CHANGED		0x80
#define GD_OBJS_2D_TRANSP		0x100
#define GD_OBJS_2D_TRANSP_CHANGED	0x200
#define GD_OBJS_2D_DYNAMIC		0x400
#define GD_OBJS_2D_IMAGE		0x800

#define GD_OBJS_2D_FORCED		0x1000

#define GD_OBJS_DYNAMIC		GD_OBJS_3D_DYNAMIC | GD_OBJS_2D_DYNAMIC

	/* bit mask constants for type of GDcamera.
	   These also go into the status flags with the
	   GDobject constants.
	*/
#define GD_CAMERAS_3D			0x2000
#define GD_CAMERAS_2D			0x4000

/* bit mask constant for HW/SW renderer */
#define GD_VIEW_HW                      0x8000

        /* bit constants for the notify_flags word in GDobject/GDcamera */
#define GD_NOTIFY_VIEW		0x1
#define GD_NOTIFY_VIRTPAL	0x2
#define GD_AUTO_NORM_DATA	0x4
#define GD_AUTO_NORM_ATTACH	0x8
#define GD_NOTIFY_VIEWLIST	0x10

	/* default scale factor to use during normalization */
#define GD_DEFAULT_NORM_SCALE	0.8

/* default: use invisible objects when normalizing */
#define GD_DEFAULT_NORM_INVISIBLE	1

	/* constants for cameras auto-norm flag */
#define GD_CAMERA_AUTO_NORM_NONE	0
#define GD_CAMERA_AUTO_NORM_DATA	1
#define GD_CAMERA_AUTO_NORM_ATTACH	2
#define GD_CAMERA_AUTO_NORM_ALL		3

	/* geom data types */
#define GD_GEOM_POINTS		0
#define GD_GEOM_POLYLINE	1
#define GD_GEOM_DISJOINT_LINES	2
#define GD_GEOM_TRISTRIP	3
#define GD_GEOM_SPHERES		4
#define GD_GEOM_IMAGE		5
#define GD_GEOM_TEXT		6
#define GD_GEOM_IMAGE_TILED	7
#define GD_GEOM_POLYGON		8
#define GD_GEOM_VOLUME		9
#define GD_GEOM_TRIANGLES	10
#define GD_GEOM_QUADS		11
#define GD_GEOM_NONE            12

	/* cell color types - These are used when rendering 
	   polylines. The cell colors may be passed as one per 
	   polyline or one per segment in the polyline. */
#define GD_CELL_COLOR_CELL	0
#define GD_CELL_COLOR_SEGMENT	1

	/* tile rendering orientation */
#define GD_GEOM_TILE_COLS_BOTTOM 0
#define GD_GEOM_TILE_ROWS_BOTTOM 1
#define GD_GEOM_TILE_COLS_TOP    2
#define GD_GEOM_TILE_ROWS_TOP    3

	/* indices into mode array */
#define GD_MODE_POINTS		0
#define GD_MODE_LINES		1
#define GD_MODE_SURF		2
#define GD_MODE_VOL		3
#define GD_MODE_BOUNDS		4
#define GD_MODE_SIZE		5

        /* point modes */
#define GD_POINTS_INHERIT       0
#define GD_NO_POINTS            1
#define GD_POINTS_PIXEL         2
#define GD_POINTS_DIRECTED      3
#define GD_POINTS_ARROW         4
#define GD_POINTS_CONE          5
#define GD_POINTS_CROSS         6

        /* line modes */
#define GD_LINES_INHERIT        0
#define GD_NO_LINES             1
#define GD_LINES                2
#define GD_LINES_TUBE           3
#define GD_LINES_ARROW          4
#define GD_LINES_RIBBON         5

	/* surface modes */
#define GD_SURF_INHERIT         0
#define GD_NO_SURF              1
#define GD_SURF_NOLIGHT         2
#define GD_SURF_FLAT            3
#define GD_SURF_GOURAUD         4
#define GD_SURF_BACKGROUND      5
/*
#define GD_SURF_PHONG           not implemented
*/

	/* volume modes */
#define GD_VOLUME_INHERIT       0
#define GD_NO_VOLUME            1
#define GD_VOLUME_BTF           2
#define GD_VOLUME_RAY           3

	/* bounds modes */
#define GD_BOUNDS_INHERIT       0
#define GD_NO_BOUNDS            1
#define GD_BOUNDS               2

	/* normals modes */
#define GD_NORMALS_INHERIT      0
#define GD_NO_NORMALS	 	1
#define GD_NORMALS_VERTEX 	2

	/* color modes */
#define GD_COLORS_INHERIT	0
#define GD_NO_COLORS		1
#define GD_COLORS_FACET	 	2
#define GD_COLORS_VERTEX	3

	/* outlining mode on/off */
#define GD_OUTLINE_ON		0
#define GD_OUTLINE_OFF		1

#define GD_CHANGE_MODE		0x1
#define GD_CHANGE_NORMALS	0x2
#define GD_CHANGE_COLORS	0x4
#define GD_CHANGE_OUTLINE	0x8

#define GD_CHANGE_PROP_MAT		0x1
#define GD_CHANGE_PROP_COL		0x2
#define GD_CHANGE_PROP_TRANS		0x4
#define GD_CHANGE_PROP_SCOL		0x8
#define GD_CHANGE_PROP_HI_COL		0x10
#define GD_CHANGE_PROP_LINE_WIDTH	0x20
#define GD_CHANGE_PROP_LINE_STYLE	0x40
#define GD_CHANGE_PROP_LINE_AA          0x80
#define GD_CHANGE_PROP_DRAW_MODE	0x100
#define GD_CHANGE_PROP_FONT		0x200
#define GD_CHANGE_PROP_DIR_PT_SIZE	0x400
#define GD_CHANGE_PROP_SUBDIV           0x800
#define GD_CHANGE_PROP_JITTER           0x1000
#define GD_CHANGE_PROP_CULL             0x2000
#define GD_CHANGE_PROP_VOX_INTERP       0x4000
#define GD_CHANGE_PROP_RAY_ALGO         0x8000
#define GD_CHANGE_PROP_RAY_NORM         0x10000
#define GD_CHANGE_PROP_FAT_RAY          0x20000
#define GD_CHANGE_PROP_SFP_ABSORB	0x40000
#define GD_CHANGE_PROP_SFP_EMIT		0x80000

        /* indices into the material array */
#define GD_MATERIAL_AMBIENT     0
#define GD_MATERIAL_DIFFUSE     1
#define GD_MATERIAL_SPECULAR    2
#define GD_MATERIAL_SPEC_EXP    3

#define GD_PROPS_LINE_SOLID	0
#define GD_PROPS_LINE_DASHED	1
#define GD_PROPS_LINE_DOTTED    2
#define GD_PROPS_LINE_DASHDOT   3

#define GD_PROPS_DRAW_COPY	0
#define GD_PROPS_DRAW_XOR	1

#define GD_CHANGE_XFORM_RSPACE	0x1

/* defines for texture mapping filter modes */
#define GD_FILTER_POINT		0
#define GD_FILTER_BILINEAR	1
#define GD_FILTER_TRILINEAR	2

/* defines for when texture mapping is applied */
#define GD_STAGE_POSTSPECULAR	0
#define GD_STAGE_PRESPECULAR	1

/* backface culling properties */
#define GD_BACKFACE_NORMAL 	0
#define GD_BACKFACE_CULL_BACK   1
#define GD_BACKFACE_CULL_FRONT  2
#define GD_BACKFACE_CULL_FLIP   3

/* defines for types of texture maps */
#define GD_TYPE_UNFILTERED	0
#define GD_TYPE_MIPMAP		1

/* defines for texture mapping tile modes */
#define GD_TILE_CLAMP		0
#define GD_TILE_WRAP		1
#define GD_TILE_BOUNDARY	2

/* defines for texture mapping alpha modes */
#define GD_ALPHA_REPLACE	0
#define GD_ALPHA_MODULATE	1
#define GD_ALPHA_DECAL		2

/* defines for texture mapping method */
#define GD_TXTR_METHOD_NORMAL	0
#define GD_TXTR_METHOD_VLTM	1

/* defines for voxel interpolation */
#define GD_VOX_POINT            0
#define GD_VOX_TRILINEAR        1
#define GD_VOX_TRICUBIC         2

/* defines for tracer algorithm */
#define GD_ALGO_DIRECT           0
#define GD_ALGO_AVERAGE          1
#define GD_ALGO_MAXVALUE         2
#define GD_ALGO_DISTMAX          3
#define GD_ALGO_SFP		 4

/* defines for ray distance normalization */
#define GD_DIST_GLOBAL		0
#define GD_DIST_VIEW		1
#define GD_DIST_RAY             2

/* defines for blending */
#define GD_BLEND_ALPHA		        0
#define GD_BLEND_SATURATE	        1

/* text alignment horizontal */
#define GD_ALIGN_HORIZ_LEFT    0
#define GD_ALIGN_HORIZ_CENTER  1
#define GD_ALIGN_HORIZ_RIGHT   2

/* text alignment vertical */
#define GD_ALIGN_VERT_BASE     0
#define GD_ALIGN_VERT_BOTTOM   1
#define GD_ALIGN_VERT_CENTER   2
#define GD_ALIGN_VERT_TOP      3

/* text option mask - external options */
#define GD_TEXT_OPT_DROP_SHADOW   (1<<1)
#define GD_TEXT_OPT_BOUNDS        (1<<2)
#define GD_TEXT_OPT_UNDERLINE     (1<<3)
#define GD_TEXT_OPT_BACKGROUND    (1<<4)
#define GD_TEXT_OPT_OFFSET        (1<<5)
#define GD_TEXT_OPT_LEADLINE      (1<<6)
#define GD_TEXT_OPT_RADIAL        (1<<7)
#define GD_TEXT_XFORM_MODE	  (1<<8)
#define GD_TEXT_COLOR		  (1<<9)
/* private options for specifying renderer capabilities */
#define GD_TEXT_OPT_ALIGNV        (1<<10)
#define GD_TEXT_OPT_ALIGNH        (1<<11)

/* pick control modes */
#define GD_PICK_CTRL_FRONT	0
#define GD_PICK_CTRL_FIRST	1
#define GD_PICK_CTRL_ALL	2
#define GD_PICK_CTRL_APPEND	3

/* pick selections */
#define GD_PICK_NONE 0
#define GD_PICK_ALL 1
#define GD_PICK_SURFACES 2
#define GD_PICK_LINES 3
#define GD_PICK_POINTS 4

	/* define bit flags for stack/state code */
#define SINGLE_ARG      0x1
#define EXDATA          0x2
#define BOTH_ARGS       0x3

/* Defines needed for software renderer */

#define GD_POWER_TABLE_SIZE	256

/* Special types of node/cell data */
#define GD_UNDEFINED_DATA_ID      0	    /* no special type */
#define GD_NORMAL_DATA_ID	666	    /* vector data represents normals */
#define GD_COLOR_DATA_ID	667	    /* RGB colors, 0 - 1 */
#define GD_RADIUS_DATA_ID	668	    /* data represents radii */
#define GD_RGB_DATA_ID		669	    /* RGB or ARGB colors, 0 - 255 */
#define GD_UV_DATA_ID		670	    /* vector data is UV or UVW texture coords */
#define GD_PICK_DATA_ID		671

/* Formats of framebuffer input/output */
#define	GD_FB_NONE		0		/* don't generate/use FB */
#define	GD_FB_ARGB		1		/* SW/PEX format (canonical) */
#define	GD_FB_RGBA		2		/* OpenGL format (y flipped) */
#define	GD_FB_ABGR		3		/* XGL format */

/* Formats of Z buffer input/output */
#define	GD_ZB_NONE		0		/* don't generate/use ZB */
#define GD_ZB_SHORT		1		/* SW renderer */
#define GD_ZB_FLOAT_1NEAR	2		/* canonical */
#define GD_ZB_FLOAT_0NEAR	3		/* OpenGL renderer (y flipped) */
#define GD_ZB_INT		4		/* XGL (in an Xgl_usgn32) */

#define GD_MAX_RSPACE 3

/* VRML output protocols */

#define GD_WWW_VRML1            0
#define GD_WWW_VRML2            1

/* These are the possible cache modes */

#define GD_CACHE_OFF 0
#define GD_CACHE_ON 1

/* bit constants for datamap and input data changing. */
#define GD_CACHE_DMAP_CHANGED	0x1
#define GD_CACHE_DATA_CHANGED	0x2

/* This is the block size for the cache memory management */
#define GD_CACHE_BLOCK_SIZE 65536

/* flags to indicate how a memory block has been allocated. */
#define GD_CACHE_FLAG_CACHE         1	/* memory owned GD cache */
#define GD_CACHE_FLAG_ARR           2	/* memory owned by OM/ARR */
#define GD_CACHE_FLAG_MALLOC        3	/* memory has been malloc'd */

#define GD_NUM_CLIP_PLANES 16
#define GD_NUM_HIGHLIGHT_COLORS 2

/* Image interpolation types */
#define GD_IMAGE_INTERP_POINT      0
#define GD_IMAGE_INTERP_BILINEAR   1
#define GD_IMAGE_INTERP_BICUBIC    2
#define GD_IMAGE_INTERP_FLAT       3
#define GD_IMAGE_INTERP_SMOOTH     4
#define GD_IMAGE_INTERP_POINT_I    5
#define GD_IMAGE_INTERP_BILINEAR_I 6
#define GD_IMAGE_INTERP_BICUBIC_I  7
#define GD_IMAGE_INTERP_MAX        8

/* Triangle subdivision types */
#define GD_TRI_SUBDIV_ADAPTIVE 0
#define GD_TRI_SUBDIV_FIXED    1

/* Stereo states */
#define GD_STEREO_OFF   0
#define GD_STEREO_LEFT  1
#define GD_STEREO_RIGHT 2

/*---------- default values ----------*/

        /* default light settings */
#define GD_DEFAULT_LIGHT_TYPE   GD_LIGHT_DIR
#define GD_DEFAULT_CONCEN       1.0
#define GD_DEFAULT_ANGLE        45.0
#define GD_DEFAULT_ATTEN        1.0

        /* default color */
#define GD_DEFAULT_RED          1.0
#define GD_DEFAULT_GREEN        1.0
#define GD_DEFAULT_BLUE         1.0

        /* default line properties */
#define GD_DEFAULT_DRAW_MODE    GD_PROPS_DRAW_COPY
#define GD_DEFAULT_LINE_WIDTH   0
#define GD_DEFAULT_LINE_STYLE   GD_PROPS_LINE_SOLID
#define GD_DEFAULT_LINE_AA      0

        /* default glyph metric */
#define GD_DEFAULT_DIR_PT_SIZE  0.5

        /* default jitter */
#define GD_DEFAULT_JITTER       0

        /* default sphere & cylinder subdivision */
#define GD_DEFAULT_SUBDIV       4

        /* default font */
#define GD_DEFAULT_FONT         ""
#define GD_DEFAULT_TEXT_HEIGHT  12        /* pixels */

        /* default material values */
#define GD_DEFAULT_AMBIENT      0.3
#define GD_DEFAULT_DIFFUSE      0.7
#define GD_DEFAULT_SPECULAR     0.4
#define GD_DEFAULT_SPEC_EXP     12.0
#define GD_DEFAULT_TRANS        1.0

        /* default cull */
#define GD_DEFAULT_CULL         GD_BACKFACE_NORMAL

        /* default voxel interpolation */
#define GD_DEFAULT_VOX_INTERP   GD_VOX_TRILINEAR

        /* default ray tracer parameters */
#define GD_DEFAULT_RAY_ALGO     GD_ALGO_DIRECT
#define GD_DEFAULT_RAY_NORM     GD_DIST_GLOBAL
#define GD_DEFAULT_BLEND_MODE   GD_BLEND_ALPHA
#define GD_DEFAULT_FAT_RAY      1
#define GD_DEFAULT_SFP_ABSORB	0.2
#define GD_DEFAULT_SFP_EMIT	0.2

        /* default rspace for transformation */
#define GD_DEFAULT_RSPACE       3

        /* camera defaults */
#define GD_DEFAULT_DEPTH_FRONT  9.0
#define GD_DEFAULT_DEPTH_BACK   15.0
#define GD_DEFAULT_DEPTH_SCALE  0.1

#define GD_DEFAULT_BACK         112.0
#define GD_DEFAULT_FRONT_PAR    -88.0
#define GD_DEFAULT_FRONT_PER    1.0
#define GD_DEFAULT_FROM_Z       12.0

#define GD_DEFAULT_FRONT_CLIP   7.0
#define GD_DEFAULT_BACK_CLIP    17.0

#define GD_DEFAULT_WSIZE        5.0
#define GD_DEFAULT_VIEW_ANGLE   45.0

#define GD_DEFAULT_STEREO_BALANCE 1.0
#define GD_DEFAULT_STEREO_OFFSET  1.0

/*---------- end of defaults ----------*/

#ifdef __cplusplus
} /* End of extern "C" */
#endif
