/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/gd_ren.h#1 $
*/

/*
 *  gd_ren.h - This file contains no definitions of its own.  Instead, it
 *             just includes the machine-specific verison of gd_ren.h.
 */

#ifndef _GD_REN_H_INCLUDED
#define _GD_REN_H_INCLUDED

#include <avs/port.h>

#if defined(__alpha)
#include <alpha/gd_ren.h>
#endif

#ifdef __hpux
#ifdef hp11
#ifdef hp11_64
#include <hp11_64/gd_ren.h>
#else
#include <hp11/gd_ren.h>
#endif
#else
#error Unknown version of HPUX
#endif
#endif

#ifdef _AIX
#include <ibm/gd_ren.h>
#endif

#ifdef MSDOS
#if _MSC_VER >= 1300
/* VC++ 7 version */
#include <pc/gd_ren.h>
#else
/* VC++ 6 version */
#include <pc6/gd_ren.h>
#endif
#endif

#ifdef sol8
#ifdef __sparcv9
#include <s8_64/gd_ren.h>
#else
#include <s8/gd_ren.h>
#endif
#else
#ifdef sol7
#include <s7/gd_ren.h>
#endif
#endif

#ifdef __sgi
#if defined(_ABIN32) && (_MIPS_SIM == _ABIN32)
#include <sgN32/gd_ren.h>
#endif
#if defined(_ABI64) && (_MIPS_SIM == _ABI64)
#include <sg6/gd_ren.h>
#endif
#endif

#endif /* _GD_REN_H_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
