/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/gd_str.h#1 $
*/

#ifndef _GD_STR_H
#define _GD_STR_H

#include <avs/om.h>

#ifndef MSDOS
/* some (older) HP systems don't ship this */
#ifdef MBX_HEADER_FILE_NOT_INSTALLED
#include <avs/multibuf.h>
#else
#include <X11/extensions/multibuf.h>
#endif
#endif

#ifdef sparc
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef float FLOAT2[2];
typedef float FLOAT3[3];
typedef float FLOAT4[4];
typedef int   INT2[2];
typedef int   INT3[3];
typedef int   INT4[4];
typedef short SHORT2[2];
typedef short SHORT3[3];
typedef short SHORT4[4];
typedef unsigned char byte;
typedef double widenum; /* this has to be the biggest type */

/**********************************************/
/* Pixel definitions (public)                 */
/**********************************************/

/*
 * Most machines we deal with have 4 byte integers.
 * One some (maybe all) of them it is a little faster to
 * treat pixels as integers rather than separate bytes.
 * On machines, such as Cray Y-MP, where an int is not 4
 * bytes we must use the more general method.
 */

#ifdef _CRAY
#define REN_PIXEL_IS_NOT_INT 1
#endif

typedef unsigned short ZPIXEL;

/*
 * On machines with 4-byte longs, it might be more efficient
 * to treat pixels as integers rather than 4 separate bytes.
 * On Cray machines (and any other machine where 4 byte integers
 * are not available), it is necessary to handle as separate bytes.
 */

#define RPIXEL_BYTES 4

#if defined(REN_PIXEL_IS_NOT_INT)
typedef unsigned char RPIXEL;
#elif defined(WORDLENGTH_64)
typedef unsigned int RPIXEL;
#else
typedef unsigned long RPIXEL;
#endif

/* Defines Image Form Structure for Passing Image Ptr's around. 
   This is used by the ImageCapture module that is part of the
   Express animation capability.
*/

typedef struct {
   unsigned char *ptr;
   int width;
   int height;
} LImageForm;


typedef struct {
   unsigned char *ptr;
   int width;
   int height;
} CGeomForm;

/**************************************/
/* Data Structures for View           */
/**************************************/

struct _GDview {
  OMobj_id view_id;			/* reference to OM element */
  OMobj_id upd_func;			/* function for view update */
  OMobj_id pick_ctrl_id;		/* reference to pick control element */
  GDwinfo *Winfo;			/* info about view parent window */
  OMobj_id handle_id;			/* reference to UIwinHandle */
  PALvirt *VirtPal;			/* virtual palette attached to view */
  PALfunc change_func;			/* function the virtual palette code will call */
  GDstack *Stack;
  GDstate *State;
  GDlight_info *LightInfo;
  GDviewAttrs *ViewAttr;
  int output_enabled;			/* 1 if output is enabled */
  GDoutput *Output;
  int ncams;				/* number of cameras (ie. viewports) */
  GDcamera **cameras;		        /* array of cameras */
  int cam_seq;				/* seq # for camera array */ 
  int vobjs;				/* number of objects in top level list */
  GDobject **objs;		        /* array of objects */
  int renderer;				/* current renderer */
  int available;			/* 1 if view avail, 0 when renderer changed */
  int status;			   /* status of cameras/objects in the view */
  int mode;				/* update mode - auto/manual */
  int timer;				/* if 1 spew rendering times */
  int pcache;				/* if 1 render to pcache (XGL only) */
  int accel;				/* accel mode for incremental rendering */
  int accel_valid;			/* accel buffers valid */
  int double_buffer;			/* 1 if double buffered */
  float back_col[3];			/* background color */
  int use_parent;			/* 1 if we are rendering to the parent window */
  int clear;				/* 0 = don't clear buffers */
  int aspect;				/* controls view resize */
  int stereo_enable;     /* 1 if we want this view to be able to do stereo */
                        /* must be set when view is created on PC */
  int stereo;			/* 1 if stereo enabled */
  int video;			/* 1 if video mode set to stereo */
  int video_off;		/* external video off control */
  float stereo_balance; 	/* balance between front and back parallax */
  float stereo_offset;		/* size of stereo separation */
  int blend_mode;               /* how to blend volume rendering result with
				   current pixel */

			/* true scale parameters - another way to control orientation */
  int ts_changed;		/* 1 if true scale params have changed. */
  int ts_enable;
  int ts_uniform;               /* 1 if we use ts_scale for both */
  float ts_scale;		/* map scale eg. 1:25000 */
  float ts_yscale;		/* y map scale eg. 1:25000 */
  float ts_xorig;		/* xy origin in meters */
  float ts_yorig;
  float ts_viewx_cm;		/* centimeters in view */
  float ts_viewy_cm;

  /* sequence numbers for update view routine */
  int rend_seq, mode_seq, upd_seq, refresh_seq, accel_seq;
  int timer_seq, pcache_seq, buffer_seq, col_seq, clear_seq;
  int aspect_seq;
  int stereo_seq, stereo_enable_seq, video_seq, video_off_seq;
  int stereo_balance_seq, stereo_offset_seq;
  int ts_enb_seq, ts_unif_seq, ts_scale_seq, ts_yscale_seq, ts_xorig_seq, ts_yorig_seq;
  int blend_mode_seq;

  int render_in_progress;		/* 1 if render in progress */
  int event_in_progress;		/* 1 if resize or expose event in progress */
  int visible_state;			/* visibility of window state */
  int roll_done;			/* used to make sure the track roll matrix is
					   added only one while rendering a view. */

  	/* Stuff associated with being able to accept a
	   frame buffer and Z buffer as input to a view.
        */
  int buf_width, buf_height;
  int buf_seq;
  int have_framebuffer, fb_type;
  char *framebuffer;
  int have_zbuffer, zb_type;
  char *zbuffer;

  int palette_changed;		/* for use on PC to synch up after palette modifications */

  /* flipbook related stuff */
  int flip_mode; /* Idle, Playback or record */
  int nframes;   /* number of frames */
  int cPframe;   /* current playback frame */
  int cCframe;   /* current capture  frame */
  int regen_cache; /* set if the cache needs re-generating */
  int any_caches_trashed; /* set if any of the flipbook frames have been "optimized" 
                             i.e. if either the XGL or PEX renders have wiped our data */
  void *discFrameManager; /* manages storing of textures and geom caches on disc */

  /* renderer specific view functions - cached for performance */
  OMpfi view_avail;
  OMpfi view_create;
  OMpfi view_clear;
  OMpfi view_transp_pass;
  OMpfi view_accel;
  OMpfi view_accel2d;
  OMpfi view_swap1;
  OMpfi view_image_pass;
  OMpfi view_swap2;
  OMpfi view_refresh;
  OMpfi view_delete;
  OMpfi view_resize;
  OMpfi view_set_video_mode;
  OMpfi view_set_left_eye;
  OMpfi view_set_right_eye;
  OMpfi view_get_image;
  OMpfi view_put_image;
  /* end of renderer specific functions */

  /* renderer specific state functions - cached for
     performance. create & delete also cached to
     avoid problems when switching renderers  */
  OMpfi state_create;
  OMpfi state_delete;
  OMpfi state_init;
  OMpfi state_concat_obj_matrix;
  OMpfi state_set_backface_cull;
  OMpfi state_set_jitter;
  OMpfi state_set_camera_attrs;
  OMpfi state_set_color;
  OMpfi state_set_highlight_colors;
  OMpfi state_set_draw_mode;
  OMpfi state_set_font;
  OMpfi state_set_line_width;
  OMpfi state_set_line_style;
  OMpfi state_set_line_aa;
  OMpfi state_set_dir_pt_size;
  OMpfi state_set_cmap;
  OMpfi state_set_depth_cue;
  OMpfi state_set_lights;
  OMpfi state_set_material;
  OMpfi state_set_mode;
  OMpfi state_set_mode_normals;
  OMpfi state_set_mode_outline;
  OMpfi state_set_obj_matrix;
  OMpfi state_set_specular_color;
  OMpfi state_set_subdiv;
  OMpfi state_set_texture;
  OMpfi state_set_transparency;
  OMpfi state_update_matrix;
  OMpfi state_set_drawable;
  OMpfi state_set_viewport;
  OMpfi state_set_vox_interp;
  OMpfi state_set_ray_algo;
  OMpfi state_set_ray_norm;
  OMpfi state_set_blend_mode;
  OMpfi state_set_fat_ray;
  OMpfi state_set_sfp_absorb;
  OMpfi state_set_sfp_emit;
  OMpfi state_set_www_anchor;
  OMpfi state_set_stereo_attrs;
  /* end of renderer specific state functions */

  /* renderer specific primitive functions - cached for performance */
  OMpfi prim_3d_points;
  OMpfi prim_3d_spheres;
  OMpfi prim_3d_lines;
  OMpfi prim_3d_polyline;
  OMpfi prim_3d_polytri;
  OMpfi prim_3d_tris;
  OMpfi prim_3d_quads;
  OMpfi prim_3d_volume;
  OMpfi prim_3d_image;
  OMpfi prim_3d_text;

  OMpfi prim_2d_points;
  OMpfi prim_2d_lines;
  OMpfi prim_2d_polyline;
  OMpfi prim_2d_polylines;
  OMpfi prim_2d_polytri;
  OMpfi prim_2d_tris;
  OMpfi prim_2d_quads;
  OMpfi prim_2d_polygons;
  OMpfi prim_2d_image;
  OMpfi prim_2d_image_tiled;
  OMpfi prim_2d_text;

  /* renderer specific geom functions - cached for performance */
  OMpfi geom_init;
  OMpfi geom_free;
  OMpfi geom_build;
  OMpfi geom_format;
  OMpfi geom_gamma_correct;
  OMpfi vol_free;
};

struct _GDwinfo {
#ifdef MSDOS
  HINSTANCE	hInst;			/* Original instance */
  HWND		Parent;			/* Parent of view window */
  HWND		hWnd;			/* Handle of view window */
  HDC		hdc;			/* Device context of view window */
  int		Depth;			/* Depth of window */
  int		bytes_per_pixel;
  int		xPPM, yPPM;		/* Pels Per Meter */
#else
  Display *disp;			/* X display for view window */
  int screen;
  Widget widget;			/* widget of parent window */
  Window parent;			/* parent of view window */
  Widget view_widget;			/* actual view widget */
  Drawable window;			/* actual view window or pixmap */
#endif
  int offscreen;			/* flag for offscreen mode */
  int x, y, w, h;			/* position and size of view window */
  int dwidth, dheight;			/* width and height of display in pixels */
  int dwidthMM, dheightMM;		/* width and height of display in millimeters */
  void *priv;                           /* renderer private record */
};

/**************************************/
/* Data Structures for Lights         */
/**************************************/

struct _GDlight_info {
  OMobj_id light_info_id;	/* OM element id of light info */
  OMobj_id upd_func;		/* function for object update */
  int changed;			/* set by update func, reset by state func */
  int show_lights;		/* enable/disable display of light rep */
  int nlights;			/* number of lights */
  GDlight **lights;	        /* array of lights */
  int amb_state;		/* ambient light on/off */
  float amb_col[3];		/* ambient light color */
};

struct _GDlight {
  OMobj_id light_id;		/* OM element id of light */
  OMobj_id upd_func;		/* function for update */
  int state;			/* on or off */
  int type;			/* dir, point, bi-dir or spot */
  float col[3];			/* rgb color */
  float att[2];			/* attenuation coefficients for point & spot lights */
  float angle;			/* spread angle for spot lights */
  float concen;			/* concentration for spot lights */
  GDxform *Xform;	        /* object transform and translate */
};

/**************************************/
/* Data Structures for Camera         */
/**************************************/

struct _GDcamera {
  OMobj_id camera_id;		/* associated database element id */
  OMobj_id upd_func;		/* function for update */
  int nviews;			/* number of views containing camera */
  GDview **views;	        /* array of views */
  int nobjs;			/* number of objects in top level list */
  GDobject **objs;       	/* array of objects */
  int status;			/* status of objects in camera */
  int notify_flags;             /* notify virtpal flag */
     			/* viewport specification */
  float vport[4];		/* xmin,ymin,xmax,ymax in view in 0-1 range */
  int vp_xmin, vp_ymin;		/* viewport values in pixels */
  int vp_xmax, vp_ymax;		/* upper left is 0,0 */
  int pick_valid;		/* 1 if pick was within viewport */
  int type;			/* 3d or 2d camera */
  int mode;			/* update mode - auto/manual */
  int auto_norm;		/* if 1 - autonormalize objects when it changes */
  float norm_scale;		/* scale factor to use during normalization */
  int norm_invisible;		/* 0 = don't use invisible objects when normalizing */
  float jitter;			/* user jitter scale factor */
  int extents;			/* 0 = compute, 1 = use window */
  int mapping;			/* 0 = world, 1 = pixels */
  int image_pass;		/* 1 if separate pass for images in 2D cameras */
  int pickable;			/* 1 if camera is pickable */
  float data_extents[6];	/* extents of objects in camera */
  int extents_valid;		/* 1 if extents are valid */
			/* camera orientation parms */
  float from[3];		/* xyz of camera in world space */
  float up[3];			/* direction vector that indicates vertical axis */
  float at[3];			/* Z axis of camera */
  float scale;			/* camera scale */
  GDxform *Xform;          	/* camera transform, translate and center */
  float txform[4][4];		/* rotation & scale matrix */
			/* camera projection parms */
  float front;			/* front clip */
  float back;			/* back clip */
  float fov;			/* angle - field of view */
  float wsize;			/* window size */
  float vxform[4][4];		/* perspective/parallel matrix */
  float cxform[4][4];		/* combined matrix */

  int perspective;		/* 0 = off 1 = on */
  int hither;			/* 0 = front/back clip disabled 1 = enabled */
  int depth_cue;		/* depth cue enabled flag */
  float depth_front;		/* depth cue parameters */
  float depth_back;
  float depth_scale;

  /* flipbook record */
  int        saved_nobjs;
  GDobject **saved_objs;
  struct _GDflipbook *flipbook;

  /* data base sequence number for camera update routine */
  int objs_seq, upd_seq, type_seq, mode_seq, xform_seq;
  int xmin_seq, ymin_seq, xmax_seq, ymax_seq;
  int from_seq, at_seq, up_seq, scale_seq;
  int pers_seq, hither_seq, front_seq, back_seq, fov_seq, wsize_seq;
  int dcue_seq, dfront_seq, dback_seq, dscale_seq;
  int norm_seq, ext_seq, map_seq, pick_seq, ip_seq;
  int norm_scale_seq, norm_invisible_seq, jitter_seq;
};

/**************************************/
/* Data Structures for View Attribs   */
/**************************************/

struct _GDviewAttrs {	/* flags for various rendering options */
  int zbuffer;
  int shadow;
  int global_antialias;
  int doublebuffer;
  int sort_trans;
  int hw_spheres;
  int freeze;
};

/**************************************/
/* Data Structures for output         */
/**************************************/

struct _GDoutput {
  OMobj_id out_id;
  OMobj_id view_id;	/* id of view output is attached to. */
     /* Needed for file/field output classes. */
  int flip;
  int clear;		/* clear output buffer for field output */
  int fb_type;		/* frame buffer format: ARGB, RGBA, ABGR */
  int zb_type;		/* z buffer format: SHORT, 1NEAR, 0NEAR */

  GDprtOutput  *prtOutput;
  GDvrmlOutput *vrmlOutput;
  GDfileOutput *fileOutput;
  void         *vpsOutput;
};

/* Data specific to printer output */
struct _GDprtOutput {
  char *file;
  int format;
  int backgroundType;
  int orientation;
  int size;
  float widthMM;
  float heightMM;
  int resolution;
  float fromRatio;
  int fromWidth;
  int fromHeight;
  int file_valid, format_valid, backgroundType_valid;
  int orientation_valid, size_valid, widthMM_valid;
  int heightMM_valid, resolution_valid, fromRatio_valid;
  int fromWidth_valid, fromHeight_valid;
#ifdef MSDOS
  void * pdevModes;
  void * pdevNames;
#endif
};

/* Data specific to VRML output */
struct _GDvrmlOutput {
  char *file;                /* filename             */
  int  protocol;             /* GD_WWW_VRML1 / VRML2 */
  int  floatPrec;            /* general FP precision */
  int  xformPrec;            /* xform   FP precision */
  int  colorPrec;            /* color   FP precision */
  int  indent;               /* indent output format */
  int  suppressNormals;      /* don't generate normals */
  int  compress;             /* compress (gzip) output file */
  int  width;                /* view width           */
  int  height;               /* view height          */
  void *vrml;
};

/* Data specific to file output */
  struct _GDfileOutput {
  char *filename;
};

/**************************************/
/* Data Structures for Object         */
/**************************************/

struct _GDobject {
  OMobj_id obj_id;		/* reference to object data element */
  OMobj_id upd_func;		/* function for object update */
  OMobj_id field_id;		/* reference to field data */
  OMpfi render_func;		/* get the render method */
  int render_flags;		/* non-zero if render func is uniform mesh/volume */
  int field_seq;		/* sequence number of data last render */
  int new_field_seq;		/* sequence number of data this render */
  OMobj_id dmap_id;		/* reference to datamap */
  int dmap_seq;			/* sequence number of data map */
  int nviews;			/* number of views containing object */
  GDview **views;	        /* array of views */
  int ncams;			/* number of cameras (ie. viewports) containing object */
  GDcamera **cameras;	        /* array of cameras */
  int nparents;			/* number and list of parents of object */
  GDobject **parents;      	/* array of parents */
  int nchildren;		/* number and list of children object has */
  GDobject **children;     	/* array of children */
  int use_altobj;		/* 1 if alternate object to be used */
  GDobject *altobj;	        /* pointer to alternate object */
  GDprops *Props;	        /* object property information */
  int props_seq;		/* props seq number */
  GDmodes *Modes;	        /* rendering/shading mode information */
  int modes_seq;		/* modes seq number - change invalidates cache */
  GDtexture *Texture;	        /* texture mapping information */
  int texture_seq;		/* texture seq number */
  int xform_mode;		/* transform mode of object */
  int xform_mode_seq;
  GDxform *Xform;	        /* object transform and translate */
  int xform_seq;		/* xform seq number */
  GDxform *AltXform;	        /* alternate transform and translate */
  int alt_xform_seq;		/* xform seq number */
  GDxform *TxtrXform;	        /* texture transform and translate */
  int txtr_xform_seq;		/* xform seq number */
  int rspace_seq;		/* rspace seq number - change invalidates cache */
  GDpick_info *PickInfo;        /* pick information for an object */
  int notify_flags;             /* notify view/virtpal or both flags */
  int cache_flags;		/* dmap or data changed flags */
  GDcache_header *cache[GD_MAX_CACHED_RENDERERS]; /* this is where the cached geom lives */
  int visible;			/* object visibility flag */
  int space;
  int pickable;			/* object pickability flag */
  int cached;			/* cache enable flag */
  xp_long cache_size;		/* size of cache allowed in megabytes */
  int cache_toobig;		/* 1 if data too render will exceed the cache size */
  int surf_conv;		/* how surfaces are converted to tri-strips */
  int chunk;			/* 1 if chunking is enabled */
  int surf_chunk_size;		/* # primitives to chunk at a time */
  int line_chunk_size;
  int surf_subdiv;		/* controls quad subdivision */
  int active;			/* object is being directly manipulated */
  int type;			/* object is either dynamic or static */
  int dith_tech;		/* how to dither images */
  int interp_type;		/* image interpolation type */
  int tmap_method;		/* texture mapping method: usually "normal" */
  int tri_subdiv_type;		/* triangle subdivision type */
  int tri_subdiv_aval;		/*                      adaptive value */
  int tri_subdiv_fval;		/*                      fixed value */

  char www_url[128];            /* VRML anchor url */
  char www_label[128];          /* VRML anchor label */
  char name[128];               /* object name */

  float missing_val;
  float missing_rgb[3];         /* value(s) for empty pixels when rotating,
				 * tiling, etc: should really be widenums! */
  int has_window;		/* set to 1 if the object's window has been set */
  float window[6];		/* used when normalizing object */
  int status;			/* 3d/2d/transparent/dynamic */
  int old_status;		/* 3d/2d/transparent/dynamic last frame */
  int changed;			/* obj has changed - needs to be re-rendered */
  int rspace;			/* space of highest camera the object is attached to */
			/* info from data attached to object */
  int nspace;
  int vert_extents;		/* 1 if we actually have the extents */
  float vert_min[3];		/* xyz min values */
  float vert_max[3];		/* xyz max values */

  /* sequence numbers for update routine */
  int child_seq;		/* seq # for children object array */
  int vis_seq, pick_seq, cache_seq, active_seq, type_seq;
  int dith_seq, interp_seq, missing_val_seq, wind_seq;
  int convert_seq, chunk_seq, schunk_seq, lchunk_seq;
  int missing_rgb_seq, tmap_method_seq;
  int tri_subdiv_type_seq, tri_subdiv_aval_seq, tri_subdiv_fval_seq;
  int space_seq, altobj_seq, cache_size_seq;
  int www_url_seq, www_label_seq, name_seq;
  int surf_subdiv_seq;

  /* flipbook */
  int renderer; /* current renderer */
  int geom_field_seq;
  int geom_xform_seq;
  int geom_nchildren;

  int cache_id; /* unique cache_id used for flipbook during disc caching */
  int txtr_id;  /* unique txtr_id used for flipbook during disc caching */

  int interleave;  /* was the last frame generated with interleaved data */

  GDprops *GeomProps;
  GDmodes *GeomModes;
  GDxform *GeomXform;

  int geom_props_seq;
  int geom_modes_seq;
};

/*************************************************
 *               FlipBook structures             *
 *************************************************/

/* Frame Structure */
struct _GDframe {
  int nobjs;			/* number of objects in top level list */
  GDobject **objs;
  struct _GDframe *next;
};

/* Flipbook main header */
struct _GDflipbook {
  int nframes;
  GDframe *list;
  GDframe *last;
  GDframe *curr, *prev_curr;
};

/* 
 * end of flipbook definitions
 */

struct _GDobj_list {
  int level;			/* level object is at in heirarchy */
  OMobj_id obj_id;		/* element id of object */
  char name[128];		/* keep name of object too. */
};

struct _GDobj_sel {
  OMobj_id view_id;		/* current GDview being edited */
  OMobj_id upd_id;		/* update function in GDobj_sel */
  OMobj_id picked_obj;		/* current picked object */
  OMobj_id cur_obj;		/* current object from list widget */
  int nobjs;			/* number of objects in view */
  int list_size;		/* alloced size of obj list */
  GDobj_list *obj_list;		/* array of objects in view */
  int name_seq;			/* seq number for curobj_name */
};

/**************************************/
/* Data Structures for Properties     */
/**************************************/

struct _GDprops {
  OMobj_id props_id;		/* associated database element id */
  OMobj_id upd_func;		/* id of update function */
  int changed;			/* changed flag values */
  int saved_changed;		/* saved change when inherit is set */
  float col[3];			/* color */
  float hi1_col[3];		/* highlight color 1 */
  float hi2_col[3];		/* highlight color 2 */
  float material[4];		/* ambient, diffuse, specular, spec_exp */
  float spec_col[3];		/* specular color */
  float trans;			/* transparency */
  int draw_mode;		/* copy, xor, etc... */
  int line_width;		/* line width 0 = default (fastest method) */
  int line_style;		/* line style */
  int line_aa;                  /* line anti-aliasing */
  float dir_pt_size;		/* length of directed points */
  int subdiv;                   /* sphere and cylinder subdivision */
  int cull;			/* backface culling mode */
  int jitter;                   /* logical jitter level */
  int vox_interp;               /* vol interpolation scheme: 
                                   point, trilinear, tricubic */
  int ray_algo;                 /* ray tracer algorithm */
  int ray_norm;                 /* distance-to-maximum normalization */
  int fat_ray;                  /* ray tracer 4x4 acceleration */
  float sfp_absorb;		/* absorption coefficient for SFP algorithm */
  float sfp_emit;		/* emission coefficient for SFP algorithm */
  char font[128];               /* font used for text */
  int inherit;			/* inherit props from parent */
  int cache_valid;		/* 0 if props subobject causes cache invalidation */
  int ref_count; /* reference count - used by flipbook */
};

/**************************************/
/* Data Structures for Data/Color Maps*/
/**************************************/

struct _GDcolor {
    float r;
    float g;
    float b;
};

/**************************************/
/* Data Structures for Modes          */
/**************************************/

struct _GDmodes {
  OMobj_id modes_id;		/* associated database element id */
  OMobj_id upd_func;		/* function for update */
  int changed;			/* changed flag for all values below */
				/* mode[0] = points, mode[1] = lines, modes[2] = surf */
  int mode[GD_MODE_SIZE];	/* mode[3] = volume, mode[4] = bounds */
  int normals;			/* none, facet or vertex */
  int colors;			/* none, facet, vertex */
  int outline;			/* on, off */
  int visible;			/* visible/invisible flag */
  /* flipbook */
  int ref_count;                   /* reference count - used by flipbook */
};

/**************************************/
/* Data Structures for Texture        */
/**************************************/

struct _GDtexture {
  OMobj_id texture_id;		/* associated database element id */
  OMobj_id upd_func;		/* function for update */
  int alloced;			/* 1 if (renderer specific) structs built */
  int changed;			/* changed flag for all values below */
  int data_changed, cmap_changed;
  unsigned char *data;
  OMobj_id data_id;
  unsigned char *colormap;
  OMobj_id colormap_id;
  int ndims, ncomps;
  int width, height, depth;
  int tile, alpha, filter, type, stage;
  int data_seq, colormap_seq;
  OMpfi txtr_free_func;		   /* renderer specific txtr free function */
  void  *privs[GD_MAX_RENDERERS];  /* renderer private records */

  /* flipbook */
  int ref_count; /* reference count - used by flipbook */
  int renderer;  /* current renderer */
  int txtr_id;   /* unique txtr_id used for flipbook during disc caching */

};

/**************************************/
/* Data Structures for Text           */
/**************************************/

/* this is the C struct to match the V definition in fld.v */

/* required fields are str, nspace and position            */
/* other, newer, subobjects are optional, if they are not  */
/* set a suitable default will be used                     */

typedef struct _GDtext {
    char*        str;
    int          nspace;
    float        *position;        /* [nspace] */
    int          align_h;
    int          align_v;
    unsigned int options;          /* combines all the option bits */
    float        *offset;          /* NULL or [nspace] */
} GDtext;

/* This is the C struct to match the V definition in fld.v.
   There are also some additional things that are calculated
   from the original parameters.
*/

typedef struct _GDstrokeText {
    int font;           /* 0-8 - all normal size hershey fonts */
    int style;          /* 0=vector, 1=quads, 2=3D, 3=scaled vector */
    int plane;          /* 0=XY, 1=XZ, 2=YZ */
    int orient;         /* 0=-->, 1=up, 2=<--, 3=down, 4=arbitrary */
    int path;           /* 0=l-to-r, 1=up, 2=r-to-l, 3=down */
    int space_mode;     /* 0=fixed, 1=proportional */
    float spacing;      /* spacing scale factor */
    float angle;        /* angle of rotation in plane */
    float height;       /* scale to apply to width,height */
    float expansion;    /* non-uniform X character expansion */
    float width;        /* for poly/3D styles */
                        /* calculated parameters */
    float mat[4][4];
    float align_mat[4][4];
    float extents[6];           /* extents of whole (multi-line)text string */
    float *line_extents;        /* array of extents - 6 values per line */
    int nlines;                 /* number of lines of text */
    int length;                 /* number of characters in string */
    int cur_line;		/* current line we are working on */
} GDstrokeText;

/**************************************/
/* Data Structures for Xform          */
/**************************************/

		/* for object, camera, light, texture */
struct _GDxform {
  OMobj_id xform_id;		/* associated database element id */
  int changed;			/* changed flag - only for rspace now */
  float xform[4][4];		/* rotation & scale */
  float xlate[3];		/* translation */
  float center[3];		/* center of rotation */
  float matrix[4][4];		/* composite matrix from xform, xlate & center */
  int rspace;			/* rspace of object, either 2 or 3 */
  float dcenter[3];		/* delta in center - used to keep obj from */
				/* moving when center is changed */
  int is_rolling;		/* 1 if "track rolling", means concat... */
  float roll_xform[4][4];	/* ...this stuff on each render */
  float roll_xlate[3];
			/* sequence numbers for update routine */
  int mat_seq, xlate_seq, center_seq, rspace_seq;
  int ref_count; /* reference count - used by flipbook */
};

/* Queue used for track rolling */
typedef struct _q_t {
   int x, y;
   unsigned int time;
} q_t;

struct _GDtrack_edit {
  OMobj_id edit_id;		/* associated database element id */
  OMobj_id upd_func, del_func;	/* functions for update, delete */
  OMobj_id xform_id;		/* current GDxform being edited */
  int state;

  float last_x, last_y;
  float orig_x, orig_y;
  float CurTrackInverseMatrix[4][4];	/* Inverse matrix for translations */
  float CurTrackTransposeMatrix[4][4];	/* Tranpose matrix for rotations */

  int qct;			/* Number of queue entries in the queue (+1) */
  q_t qptr[GD_TRACK_QSIZE];	/* Q of the last QSIZE motion events, times and x/y */
};

/**************************************/
/* Data Structures for Pick Data      */
/**************************************/

	/* pick information that is associated with each object */
struct _GDpick_data {
  int sx, sy;		/* screen space xy of pick */
  float vert[3];	/* xyz of nearest vertex */
  float point[3];	/* interpolated xyz of picked point */
  xp_long verti;		/* 0-based index into coordinate array */
  xp_long conni;		/* 0-based index into connectivity array */
  xp_long primi;		/* 0-based primitive index */
  float dist;		/* interpolated screen space z of picked point */
  OMobj_id field_id;    /* field id - needed if array of fields picked */
  OMobj_id values_id;   /* coordinates.values id */
  OMobj_id data_id;	/* cell_set_id */
};

struct _GDpick_info {
  OMobj_id pick_info_id;	/* associated database element id */
  int changed;			/* pick data changed flag */
  float dist;			/* closest of all picked primitives */
  float viewxform[4][4];
  float topxform[4][4];
  float objxform[4][4];
  int selected;			/* 1 if picked */
  int npicked;
  GDpick_data *pick_data;
		/* The view, camera and objects that make up the
		   pick path. Includes the object itself. */
  OMobj_id view_id;
  OMobj_id cam_id;
  int sobjs;			/* size of existing array */
  int nobjs;
  OMobj_id *obj_ids;
};

/* screen space text extent for picking */
typedef struct _GDtext_extent {
  int x, y;     /* top left corner on the screen */
  int w, h;     /* clipped width and height of the text */
} GDtext_extent;


/********************************************/
/* This structure holds all of the info the */
/* lower level drawing routines need (about */
/* vertices, etc.).                         */
/********************************************/

struct _GDgeom_data {
  char name[128];               /* object name */
  int geom_type;		/* GD_GEOM_POINTS, etc (see gd_def.h) */
  xp_long ngeoms;                   /* array size for multi-primitives    */
  xp_long n, x, y, z;
  int nspace, rspace;
  float *vert, *vert_base;
  int vert_alloced;
  xp_long num_vert_alloced;
  xp_long npolys;					/* number of polygons */
  int *nnodes_array, *nnodes_array_base;	/* nnodes per polygon */
  int nnodes_alloced;
  int poly_flag;				/* convex, nonconvex, complex flag */
  float *normal, *normal_base;
  int normal_alloced;
  int normal_generated;
  float *radius, *radius_base;
  int radius_alloced;
  float *color, *color_base;
  int color_alloced;
  byte *argb, *argb_base;
  int argb_alloced;
  byte *rgb, *rgb_base;
  int rgb_alloced;
  float *cell_normal, *cell_normal_base;
  int cell_normal_alloced;
  float *cell_color, *cell_color_base;
  int cell_color_alloced;
  int cell_color_type;		/* 0=cell, 1=segment */
  float *ndata, *ndata_base;	/* interleaved node data (renderer specific):
				   verts [colors] [normals] [uvs] */
  int ndata_alloced;
  float *fdata, *fdata_base;	/* interleaved facet data: [colors] [norms] */
  int fdata_alloced;
  float *ldata, *ldata_base;	/* interleaved line data: verts [colors] */
  int ldata_alloced;
  float *pdata, *pdata_base;	/* interleaved dir pnt data: verts [colors] */
  int pdata_alloced;

  int node_type; 		/* data type of value, min, max */
  int node_size; 		/* size of data type */
  int cache_flags;		/* dmap or data changed flags */
  int null_flag;
  widenum null_value;		/* this just has to be big enough to
				   hold any data type. */
  void *node_value, *node_value_base;	/* can point to any type of data */
  widenum node_min, node_max;		/* range of above values */
  int cell_null_flag;
  widenum cell_null_value;	/* this just has to be big enough to
				   hold any data type. */
  int node_value_alloced;

  xp_long *connectivy;		/* connectivity array (per cell set) */
  int conn_alloced;

  int cell_type; 			/* data type of value, min, max */
  int cell_size; 			/* size of data type */
  void *cell_value, *cell_value_base;	/* can point to any type of data */
  void *tmp_cell_value;			/* used when removing null cells */
  int tmp_cell_value_alloced;
  widenum cell_min, cell_max;		/* range of above values */
  int cell_value_alloced;
  float *transp, *transp_base;
  int transp_alloced;
  float *uv, *uv_base;
  int uv_alloced;
  float *uvw, *uvw_base;
  int uvw_alloced;
  int have_vert_extents;	/* 0 = no extents, 1 = extents */
  float vert_min_ext[3], vert_max_ext[3];	/* xyz vertex extents */

  int have_surface;		/* 1 if object has a surface type cell set */
  int have_lines;		/* 1 if object has a line type cell set */

  float im_mat[4][4];		/* fullmat for rotate/scale updates */
  float im_scaled[2];		/* image scaled width, height */
  float im_border[2];		/* image border width, height */
  float im_angle;               /* rotation angle (degrees) */
  float im_vpw, im_vph;		/* camera viewport width, height */

  int tile_start;		/* tile info: start slice in volume      */
  int tile_ntiles;		/*            number to draw from start  */
  int tile_w_format;		/*            format for width (ntiles)  */
  int tile_h_format;		/*                       height          */
  int tile_orient;		/*            orientation (see gd_def.h) */
  int tile_border;              /* width of border within container      */
  int tile_cont_mode;		/* container mode, 0 or 1 */
  int tile_xform_identity;      /* 1 if tile_xform need not be applied */
  float tile_xform[4][4];       /* the local tile xform */

  int align_horiz;              /* alignment in the local text x coord */
  int align_vert;               /* alignment in the local text y coord */
  unsigned int text_options;    /* bit mask of text options */
  float text_offset[3];         /* nspace array of offsets              */
                                /* coord system depends on render mode: */
                                /*    annotation (NDC), stroke (WC)     */

  void *vol_data;		/* data specific to volume rendering */

  OMpfi geom_free_func;		/* renderer specific geom   free function */
  OMpfi vol_free_func;		/* renderer specific volume free function */

  void *priv;                   /* renderer private record */
};

struct _GDcache {
  GDgeom_data *data;
  int   renderer;
  int   prim_index_2d;
  OMpfi prim_func_2d;
  int   prim_index_3d;
  OMpfi prim_func_3d;
  struct _GDcache *next;
};

struct _GDcache_block {
    char *mem;
    char *next_addr;
    xp_long remain;
    GDcache_block *next;
};

struct _GDcache_header {
  int ref_count;
  int cache_id; /* unique cache_id used for flipbook during disc caching */
  GDcache *list;
  GDcache *last;
  GDcache_block *blocks;
  struct _GDcache_header *gfa_copy; /* pointer to copy of this cache, used by flipbook */
};


/**************************************/
/* Data Structures for Renderer Stack */
/**************************************/

typedef struct _stackentry {
  char *name;			/* Name of routine to call */
  OMpfi func;			/* Pointer to function to call */
  int args;			/* How to call restore function: both data and exdata,
				   data or exdata. */
  int size;			/* Size of "exdata" for this entry                */
  int exoffset;			/* Offset into exbuffer for data                  */
  char *data;			/* first int of the data (often all the data)     */
} stackentry;

struct _GDstack {
  stackentry *stack_buff;	/* pointer to memory containing stack */
  int stackptr;			/* index to current stack entry */
  int stacksize;		/* size in bytes of the allocated stack */
  int state_level;		/* current stack level for debugging */
  char *exbuff;
  int exbuffoff;
  int exbuffsize;
  int restore;
  int enabled;
};

/**************************************/
/* Data Structures for Renderer State */
/**************************************/

struct _GDclip {
   int status;
   float coeffs[4];
};

/* structure containing info for cached lights */
struct _GDstate_lights {
  int state;			/* on or off */
  int type;			/* dir, point, bi-dir or spot */
  float col[3];			/* rgb color */
  float att[2];			/* attenuation coefficients for point & spot lights */
  float angle;			/* spread angle for spot lights */
  float concen;			/* concentration for spot lights */
  float tdir[3];		/* transformed direction */
  float tpos[3];		/* transformed position */
};

struct _GDstate {

  GDview *view;			/* pointer to view associated with state */
  GDcamera *camera;	        /* pointer to current camera associated with state */
  int width, height;		/* width & height of view */
  GDobject *obj;		/* used by PEX, XGL renderers for caching */

  /* the image draw buffer(s) are here to be shared amongst renderers,
   * i.e. not be exclusively SW so that other renderers can use the SW im draw
   * funcs if they wish...
   */
  char *ipixmap;                /* image pixmap */
  int ialloced_size;            /* current allocated size of image pixmap */

  int buf2d_size;		/* size of 2d buffer */
#ifndef MSDOS

  Pixmap pbuf2d;		/* !NULL if using pixmap */
  Multibuffer mbuf2d[2];	/* !NULL if using mbx extension */
  int cur_mbuf;			/* either 0 or 1 to indicate the current buffer */

#ifdef sparc
  XImage *shm_image;            /* use the MIT-SHM extension if available */
  int shm_rw;
  XShmSegmentInfo shm_info;
  int shm_size;                 /* current allocated size of shm_image */
#endif

  Drawable drawable;		/* window or accel buffer */
  GC gc;			/* GC for drawable */
  GC draw_gc;			/* GC for clearing/copying */
  long max_points;		/* max number in a X request */
  long max_lines;		/* ditto */

  XFontSet fontset;             /* current fontset */
  char     *fontset_name;       /* user font in current fontset */
  XFontSet fixed_fontset;	/* default local fontset */

#else /* MSDOS */

  int draw_buffer;		/* 0=back buffer, 1=front buffer */
  HBITMAP buf2d;		/* saved bitmap from 2d hdc */

  HBITMAP Drawable;		/* Dither bitmap back from CreateDIBSection */
  HDC hdc;			/* Device context for current Drawable */

  HFONT hFixedFont;		/* Default font */
  HFONT hFont;			/* User font */
  char *font_name;		/* User font name */

#endif /* MSDOS */

#ifdef POWER_IMAGE
  PWIHandle hPWI;               /* handle to image for PowerImage */
  unsigned int pwiInfo;
  PWIMapHandle hMap;            /* handle to map for window leveling */
  int handleValid;
#endif

  int gc_valid; 		/* if false, the GC for 2D drawing is needs
				   to be updated */
  float col[3];			/* surface color */
  float material[4];		/* ambient, diffuse, specular, exp */
  float spec_col[3];		/* specular color */
  int transp_flag;
  float transp;			/* transparency level */
  int mode[GD_MODE_SIZE];	/* drawing modes */
  int mode_normals;		/* normal generation mode */
  int mode_outline;		/* 0 = on (default) 1 = off (to "override") */
  int depth_cue;		/* depth cueing */
  float depth_front_scale;	/* depth cue parameters */
  float depth_back_scale;
  float depth_front;
  float depth_back;
  float high_col[GD_NUM_HIGHLIGHT_COLORS][3];
                                /* the highlight colors for outline modes */
  int draw_mode;
  int xform_mode;		/* for 2D prims. if 1, use Z, if 0 ignore Z */
  char font[128];
  int line_width;
  int line_style;
  int line_aa;
  float dir_pt_size;
  int subdiv;                   /* sphere and cylinder subdivision */
  int cull;			/* backface culling mode */
  int vox_interp;               /* voxel interpolation method */
  int ray_algo;                 /* ray tracer algorithm */
  int ray_norm;                 /* distance-to-maximum normalization */
  int blend_mode;               /* how to blend result with current pixel */
  int fat_ray;                  /* ray tracer 4x4 acceleration */
  float sfp_absorb;		/* absorption coefficient for SFP algorithm */
  float sfp_emit;		/* emission coefficient for SFP algorithm */
  int dith_tech;		/* dither technique for displaying images */
  int interp_type;		/* image interpolation type */
  int tmap_method;		/* texture mapping method: usually "normal" */
  int tri_subdiv;		/* triangle subdivision level */
  float missing_val;		/* "empty" pixel value on rotation, etc */
  float missing_rgb[3];         /* "empty" pixel value on rotation, etc */
  float zoffset;		/* offset for outline mode */
  int   jitter_level;           /* logical jitter level */
  float jitter_offset;          /* NDC offset for each level of jitter */
  float vport[4];		/* current drawing viewport in 0-1 range. */
  float viewmat[4][4];		/* view matrix */
  float objmat[4][4];		/* object matrix */
  float fullmat[4][4];		/* view matrix * object matrix */
  float txtrmat[4][4];		/* texture matrix */
  int rspace;			/* rspace for object = 2 or 3 */
  GDpick_info *PickInfo;	/* ptr to pick info for object being picked */
  GDpick_data PickData;	        /* copy of pick data for pick routines */
  int picksx, picksy;		/* screen space xy coord for picking */
  float pickx, picky;		/* xy coord for picking */
  int pickmode;			/* pick mode */
  float pick_dist;		/* pick distance */
  float pickpos[3];
  float pickvec[3];
  OMobj_id dmap_id;		/* id of the current data map */
  int nclips;			/* number of clip planes */

  GDclip *clips[GD_NUM_CLIP_PLANES];
  GDclip clip_planes[GD_NUM_CLIP_PLANES];

  /* make this a dynamically allocated array */
  GDstate_lights lights[GD_MAX_LIGHTS];	/* lights info */

  /* Shape functions for quad tesselation */
  int shape_alloced;
  float *shape1, *shape2, *shape3, *shape4;

  int   stereo_state;		/* GD_STEREO_OFF, LEFT, RIGHT */
  float stereo_balance; 	/* balance between front and back parallax */
  float stereo_offset;		/* size of stereo separation */
  
  GDtexture *texture;
  void *priv;                   /* renderer prvate record */
};

#ifdef __cplusplus
} /* End of extern "C" */
#endif
#endif
