/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/geom.h#1 $
*/
/*		@(#)geom.h	8.3 AVS 92/10/13	*/

#ifndef GEOM_ALREADY_INCLUDED
#define GEOM_ALREADY_INCLUDED

/*
 * This depends on stdio.h when using ANSI function prototypes.
 */

#ifndef _NFILE
#include <stdio.h>
#endif

#include <avs/mem_defs.h>

#ifdef __cplusplus
extern "C" {
#endif
/* Constant used for NULL in fortran expressions */
#ifndef F77
#define GEOM_NULL 0
#define F77_NULL_PTR 0x7fffffff   /* MUST MATCH GEOM_NULL VALUE */
#define F77_PTR(a) ((F77_NULL_PTR == (*((int *)a))) ? NULL : (a))
#endif /* F77 */

#ifdef F77
#define GEOM_NULL 0x7fffffff   /*_F77_s: GPNULL */
#endif /* F77 */

#ifndef F77
#include <avs/port.h>
#endif /* F77 */

#define GEOM_MESH	1      /*_F77_s: GPMESH */
#define GEOM_POLYHEDRON 2      /*_F77_s: GPPLYH */
#define GEOM_POLYTRI	3      /*_F77_s: GPPTRI */
#define GEOM_SPHERE	4      /*_F77_s: GPSPHR */
#define GEOM_LABEL	5      /*_F77_s: GPLABL */

/* Property types */
#define GEOM_COLOR	1      /*_F77_s: GPCOL  */
#define GEOM_AMBIENT	2      /*_F77_s: GPAMBI */
#define GEOM_DIFFUSE	3      /*_F77_s: GPDIFF */
#define GEOM_SPECULAR	4      /*_F77_s: GPSPEC */
#define GEOM_PICKABLE	5      /*_F77_s: GPPICK */
#define GEOM_POLYGON_TYPE 6    /*_F77_s: GPPLYT */

#define GEOM_SHARED	0      /*_F77_s: GPSHAR */
#define GEOM_NOT_SHARED 1      /*_F77_s: GPNSHR */

/* To the GEOMgen_normals function.  If set causes facet normals */
#define GEOM_FACET_NORMALS 1   /*_F77_s: GPFNRM */

/* Data associated with object */
#define GEOM_NORMALS	1      /*_F77_s: GPNORM */
#define GEOM_VCOLORS	2      /*_F77_s: GPVCOL */
#define GEOM_UVS	4      /*_F77_s: GPUVS  */
#define GEOM_UVWS	8      /*_F77_s: GPUVWS */
#define GEOM_LABEL_FLAGS 0x10  /*_F77_s: GLFLAG */
#define GEOM_NORADII    0x20   /* internal use only */
#define GEOM_PDATA	0x40   /*_F77_s: GPPDAT */
#define GEOM_VDATA	0x80   /*_F77_s: GPVDAT */
#define GEOM_VTRANS	0x100  /*_F77_s: GPVTRA */

/* Passed to read and write routines to strip off data */
#define GEOM_DO_ALL_DATA 0     /*_F77_s: GPALLD */

/* When converting objects, create these descriptions */
#define GEOM_SURFACE	1      /*_F77_s: GPSURF */
#define GEOM_WIREFRAME	2      /*_F77_s: GPWIRE */
/* Flags for converting polygons */
#define GEOM_EXHAUSTIVE	   4   /*_F77_s: GPEXHS */
#define GEOM_NO_CONNECTIVITY 8 /*_F77_s: GPNCON */

/* Flags to the alloc fields of create calls */
#define GEOM_DONT_COPY_DATA 1  /*_F77_s: GPNCPY */
#define GEOM_COPY_DATA	    0  /*_F77_s: GPCOPY */

/* Flags for creating polygons */
#define GEOM_CONVEX	   0   /*_F77_s: GPCNVX */
#define GEOM_CONCAVE	   2   /*_F77_s: GPCNCV */
#define GEOM_COMPLEX	   4   /*_F77_s: GPCMPX */

/* Font flags (lflags) */
#define GEOM_LABEL_FONT	 	0xff     /*_F77_s: GLFONT */
#define GEOM_LABEL_STROKE	0x100    /*_F77_s: GLSTRK */
#define GEOM_LABEL_STRING	0x200    /*_F77_s: GLSTRG */
#define GEOM_LABEL_DROPSHADOW   0x400    /*_F77_s: GLDROP */
#define GEOM_LABEL_ABSOLUTE	0x800    /*_F77_s: GLABSL */
#define GEOM_LABEL_CENTER	0x1000   /*_F77_s: GLCNTR */
#define GEOM_LABEL_RIGHT	0x2000   /*_F77_s: GLRGHT */
#define GEOM_LABEL_LEFT		0x4000   /*_F77_s: GLLEFT */
#define GEOM_LABEL_BACKGROUND	0x8000   /*_F77_s: GLBACK */
#define GEOM_LABEL_HIGHLIGHT	0x10000  /*_F77_s: GLHIGH */

/* Defines for the routine GEOMedit_visibility */
#define GEOM_EDIT_VIS		1
#define GEOM_EDIT_INVIS 	0
#define GEOM_EDIT_DELETE 	-1

/* Defines for the routine GEOMedit_texture_options */
#define GEOM_TEXTURE_FILTER	0x1
#define GEOM_TEXTURE_ALPHA	0x2
#define GEOM_TEXTURE_VOLUME	0x4
#define GEOM_TEXTURE_TILE	0x8

#define GEOM_CLIP_INSIDE	0x1
#define GEOM_CLIP_OUTSIDE	0x2
#define GEOM_CLIP_IGNORE	0x3
#define GEOM_CLIP_INHERIT	0x4

/*
 * Flags for the edit_camera_proj call
 */
#define GEOM_CAMERA_FRONT	0x1
#define GEOM_CAMERA_BACK	0x2
#define GEOM_CAMERA_WSIZE	0x4
#define GEOM_CAMERA_FOV		0x8
/*
 * Flags for the edit_camera_orient call
 */
#define GEOM_CAMERA_FROM	0x10
#define GEOM_CAMERA_AT		0x20
#define GEOM_CAMERA_UP		0x40
#define GEOM_CAMERA_SCALE	0x80

/* Works for both of the above */
#define GEOM_CAMERA_ALL		0xffffffff

/*
 * Flags for the edit_camera_params call
 */
#define GEOM_CAMERA_DEPTH_CUE		0x1
#define GEOM_CAMERA_ZBUFFER		0x2
#define GEOM_CAMERA_SORT_TRANSPARENCY 	0x4
#define GEOM_CAMERA_GLOBAL_ANTIALIAS 	0x8
#define GEOM_CAMERA_PERSPECTIVE 	0x10
#define GEOM_CAMERA_AXES		0x20
#define GEOM_CAMERA_FREEZE		0x40
#define GEOM_CAMERA_SHOW		0x80
#define GEOM_CAMERA_DOUBLE_BUFFER	0x100
#define GEOM_CAMERA_SHADOWS		0x200

/*
 * Flags for the edit_depth_cue_params call
 */
#define GEOM_DEPTH_CUE_FRONT	0x1
#define GEOM_DEPTH_CUE_BACK	0x2
#define GEOM_DEPTH_CUE_SCALE	0x4
#define GEOM_DEPTH_CUE_ALL	0xffffffff

#define GEOM_BACKFACE_NORMAL	0
#define GEOM_BACKFACE_CULL_BACK 1
#define GEOM_BACKFACE_CULL_FRONT 2
#define GEOM_BACKFACE_FLIP	3
#define GEOM_BACKFACE_INHERIT	4

#define GEOM_CAMERA_DEPTH_FRONT 0x100
#define GEOM_CAMERA_DEPTH_BACK  0x200
#define GEOM_CAMERA_DEPTH_SCALE 0x400

#ifndef F77
#define GEOM_FONT_NUMBER(A)	((A) & 0xff)

#define GEOMadd_int_colors(O,C,N,A)		\
  	GEOM_add_colors(O,(char *)(C),N,add_to_vlist_from_int,A)
#define GEOMadd_float_colors(O,C,N,A) 		\
	GEOM_add_colors(O,(char *)(C),N,add_to_vlist,A)

#define GEOMadd_vertex_with_data(O,V,N,C)  \
	GEOMadd_vertices_with_data(O,&(V),&(N),&(C),1,0)

#define GEOMadd_vertex(O,V)  GEOMadd_vertices(O,&(V),1,0)

typedef struct _GEOMvert_list {
   xp_long	alloced_size;
   xp_long	n;
   float *l;
} GEOMvert_list, GEOMscalar_list; /* These are the same. but treated differently*/

typedef struct _GEOMint_list {
   xp_long	alloced_size;
   xp_long	n;
   int *l;
} GEOMint_list;

typedef struct _GEOMchar_list {
   xp_long	alloced_size;
   xp_long	n;
   char **l;
} GEOMchar_list;

typedef struct _GEOMplist_list {
   xp_long	alloced_size;
   xp_long	nps, nvs;	/* Number of polygons and number of vert indicies */
   xp_long  *l;		/* Compacted array of both (zero terminated) */
} GEOMp_list;

typedef struct _GEOMsphere {
   GEOMvert_list verts;
   GEOMscalar_list radii;
   GEOMvert_list colors;
   GEOMvert_list normals; /* Perhaps useful later on for point clouds?*/
   GEOMint_list vdata;
   GEOMscalar_list vtrans;
} GEOMsphere;

typedef struct _GEOMmesh {
   xp_long		m,n;	/* Data is same for lines or polytriangles */
   GEOMvert_list verts;
   GEOMvert_list normals;
   GEOMvert_list colors;
   GEOMscalar_list uvs;
   GEOMint_list vdata;
   GEOMint_list pdata;
   GEOMscalar_list vtrans;
} GEOMmesh;

typedef struct _GEOMpolytri {
   xp_long npts;		   /* Number of polytris */
   GEOMvert_list *ptverts; /* Polytriangle data */
   GEOMvert_list *ptcolors;
   GEOMvert_list *ptnormals;
   GEOMscalar_list *ptuvs;
   xp_long npls;		   /* Number of polylines */
   GEOMvert_list *plverts; /* Polyline data */
   GEOMvert_list *plcolors;
   GEOMvert_list dlverts; /* Disjoint line data */
   GEOMvert_list dlcolors;

   /* User defined data for polytris, polylines, disjoint lines */
   GEOMint_list *ptvdata;
   GEOMint_list *ptpdata;
   GEOMint_list *plvdata;
   GEOMint_list *plpdata;
   GEOMint_list dlvdata;
   GEOMint_list dlpdata;
   GEOMscalar_list *ptvtrans;
} GEOMpolytri;

typedef struct _GEOMlabel {
   int lflags;
   GEOMchar_list labels;	/* Character strings themselves */
   GEOMvert_list verts; 	/* Locations of label strings */
   GEOMvert_list offsets;	/* Offsets of label strings from point */
   GEOMvert_list colors;	/* Color of string */
   GEOMscalar_list heights;
   GEOMint_list vflags;
} GEOMlabel;

typedef struct _GEOMpolyh {
   GEOMvert_list verts;
   GEOMvert_list normals;
   GEOMvert_list colors;
   GEOMscalar_list uvs;
   GEOMp_list	ptlist;
   GEOMint_list vdata;
   GEOMint_list pdata;
   GEOMscalar_list vtrans;
} GEOMpolyh;

typedef struct _GEOMval {
   int	type;
   int  size; /* Number of bytes of extra data following this struct */
   union {
      int	i;
      float	f;
      unsigned int c;
      int	data[1];
   } d;
} GEOMval;

typedef struct _GEOMobj {
   int	type; /* Object type */
   int  data; /* Vertex data that this object has (normals and vertices) */
   float extent[6];
   int	 has_extent;
   char	 *name, *filename;
   char  *groupname;
   GEOMval *vals;	/* Pointer to a list of name/value pairs */
   int	nvals;
   union {	/* An objects internal bits */
      GEOMmesh m;
      GEOMpolyh ph;
      GEOMpolytri pt;
      GEOMsphere sp;
      GEOMlabel la;
   } d;
   int	refcnt;
} GEOMobj;

/* The first 4 bytes of a geom file contain a "magic" number. */
/* In AVS version 2, this number was "GEOM" on most machines and */
/* "MOEG" on the DECstation.  */
/* For AVS version 3, it was changed to "GEO3" for all machines. */
/* Data is now stored in XDR rather than native format so the same */
/* file can be used on all machine types without any converters. */

#define GEOM_FILE_MAGIC  0x47454F4D  /* ascii "GEOM" */
#define GEOM_FILE_MAGIC_V3 0x47454F33 /* ascii "GEO3" */
#define GEOM_FILE_MAGIC_64	0x474D3634	/* ascii "GM64" */

typedef struct _GEOMobj_file_header {
   int		magic;	/* magic number that indicates this is a geom file */
   int	    hdrsize; /* Size of object header data (after this header) */
   int		data;	/* Data field from above */
   int		type;	/* Object type from above */
   float	extent[6]; /* Extent from above */
   int		has_extent; /* From above if extent is valid */
   xp_long	bytecount; /* Number of bytes total in object */
   int		nvals;
   /*
    Val data follows. For each val structure:
	int type;
	int size;  where n >= 4
	[ n bytes of data ]

    Names follow: null terminated: object name, group name
    */
} GEOMobj_file_hdr;

typedef struct _GEOMsphere_file {
   xp_long nverts;
   /*
   VERTICES X Y Z
   RADII
   if (normals) NORMALS X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (vtrans) VERTTRANS
   */
} GEOMsphere_file_hdr;

typedef struct _GEOMpolytri_file {
   xp_long		npts, npls, dls /* one or zero */;
/*
   data follows:
   PTRI data
   N verts
   VERTICES X Y Z
   if (normals) NORMALS X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (pdata) PRIMDATA
   if (vtrans) VERTTRANS
   PLINE data
   N verts
   VERTICES X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (pdata) PRIMDATA
   DLINE data
   N verts
   VERTICES X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (pdata) PRIMDATA
*/
} GEOMptri_file_hdr;

typedef struct _GEOMmesh_file {
   xp_long		n, m;
/*
   data follows:
   verts
   if (normals) normals
   if (colors) colors
   if (uvs) uvs;
   if (vdata) vertdata
   if (pdata) primdata
   if (vtrans) VERTTRANS
*/
} GEOMmesh_file_hdr;

typedef struct _GEOMpolyh_file {
   xp_long nps, nvs, nverts;
/*
   data follows:
   indicies
   verts
   if (normals) normals
   if (colors) colors
   if (uvs) uvs;
   if (vdata) vertdata
   if (pdata) primdata
   if (vtrans) VERTTRANS
*/
} GEOMpolyh_file_hdr;


typedef struct _GEOMlabel_file {
   xp_long nlabels;
   int lflags;
/*
   data follows:
   char labels (null terminated)
   label positions
   label offsets
   label heights
   if (colors) colors
*/
} GEOMlabel_file_hdr;

typedef float GEOMpoint3[3];

typedef struct _GEOMedit {
  int type;
  char *data;
  char *name;
  int size; /* If it is a generic value, this is valid */
  struct _GEOMedit *next;
} GEOMedit;

typedef struct _GEOMedit_list {
   GEOMedit *l;
} *GEOMedit_list;


#ifndef avsargs_h
#include <avs/avsargs.h>
#endif

#if NeedFunctionPrototypes
#ifndef _COLORMAP_H_defined
#include <avs/colormap.h>
#endif

#ifndef _FIELD_H_defined
#include <avs/field.h>
#endif
#endif /* NeedFunctionPrototypes */

#ifdef __cplusplus
extern "C" {
#endif

AVS_EXTERN( void GEOM_add_colors, (GEOMobj *obj, char *colors, xp_long n,
				   void (*cvt_func)(), int alloc));
AVS_EXTERN(void GEOMadd_disjoint_line, (GEOMobj *obj, float *verts,
					float *colors, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_disjoint_polygon, (GEOMobj *obj, float *verts,
					   float *normals, float *colors,
					   xp_long nverts, int flag, int alloc));
AVS_EXTERN(void GEOMadd_disjoint_prim_data, (GEOMobj *obj, int *pdata, xp_long n,
					     int alloc));
AVS_EXTERN(void GEOMadd_disjoint_vertex_data, (GEOMobj *obj, int *vdata, xp_long n,
					       int alloc));
AVS_EXTERN(void GEOMadd_int_value, (GEOMobj *obj, int type, int value));
AVS_EXTERN(void GEOMadd_label, (GEOMobj *obj, char *label, float *vert,
				float *offset, float height, float *color,
				int vflag));
AVS_EXTERN( void GEOMadd_labels, (GEOMobj *obj, char **labels, float *verts,
				float *offsets, float *heights, float *colors,
				int *vflags, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_normals, (GEOMobj *obj, float *normals, xp_long n,
				  int alloc));
AVS_EXTERN(void GEOMadd_polygon, (GEOMobj *obj, xp_long nverts, xp_long *indicies,
				  int flags, int alloc));
AVS_EXTERN(void GEOMadd_polygons, (register GEOMobj *obj, register xp_long *plist,
				   int flags, int alloc));
AVS_EXTERN(void GEOMadd_polyh, (GEOMobj *obj, xp_long *plist, int flags,
				int alloc));
#ifdef WORDLENGTH_64
AVS_EXTERN(void GEOMadd_polygon_n, (GEOMobj *obj, int nverts, int *indicies,
				  int flags, int alloc));
AVS_EXTERN(void GEOMadd_polygons_n, (register GEOMobj *obj, register int *plist,
				   int flags, int alloc));
AVS_EXTERN(void GEOMadd_polyh_n, (GEOMobj *obj, int *plist, int flags,
				int alloc));
#endif
AVS_EXTERN(void GEOMadd_polyline, (GEOMobj *obj, float *verts, float *colors,
				   xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polyline_colors, (GEOMobj *obj, float *colors, xp_long i,
					  xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polyline_prim_data, (GEOMobj *obj, int *pdata, xp_long i,
					     xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polyline_vertex_data, (GEOMobj *obj, int *vdata, xp_long i,
					       xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polytriangle, (GEOMobj *obj, float *verts,
				       float *normals, float *colors, xp_long n,
				       int alloc));
AVS_EXTERN(void GEOMadd_polytriangle_colors, (GEOMobj *obj, float *colors,
					      xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polytriangle_prim_data, (GEOMobj *obj, int *pdata,
						 xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polytriangle_uvs, (GEOMobj *obj, float *uvs, xp_long i,
					   xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polytriangle_uvws, (GEOMobj *obj, float *uvs, xp_long i,
					    xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polytriangle_vertex_data, (GEOMobj *obj, int *vdata,
						   xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_polytriangle_vertex_trans, (GEOMobj *obj, float *vtrans,
						    xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_prim_data, (GEOMobj *obj, int *pdata, xp_long n,
				    int alloc));
AVS_EXTERN(void GEOMadd_radii, (GEOMobj *obj, float *radii, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_uvs, (GEOMobj *obj, float *uvs, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_uvws, (GEOMobj *obj, float *uvs, xp_long n, int alloc));
AVS_EXTERN(void GEOMadd_vertex_data, (GEOMobj *obj, int *vdata, xp_long n,
				      int alloc));
AVS_EXTERN(void GEOMadd_vertex_trans, (GEOMobj *obj, float *vtrans, xp_long n,
				       int alloc));
AVS_EXTERN(void GEOMadd_vertices, (GEOMobj *obj, float *verts, xp_long n,
				   int alloc));
AVS_EXTERN(void GEOMadd_vertices_with_data, (GEOMobj *obj, float *verts,
					     float *normals,
					     unsigned int *colors, xp_long n,
					     int alloc));
AVS_EXTERN(void GEOMauto_transform, (register GEOMobj *obj));
AVS_EXTERN(void GEOMauto_transform_list, (register GEOMobj **objs,
					  register int n));
AVS_EXTERN(void GEOMauto_transform_non_uniform, (register GEOMobj *obj));
AVS_EXTERN(void GEOMauto_transform_non_uniform_list, (register GEOMobj **objs,
						      register int n));
AVS_EXTERN(int GEOMcheck_obj, (GEOMobj *obj, int flags, int (*func)()));
AVS_EXTERN( GEOMobj *GEOMcreate_label, (float *extent, int lflags));
AVS_EXTERN( int GEOMcreate_label_flags, (int font_number, int title,
					 int background, int drop, int align,
					 int stroke));
AVS_EXTERN( GEOMobj *GEOMcreate_mesh, (float *extent, float *verts, xp_long n,
				       xp_long m, int alloc));
AVS_EXTERN(void GEOMcreate_mesh_uvs, (GEOMobj *obj, double umin, double vmin,
				      double umax, double vmax));
AVS_EXTERN( GEOMobj *GEOMcreate_mesh_with_data, (float *extent, float *verts,
						 float *normals,
						 unsigned int *colors, xp_long n,
						 xp_long m, int alloc));
AVS_EXTERN( GEOMobj *GEOMcreate_normal_object, (GEOMobj *obj, float scale));
AVS_EXTERN( GEOMobj *GEOMcreate_obj, (int type, float *extent));
AVS_EXTERN( GEOMobj *GEOMcreate_polyh, (float *extent, float *verts, xp_long n,
					xp_long *plist, int flags, int alloc));
AVS_EXTERN( GEOMobj *GEOMcreate_polyh_with_data, (float *extent, float *verts,
						  float *normals,
						  unsigned int *colors, xp_long n,
						  xp_long *plist, int flags,
						  int alloc));
#ifdef WORDLENGTH_64
AVS_EXTERN( GEOMobj *GEOMcreate_polyh_n, (float *extent, float *verts, int n,
					int *plist, int flags, int alloc));
AVS_EXTERN( GEOMobj *GEOMcreate_polyh_with_data_n, (float *extent, float *verts,
						  float *normals,
						  unsigned int *colors, int n,
						  int *plist, int flags,
						  int alloc));
#endif
AVS_EXTERN( GEOMobj *GEOMcreate_scalar_mesh, (float xmin, float xmax,
					      float ymin, float ymax,
					      float *mesh, float *colors, xp_long n,
					      xp_long m, int alloc));
AVS_EXTERN( GEOMobj *GEOMcreate_sphere, (float *extent, float *verts,
					 float *radii, float *normals,
					 unsigned int *colors, xp_long n,
					 int alloc));
AVS_EXTERN(void GEOMcreate_sphere_uvs, (GEOMobj *obj, float matrix[4][4],
					float umin, float vmin, float umax,
					float vmax));
AVS_EXTERN(void GEOMcvt_mesh_to_polytri, (GEOMobj *obj, int flag));
AVS_EXTERN(int GEOMcvt_polyh_to_polytri, (GEOMobj *obj, int flags));
AVS_EXTERN(void GEOMdestroy_edit_list, (GEOMedit_list list));
AVS_EXTERN(int GEOMdestroy_obj, (GEOMobj *obj));
AVS_EXTERN(void GEOMdestroy_uvs, (GEOMobj *obj));
AVS_EXTERN(void GEOMedit_backface, (GEOMedit_list list, char *name, int mode));
AVS_EXTERN(void GEOMedit_camera_orient, (GEOMedit_list list, char *name,
					 int flags, float scale, float at[3],
					 float up[3], float from[3]));
AVS_EXTERN(void GEOMedit_camera_params, (GEOMedit_list list, char *name,
					 int options, int val));
AVS_EXTERN(void GEOMedit_camera_project, (GEOMedit_list list, char *name,
					  int flags, float front, float back,
					  float fov, float wsize));
AVS_EXTERN(void GEOMedit_center, (GEOMedit_list list, char *name,
				  float *center));
AVS_EXTERN(void GEOMedit_clip_plane, (GEOMedit_list list, char *obj,
				      char *clip, int state));
AVS_EXTERN(void GEOMedit_color, (GEOMedit_list list, char *name, float *color));
AVS_EXTERN(void GEOMedit_concat_matrix, (GEOMedit_list list, char *name,
					 float *matrix));
AVS_EXTERN(void GEOMedit_cycle, (GEOMedit_list list, char *name, int cycle));
AVS_EXTERN(void GEOMedit_depth_cue_params, (GEOMedit_list list, char *name,
					    int flags, float front, float back,
					    float scale));
AVS_EXTERN(void GEOMedit_field_texture, (GEOMedit_list	list, char *name,
					 AVSfield *field));
AVS_EXTERN(void GEOMedit_geometry, (GEOMedit_list list, char *name,
				    GEOMobj *obj));
AVS_EXTERN(void GEOMedit_light, (GEOMedit_list list, char *name, char *type,
				 int status));
AVS_EXTERN(void GEOMedit_parent, (GEOMedit_list list, char *name,
				  char *parent));
AVS_EXTERN(void GEOMedit_position, (GEOMedit_list list, char *name,
				    float *position));
AVS_EXTERN(void GEOMedit_projection, (GEOMedit_list list, char *name,
				      float *projection));
AVS_EXTERN(void GEOMedit_properties, (GEOMedit_list list, char *name,
				      float ambient, float diffuse,
				      float specular, float spec_exp,
				      float transparency, float spec_col[3]));
AVS_EXTERN(void GEOMedit_render_mode, (GEOMedit_list list, char *name,
				       char *mode));
AVS_EXTERN(void GEOMedit_selection_mode, (GEOMedit_list list, char *name,
					  char *mode, int flags));
AVS_EXTERN(void GEOMedit_set_matrix, (GEOMedit_list list, char *name,
				      float *matrix));
AVS_EXTERN(void GEOMedit_subdivision, (GEOMedit_list list, char *name,
				       int subdiv));
AVS_EXTERN(void GEOMedit_texture, (GEOMedit_list list, char *name,
				   char *texture));
AVS_EXTERN(void GEOMedit_texture_colormap, (GEOMedit_list list, char *name,
					    AVScolormap *colormap));
AVS_EXTERN(void GEOMedit_texture_options, (GEOMedit_list list, char *name,
					   int options, int val));
AVS_EXTERN(void GEOMedit_transform_mode, (GEOMedit_list list, char *name,
					  char *redirect, int flags));
AVS_EXTERN(void GEOMedit_visibility, (GEOMedit_list list, char *name, int vis));
AVS_EXTERN(void GEOMedit_window, (GEOMedit_list list, char *name,
				  float *window));
AVS_EXTERN(void GEOMflip_normals, (GEOMobj *obj));
AVS_EXTERN(int GEOMfont_number, (int a));
AVS_EXTERN(void GEOMgen_normals, (GEOMobj *obj, int flags));
AVS_EXTERN(void GEOMgen_normals_tol, (GEOMobj *obj,int flags,double tol));
AVS_EXTERN(int GEOMget_label_flags, (GEOMobj *obj, int vert));
AVS_EXTERN( GEOMedit_list GEOMinit_edit_list, (GEOMedit_list list));
AVS_EXTERN(void GEOMnormalize_normals, (GEOMobj *obj));
AVS_EXTERN(void GEOMprocess_edit_list, (GEOMedit_list list));
AVS_EXTERN(int GEOMquery_int_value, (GEOMobj *obj, int type, int *value));
AVS_EXTERN(int GEOMquery_polygon_type, (GEOMobj *obj));
AVS_EXTERN( GEOMobj *GEOMread_obj, (int fd, int flags));
AVS_EXTERN( GEOMobj *GEOMread_text, (FILE *fp, int flags));
AVS_EXTERN(void GEOMset_color, (GEOMobj *obj, unsigned int color));
AVS_EXTERN(void GEOMset_computed_extent, (GEOMobj *obj, float *extent));
AVS_EXTERN(void GEOMset_extent, (GEOMobj *obj));
AVS_EXTERN(void GEOMset_object_group, (GEOMobj *obj, char *name));
AVS_EXTERN(void GEOMset_object_name, (GEOMobj *obj, char *name));
AVS_EXTERN(void GEOMset_pickable, (GEOMobj *obj, unsigned int pickable));
AVS_EXTERN(void GEOMset_polygon_type, (GEOMobj *obj, int val));
AVS_EXTERN(void GEOMunion_extents, (GEOMobj *obj1, GEOMobj *obj2));
AVS_EXTERN(void GEOMwrite_obj, (GEOMobj *obj, int fd, int flags));
AVS_EXTERN(void GEOMwrite_text, (GEOMobj *obj, FILE *fp, int flags));
AVS_EXTERN(char *GEOMget_font_info, (int value, int *bold, int *italic));
AVS_EXTERN(int GEOMget_font_number, (char *name, int bold, int italic));
AVS_EXTERN(xp_long *GEOMtriangulate_polygons,(GEOMobj *obj));
AVS_EXTERN(void GEOMserialize_obj, (xp_long (*func)(),GEOMobj *obj,void *fd,
				    int flags,int proto_version));




AVS_EXTERN(void add_to_ilist, (register GEOMint_list *ilist, register int *ints,
			       register xp_long  n, xp_long grow, int alloc));
AVS_EXTERN(void create_ilist, (GEOMint_list *new_ilist, int *ilist, xp_long  n,
			       int alloc));
AVS_EXTERN(void add_to_vlist_from_int, (GEOMvert_list *vlist,
					unsigned int *verts, xp_long n, xp_long grow,
					int alloc));
AVS_EXTERN(void create_vlist_from_int, (GEOMvert_list *new_vlist,
					unsigned int *vlist, xp_long n,
					int alloc));
AVS_EXTERN(void add_to_vlist, (GEOMvert_list *vlist, float *verts, xp_long n,
			       xp_long grow, int alloc));
AVS_EXTERN(void create_vlist, (GEOMvert_list *new_vlist, float *vlist, xp_long n,
			       int alloc));
AVS_EXTERN(void add_to_plist, (GEOMobj *obj, register GEOMp_list *new_plist,
			       register xp_long *plist, int flags, int alloc));
AVS_EXTERN(void create_plist, (register GEOMp_list *new_plist,
			       register xp_long *plist, int flags, int alloc));
AVS_EXTERN(void add_to_slist, (register GEOMscalar_list *slist,
			       register float *scalars, register xp_long n,
			       xp_long grow, int alloc));
AVS_EXTERN(void create_slist, (GEOMscalar_list *new_slist, float *slist, xp_long n,
			       int alloc));
AVS_EXTERN(void add_to_fvlist, (register GEOMvert_list *vlist,
				register float *vx, register float *vy,
				register float *vz, register xp_long n, xp_long grow,
				int alloc));
AVS_EXTERN(void destroy_plist, (GEOMp_list *plist));
AVS_EXTERN(void destroy_slist, (GEOMscalar_list *slist));
AVS_EXTERN(void destroy_vlist, (GEOMvert_list *vlist));
AVS_EXTERN(void destroy_charlist, (GEOMchar_list *charlist));
AVS_EXTERN(void destroy_ilist, (GEOMint_list *ilist));
AVS_EXTERN(void copy_with_stride, (register float *dst, register int ds,
				   register float *src, register xp_long ss,
				   register xp_long n));
AVS_EXTERN(void copy_with_stride_int, (register int *dst, register int ds,
				       register int *src, register xp_long ss,
				       register xp_long n));
AVS_EXTERN(void create_charlist, (GEOMchar_list *ll, char **labels, xp_long n,
				  int alloc));
AVS_EXTERN(void add_string_to_charlist, (GEOMchar_list *ll, char *label));

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
   #define	 GEOMadd_polygon			GEOMadd_polygon_n
   #define	 GEOMadd_polygons			GEOMadd_polygons_n
   #define   GEOMadd_polyh              GEOMadd_polyh_n
   #define	 GEOMcreate_polyh_with_data	GEOMcreate_polyh_with_data_n
   #define	 GEOMcreate_polyh			GEOMcreate_polyh_n
#endif

#ifdef __cplusplus
}
#endif

#define PH(A)	((A)->d.ph)
#define PT(A)	((A)->d.pt)
#define MSH(A)	((A)->d.m)
#define SP(A)	((A)->d.sp)
#define LA(A)	((A)->d.la)

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* F77 */
#endif /* GEOM_ALREADY_INCLUDED */
