/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/lui.h#1 $
*/
/*              @(#)lui.h	8.8 AVS 93/01/11 */

/*
 * LUI header
 */

#ifndef _LUI_HEADER
#define _LUI_HEADER 1

/* X include files */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#include <avs/port.h>		/* to define BSD, used below */

#ifdef BSD
#include <sys/file.h>
#else
#include <sys/fcntl.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef LUI_DECLARE
# define LUI_GLOBAL  /* */
# define LUI_INIT(v) = v
#else
# define LUI_GLOBAL  extern
# define LUI_INIT(v) /* */
#endif

#define LUI_MAIN_CURSOR          0  /* Default Cursor */
#define LUI_DIAL_CURSOR          1
#define LUI_DIAL_CW_CURSOR       2
#define LUI_DIAL_CCW_CURSOR      3
#define LUI_DIAL_RES_CURSOR      4
#define LUI_QUESTION_CURSOR      5
#define LUI_DOWN_CURSOR          6
#define LUI_UP_CURSOR            7
#define LUI_UP_DOWN_CURSOR       8
#define LUI_CLOCK_CURSOR         9
#define LUI_PENCIL_CURSOR       10
#define LUI_ARROW_HAND_CURSOR   11
#define LUI_RIGHT_LEFT_CURSOR   12
#define LUI_RIGHT_CURSOR        13
#define LUI_LEFT_CURSOR         14

#define LUI_MAX_NUM_RED 	8
#define LUI_MAX_NUM_GREEN	8
#define LUI_MAX_NUM_BLUE	8

#define LUI_MAX_NUM_GREY	256


#define LUI_COLOR_NOTSET        0xffffffff

/* For degrees <--> radians conversion */
#define DERAD(x) ((x) * 0.017453292519943295)
#define RADDE(x) ((x) * 57.29577951308232300)

/*
 * Destruction support macro
 */

#define LUI_DELETE_LINK(hp,ptr,nextfield,tmp,prev,nptr)                              \
{                                                                                    \
    for (tmp = hp, prev = nptr ; tmp != nptr; prev = tmp, tmp = tmp ->nextfield) {   \
	if (tmp == ptr) {                                                            \
	    if (tmp == hp)                                                           \
	      hp = tmp -> nextfield;                                                 \
	    else                                                                     \
	      prev->nextfield = tmp->nextfield;                                      \
	    free(ptr);                                                               \
	    ptr = nptr;                                                              \
	    break;                                                                   \
	}                                                                            \
    }                                                                                \
}

#define LUI_POPUP_MENU_SIZE(M) (sizeof(M) / sizeof(char*))

typedef int ((*LUI_FNCP)());

typedef struct {
    int size;
    unsigned long color;
    LUI_FNCP func;
} LUI_DECORATE;

typedef struct _lui_display_info{
    char		name[256];
    Display 		*display;
    int 		screen;
    int 		image_byte_order;
    Window 		root_window;
    Visual		*visual;
    int			depth;
    Colormap		colormap;
    int			cells;
    int			bytes_per_pixel, scanline_pad;
    int			num_red, num_green, num_blue, num_grey;
    unsigned long	colors[LUI_MAX_NUM_RED][LUI_MAX_NUM_GREEN][LUI_MAX_NUM_BLUE];
    unsigned long 	greycolors[LUI_MAX_NUM_GREY];
    unsigned long   	red[256], green[256], blue[256];
    Window		gc_window;
    GC			gc;
    struct _lui_display_info    *next;
    Cursor		geom_cursor, rotate_cursor, translate_cursor;
    Cursor		wait_cursor, select_object_cursor;
    Atom		atom_delete_window, atom_protocols;
} LUI_DISPLAY_INFO;

LUI_GLOBAL LUI_DISPLAY_INFO
  *LUI_DisplayInfo LUI_INIT ( NULL ) ;

LUI_DISPLAY_INFO *LUI_GetDisplayInfo();
LUI_DISPLAY_INFO *LUI_GetNamedDisplayInfo();

LUI_GLOBAL Display
  *LUI_Display LUI_INIT ( NULL ) ;

LUI_GLOBAL Window
  LUI_RootWindow;

LUI_GLOBAL Window
  LUI_GCWindow;

/* set this to 1 to override gamma correction */
LUI_GLOBAL int		LUI_No_Gamma LUI_INIT(0);
#ifdef LUI_GAMMA
LUI_GLOBAL float	LUI_Gamma LUI_INIT(LUI_GAMMA);
LUI_GLOBAL float	LUI_Inv_Gamma LUI_INIT(1.0 / LUI_GAMMA);
#else
LUI_GLOBAL float	LUI_Gamma LUI_INIT(1.0);
LUI_GLOBAL float	LUI_Inv_Gamma LUI_INIT(1.0);
#endif

LUI_GLOBAL unsigned long LUI_XOR_Value LUI_INIT(0xaaaaaa);

LUI_GLOBAL Colormap
  LUI_Colormap;

LUI_GLOBAL unsigned long
  LUI_Color_FG,
  LUI_Color_BG,
  LUI_Color_black,
  LUI_Color_dk_grey,
  LUI_Color_md_grey,
  LUI_Color_lt_grey,
  LUI_Color_sl_grey,
  LUI_Color_xl_grey,
  LUI_Color_white,
  LUI_Color_fore,
  LUI_Color_xor;

LUI_GLOBAL GC
  LUI_Gc,
#ifdef KANJI
  LUI_Gc_kanji,
#endif /* KANJI */
  LUI_GC_black,
  LUI_GC_dk_grey,
  LUI_GC_md_grey,
  LUI_GC_lt_grey,
  LUI_GC_sl_grey,
  LUI_GC_xl_grey,
  LUI_GC_white,
  LUI_GC_fore,
  LUI_GC_xor;

LUI_GLOBAL XFontStruct
#ifdef KANJI
  *LUI_Font_kanji LUI_INIT ( NULL ),
#endif /* KANJI */
  *LUI_Font       LUI_INIT ( NULL );

LUI_GLOBAL int
  LUI_Debug       LUI_INIT ( 0.0 ),
  LUI_HighlightInhibit LUI_INIT( 0 ), 
  LUI_Screen,
  LUI_Width,
  LUI_Height,
  LUI_VirtWidth   LUI_INIT ( 1280 ),
  LUI_VirtHeight  LUI_INIT ( 1024 ),
  LUI_Depth,
  LUI_Font_yoff,
  LUI_Cells,
  LUI_BytesPerPixel,
  LUI_ScanlinePad,
  LUI_ImageByteOrder,
  LUI_ScriptMask LUI_INIT ( 0 ),
  LUI_NumRed, LUI_NumGreen, LUI_NumBlue, LUI_NumGrey;

LUI_GLOBAL Visual 
  *LUI_Visual;

LUI_GLOBAL float
  LUI_DefaultHue  LUI_INIT ( -1.0 ),
  LUI_DefaultHue2 LUI_INIT (  0.0 ),
  LUI_DefaultHue3 LUI_INIT (  0.0 );

LUI_GLOBAL unsigned long
   LUI_colors[LUI_MAX_NUM_RED][LUI_MAX_NUM_GREEN][LUI_MAX_NUM_BLUE];
LUI_GLOBAL unsigned long 
   LUI_greycolors[LUI_MAX_NUM_GREY];
LUI_GLOBAL unsigned long
   LUI_red[256], LUI_green[256], LUI_blue[256];

LUI_GLOBAL char
  LUI_SeparatorChar LUI_INIT ( '%' );

LUI_GLOBAL unsigned long
  LUI_BackgroundColor LUI_INIT ( LUI_COLOR_NOTSET ),
  LUI_PageColor LUI_INIT ( LUI_COLOR_NOTSET );

#ifdef LUI_DECLARE 
LUI_DECORATE
  LUI_DecorateInterior = { 0, 0, NULL },
  LUI_DecorateExterior = { 0, 0, NULL };
char
  LUI_ProgramName[128];
char
  LUI_InstanceName[128];
Cursor
  LUI_CursorTable[32];
#else
extern LUI_DECORATE
  LUI_DecorateInterior,
  LUI_DecorateExterior;
extern char
  LUI_ProgramName[];
extern Cursor 
  LUI_CursorTable[];
#endif

Window 
  LUI_CreateWindow(),
  LUI_CreateWindowInfo(),
  LUI_CreateWindowAt(),
  LUI_CreateWindowAtInfo();

unsigned long 
  LUI_MakeColor(),
  LUI_AllocColor();

GC 
  LUI_MakeGC();

int
  LUI_DrawFlatBorder(),
  LUI_DrawBevelEdge(),
  LUI_DrawDropShadow();


/*
 * The following is an event mask that LUI uses to refer to events of type
 * "ClientMessage".  X does not require (or allow) this bit to be set in the
 * event mask for a window -- it will always send these events.  LUI, on the
 * other hand, requires that the user specify a mask bit to direct events
 * properly.
 */
#define  LUI_CLIENT_MASK (1L<<28)


#ifdef KANJI
#   define XDrawString(display, d, gc, x, y, string, length)  \
           XkDrawString(display, d, gc, LUI_Gc_kanji, x, y, string, length)
#endif /* KANJI */

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif  /* _LUI_HEADER */


