/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/mathutil.h#1 $
*/
#ifndef _MATH_UTIL_H_defined
#define _MATH_UTIL_H_defined

#include <math.h>

#define AVS_DIST(A,B) sqrt(((A[0]-B[0])*(A[0]-B[0])) +\
                           ((A[1]-B[1])*(A[1]-B[1])) +\
                           ((A[2]-B[2])*(A[2]-B[2])) )
#define AVS_LENGTH(A) sqrt( A[0]*A[0] + A[1]*A[1] + A[2]*A[2] )

#define AVS_UNITIZE(A,EPS) { float len,len0; len0=A[0]*A[0]+A[1]*A[1]+A[2]*A[2];\
			     len = sqrt(len0); \
			     if (len>EPS) { A[0] /= len; A[1] /= len; A[2] /= len; } }
#define AVS_NORMALIZE(C,L) { C[0] =  C[0] / (L) ; \
			     C[1] =  C[1] / (L) ; \
			     C[2] =  C[2] / (L) ; } 

#define AVS_DOT(A,B)	( A[0]*B[0] + A[1]*B[1] + A[2]*B[2] )
#define AVS_CROSS(A,B,C) { C[0] = A[1]*B[2] - A[2]*B[1]; \
			   C[1] = A[2]*B[0] - A[0]*B[2]; \
			   C[2] = A[0]*B[1] - A[1]*B[0]; }
#define AVS_TRIPLE_PROD(A,B,C)	\
	( A[0]*B[1]*C[2] + A[1]*B[2]*C[0] + A[2]*B[0]*C[1]	\
	- A[2]*B[1]*C[0] - A[1]*B[0]*C[2] - A[0]*B[2]*C[1] )

#endif /* _MATH_UTIL_H_defined */
