/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/ne.h#1 $
*/

/* Network Editor header file */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_NE_INCLUDED
#define XP_NE_INCLUDED

/*---------------------------------------------------------------------*/

/* Header files */

#include <avs/ne_type.h>

/*--------------------------------------------------------------------*/
/*                       Function prototypes                          */
/*--------------------------------------------------------------------*/

#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif

/*--------------------------------------------------------------------*/
/*                          API functions                             */
/*--------------------------------------------------------------------*/

/* From api.c */

int
NEget_selected_objs (
    OMobj_id  ne_obj_id,
    OMobj_id  **objs,
    int       *num_objs);

/*--------------------------------------------------------------------*/
/*                       Internal functions                           */
/*--------------------------------------------------------------------*/

NEobj_disp *
NEcreate_obj_disp (
    NEshell_info  *shell_info,
    WTsys_wind   parent_sys_wind,
    OMobj_id      obj_id,
    NEdisp_type   *type,
    NEgeom_spec   *geom_spec);

NEobj_disp *
NEcreate_sub_obj_disp (
    NEobj_disp   *parent,
    OMobj_id     obj_id,
    NEdisp_type  *type,
    NEgeom_spec  *geom_spec);

void NEdestroy_obj_disp (NEobj_disp *);

void NErealize_obj_disp (NEobj_disp *obj_disp);

int NEupd_subobjs (NEobj_disp *obj_disp);

void NEdestroy_subs (NEobj_disp *);

void NEupd_conns (NEobj_disp *obj_disp);

void NEgen_poss_conns (NEobj_disp *obj_disp, int icon, int port, 
                              int inout, int connect);

void
NEutil_draw_poss_conns (
    NEobj_disp  *obj_disp,
    int         draw);

void NEdestroy_conns (NEobj_disp *obj_disp);

void NEdestroy_poss_conns (NEobj_disp *obj_disp);

void NEdestroy_stubs (NEobj_disp *obj_disp);

void NEtoggle_disp_mode (NEobj_disp *obj_disp);

int  NEis_obj_destroyable (NEobj_disp *obj_disp);

void NEuser_destroy_obj (NEobj_disp *obj_disp);

void NEuser_destroy_objs (int nobjs, NEobj_disp *obj_disp[]);

int NEmake_obj_disp_rw (NEobj_disp *obj_disp);

int NEobj_sub_outline (NEobj_disp *obj_disp,WTregion *reg);

int NEutil_graph_disp_subobjs (NEobj_disp *obj_disp);

void NEutil_port_size (int num_ports, WTcoord min, WTcoord max, 
                              WTcoord *incr, WTcoord *pad);

void NEutil_draw_ports (NEobj_disp *obj_disp, int horiz,
                               WTcoord min_x, WTcoord min_y, 
                               WTcoord max_x, WTcoord max_y);

void NEutil_draw_conns (NEobj_disp *obj_disp, int draw);

void NEutil_draw_marker (WTwind *wind, WTcolor color,
                               WTcoord x, WTcoord y,
                               int in, WTcoord size, int horiz);

void NEpport_get_port_dims (NEobj_disp *obj_disp, NEport *port,int ind,
                                  int inout, WTcoord *x, WTcoord *y, 
                                  WTcoord *size, int *horiz, 
                                  NEobj_disp *par_disp);

void NElport_get_port_dims (NEobj_disp *obj_disp, NEport *port,int ind,
                                  int inout, WTcoord *x, WTcoord *y, 
                                  WTcoord *size, int *horiz, 
                                  NEobj_disp *par_disp);

int NEutil_get_port_from_xy (NEobj_disp *obj_disp, WTcoord x,
                                    WTcoord y,
                                    int *inout, int *port, 
                                    NEobj_disp *par_obj_disp);

int
NElport_guts (
    NEobj_disp  *obj_disp,
    NEport      *port,
    int         ind,
    int         inout,
    WTcoord    *x,
    WTcoord    *y,
    WTcoord    *size,
    int         *horiz,
    NEobj_disp  *par_obj_disp);

OMobj_name NEget_unique_name (OMobj_id new_obj, OMobj_id new_parent, int *);

char *
NEget_obj_text_info (
    NEobj_disp             *obj_disp,
    WTcoord               *text_x,
    WTcoord               *text_y,
    WTcoord               *pixmap_x,
    WTcoord               *pixmap_y,
    WTtext_justification  *justification,
    char                   *buf,
    int                    maxsize);

WTwind *
NEget_parent_wind (
    NEobj_disp  *obj_disp);

void
NEdelete_child (
    NEobj_disp  *child,
    int         destroy);

NEobj_disp *
NEget_resize_disp (
    NEobj_disp  *obj_disp);

NEobj_disp *
NEfind_sub_obj_disp (
    NEobj_disp  *obj_disp,
    OMobj_id    child_id);

void
NEmap_buttons (
    NEobj_disp  *obj_disp,
    int         map);

void
NErequest_default_geom (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec,
    int          *request_config);

void NEget_obj_port_vals (OMobj_id obj_id, int port_vals[2]);

void NEmodify_port_levels (OMobj_id obj_id, int iport, int oport);

int NEgraph_init (NEobj_disp *obj_disp, NEgeom_spec *geom_spec, int conf);

void NEgraph_realize (NEobj_disp *obj_disp);

void NEgraph_config (NEobj_disp *);

int NEgraph_prop_changed (NEobj_disp *);

WTwind *
NEgraph_get_parent_wind (
    NEobj_disp  *obj_disp);

void
NEgraph_delete_child (
    NEobj_disp  *obj_disp,
    NEobj_disp  *child,
    int         destroy);

int
NEgraph_resize_query (
    NEobj_disp  *obj_disp,
    NEobj_disp  *sub_disp);

void
NEgraph_geom_spec_req (
    NEobj_disp   *obj_disp,
    NEobj_disp   *chld,
    NEgeom_spec  *spec,
    int          *conf);

int
NEgraph_config_req (
    NEobj_disp   *obj_disp,
    NEobj_disp   *chld,
    NEgeom_spec  *spec);

int NEgraph_get_port_from_xy (NEobj_disp *obj_disp, 
        WTcoord press_x, WTcoord press_y, int *press_inout, int *press_port,
	int *inside);

int NEgraph_upd_subobjs (NEobj_disp *);

NEconn *NEgraph_pick_conn (NEobj_disp *obj_disp,
                                  WTcoord x, WTcoord y);

int NElist_init (NEobj_disp *obj_disp, NEgeom_spec *geom_spec, int conf);
int NEexport_list_init (NEobj_disp *obj_disp, NEgeom_spec *geom_spec, 
                        int conf);
int NEexport_list_cleanup (NEobj_disp *obj_disp, NEcleanup_mode  mode);

void NElist_config (NEobj_disp *);

int NElist_upd_subobjs (NEobj_disp *);

int
NElist_config_req (
    NEobj_disp   *obj_disp,
    NEobj_disp   *chld,
    NEgeom_spec  *spec);

WTwind *
NElist_get_parent_wind (
    NEobj_disp  *obj_disp);

void
NElist_geom_spec_req (
    NEobj_disp   *obj_disp,
    NEobj_disp   *chld,
    NEgeom_spec  *spec,
    int          *conf);

void NEscroll_to_descendant (NEobj_disp *);

void NElabel_expose (WTwind *wind, WTevent *event, void *arg);

void NElabel_highlight_entlv (WTwind *wind, WTevent *event, void *arg);

int NEicon_init (NEobj_disp *obj_disp, NEgeom_spec *geom_spec, int conf);

void NEicon_realize (NEobj_disp *obj_disp);

char *
NEicon_get_text_info (
    NEobj_disp             *obj_disp,
    WTcoord               *text_x,
    WTcoord               *text_y,
    WTcoord               *pixmap_x,
    WTcoord               *pixmap_y,
    WTtext_justification  *justification,
    char                   *buf,
    int                    maxsize);

int NElink_init (NEobj_disp *,NEgeom_spec *,int);

void NEinsert_link (NEobj_disp *,NEconn *,float,float);

void NEdelete_link (NEobj_disp *);

void NEsub_port_expose (WTwind *wind, WTevent *event, void *arg);

void NEconn_expose (WTwind *wind, WTevent *event, void *arg);

int NEwind_init (NEobj_disp *, NEgeom_spec *geom_spec, int);

void NEresize_button (NEobj_disp *obj_disp, WTevent *event);

void NEwind_button (WTwind *wind, WTevent *event, void *arg);

void NEwind_realize (NEobj_disp *obj_disp);

int NEwind_cleanup (NEobj_disp *obj_disp,
                           NEcleanup_mode  mode);

void NEwind_port_dims (NEobj_disp *obj_disp, NEobj_disp *par_disp, 
                              int inout, int *horiz, 
                              WTcoord *min, WTcoord *max, WTcoord *loc);

int NEwind_prop_changed (NEobj_disp *);

int NEwind_upd_subobjs (NEobj_disp *);

char *
NEwind_get_text_info (
    NEobj_disp             *obj_disp,
    WTcoord               *text_x,
    WTcoord               *text_y,
    WTcoord               *pixmap_x,
    WTcoord               *pixmap_y,
    WTtext_justification  *justification,
    char                   *buf,
    int                    maxsize);

NEobj_disp *
NEwind_get_resize_disp (
    NEobj_disp  *obj_disp,
    NEobj_disp  *sub_disp);

NEobj_disp *
NEwind_find_sub_obj_disp (
    NEobj_disp  *obj_disp,
    OMobj_id    child_id);

void NEinit_install_dirs (void);

int NEutil_get_port_from_xy (NEobj_disp *obj_disp, WTcoord x,
                                   WTcoord y,
                              int *inout, int *port, NEobj_disp *par_obj_disp);

void NEport_draw_ports (NEobj_disp *, NEobj_disp *);

int NEwind_get_port_from_xy (NEobj_disp *obj_disp, 
        WTcoord press_x, WTcoord press_y, int *press_inout, int *press_port,
	int *inside);

void NEpport_get_port_dims (NEobj_disp *obj_disp, NEport *port,int index,
                                   int inout, WTcoord *x, WTcoord *y, 
                                   WTcoord *size, int *horiz, 
                                   NEobj_disp *par_obj_disp);

void NElport_get_port_dims (NEobj_disp *obj_disp, NEport *port,int index,
                                   int inout, WTcoord *x, WTcoord *y, 
                                   WTcoord *size, int *horiz, 
                                   NEobj_disp *par_obj_disp);

void NEgraph_port_dims (NEobj_disp *obj_disp, NEobj_disp *par_disp, 
                              int inout, int *horiz, 
                              WTcoord *min, WTcoord *max, WTcoord *loc);

void NElist_realize (NEobj_disp *obj_disp);

void NElist_restack (NEobj_disp *);

NEdisp_type *NEget_disp_type (NEobj_disp *obj_disp, int *maximize);

void NEadd_disp_type (NEdisp_type *type);

void NE_callback (OMobj_id, OMobj_id, unsigned int, void *);

int NEupd_ports (NEobj_disp *);

int
NEget_subports (
    OMobj_id  obj_id,
    OMobj_id  cache_id,
    NEport    *ports,
    int       first,
    int       max,
    int       depth,
    int	      orig,
    int	      export_list);

void
NEdelete_subports (
    NEobj_disp  *obj_disp);

void
NEupdate_port_id_rw (
    NEobj_disp  *obj_disp,
    NEport	*port);

void
NEcheck_my_port (
    NEobj_disp  *obj_disp);

int NEset_conn (NEobj_disp *, int, int, int, int, int);

int NEis_disp_descendant (NEobj_disp *, NEobj_disp *);

void NEset_obj_disp_decor (
    NEobj_disp  *obj_disp,
    int          flush);

int NE_upd_port_color (NEport *, OMobj_id);

void NEinstall_hourglass (NEobj_disp  *obj_disp);

void NEinstall_hourglass_with_sys_wind (WTsys_wind  sys_wind);

int NEget_port_dims (
    NEobj_disp  *obj_disp,
    int          port_index,
    int          inout,
    WTcoord     *x,
    WTcoord     *y,
    WTcoord     *size,
    int          *horiz,
    NEobj_disp  *par_obj_disp);

void NEinit_help (void);

int NEdisplay_help (
    NEobj_disp  *obj_disp,
    const char  *topic,
    int         flag_errors);

void NEterminate_help (
    NEshell_info  *shell_info);

void
NEdisplay_obj_menu (
    NEobj_disp  *obj_disp,
    int         x,
    int         y,
    int         port_hit,
    int         inout,
    int         port_index);

void
NEgraph_menu_button (
    WTwind *wind,
    WTevent *event,
    void *arg);

int
NEhit_resize (
    NEobj_disp     *obj_disp,
    WTevent        *event);

void
NEwind_get_text_pos (
    NEobj_disp             *obj_disp,
    WTcoord               *text_x,
    WTcoord               *text_y,
    WTcoord               *pixmap_x,
    WTcoord               *pixmap_y,
    WTtext_justification  *justification);

char *
NEget_obj_name_and_value_string (
    NEobj_disp  *obj_disp,
    char        *buf,
    int         maxsize);

char *
NEget_obj_path_string (
    NEobj_disp  *obj_disp,
    char        *buf,
    int         maxsize);

char *
NEget_obj_mode_and_name (
    NEobj_disp  *obj_disp,
    char        *buf,
    int         maxsize);

void
NEget_pixmap_info (
    NEobj_disp      *obj_disp,
    char            **name,
    WTpixmap_type  *type);

void
NE_draw_xor_box (
    WTwind     *wind,
    WTcoord    x1,
    WTcoord    y1,
    WTcoord    x2,
    WTcoord    y2,
    int         draw);

/* Object finder functions */

void NEpopup_object_finder (
    NEobj_disp  *obj_disp);

void NEhide_object_finder (
    NEobj_disp  *obj_disp);

NEdescendant *NEfind_matching_descendants (
    NEobj_disp  *obj_disp,
    char         *string,
    int          mode,
    int          libs,
    int          *num_descendants);

void NEfree_descendant_list (
    NEdescendant  *descendants,
    int           num_descendants);

NEobject_finder NEcreate_object_finder (
    NEobj_disp  *obj_disp);

void NEupdate_object_finder (
    NEobject_finder  finder,
    NEobj_disp       *obj_disp);

void NEdisplay_object_finder (
    NEobject_finder  finder);

void NEshow_descendant (
    NEobj_disp        *obj_disp,
    NEdescendant_list  list);

/* Property editor functions */

void
NEpopup_properties_editor (
    NEobj_disp  *obj_disp);

void
NEhide_properties_editor (
    NEobj_disp  *obj_disp);

NEprop_list
NEget_defined_props (
    int  *num_props);

NEobj_prop_list
NEget_obj_props (
    NEobj_disp   *obj_disp,
    NEprop_list  global_props,
    int          num_global_props,
    int          *num_props);

void
NEset_obj_props (
    NEobj_disp       *obj_disp,
    NEobj_prop_list  props,
    int              num_props);

int
NEadd_obj_prop (
    NEobj_prop_list  *props,
    int              *num_props,
    NEprop_list      global_props,
    int              global_index);

void
NEdelete_obj_prop (
    NEobj_prop_list  props,
    int              prop_index,
    int              *num_props,
    NEprop_list      global_props);

void
NEfree_obj_props (
    NEobj_prop_list  props,
    int              num_props);

NEprop_group_list
NEget_prop_group_info (
    int  *num_info);

unsigned int
NEget_default_prop_group (
    NEobj_disp  *obj_disp);

int *
NEget_prop_group_indices (
    unsigned int  group,
    unsigned int  type_group,
    NEprop_list   props,
    int           num_props,
    int           *num_indices);

int *
NEget_obj_prop_group_indices (
    unsigned int     group,
    unsigned int     type_group,
    NEobj_prop_list  obj_props,
    int              num_obj_props,
    int              *num_indices);

int
NEget_num_prop_group_indices (
    unsigned int  group,
    unsigned int  type_group,
    NEprop_list   props,
    int           num_props);

/* Info dialog functions */

char **
NEget_info_port_strings (
    NEobj_disp  *obj_disp);

void
NEfree_info_port_strings (
    NEobj_disp  *obj_disp,
    char        **port_strings);

void NEpopup_object_info (
    NEobj_disp  *obj_disp);

/* Rename dialog functions */

void NEpopup_rename_dialog (
    NEobj_disp  *obj_disp);

void NEhide_rename_dialog (
    NEobj_disp  *obj_disp);

/* Object browser dialog functions */

void NEpopup_object_browser (
    NEobj_disp  *obj_disp);

/* Menu initialization functions */

int
NEdo_copy (
    char     *buffer_file);

int
NEdo_paste (
    NEobj_disp  *obj_disp,
    char        *buffer_file);

/* From app_rsrc.c */

void
NEinit_app_resources (
    NEshell_info  *shell_info);

NEapp_resource_list *
NEget_app_resources (void);

/* From arrange.c */

void
NEgraph_arrange (
    NEobj_disp *obj_disp,
    int        set_prop);

/* From data_obj.c */

void
NEupdate_proj_edit_state (
    OMobj_id  obj_id);

/* From drop.c */

int
NEdrop_selected (
    NEobj_disp  *obj_disp,
    NEobj_disp  *drop_site,
    int          merge);

int
NEcopy_vs_reparent (
    NEobj_disp  *obj_disp,
    NEobj_disp  *drop_site);

/* From flash.c */

void
NEset_flashing (
    int  flag);

void
NEadd_flash_request (
    NEobj_disp  *obj_disp);

void
NEdelete_flash_request (
    NEobj_disp  *obj_disp);

/* From group.c */

void
NEgroup_init (
    NEobj_disp  *obj_disp);

void
NEgroup_realize (
    NEobj_disp  *obj_disp);

void
NEgroup_config (
    NEobj_disp  *obj_disp);

char *
NEgroup_get_text_info (
    NEobj_disp             *obj_disp,
    WTcoord               *text_x,
    WTcoord               *text_y,
    WTcoord               *pixmap_x,
    WTcoord               *pixmap_y,
    WTtext_justification  *justification,
    char                   *buf,
    int                    maxsize);

/* From list.c */

void
NElist_val_changed (
    NEobj_disp  *obj_disp);

/* From maindisp.c */

void
NEinit_main_disp (
    NEobj_disp  *obj_disp,
    OMobj_id    upper_obj,
    OMobj_id    lower_obj,
    WTcoord    upper_height);

/* From ne_util.c */

void
NEset_port_levels (
    OMobj_id  obj_id,
    int       input,
    int       port);

OMobj_name
NEget_display_mode (
    OMobj_id  obj_id);

void
NEset_drag_cursor (
    NEobj_disp      *obj_disp,
    WTcursor_class  cursor_class);

void
NEget_geometry (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec,
    WTcoord     *x,
    WTcoord     *y,
    WTcoord     *w,
    WTcoord     *h);

WTpixel
NEget_standard_pixel (
    WTdisp           *disp,
    NEstandard_color  color_index);

const char *
NEget_translated_string (
    NEtranslation_index  index);

WTdecor_ptr
NEget_default_decor (
    NEobj_disp  *obj_disp);

NEobj_disp*
NEfind_descendant_obj_disp (
    NEobj_disp  *obj_disp,
    OMobj_id    descendant_id);

void
NEadd_subobj_callback (
    OMobj_id            obj_id,
    char                *subobj_name,
    char                *callback_name,
    NEom_callback_func  callback_func,
    void                *callback_data,
    OMobj_id            callback_obj_id);

OMobj_id
NEget_data_obj (
    OMobj_id  obj_id);

NEshell_info *
NEget_shell_info (
    OMobj_id  obj_id);

void
NEset_error_handler (
    NEshell_info  *shell_info);

void
NEclear_error_handler (
    NEshell_info  *shell_info);

void
NEhide_dialogs (
    NEobj_disp  *obj_disp);

void
NEunderscores_to_spaces (
    char *str);

/* From network.c */

void
NEupd_refs (
    NEobj_disp  *sub_disp);

/* From obj_disp.c */

void
NEmake_config_request (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec);

void
NEobj_disp_val_changed (
    NEobj_disp  *obj_disp);

void
NEconfig_obj_disp (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec);

int
NEget_port_from_xy (
    NEobj_disp  *obj_disp,
    WTcoord     x,
    WTcoord     y,
    int         *inout,
    int         *port,
    int         *inside);

WTdecor_ptr
NEget_obj_disp_decor (
    NEobj_disp  *obj_disp,
    WTdisp     *disp);

void
NEinit_maximized_obj_disp (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec);

void
NEinit_unmaximized_obj_disp (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec);

void
NEvalidate_cache (
    NEobj_disp   *obj_disp);

void
NEinvalidate_cache (
    NEobj_disp   *obj_disp);

/* From obj_info.c */

int NEcan_close (NEobj_disp *obj_disp);
int NEcan_open (NEobj_disp *obj_disp);
int NEis_opened (NEobj_disp *obj_disp);
int NEis_showing_params (NEobj_disp *obj_disp);
int NEcan_show_params (NEobj_disp *obj_disp);
int NEcan_rename (NEobj_disp *obj_disp);
int NEcan_obj_reference_others (OMobj_id obj_id);

int NEcan_minimize (NEobj_disp *obj_disp);

int NEis_minimized (NEobj_disp *obj_disp);

int NEcan_maximize (NEobj_disp *obj_disp);

int NEget_maximization (NEobj_disp *obj_disp);

int NEcan_move (NEobj_disp *obj_disp);

int NEcan_size (NEobj_disp *obj_disp);

int NEhas_siblings (NEobj_disp *obj_disp);

int NEis_obj_open (
    OMobj_id  obj_id);

int NEis_open (
    NEobj_disp  *obj_disp);

int NEis_obj_library_type (
    OMobj_id  obj_id);

int NEis_library_type (
    NEobj_disp  *obj_disp);

int NEis_flibrary_type (
    NEobj_disp  *obj_disp);

int NEis_editable (
    NEobj_disp  *obj_disp);

int NEis_loadable (
    NEobj_disp  *obj_disp);

int NEcan_resize (
    NEobj_disp  *obj_disp);

int NEcan_edit_props (
    NEobj_disp  *obj_disp);

int NEcan_edit_ports (
    NEobj_disp  *obj_disp);

int
NEis_expanded (NEobj_disp *obj_disp);

int
NEis_selected (NEobj_disp *obj_disp);

int
NEis_visible (NEobj_disp *obj_disp);

int
NEis_group_array (NEobj_disp *obj_disp);

int
NEcan_edit_value (NEobj_disp *obj_disp);

int NEis_obj_link (
    OMobj_id  obj_id);

int
NEis_link (NEobj_disp *obj_disp);

int NEnum_subobjs (
    NEobj_disp  *obj_disp);

int NEis_scratch_pad (
    NEobj_disp  *obj_disp);

int
NEin_scratch_pad (
    NEobj_disp  *obj_disp);

int
NEis_array_of_group_refs (
    NEobj_disp  *obj_disp);

int
NEsubobjs_readonly (
    NEobj_disp  *obj_disp);

int
NEis_connected_group_ref (
    NEobj_disp  *obj_disp);

int
NEis_array (
    NEobj_disp  *obj_disp);

/* From oe.c */

int
OEget_obj_ref (
    OMobj_id  obj_id,
    OMobj_id  *ref_id);

int
OEset_int_val_same (
    OMobj_id  obj_id,
    const char *name_str,
    int       value);

/* From popup.cxx */

void
NEprocess_popup_selection (
    NEobj_disp  *obj_disp,
    int         active_id);

/* From port.c */

void
NEport_press (
    NEobj_disp  *obj_disp,
    int         inout,
    int         port_index,
    int         inside);

void
NEport_motion (
    NEobj_disp  *obj_disp,
    WTevent     *event,
    int         in_parent);

void
NEport_release (
    NEobj_disp  *obj_disp);

/* From stat.c */

NEstate_ptr
NEcreate_state ();

void
NEdestroy_state (
    NEstate_ptr  state);

void
NEadd_selected_obj (
    NEstate_ptr  state,
    NEobj_disp   *obj_disp);

int
NEis_selected_obj (
    NEstate_ptr  state,
    NEobj_disp   *obj_disp);

void
NEdelete_selected_obj (
    NEstate_ptr  state,
    NEobj_disp   *obj_disp);

void
NEclear_selected_objs (
    NEstate_ptr  state);

void
NEadd_shell_info (
    NEstate_ptr   state,
    NEshell_info  *shell_info);

void
NEdelete_shell_info (
    NEstate_ptr   state,
    NEshell_info  *shell_info);

void
NEupdate_menubars (
    NEstate_ptr  state);

NEobj_disp *
NEget_single_selected_obj (
    NEstate_ptr  state);

/* From tmp_util.cxx */

void
NEupdate_status_bar (
    NEobj_disp  *obj_disp,
    char        *string);

/* From val.c */

int
NEval_init (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec,
    int          request_config);

int
NEval_cleanup (
    NEobj_disp      *obj_disp,
    NEcleanup_mode  mode);

void
NEval_realize (
    NEobj_disp  *obj_disp);

void
NEval_val_changed (
    NEobj_disp  *obj_disp);

void
NEval_config (
    NEobj_disp  *obj_disp);

/* From wind.c */

void
NEwind_val_changed (
    NEobj_disp  *obj_disp);

/* UNIX/NT-specific functions */

#ifdef MSDOS

BOOL WINAPI
BrowserDlgProc (HWND hDlg,UINT msg,WPARAM wParam,LPARAM lParam);

BOOL WINAPI
ElemInfoDlgProc (HWND hDlg,UINT msg,WPARAM wParam,LPARAM lParam);

#else

XmString
NEget_translated_xmstring (
    NEtranslation_index  index);

void
NEcenter_widget (
    Widget  w);

void NEadd_wm_del_handler (Widget  w);

#endif

#ifdef __cplusplus
}  /* End extern "C" */
#endif

/*--------------------------------------------------------------------*/

#endif /* XP_NE_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
