/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/ne_type.h#1 $
*/

/* Header file containing type definitions for the Network Editor */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_NE_TYPE_INCLUDED
#define XP_NE_TYPE_INCLUDED

/*---------------------------------------------------------------------*/

/* Header files */

#include <avs/wt_objs.h>
#include <avs/ne_om.h>
#include <avs/f_utils.h>

/*--------------------------------------------------------------------*/
/*                      Constants and macros                          */
/*--------------------------------------------------------------------*/

/* Function return codes */

#define NE_SUCCESS  1
#define NE_ERROR    0

/* Constants to indicate input and output ports */

#define NE_PORT_IN   1
#define NE_PORT_OUT  0

/* Modes indicating types of possible connections that should be displayed */

#define NE_CONN     0x1
#define NE_DISCONN  0x2

/* Modes for NEfind_matching_descendants */

#define NE_MATCH_NAME   0
#define NE_MATCH_TYPE   1
#define NE_MATCH_CLASS  2

/* Size of an icon obj_disp */

#define NE_DEFAULT_WIDTH   140.0
#ifdef MSDOS
#define NE_DEFAULT_HEIGHT  28.0
#else
#define NE_DEFAULT_HEIGHT  30.0
#endif

/* Default size of upper obj_disp in main NE window */

#define NE_DEFAULT_PANE_HEIGHT  258.0

/* Default window transformation */

#define NE_DEFAULT_OFFX   0.0
#define NE_DEFAULT_OFFY   0.0
#define NE_DEFAULT_SCALE  1.0

/* Grid size for networks */

#define NE_DEFAULT_GRID_W  11.0
#define NE_DEFAULT_GRID_H  11.0

/* Offset for duplication of obj_disps */

#define NE_ICON_COPY_OFFSET  20.0

/* Pixmap or text origin in obj_disps */

#define NE_ICON_LEFT_PAD  5.0
#ifdef MSDOS
#define NE_ICON_TOP_PAD   2.0
#else
#define NE_ICON_TOP_PAD   4.0
#endif

/* Minimum subport width before icons are widened */

#define NE_ICON_MIN_PORT_SIZE  20.0

/* Default port width */

#define NE_ICON_PORT_WIDTH  20.0

/* Pointer tolerance for selecting ports */

#define NE_ICON_PORT_FUDGE  3.0

/* Height/width ratio of triangle drawn at connections to subports */

#define NE_ICON_PORT_MARKER_RATIO  0.4

/* Thickness of border around inside of open lists and networks */

#define NE_ICON_SKID_PAD_SIZE  1.0

/* Thickness of ports */

#ifdef MSDOS
#define NE_ICON_PORT_THICKNESS  5.0
#else
#define NE_ICON_PORT_THICKNESS  6.0
#endif

/* Minimum space between ports */

#ifdef MSDOS
#define NE_ICON_MIN_PAD  4.0
#else
#define NE_ICON_MIN_PAD  5.0
#endif

/* Size of scroll arrow buttons */

#ifdef MSDOS
#define NE_BUTTON_WIDTH   16.0
#define NE_BUTTON_HEIGHT  16.0
#else
#define NE_BUTTON_WIDTH   18.0
#define NE_BUTTON_HEIGHT  18.0
#endif

/* Space between arrow buttons and window edge */

#define NE_BUTTON_LEFT_PAD  6.0

/* Size of type icon type indicator */

#ifdef MSDOS
#define NE_ICON_DOT_W  6.0
#define NE_ICON_DOT_H  6.0
#else
#define NE_ICON_DOT_W  7.0
#define NE_ICON_DOT_H  7.0
#endif

/* Distance from corner of obj_disp to resize handle */

#define NE_ICON_HANDLE_SIZE  20.0

/* Minimum distance between obj_disp and wrapped connection */

#define NE_CONN_EXTEND_LEN  6.0

/* Width of connection lines */

#define NE_CONN_LINE_WIDTH  4.0

/* Square of minimum pointer distance from port before connection is valid */

#define NE_CONN_START_RADIUS  400.0

/* Spacing between contents of a list */

#define NE_ICON_LIST_HPAD  0.0
#define NE_ICON_LIST_NEAD  0.0

/* Spacing between contents of a network */

#define NE_ICON_NET_HPAD  10.0
#define NE_ICON_NET_NEAD  10.0

/* Offset for subsequent iterations of default network spacing */

#define NE_ICON_NET_INCR  11.0

/* Generic obj_disp border thickness */

#define NE_OBJ_DISP_BORDER  6.0

/* List border thickness */

#define NE_ICON_LIST_BORDER  NE_OBJ_DISP_BORDER

/* Network border thickness -- side and bottom */

#define NE_ICON_NET_BORDER  NE_OBJ_DISP_BORDER
#define NE_ICON_NET_BOTTOM  NE_OBJ_DISP_BORDER

/* Typein border thickness */

#define NE_ICON_VAL_BORDER  NE_OBJ_DISP_BORDER

/* Resize handle thickness */

#define NE_ICON_SEP_BORDER  4.0

/* Height of an obj_disp header */

#define NE_OBJ_DISP_HEADER  NE_DEFAULT_HEIGHT

/* Default height of a typein */

#define NE_TYPEIN_HEIGHT  NE_DEFAULT_HEIGHT

/* Default height of a multiline typein */

#define NE_MULTILINE_TYPEIN_HEIGHT  (5.0 * NE_TYPEIN_HEIGHT)

/* Default width of a list */

#define NE_LIST_WIDTH  220.0

/* Default values for maximum list size */

#define NE_LIST_MAX_WIDTH   750.0
#define NE_LIST_MAX_HEIGHT  425.0

/* Width of scrollbars in lists */

#define NE_LIST_SCROLLBAR_WIDTH  15.0

/* Spacing between list subwindow and scrollbar */

#define NE_LIST_SCROLLBAR_MARGIN 2.0

/* Spacing between list buttons and right edge */

#define NE_BUTTON_MARGIN 6.0

/* Spacing between header and subheader */

#define NE_SUB_HEADER_MARGIN 5.0

/* Geometry of pager option menu */

#define NE_OPTION_MENU_Y       3.0
#define NE_OPTION_MENU_WIDTH   140.0
#ifdef MSDOS
#define NE_OPTION_MENU_HEIGHT  24.0
#else
#define NE_OPTION_MENU_HEIGHT  26.0
#endif

/* Height of pager obj_disp header */

#ifdef MSDOS
#define NE_PAGER_HEADER      30.0
#else
#define NE_PAGER_HEADER      31.0
#endif

/* Default color for ports/connections */

#define NE_ICON_PORT_RED        0.2
#define NE_ICON_PORT_GREEN      0.2
#define NE_ICON_PORT_BLUE       0.2

/* Rubberband color */

#define NE_RUBBER_BAND_RED      1.0
#define NE_RUBBER_BAND_GREEN    0.0
#define NE_RUBBER_BAND_BLUE     0.0

/*---------------------------------------------------------------------*/

/* The following macro returns the coordinate value "c", snapped to the
   grid size "g". */

#define NE_GRID(c, g)  ((int) (((c)/(g)) + 0.5) * (g))

/* The following macro returns a pointer to the n'th child of obj_disp "o",
   except if n is negative, in which case it returns a pointer to the
   obj_disp itself.  It returns NULL if n is positive but out of range. */

#define NE_SUB_DISP(o, n)  ((n) < 0 ? (o) : \
     ((n) >= (o)->num_subs ? NULL : (o)->subs[(n)].obj_disp))

/* The following macro returns a pointer to the n'th port of obj_disp "o",
   except if n is negative, in which case it returns a pointer to the
   obj_disp's own port.  It returns NULL if n is positive but out of range. */

#define NE_PORT(o, n) ((n) < 0 ? &(o)->my_port : \
     ((n) >= (o)->num_ports ? NULL : &(o)->ports[(n)]))

/*--------------------------------------------------------------------*/
/*                       Geometry spec flags                          */
/*--------------------------------------------------------------------*/

/* NB:  These need some explanation... */

#define NE_GEOM_X_REQ     0x1
#define NE_GEOM_Y_REQ     0x2
#define NE_GEOM_W_REQ     0x4
#define NE_GEOM_H_REQ     0x8

#define NE_GEOM_X_OPT     0x10
#define NE_GEOM_Y_OPT     0x20
#define NE_GEOM_W_OPT     0x40
#define NE_GEOM_H_OPT     0x80

#define NE_GEOM_W_RESIZE  0x100
#define NE_GEOM_H_RESIZE  0x200

#define NE_GEOM_USER      0x400

#define NE_GEOM_OPT  (NE_GEOM_X_OPT | NE_GEOM_Y_OPT | \
                      NE_GEOM_W_OPT | NE_GEOM_H_OPT)

#define NE_GEOM_REQ  (NE_GEOM_X_REQ | NE_GEOM_Y_REQ | \
                      NE_GEOM_W_REQ | NE_GEOM_H_REQ)

#define NE_GEOM_X    (NE_GEOM_X_OPT | NE_GEOM_X_REQ)
#define NE_GEOM_Y    (NE_GEOM_Y_OPT | NE_GEOM_Y_REQ)
#define NE_GEOM_W    (NE_GEOM_W_OPT | NE_GEOM_W_REQ)
#define NE_GEOM_H    (NE_GEOM_H_OPT | NE_GEOM_H_REQ)

#define NE_GEOM_TOP_DISP 0x800

/*--------------------------------------------------------------------*/
/*                         Enumerated types                           */
/*--------------------------------------------------------------------*/

/* Color indices for NEget_standard_pixel */

typedef enum {
    NE_COLOR_SELECTED,
    NE_COLOR_DROP_SITE,
    NE_COLOR_MERGE_SITE,
    NE_COLOR_EXEC,
    NE_COLOR_SEL_EXEC,
    NE_COLOR_SUBWINDOW,
    NE_COLOR_CONN_LINE,
    NE_COLOR_CONN,
    NE_COLOR_DISCONN
} NEstandard_color;

/* Indices for database that contains NE string translation info */

typedef enum {
    NE_TS_OK,
    NE_TS_APPLY,
    NE_TS_CANCEL,
    NE_TS_HELP,
    NE_TS_SELECTION,
    NE_TS_NO_MATCH,
    NE_TS_UNKNOWN,
    NE_TS_FIND_TITLE,
    NE_TS_FIND_SHOW,
    NE_TS_FIND_CLOSE,
    NE_TS_FIND_OBJECTS,
    NE_TS_FIND_FIND,
    NE_TS_FIND_BYNAME,
    NE_TS_FIND_BYCLASS,
    NE_TS_FIND_BYTYPE,
    NE_TS_FIND_FIND_OBJ,
    NE_TS_FIND_PATTERN,
    NE_TS_HELP_TITLE,
    NE_TS_HELP_NO_HELP,
    NE_TS_HELP_NO_HELPFILE,
    NE_TS_HELP_NO_HYPERHELP,
    NE_TS_INFO_TITLE,
    NE_TS_INFO_INPUT,
    NE_TS_INFO_OUTPUT,
    NE_TS_INFO_LINK,
    NE_TS_INFO_TEMPLATE,
    NE_TS_INFO_TYPE,
    NE_TS_INFO_PATH,
    NE_TS_PROP_TITLE,
    NE_TS_PROP_GROUP,
    NE_TS_PROP_CURRENT,
    NE_TS_PROP_ALL,
    NE_TS_PROP_VALUE,
    NE_TS_PROP_SET,
    NE_TS_PROP_ADD,
    NE_TS_PROP_DELETE,
    NE_TS_PROP_HELP_TITLE,
    NE_TS_PROP_WARNING_TITLE,
    NE_TS_PROP_WARNING,
    NE_TS_PROP_DEFAULT_HELP,
    NE_TS_PROP_NO_HELP,
    NE_TS_PROP_READONLY_TITLE,
    NE_TS_PROP_TITLE_1_1_FORMAT,
    NE_TS_PROP_READONLY_TITLE_1_1_FORMAT,
    NE_TS_RENAME_TITLE,
    NE_TS_RENAME_PROMPT,
    NE_TS_BROWSER_TITLE,
    NE_TS_POPUP_CLOSE,
    NE_TS_POPUP_REDUCE,
    NE_TS_POPUP_MAXIMIZE,
    NE_TS_POPUP_EDIT_VALUE,
    NE_TS_POPUP_OPEN,
    NE_TS_POPUP_SHOW_PARAMS,
    NE_TS_POPUP_INFO,
    NE_TS_POPUP_HELP,
    NE_TS_POPUP_RENAME,
    NE_TS_POPUP_PROPERTIES,
    NE_TS_POPUP_FIND,
    NE_TS_POPUP_ADD_IPORT,
    NE_TS_POPUP_ADD_OPORT,
    NE_TS_POPUP_EXPORT_PORT,
    NE_TS_POPUP_REMOVE_PORT,
    NE_TS_POPUP_DELETE,
    NE_TS_POPUP_RESET,
    NE_TS_POPUP_ARRANGE,
    NE_TS_POPUP_ZOOM,
    NE_TS_POPUP_INSERT_LINK,
    NE_TS_POPUP_DELETE_CONN,
    NE_TS_PROP_GROUP_NE,
    NE_TS_PROP_GROUP_OM,
    NE_TS_PROP_GROUP_CXX,
    NE_TS_PROP_GROUP_UCI,
    NE_TS_PROP_GROUP_BUILD,
    NE_TS_PROP_GROUP_GENERAL,
    NE_TS_PROP_GROUP_ALL,
    NE_TS_STATBAR_MOVE,
    NE_TS_STATBAR_REPARENT,
    NE_TS_STATBAR_COPY,
    NE_TS_STATBAR_PRE_MERGE,
    NE_TS_STATBAR_MERGE,
    NE_TS_STATBAR_PRE_CONN,
    NE_TS_STATBAR_EXPORT_IN,
    NE_TS_STATBAR_EXPORT_OUT,
    NE_TS_STATBAR_UNEXPORT_IN,
    NE_TS_STATBAR_UNEXPORT_OUT,
    NE_TS_STATBAR_CONN_INOUT,
    NE_TS_STATBAR_CONN_OUTIN,
    NE_TS_STATBAR_DISCONN_INOUT,
    NE_TS_STATBAR_DISCONN_OUTIN,
    NE_TS_CMPPROJ_NO_ACTION,
    NE_TS_CMPPROJ_NO_FILE,
    NE_TS_CMPPROJ_NO_APP,
    NE_TS_CMPPROJ_NO_SELECTED,
    NE_TS_CMPPROJ_COMPILING,
    NE_TS_CMPPROJ_GENERATING,
    NE_TS_CMPPROJ_GEN_AND_CMP,
    NE_TS_CMPPROJ_FAIL,
    NE_TS_CMPPROJ_SAME_PATH,
    NE_TS_CMPPROJ_REPLACE_DIR,
    NE_TS_CMPNNP_NO_ACTION,
    NE_TS_CMPNNP_BLDING_PLUGIN,
    NE_TS_PARAMS_LABEL,
    NE_TS_OE_SRC_INHERIT
} NEtranslation_index;

/* Flags for mode_cleanup method */

typedef enum {
    NE_CLEANUP_DESTROY,
    NE_CLEANUP_MODE_CHANGED
} NEcleanup_mode;

/*--------------------------------------------------------------------*/
/*                           Type definitions                         */
/*--------------------------------------------------------------------*/

/* Forward references to data structure types */

typedef struct _NEgeom_spec   NEgeom_spec;
typedef struct _NEobj_disp    NEobj_disp;
typedef struct _NEport        NEport;
typedef struct _NEshell_info  NEshell_info;

/*--------------------------------------------------------------------*/

/* obj_disp method prototypes: */

/* Display mode initialization function */

typedef int (*NEmode_init_func) (
    NEobj_disp   *obj_disp,
    NEgeom_spec  *geom_spec,
    int          conf);

/* Display mode termination function */

typedef int (*NEmode_cleanup_func) (
    NEobj_disp      *obj_disp,
    NEcleanup_mode  mode);

/* Display mode realize function */

typedef void (*NEmode_realize_func) (
    NEobj_disp  *obj_disp);

/* Called when one or more OM properties were updated */

typedef int (*NEprop_changed_func) (
    NEobj_disp  *obj_disp);

/* Called when the OM object value was updated */

typedef void (*NEval_changed_func) (
    NEobj_disp  *obj_disp);

/* For reacting to changes in obj_disp geometry */

typedef void (*NEconfig_func) (
    NEobj_disp   *obj_disp);

/* For configuring ports...  (NB:  needs further explanation) */

typedef void (*NEport_dims_func) (
    NEobj_disp  *obj_disp,
    NEobj_disp  *parent_disp,
    int         inout,
    int         *horiz,
    WTcoord    *min,
    WTcoord    *max,
    WTcoord    *loc);

typedef void (*NEget_port_dims_func) (
    NEobj_disp  *obj_disp,
    NEport      *port,
    int         ind,
    int         inout,
    WTcoord    *x,
    WTcoord    *y,
    WTcoord    *size,
    int         *horiz,
    NEobj_disp  *parent_disp);

typedef int (*NEget_port_from_xy_func) (
    NEobj_disp  *obj_disp,
    WTcoord     x,
    WTcoord     y,
    int         *inout,
    int         *port,
    int         *inside);

/* Get text info for an obj_disp's label */

typedef char* (*NEget_text_info_func) (
    NEobj_disp             *obj_disp,
    WTcoord               *text_x,
    WTcoord               *text_y,
    WTcoord               *pixmap_x,
    WTcoord               *pixmap_y,
    WTtext_justification  *justification,
    char                   *buf,
    int                    maxsize);

/* Called when one or more subobjects are added or deleted */

typedef int (*NEupd_subobjs_func) (
    NEobj_disp  *obj_disp);

/* Ask a parent to configure its child */

typedef int (*NEconfig_req_func) (
    NEobj_disp   *obj_disp,
    NEobj_disp   *chld,
    NEgeom_spec  *spec);

/*
 * This routine allows a user to request a geometry spec for a 
 * particular sub-object.  We will in any constraints so that  <== NB: ???
 * the guy knows how to create itself.  This routine also returns
 * a boolean indicating if we want the sub-object to have us
 * configure the window change from the spec.
 */

typedef void (*NEgeom_spec_req_func) (
    NEobj_disp   *obj_disp,
    NEobj_disp   *chld,
    NEgeom_spec  *spec,
    int          *conf);

/* Get the window to be used as the parent for subobject windows */

typedef WTwind* (*NEget_parent_wind_func) (
    NEobj_disp  *obj_disp);

/* Method for dealing with deletion of a subobject.  NB:  This must be
   replaced by a method that is analogous to the change_managed method
   in Xt */

typedef void (*NEdelete_child_func) (
    NEobj_disp  *parent,
    NEobj_disp  *child,
    int         destroy);

/* Method for asking an obj_disp's parent if interactive resizing is allowed */

typedef int (*NEresize_query_func) (
    NEobj_disp  *parent,
    NEobj_disp  *child);

/* Method for asking an obj_disp's parent what obj_disp should be resized
   when the user performs a rubberbanding operation */

typedef NEobj_disp* (*NEget_resize_disp_func) (
    NEobj_disp  *parent,
    NEobj_disp  *child);

/* Method for finding (and possibly creating) a sub obj_disp */

typedef NEobj_disp* (*NEfind_sub_obj_disp_func) (
    NEobj_disp  *parent,
    OMobj_id    child);

/*--------------------------------------------------------------------*/

/* Typedef for OM callback function.  (Should be defined by the OM). */

typedef int (*NEom_callback_func) (
    OMobj_id      callback_obj_id,
    OMobj_id      client_obj_id,
    unsigned int  event_mask,
    void          *client_data);

/*--------------------------------------------------------------------*/

/* Geometry specification data structure */

struct _NEgeom_spec {
    WTcoord  x, y, w, h;
    int      flags;
};

/* Data structure for a port */

struct _NEport {
    OMobj_id  obj_id;
    OMobj_id  callback;
    int       num_colors;
    WTcolor   colors[NE_MAX_PORT_COLORS];
    int       in_depth;
    int       out_depth;
};

/* Member of an obj_disp's child list.  An array of these structures is
   used instead of an array of obj_disps, because the child may not have
   and obj_disp associated with it. */

typedef struct _NEsub_obj {
    OMobj_id      obj_id;
    NEobj_disp    *obj_disp;
    unsigned int  om_rdonly:1;
    unsigned int  readonly:1;
} NEsub_obj;

/* Connection between subobjects */

typedef struct _NEconn {
    int             out_sub;
    int             in_sub;
    int             out_port;
    int             in_port;
    unsigned int    connect:1;
    struct _NEconn  *next;
    struct _NEconn  *prev;
} NEconn;

typedef struct _NEstub {
    int             sub;
    int             port;
    int		    inout;
    struct _NEstub  *next;
} NEstub;

/* Data structure for dragged objects */

typedef struct _NEdragged_obj {
    NEobj_disp  *obj_disp;
    WTcoord     new_x;
    WTcoord     new_y;
} NEdragged_obj;

/* Class record for an obj_disp */

typedef struct _NEdisp_type {
    char                        type_name[64];
    NEmode_init_func            mode_init;
    NEmode_cleanup_func         mode_cleanup;
    NEmode_realize_func         mode_realize;
    NEport_dims_func            port_dims;
    NEprop_changed_func         prop_changed;
    NEval_changed_func          val_changed;
    NEconfig_func               config;
    NEget_port_dims_func        get_port_dims;
    NEget_port_from_xy_func     get_port_from_xy;
    NEget_text_info_func        get_text_info;
    NEupd_subobjs_func          upd_subobjs;
    NEconfig_req_func           config_req;
    NEgeom_spec_req_func        geom_spec_req;
    NEget_parent_wind_func      get_parent_wind;
    NEdelete_child_func         delete_child;
    NEresize_query_func         resize_query;
    int                         use_text_in_children;
    NEget_resize_disp_func      get_resize_disp;
    NEfind_sub_obj_disp_func    find_sub_obj_disp;
    struct _NEdisp_type         *next;
} NEdisp_type;

/* Object display structure.  This is the main data structure for objects
   in the Network Editor. */

struct _NEobj_disp {
    NEdisp_type    *type;              /* Pointer to current class record */
    NEshell_info   *shell_info;        /* Pointer to shell window info */
    WTsys_wind     ext_sys_wind;       /* Parent widget for this hierarchy */
    OMobj_id       obj_id;             /* OM ID of this object */
    OMobj_id	   cache_id;	       /* The obj_id to use for querying
					  properties and other read-only
					  changes to an object.  usually
					  is just obj_id, but may be a cached
					  local copy if obj_id is in a remote
					  process */
    NEobj_disp     *parent;            /* Parent obj_disp (or NULL) */
    WTcoord        grid_w;             /* Grid size */
    WTcoord        grid_h;

    unsigned int   realized:1;
    unsigned int   selected:1;
    unsigned int   executing:1;
    unsigned int   dynamic_w:1;
    unsigned int   dynamic_h:1;        /* True for cntr windows that resize h */
    unsigned int   scroll_v:1;         /* List scrolls in given direction */
    unsigned int   scroll_h:1;
    unsigned int   list_horiz:1;       /* List is organized horizontally */
    unsigned int   conns_drawn:1;      /* Connections are currently drawn */
    unsigned int   has_conns:1;        /* Object displays conns of subs */
    unsigned int   is_drop_site:1;     /* Object is active drop site */
    unsigned int   is_merge_site:1;    /* Object is active merge site */
    unsigned int   extra_subport:1;    /* Extra subport is in use */
    unsigned int   browse_open:1;      /* Browser icon is "open" */
    unsigned int   om_rdonly:1;        /* Object is read-only in the OM */
    unsigned int   readonly:1;         /* Object is read-only in the NE */
    unsigned int   scroll_here:1;      /* Auto-scroll here at NEset_disp_mode */
    unsigned int   conns_out_of_date:1;/* Connections need to be updated */
    unsigned int   use_text:1;         /* Display object name in title */
    unsigned int   use_pixmap:1;       /* Display pixmap in title */
    unsigned int   large_pixmap:1;     /* Use large pixmap configuration */
    unsigned int   list_vertical:1;    /* List is organized vertically */
    unsigned int   scrollable:1;       /* List is scrollable */
    unsigned int   list_scrolling:1;   /* List scrollbar currently dragging */
    unsigned int   maximized:1;        /* Object is maximized */
    unsigned int   group_array:1;      /* Object is an array of groups */
    unsigned int   flash_enabled:1;    /* "Flash request" has been added */
    unsigned int   resizing:1;         /* Resize is active */
    unsigned int   connecting:2;       /* If connecting or disconnecting */
    unsigned int   poss_conns_drawn:1; /* Possible conns are currently drawn */
    unsigned int   child_port_press:1; /* User pressed in a child port */
    unsigned int   opt_xy:1;	       /* Object disp does not have NEx/NEy */
    unsigned int   port_subs:1;        /* Subobjects are ports, not real subs */
    unsigned int   ne_editable:1;      /* Is this object marked as editable? */

    int		   export_levels;      /* # of levels down we are exporting */

    OMobj_name     obj_name;           /* Name of this object */

    int            num_subs;
    int            num_ports;
    NEsub_obj      *subs;              /* List of subobjects */
    NEport         *ports;             /* List of subports */
    NEport         my_port;            /* Object's own port */

    OMobj_id       callback;           /* Callback object for OM updates */

    NEconn         *conns;             /* List of subobj connections */
    NEconn         *last_conn;         /* End of "conns" list */
    NEconn         *poss_conns;        /* List of possible connections */
    NEstub	   *stubs;	       /* List of ports with invis conns */

    WTwind         *wind;              /* Main window */
    WTwind         *scroll_wind;       /* Scrollable canvas for lists */
    WTwind         *sub_wind;          /* Window to display sub-objects */
    WTwind         *scrollbar;         /* Scrollbar window */
    WTwind         *option_menu;       /* Option menu window */
    WTwind         *typein_wind;       /* List value typein */
    WTpixmap_ptr   pixmap;             /* Pixmap to be displayed in window */
    WTfontset_ptr  fontset;            /* Font set for displaying text */
    char           *user_name;         /* Value of user_name property */

    WTwind         **buttons;          /* Array of button windows */
    int            num_buttons;        /* Number of button windows */

    NEobj_disp     *drop_site_disp;    /* Current drop site */
    WTwind         *drop_site_wind;    /* Drop window */
    NEdragged_obj  *dragged_objs;      /* Info for objects being dragged */
    int            num_dragged_objs;
    WTcursor_class drag_cursor;        /* Current drag cursor class */

    int            port_menu_index;    /* Active port for popup menu */
    NEport         *inc_subport;       /* Incr'ed subport for poss conns */
    int            inc_inout;          /* Which side was incremented */
    WTcoord        unmax_x;            /* Origin before maximize */
    WTcoord        unmax_y;
    NEobj_disp     *maximized_sub;     /* Maximized child obj_disp */
    WTcoord        unmax_offx;         /* Window info when child unmaximized */
    WTcoord        unmax_offy;
    WTcoord        unmax_scale;

    int            current_page;       /* Pager's current page */

    NEconn         *candidate_conn;
    NEobj_disp     *conn_to_disp;
    int            press_port_inout;
    int            press_port_index;

    WTcoord        press_x;
    WTcoord        press_y;
    NEobj_disp     *conn_sub;

    unsigned int   prop_group;         /* Current group in prop editor */

    OMobj_id       popup_obj;          /* Temporary object for popup menu */
};

/* Shell info for an NE top level window */

struct _NEshell_info {
    OMobj_id               data_obj;
    WText_display_context  *context;
    WTfontset_ptr          fontset;
    WTfontset_ptr          typein_fontset;
    WTdecor_ptr            default_decor;
    WTsys_wind             parent_sys_wind;
    NEobj_disp             *top_disp;
    NEobj_disp             *app_disp;
    OMobj_id               app_obj;
    int                    in_obj_editor;
};

/* State data structure for maintaining global data */

typedef struct _NEstate {

    NEobj_disp    **selected_objs;
    int           num_selected_objs;
    int           num_selected_objs_alloced;
    NEshell_info  **shells;
    int           num_shells;
    int           num_shells_alloced;
    NEobj_disp    *highlighted_obj;
    char          *buffer_file;
    int           inited;

} NEstate, *NEstate_ptr;

/* Member of linked list of descendants in a path */

typedef struct _NEdesc_list_obj {
    OMobj_id                 obj_id;
    struct _NEdesc_list_obj  *next;
} NEdesc_list_obj, *NEdescendant_list;

/* Member of descendant list for object finder */

typedef struct _NEdescendant {
    char               *path_to;
    NEdescendant_list  path_list;
} NEdescendant;

/* Opaque pointer to object finder data structure */

typedef struct _NEobject_finder_rec  *NEobject_finder;

/* Data structures for property editor */

typedef struct _NEprop_rec {
    OMobj_name    name;
    unsigned int  group;
    char          *default_value;
    char          *help_string;
    int           deletable;
    int           in_use;
} NEprop_rec, *NEprop_list;

typedef struct _NEobj_prop_rec {
    OMobj_name    name;
    unsigned int  group;
    char          *value;
    int           prop_index;
} NEobj_prop_rec, *NEobj_prop_list;

typedef struct _NEprop_group_rec {
    unsigned int         group;
    NEtranslation_index  index;
} NEprop_group_rec, *NEprop_group_list;

/* Opaque pointer to info dialog data structure */

typedef struct _NEinfo_dialog_rec  *NEinfo_dialog;

/* Opaque pointer to browser dialog data structure */

typedef struct _NEobject_browser_rec  *NEobject_browser;

/* Structure to hold application resource values.  A single structure of
   this type is accessed using the function NEget_app_resources. */

typedef struct _NEapp_resource_list {
    int      bevel_thickness;
    WTpixel  connecting_line_color;
    WTpixel  connecting_object_color;
    WTpixel  disconnecting_object_color;
    WTpixel  drop_site_color;
    WTpixel  executing_object_color;
    int      font_family;
    int      font_slant;
    int      font_weight;
    int      highlight_under_pointer;
    int      loaded_objects_replace;
    WTpixel  merge_site_color;
    WTpixel  selected_executing_object_color;
    WTpixel  selected_object_color;
    WTpixel  subwindow_background;
    int      text_height;
    int      typein_font_family;
    int      typein_font_slant;
    int      typein_font_weight;
    int      typein_text_height;
} NEapp_resource_list;

/* The following macro is used for accessing a particular field of
   the resource struct */

#define NE_APP_RESOURCE(field) \
    ((NEget_app_resources())->field)

/*--------------------------------------------------------------------*/
/*                       External references                          */
/*--------------------------------------------------------------------*/

#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif

/* References to available obj_disp types */

IMPORT NEdisp_type  *NE_type_icon, *NE_type_graph, *NE_type_list, 
		    *NE_type_export_list,
                    *NE_type_val, *NE_type_main_disp, *NE_type_pager;

/* Pointer to global state structure used by the NE */

IMPORT NEstate_ptr  NE_state;

IMPORT int NE_save_ui_settings;

#ifdef __cplusplus
}  /* End extern "C" */
#endif

/*--------------------------------------------------------------------*/

#endif /* XP_NE_TYPE_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
