/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/octree.h#1 $
*/

typedef struct list_
	{
	struct list_ * next;    /* List glue.                   */
	int id;                 /* data in list.                */
	} LIST;

typedef struct octree
{
	float size;
	float xyz[3];
	union
	{
		struct
		{
			struct octree * child;
		} internal;
		struct
		{
			int  num_e;
			LIST *elist;
		} leaf;
	} internal_or_leaf;
	char isparent;
} OCTREE;

typedef struct octree_list
{
	OCTREE *octree;
	LIST   **list;
	int     block_num;
	int     block_size;
	int     list_count;
	LIST   *list_end;
	LIST   *list_free;
	int     child_count;
	int     child_max;
} OCTREE_LIST;
