/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/om.h#1 $
*/
#ifndef OM_INCLUDED
#define OM_INCLUDED
/*
 * This file contains standard header definitions and function declarations
 * for standard OM users
 */

#ifdef MSDOS
#ifdef __cplusplus
#include <afxwin.h>
#else
#include <windows.h>
#endif
#undef min
#undef max
#endif

#include <stdio.h>
#include <avs/port.h>
#include <avs/err.h>
#include <avs/arr.h>
#include <avs/comm.h>
#include <avs/strmio.h>
#include <avs/heap.h>

#ifdef __cplusplus
extern "C" {
#endif

#define FUNC_PREFIX DLL_EXPORT

#ifdef OM_DEFINE_GLOBALS
#define OM_EXTERN
#else
#ifdef XP_INTERNAL_GLOBALS
#define OM_EXTERN extern
#else
#define OM_EXTERN DLL_IMPORT
#undef  FUNC_PREFIX
#define FUNC_PREFIX DLL_IMPORT
#endif
#endif

#ifdef OM_DEFINE_G_GLOBALS
#define OM_G_EXTERN
#else
#ifdef XP_INTERNAL_GLOBALS
#define OM_G_EXTERN extern
#else
#define OM_G_EXTERN DLL_IMPORT
#endif
#endif

/* The proc id is an index into a table of host information stuff. */
typedef int OMproc_id;

typedef int (*OMpfi)();
typedef void *OMptr;

typedef enum {
   OM_METH_CREATE_OBJ,
   OM_METH_DESTROY_OBJ,
   OM_METH_SAVE_OBJ,
   OM_METH_SAVE_OBJ_HDR,
   OM_METH_MATCH_OBJ,
   OM_METH_IS_MATCHED_OBJ,
   OM_METH_MERGE_OBJ,
   OM_METH_INSERT_SUBOBJ,
   OM_METH_DEL_SUBOBJ,
   OM_METH_UPD_SUBOBJ,
   OM_METH_UPD_OBJ_REF,
   OM_METH_SET_OBJ_PARENT,
   OM_METH_FIND_SUBOBJ,
   OM_METH_GET_OBJ_BY_NAME,
   OM_METH_GET_OBJ_SEQ,
   OM_METH_GET_INT_VAL,
   OM_METH_SET_INT_VAL,
   OM_METH_GET_LONG_VAL,
   OM_METH_SET_LONG_VAL,
   OM_METH_GET_REAL_VAL,
   OM_METH_SET_REAL_VAL,
   OM_METH_GET_STR_VAL,
   OM_METH_SET_STR_VAL,
   OM_METH_GET_PTR_VAL,
   OM_METH_SET_PTR_VAL,
   OM_METH_GET_FUNC_VAL,
   OM_METH_SET_FUNC_VAL,
   OM_METH_SET_ARRAY,
   OM_METH_GET_ARRAY,
   OM_METH_GET_SUB_BARRAY,
   OM_METH_GET_SUB_SARRAY,
   OM_METH_GET_SUB_IARRAY,
   OM_METH_GET_SUB_LARRAY,
   OM_METH_GET_SUB_RARRAY,
   OM_METH_GET_SUB_FARRAY,
   OM_METH_SET_OBJ_VAL,
   OM_METH_GET_OBJ_VAL,
   OM_METH_SET_OBJ_REF,
   OM_METH_GET_OBJ_PVAL,
   OM_METH_SET_OBJ_PARAMS,
   OM_METH_SET_ARRAY_VAL,
   OM_METH_SET_ARRAY_SIZE,
   OM_METH_GET_ARRAY_SIZE,
   OM_METH_GET_ARRAY_DIMS,
   OM_METH_GET_ARRAY_VAL,
   OM_METH_DEL_ARRAY_VAL,
   OM_METH_GET_IARRAY_VAL,
   OM_METH_GET_LARRAY_VAL,
   OM_METH_GET_RARRAY_VAL,
   OM_METH_SET_STR_ARRAY_VAL,
   OM_METH_GET_STR_ARRAY_VAL,
   OM_METH_SET_DATA_TYPE,
   OM_METH_GET_DATA_TYPE,
   OM_METH_GET_NUM_SUBOBJS,
   OM_METH_GET_ARRAY_SUBOBJ,
   OM_METH_SET_OBJ_PROP,
   OM_METH_GET_OBJ_PROP,
   OM_METH_SET_OBJ_IPROP,
   OM_METH_SET_OBJ_ATT,
   OM_METH_SET_OBJ_REF_MODE,
   OM_METH_GET_OBJ_REF_MODE,
   OM_METH_ADD_OBJ_REF,
   OM_METH_DEL_OBJ_REF,
   OM_METH_GET_NUM_REFS,
   OM_METH_GET_ARRAY_REF,
   OM_METH_COPY_OBJ,
   OM_METH_COPY_OBJ_TYPE,
   OM_METH_INHERIT_CLASS,
   OM_METH_IS_SUBCLASS_OF,
   OM_METH_GET_NUM_CLASSES,
   OM_METH_GET_ARRAY_CLASS,
   OM_METH_EXPAND_OBJ,
   OM_METH_INVOKE_OBJ,
   OM_METH_ADD_OBJ_NOTIFY_REQ,
   OM_METH_DEL_OBJ_NOTIFY_REQ,
   OM_METH_RESOLVE_OBJ,
   OM_METH_RESET_OBJ,
   OM_METH_VALID_OBJ,
   OM_METH_DB_TO_STRUCT,
   OM_METH_STRUCT_TO_DB,
   OM_METH_GENERATE_CODE,
   OM_METH_GEN_CODE,
   OM_METH_COMPILE_OBJ,
   OM_METH_OPEN_OBJ,
   OM_METH_CLOSE_OBJ,
   OM_METH_PUSH_OBJ_CTX,
   OM_METH_POP_OBJ_CTX,
   OM_METH_GET_SUBOBJ_LIST,
   OM_METH_RET_OBJ_PATH_TO,
   OM_METH_SET_OBJ_STATE,
   OM_METH_GET_OBJ_STATE,
   OM_METH_DEL_OBJ_REFS_TO,
   OM_METH_QUEUE_NOTIFIER,
   OM_METH_SET_SUB_BARRAY,
   OM_METH_SET_SUB_SARRAY,
   OM_METH_SET_SUB_IARRAY,
   OM_METH_SET_SUB_LARRAY,
   OM_METH_SET_SUB_FARRAY,
   OM_METH_SET_SUB_RARRAY,
   OM_METH_BSAVE_OBJ,
   OM_METH_BRESTORE_OBJ,
   OM_METH_SET_NEEDED,
   OM_METH_INSERT_OBJ_REF,
   OM_METH_GET_OBJ_TYPE,
   OM_METH_CLEANUP_OBJ_PROC_ID,
   OM_METH_SET_OBJ_TYPE,
   OM_METH_LINKS_TO,
   OM_METH_LAST_METHOD_ID		/* This used by ops that loop through
					   all of the methods... it MUST be
					   the last one in the list and
					   relies on the fact that enums start
					   at 0 and end with this value */
} OMmethod_id;

typedef enum {
   OM_DMETH_READ_DATA,
   OM_DMETH_WRITE_DATA,
   OM_DMETH_DESTROY_DATA,
   OM_DMETH_INCR_REFCNT
} OMdata_method_id;

#define OM_STAT_SUCCESS		1	/* Routine was successful 	*/
#define OM_STAT_ERROR    	-1	/* Error occurred 		*/
#define OM_STAT_UNDEF		0	/* Value is not defined 	*/
#define OM_STAT_FAILURE		0   	/* Failed return value from method */
#define OM_STAT_INVALID		-2	/* Value is not valid 	        */

/* Special status returns... */
#define OM_STAT_NOPROP		2	/* don't propagate atts to subelement */

#define OM_STAT_NO_MATCH	0	/* elements don't match */
#define OM_STAT_MATCH_UNDEF	3	/* match is not defined */

#define OM_OBJ_VAL		0
#define OM_OBJ_REF		1
#define OM_OBJ_PTR		2

#define OM_NAME_SEP_CHAR	'#'

#define OM_PATH_NO_VAL		1	/* mode to ret_obj_path_to */
#define OM_PATH_DERIVED_OBJ	2
#define OM_PATH_USER_NAME	4

/*
 * mode argument to the add_elem_ref, del_elem_ref routines to indicate
 * that we are just asking if the request will be successful.
 */
#define OM_OBJ_REF_QUERY   	1
#define OM_OBJ_REF_REPLACE	2

#define OM_DEL_OBJ_REF_DESTROY 1
#define OM_DEL_OBJ_REF_NO_EVENT 2

#define OM_DEFAULT_WEIGHT	1
#define OM_UNSET_WEIGHT		-1000

/* bit flag modes to OMadd/del_func_dep */
#define OM_DEP_AUTO		1
#define OM_DEP_DELETE_FUNC	2 	/* del_func_dep only */
#define OM_DEP_VALIDATE_FUNC	4

#define OM_SET_DEP_TO	1
#define OM_SET_DEP_FROM 2
#define OM_SET_DEP_REQ  4

#define OM_VALID_OBJ_DOWN	1
#define OM_VALID_REQ		2	/* 'req' bit must be set at each level*/
#define OM_VALID_ERROR		4	/* print out invalid info */

/* mode argument to OMdestroy_obj */
#define OM_DESTROY_CHILD	1	/* don't call OMdel_subobj in destroy*/
#define OM_DESTROY_SUBOBJ	2	/* call OMdel_subobj even if refcnt>0*/

/* mode argument to OMdel_obj_refs_to */
#define OM_DEL_OBJ_REFS_LEAVE_PATHS 1
/* Mode indicating that this del_obj_refs_to call should not cause
   a value change event... we are replacing the object with a derived
   object of the same value */
#define OM_DEL_OBJ_REFS_NO_EVENT    OM_DEL_OBJ_REF_NO_EVENT /* 2 */

#define OM_REF_TO_ARRAY_ELEMENT 1

/* options to the OMset_remote_obj routine */
#define OM_REMOTE_ADD_OBJ	1
#define OM_REMOTE_DESTROY_OBJ  2
#define OM_REMOTE_SET_PARENT	3
#define OM_REMOTE_ADD_DERIVED_OBJ 4

/* Cannot conflict with gen_code options */
#define OM_COMPILE_NO_BUILD	0x10
#define OM_COMPILE_BATCH	0x20
#define OM_COMPILE_ON		0x800
#define OM_COMPILE_APP_FILE	0x1000
#define OM_COMPILE_NO_TEMPL	0x2000
#define OM_COMPILE_BUILD_ONLY   0x4000
#ifdef MSDOS
#define OM_COMPILE_BUILD_OCX	0x8000
#define OM_COMPILE_NO_OLE	0x10000
#define OM_COMPILE_AUTOM 	0x20000
#endif
#define OM_COMPILE_SUBSET 	0x40000
#define OM_COMPILE_BUILD_PLUGIN 0x80000

#define OM_EXCXX_NONE			0
#define OM_EXCXX_ALL			1
#define OM_EXCXX_PORTS_ONLY		2
#define OM_EXCXX_ONE_LEVEL_PORTS	3
#define OM_EXCXX_MODE_MASK		3
#define OM_EXCXX_MODE(M)		((M) & OM_EXCXX_MODE_MASK)

#define OM_EXCXX_OPT_CLASS		4
#define OM_EXCXX_NO_DERIVE		8
#define OM_EXCXX_DERIVE_ONE		0x10
#define OM_EXCXX_NEEDED			0x20

#define OM_NEEDED_ON		0x1
#define OM_NEEDED_PROC_CHECK	0x2
#define OM_NEEDED_UP		0x4
#define OM_NEEDED_COMPILE	0x8
#define OM_NEEDED_DOWN		0x10
#define OM_NEEDED_COMPILE_SUB	0x20
#define OM_NEEDED_NO_PROC_CHECK 0x40

#define OM_PROJECT_TEMPLS_ONLY  0x1
#define OM_PROJECT_APP_FILE	0x2
#define OM_PROJECT_NO_BUILD	0x4
#define OM_PROJECT_NEED_NE	0x8
#define OM_PROJECT_BUILD_ONLY   0x10
#define OM_PROJECT_BATCH	0x20
#ifdef MSDOS
#define OM_PROJECT_BUILD_OCX	0x40
#define OM_PROJECT_NO_OLE	0x80
#endif
#define OM_PROJECT_SAVE_USR	0x100
#define OM_PROJECT_PLUGIN_BUILD 0x200

#define OM_INIT_LOAD_TEMPL	0x1
#define OM_INIT_LOAD_INST	0x2
#define OM_INIT_LOAD_APPL	0x4

/*
 * Flags arguments to function arg call in OMget_ports
 */
#define OM_PORT_INPUT 	 	1
#define OM_PORT_OUTPUT  	2
#define OM_PORT_EXPORTED 	4

/* Flag to OMget_port_list/OMget_ports function */
#define OM_PORTS_NO_TOP_LEVEL	1	/* skip top-level object in port list */
#define OM_PORTS_ON		2	/* export_all = 1 by default */
#define OM_PORTS_EXPORTED	4	/* stop at exported groups... */
#define OM_PORTS_RW		8	/* get port ids RW */
#define OM_PORTS_CHECK_NE	0x10	/* Use NEnumSubports property */

/*
 * mode argument to the OMgen_code routine... this call comes from a dep
 * rather than coming from the parent element
 */
#define OM_GEN_CODE_FROM_DEP 1
/*
 * We only generate code for objects with the "needed" attribute set.
 */
#define OM_GEN_CODE_NEEDED_OBJS 2

/*
 * Argument to the OMset_array_val call.  if this argument is supplied
 * in place of the index, we append onto the array instead of setting it.
 */
#define OM_ARRAY_APPEND		-666
/* an array dimension that is "unspecified" */
#define OM_DIM_UNSPEC		-333

/* mode arg to the find and get_array_val routines */
#define OM_OBJ_RW		0
#define OM_OBJ_RD		1

/* arguments to check the mode to find, get_array_val, etc. */
#define OM_OBJ_IS_RW(M)	(!((M) & OM_OBJ_RD))
#define OM_OBJ_IS_RD(M)	((M) & OM_OBJ_RD)

/* this does not conflict with SUB_ or ELEM_ modes */
#define OM_REF_SYMBOLIC		0x800
#define OM_REF_MODE(M)		((M) & OM_REF_SYMBOLIC)

/* used for group set_obj_ref to allow group copy to work when val_ref = 0 */
#define OM_REF_SUB_VALUE	0x10000

/*
 * this does not conflict with SUB_ or ELEM_ or REF_ modes
 * it is currently only passed to the get_obj_pval routine restricting
 * it to only return a program or user state value
 */
#define OM_VAL_PRG		0x1000
#define OM_VAL_USR		0x2000

/* values for the mode argument to set_elem_val */
#define OM_OBJ_VAL_REF_MODE	0x1
/* value to the set_elem_val and set_elem_ref routines */
#define OM_OBJ_REF_RDONLY	0x2
#define OM_OBJ_VAL_NULL_OK	0x4
#define OM_OBJ_REF_NO_MATCH	0x8

/* return values from OMcheck_license routine */
#define OM_LIC_NO_USE		1
#define OM_LIC_NO_EDIT		2

/* modes to OMget_str_val_mode, OMget_str_array_val_mode */
#define OM_STR_NO_I18N	1

/*
 * These flags can't conflict with either ELEM flags or SUB flags.
 */
/*
 * This flag is OR'd into the mode argument of the find_subelem argument
 * to suppress the retrieval of virtual data.
 */
#define OM_FIND_NO_VIRTUAL	0x4
/*
 * This flag is OR'd into the mode argument of the find_elem command (or
 * find_subelem) to suppress the propagation through libraries.  If you
 * are looking up something that is an instance, it would make more sense
 * to use this flag.
 */
#define OM_FIND_NO_LIBRARIES	0x8
/*
 * This flag is used by libraries to know that they should not try to
 * load any new types to try and process this request.
 */
#define OM_FIND_EXISTING_TYPE	0x10

/*
 * If this element is a derived group, use the type we are derived from
 * to do the find and return this element.
 */
#define OM_FIND_DERIVED_SUBOBJ	0x20

#define OM_FIND_SKIP_EQUAL_PATHS 0x40

/* Allow finding subobjects of objects with reference mode = pointer */
#define OM_FIND_SUB_PTRS	0x80

/*
 * Mode arguments to the upd_subelem and upd_elem_ref routines.  They
 * allow a parent or a pointer element to be notified when some attribute
 * of a sub-element or reference are changed.
 */
#define OM_UPD_NAME		1
#define OM_UPD_PARENT		2
#define OM_UPD_TYPE		4
#define OM_UPD_BUFFER		8

/*
 * Mode arguments to OMget_ref_to_list
 */
#define OM_REF_TO_SOURCE	1	/* trace back to refs without refs to */
#define OM_REF_TO_VALUE		2	/* return the "raw" list of refs */

/*
 * Mode arguments to OMset_obj_state
 */
#define OM_SET_STATE_VAL	1	/* set the value state */
#define OM_SET_STATE_OR		2	/* or in the state values */

/* Used for OMget_num_subobjs, OMget_array_subobj, OMmatch_subobj,
   OMfind_subobj, OMcopy_obj, OMcreate_obj_mode, OMinsert_subobj,
   OMdel_subobj */
#define OM_SUB_TEMPL		0x100
/* Used only for OMfind_subobj */
#define OM_SUB_NO_COPY_ON_RD	0x200

/*
 * Used for OMfind_subobj, OMget_obj_pval
 */
#define OM_SUB_TYPE_CHECK	0x400
/*
 * Used for OMfind_subobj
 */
#define OM_SUB_COPY_OBJ		0x4000/* force a copy but leave unmod bit set*/
/*
 * Used for OMget_array_subobj which by default, does not honor the copy_on_rd
 * bit.  If this flag is set, we do.
 */
#define OM_SUB_COPY_ON_RD	0x8000
/*
 * Used for OMinsert_subobj, and OMfind_subobj
 */
#define OM_SUB_REF_CHILD	0x10000
/*
 * Used for OMfind_subobj, OMget_array_subobj, OMget_num_subobjs
 */
#define OM_SUB_NO_REF_CHILD	0x20000
/*
 * Used for OMget_array_subobj, OMget_num_subobjs - get subobj list as
 * displayed in the NE.  For merge objects this shows the subobjects of
 * the merge's value, not the args to the merge
 */
#define OM_SUB_SYMBOLIC		0x40000
/* This macro is used to propagate SUB flags to another routine */
#define OM_SUB_FLAGS(M)		((M) & (OM_SUB_TEMPL|OM_SUB_TYPE_CHECK))

/* This flag is used by groups as flag to insert_subobj/copy_obj_base */
#define OM_SUB_DERIVED_OBJ	0x800000
#define OM_SUB_EXISTING_TYPE	0x1000000

/*
 * Flag for the del/insert subobj routine to prevent parent from being set
 * cannot conflict with COPY modes or other SUB modes
 */
#define OM_SUB_OBJ_NO_PARENT	0x4000000

/* Flag for del_subobj - delete this subobject, but continue to inherit...*/
#define OM_DEL_SUB_REDUCE	0x2

/* flag to insert_subobj that prevents sorting of sorted groups  */
#define OM_SUB_NO_SORT	0x4

/* Flag for OMget_num_subobjs to not open buffered objects.. don't
   conflict with sub-flags above */
#define OM_SUB_OBJ_OPEN_BUFFER  0x1  /* Open any buffered objects */
#define OM_SUB_OBJ_OPEN_VBUFFER	0x2  /* Open only non-ascii buffers */


/* Find out if the TEMPL flag is set */
#define OM_SUB_IS_TEMPL(M)	((M) & OM_SUB_TEMPL)

#define OM_EVENT_VAL		0x1	/* value has changed  	  */
#define OM_EVENT_ADD_SUBOBJ	0x2	/* subobject inserted	  */
#define OM_EVENT_DEL_SUBOBJ	0x4	/* subobject deleted      */
#define OM_EVENT_INST		0x8	/* object instanced       */
#define OM_EVENT_PATH_CHANGED	0x10	/* object removed from hierarchy */
#define OM_EVENT_DEL		0x20	/* object destroyed (refcnt = 0) */
#define OM_EVENT_PROP		0x40	/* property changed on object */

#define OM_EVENT_INVOKE_E	0x100	/* method has finished running */

#define OM_EVENT_ADD_REF_TO	0x400	/* reference added to object 	*/
#define OM_EVENT_DEL_REF_TO	0x800	/* reference deleted from object */
#define OM_EVENT_ADD_REF_FR	0x1000	/* reference added from object   */
#define OM_EVENT_DEL_REF_FR	0x2000	/* reference deleted from object */
#define OM_EVENT_DEINST		0x4000	/* object is deinstanced         */
#define OM_EVENT_NAME		0x8000  /* object's name changed         */
#define OM_EVENT_ANY		0x10000 /* continue propagating events   */
#define OM_EVENT_WRITE		0x20000 /* method writes this object     */
#define OM_EVENT_READ		0x40000 /* method reads this object      */
#define OM_EVENT_REQ		0x80000 /* method requires obj to be valid */
#define OM_EVENT_NEEDS_INST	0x100000 /* method needs obj to be inst */
#define OM_EVENT_TYPE_CHANGED   0x200000 /* objects type info has changed */
#define OM_EVENT_PORTS_CHANGED  0x400000 /* objects port info has changed */

#define OM_EVENT_REF_TO		(OM_EVENT_ADD_REF_TO | OM_EVENT_DEL_REF_TO)
#define OM_EVENT_REF_FR		(OM_EVENT_ADD_REF_FR | OM_EVENT_DEL_REF_FR)
#define OM_EVENT_REF		(OM_EVENT_REF_TO | OM_EVENT_REF_FR)

#define OM_IMM_EVENTS \
	 (OM_EVENT_DEL | OM_EVENT_INVOKE_E | OM_EVENT_DEL_SUBOBJ)

#define OM_NOPROP_EVENTS \
	 (OM_EVENT_DEL | OM_EVENT_INST | OM_EVENT_ADD_SUBOBJ |      \
	  OM_EVENT_DEL_SUBOBJ | OM_EVENT_PROP | \
          OM_EVENT_INVOKE_E | OM_EVENT_DEINST | \
	  OM_EVENT_NAME | OM_EVENT_NEEDS_INST | OM_EVENT_TYPE_CHANGED | \
	  OM_EVENT_PORTS_CHANGED)

/*
 * This is the set of events that must force read-write element mode when
 * we get the element out to add the notification request.  Other events
 * must be preceeded by a request that will specify read-write mode.
 */
#define OM_RW_EVENTS (OM_EVENT_DEL | OM_EVENT_INST | OM_EVENT_DEINST)

/*
 * These are events that we test for validity before executing...
 */
#define OM_VALID_EVENTS (OM_EVENT_VAL | OM_EVENT_INST)

/* arguments to OMset_sub_event_mask */
#define OM_SUB_EVENT_NO_VAL	0x1
#define OM_SUB_EVENT_NO_REQ	0x2

#define OM_NOTIFY_SUBOBJS	0x1
#define OM_NOTIFY_NO_SUBOBJS	0x2  	/* force sub-elements to not notify */
#define OM_NOTIFY_IMM		0x4	/* don't q the events...*/
#define OM_NOTIFY_ROOT_CTX	0x8	/* always queue events in root ctx */
#define OM_NOTIFY_NO_ARRVAL	0x10    /* don't prop notify to array vals */
#define OM_NOTIFY_INACTIVE	0x20
/*
 * event has been propagated up the hierarchy with a new template... used
 * so that this notification can be differentiated from the previous ones
 * on the same objects without having to compare the templates.
 */
#define OM_NOTIFY_PROPAGATED	0x40
#define OM_NOTIFY_NOQUEUE	0x80
#define OM_NOTIFY_INTERRUPT	0x100
#define OM_NOTIFY_DIMS_UPDATE	0x200
#define OM_NOTIFY_REFCNT   	0x400
#define OM_NOTIFY_STATUS	0x800
#define OM_NOTIFY_QUEUE_SELF	0x1000 /* allow us to queue methods for us */

/*
 * flags for the "event_mode" and "child_mode" arguments to OMpush_ctx.
 * If these flags are passed in the "event_mode" argument, they affect this
 * context.  If they are passed in the "child_mode" arguments, they affect
 * all subsequent contexts.
 */
#define OM_CTX_PARENT_NOTIFIES	0x1	/* do not execute events in this ctx */
#define OM_CTX_ALL_NOTIFIES	0x2	/* don't suppress events based on ctx */
#define OM_CTX_ALL_EVENTS OM_CTX_ALL_NOTIFIES /* compatibility with old stuff */
#define OM_CTX_TOSS_NOTIFIES	0x4	/* suppress all events in this ctx */
#define OM_CTX_INHERIT_STATE_MODE 0x8   /* inherit the state mode of cur ctx */
#define OM_CTX_BEGIN_OP		0x10
#define OM_CTX_NO_INHERIT_EVENT_MODE 0x20 /* don't inherit child event mode */

#define OM_FLUSH_ROOT_CTX	0x1	/* mode flag for flush_notifies */

/* flags for the "state_mode" argument to push_ctx. */
#define OM_STATE_USR		0x1
#define OM_STATE_PRG		0x2
#define OM_STATE_PROG		OM_STATE_PRG	/* older version of same thing*/
#define OM_STATE_TRANSIENT	0x4
#define OM_STATE_VOLATILE	OM_STATE_TRANSIENT  /* new term, same thing */

#define OM_SEQ_SUBOBJS		0x1
#define OM_SEQ_PTRS		0x2
#define OM_SEQ_VAL		(OM_SEQ_SUBOBJS|OM_SEQ_PTRS)

/* values for the get_array function */
#define OM_GET_ARRAY_RD		0  	/* get most efficient read-only copy */
#define OM_GET_ARRAY_WR		1	/* get most efficient write-only copy*/
#define OM_GET_ARRAY_RW		2	/* get most efficient read-write copy*/
#define OM_GET_ARRAY_RD_COPY	3	/* get a read-only version that I
					   can modify */
/* Mode to indicate not to do an update (internal use) */
#define OM_GET_ARRAY_NO_UPDATE  0x80

/* values for the set_array function */
#define OM_SET_ARRAY_COPY	0
#define OM_SET_ARRAY_FREE	1
#define OM_SET_ARRAY_STATIC	2

/* Flags used in the mode call - OR these together */
#define OM_MATCH_POSS	    0x0  /* do a "possible" match   */
#define OM_MATCH_EXACT	    0x1  /* do an "exact" match     */
#define OM_MATCH_STRUCT	    0x2  /* do a "structural" match */
#define OM_MATCH_ARRAY	    0x4  /* array matching a scalar */

#define OM_MATCH_BACKWARD   0x8  /* used by links to prevent loops in match */

/* The value of the elem1 will be replaced during the match */
#define OM_MATCH_REPL_VAL   0x10

#define OM_MATCH_NO_ERROR   0x20 /* suppress errors during the match operation*/
#define OM_MATCH_REQ	    0x40 /* Only match the 'req' objects */
#define OM_MATCH_PROPS	    0x80
/*
 * do not conflict with OM_SUB_TEMPL, OM_SUB_NO_TYPE_CHECK
 */
#define OM_MATCH_SCALAR	    0x400 /* scalar matching array */


#define OM_MATCH_SUBOBJ_FLAGS(M)  \
  ((M) & (OM_MATCH_EXACT | OM_MATCH_STRUCT | OM_MATCH_REQ | OM_MATCH_PROPS))

/* Macros to test the mode flag for the match call */
#define OM_MATCH_IS_POSS(M)	(!((M) & OM_MATCH_EXACT))
/*
 * We always want struct match to match exactly
 */
#define OM_MATCH_IS_EXACT(M)	((M) & (OM_MATCH_EXACT | OM_MATCH_STRUCT))
#define OM_MATCH_IS_VAL(M)	(!((M) & OM_MATCH_STRUCT))
#define OM_MATCH_IS_STRUCT(M)	((M) & OM_MATCH_STRUCT)
#define OM_MATCH_IS_ARRAY(M)	((M) & OM_MATCH_ARRAY)
#define OM_MATCH_IS_REPL_VAL(M)	((M) & OM_MATCH_REPL_VAL)

/* mode argument to the OMoverlap_obj routine */
#define OM_OVERLAP_RDWR		1

#define OM_SAVE_VAL  	1 /* Values for the "mode" for OMsave_obj */

/*
 * OM_SAVE_ALL is used by the print command to override the "nosave"
 * option (i.e. show me everything that I ask for)
 *
 * OM_SAVE_DBG is used to print out even stuff that ordinarily isn't saved
 * as part of the save option
 *
 * OM_SAVE_USR is used to save out both user and program state.
 *
 * OM_SAVE_PRG is used to save out program state only.
 */
#define OM_SAVE_ALL      	0x2
#define OM_SAVE_DBG		0x4
#define OM_SAVE_USR		0x8
#define OM_SAVE_PRG		0x10

/* Save the element with a reference to the element */
#define OM_SAVE_REF		0x20

/* This element is being saved as a sub-element */
#define OM_SAVE_SUB		0x80

/* Save character strings with 8 bit encodings... */
#define OM_SAVE_8BIT		0x100

#define OM_SAVE_PARAMS		0x200
#define OM_SAVE_NEWLINE		0x400
#define OM_SAVE_LINE_FEED	0x800
#define OM_SAVE_NO_NEW_LINES	0x1000


/* should not overlap with OM_SAVE_PRG or OM_SAVE_USR */
#define OM_BSAVE_COMPLETE	0x200 /* include defs of unsaved derived objs */
#define OM_BSAVE_NEEDED_OBJS	0x400 /* save those marked with 'needed' */
#define OM_BSAVE_OPEN_OBJS	0x800 /* open objects as we save them    */
#define OM_BSAVE_TEMPLS_ONLY	0x1000 /* only save templates... */
#define OM_BSAVE_NO_PARENT	0x2000 /* didn't save the parent */
#define OM_BSAVE_SUB_HEAP	0x4000
#define OM_BSAVE_NO_SUBOBJS	0x8000 /* don't save subobjects */
#define OM_BSAVE_ACTIVE		0x10000 /* allow bsaving of active objects */
#define OM_BSAVE_STRIP_NE	0x20000 /* strip NE properties when saving */

#define OM_BRESTORE_ACTIVE	0x1   /* internal flag for brestore function */
#define OM_BRESTORE_NEEDED_OBJS	0x2   /* internal flag */
#define OM_BRESTORE_UNEDITABLE  0x4   /* used to make restore objs uneditable*/

/*
 * Restore into parent id instead of as a subobject of parent_id
 */
#define OM_BRESTORE_OBJ		0x8
#define OM_BRESTORE_ADD_SUBOBJ  0x10  /* internal flag */
#define OM_BRESTORE_LOC_TEMPL	0x20  /* restore templs into OMloc_templ_obj */
#define OM_BRESTORE_NO_PROCS	0x40  /* don't restore processes */
#define OM_BRESTORE_MERGE	0x80  /* merge description into parent_id */

/* Binary V file blocks are only aligned to 4 byte boundaries... */
#define OM_BINV_ALIGN 	8

/* return values to the routine OMbfile_identify */
#define OM_BFILE_NORM		0x1
#define OM_BFILE_COMPLETE	0x2
#define OM_BFILE_UNKNOWN	0x0

/*
 * Return value for OMsave_obj with OM_SAVE_VAL mode indicating that
 * value is to be saved by reference.
 */
#define OM_STAT_BYREF		2

/* values for the OMwrite_obj mode or'd with above */
#define OM_WRITE_APPEND 0x40

#define OM_WRITE_GEN_HDR 0x1000

/* Values for the mode argument to OMread_desc and OMparse_stream */
#define OM_READ_REPLACE	0  /* replace existing elements */
#define OM_READ_MERGE	1  /* merge description with existing description */
#define OM_READ_UNIQ    2  /* create unique element names for duplicates */
#define OM_READ_NODUP   3  /* cause error when a duplicate occurs */
#define OM_READ_MMAX	4
#define OM_READ_MBITS   0x7

/* Macros to read the mode argument for read/parse */
#define OM_READ_IS_REPLACE(M)	(((M) & OM_READ_MBITS) == OM_READ_REPLACE)
#define OM_READ_IS_MERGE(M)	(((M) & OM_READ_MBITS) == OM_READ_MERGE)
#define OM_READ_IS_UNIQ(M)	(((M) & OM_READ_MBITS) == OM_READ_UNIQ)
#define OM_READ_IS_NODUP(M)	(((M) & OM_READ_NODUP) == OM_READ_NODUP)

/* Macros to set the mode for the read/parse functions */
#define OM_READ_SUBOBJ  0x0
#define OM_READ_OBJ     0x10
#define OM_READ_BUFFERED  0x20
#define OM_READ_ONE_OBJ   0x40
/* Always should imply reading one object */
#define OM_READ_OBJ_HDR_ONLY 0x80

#define OM_READ_SBITS	(OM_READ_OBJ | OM_READ_NO_SUBOBJ)

/* Macros to interpret the mode for the read/parse functions */
#define OM_READ_IS_OBJ(M)	((M) & (OM_READ_OBJ | OM_READ_OBJ_HDR_ONLY))
#define OM_READ_IS_SUBOBJ(M)	(!((M) & OM_READ_SBITS))

#define OM_READ_FILE_DERIVED	0x1
#define OM_READ_FILE_NO_SUBOBJ  0x2

/* flags for the "mode" argument to the OMcopy_obj routine */
#define OM_COPY_VIRT_OBJ 	0x1
#define OM_COPY_ACTIVE_PARENT	0x2   /* parent arg is null but it is active */
#define OM_COPY_CLOSE		0x4
#define OM_COPY_DERIVED_OBJ    0x8
#define OM_COPY_NOT_DERIVED	0x10 /* Do not make "derived" copies */
#define OM_COPY_SUB_OBJ		0x20 /* Copying a sub-object */
#define OM_COPY_STATE		0x40 /* copy the state of the object */
#define OM_COPY_SEQ		0x80

/* Values for the COPY and MERGE routines */
#define OM_COPY_STATE_USR	0x100  /* copy only usr state     */
#define OM_COPY_STATE_PRG	0x200  /* copy only program state */

#define OM_COPY_BUFFERED	0x400
#define OM_COPY_STATE_TRANSIENT 0x800

#define OM_COPY_STATE_FLAGS(F)  ((F) & (OM_COPY_STATE_USR | OM_COPY_STATE_PRG))

/* flags for the "mode" argument to the OMmerge_obj routine */
#define OM_MERGE_NO_VAL		1
#define OM_MERGE_UNMERGE_OBJ	2
#define OM_MERGE_DERIVED_OBJ    OM_COPY_DERIVED_OBJ
#define OM_MERGE_NOT_DERIVED	OM_COPY_NOT_DERIVED
#define OM_MERGE_NO_TYPES	0x1000

#define OM_ARRAY_MAXDIM 4

/* modes to the OMget_obj_type_mode routine */
#define OM_OBJ_TYPE_RAW	1

/*
 * mode argument to get_elem_prop...true if we don't follow pointers or
 * if we shouldn't follow references to this element to get the property
 * If NO_TYPES is set, we only look at properties explicitly defined for
 * this element (i.e. not inherited from any derived types)
 */
#define OM_PROP_NO_PTRS		0x1
#define OM_PROP_NO_REFS		0x2
#define OM_PROP_NO_TYPES	0x4
#define OM_PROP_NO_METHS	0x8
#define OM_PROP_EQUAL_PATHS	0x10
#define OM_PROP_NO_BASE_TYPES	0x20


/* modes to the function associated with a property in OMcreate_prop */
#define OM_PROP_NEW_VAL		1
#define OM_PROP_NEW_OBJ	2
#define OM_PROP_DELETED		3

/* mode to the OMcopy_props function */
#define OM_COPY_PROPS_INHERITED	0x1


/*
 * mode argument to the OMget_num_classes/OMget_array_class routines
 * to following this through link objects.
 *
 * don't conflict with OBJ_RD and OBJ_RW flags.
 */
#define OM_CLASS_FOLLOW_REFS	0x4
#define OM_CLASS_SKIP_EQUAL_PATHS 0x8
#define OM_CLASS_EQUAL_PATHS_ONLY 0x10

/*
 * flag to OMresolve_obj to indicate that you need to revalidate name
 * references as something may have changed to invalidate a name ref.
 */
#define OM_RESOLVE_NAME_CHECK	0x1
/*
 * For the resolve process to occur, even if the element is not marked
 * as "unresolved"
 */
#define OM_RESOLVE_FORCE	0x2
/*
 * Or'd in with the above flag to cause name-elements to update their value
 */
#define OM_RESOLVE_NAME_UPDATE  0x4
#define OM_RESOLVE_BACKWARD	0x8
/*
 * Break any unresolved connections during the unresolve operation
 */
#define OM_RESOLVE_BREAK_UNRES  0x10

/*
 * Resolve the object and repair the superclasses that might have been
 * deleted
 */
#define OM_RESOLVE_REPAIR	0x20

#define OM_RESOLVE_OPEN		0x40
/* Set when we are resolving the parent object */
#define OM_RESOLVE_SUB		0x80
#define OM_RESOLVE_CULL		0x100
#define OM_RESOLVE_COMPILE	0x200


/* Want to be able to use the COMMdata_sizes array so make these the same */
#define OM_TYPE_CHAR	DTYPE_CHAR
#define OM_TYPE_BYTE	DTYPE_BYTE
#define OM_TYPE_SHORT	DTYPE_SHORT
#define OM_TYPE_INT	DTYPE_INT
#define OM_TYPE_LONG	DTYPE_LONG
#define OM_TYPE_FLOAT	DTYPE_FLOAT
#define OM_TYPE_DOUBLE	DTYPE_DOUBLE
#define OM_TYPE_PTR 	DTYPE_PTR
#define OM_TYPE_STRING  DTYPE_STRING
#define OM_TYPE_GROUP	DTYPE_GROUP
#define OM_TYPE_UNSET	DNTYPES+1

/* Definitions used in generate_code */
#define OM_TYPE_MASK		0x0ffff

#define OM_TYPE_CPTR		0x10000
#define OM_TYPE_CPTR_LIST	0x20000

/* Definitions for the stages of generating code */
#define OM_BITMASK_STAGE	1
#define OM_FUNC_STRUCT_STAGE	2
#define OM_PROTO_STAGE		3
#define OM_DESC_TABLES_STAGE	4
#define OM_PTR_TABLES_STAGE	5
#define OM_FUNC_TABLES_STAGE	6
#define OM_WRAPPER_FUNC_STAGE	7

/* Definitions to define element attributes */
#define OM_NATT_BITS (int)(8 * sizeof(unsigned int)) /* 64-bit porting . casted to int as OM_NATT_BITS is a small value */
#define OM_ATTS_SIZE 1
#define OM_NUM_ATTS (OM_NATT_BITS * OM_ATTS_SIZE)
typedef	struct _OMatts {
	unsigned int a[OM_ATTS_SIZE];
} OMatts;

#define OM_GET_OBJ_ATTS(E,A) \
   (OMis_local_obj(E) ? (E).elem_id->atts.a[0] & (A).a[0] :  \
			  OMget_obj_atts(E,A))

#define OM_ATTS_AND(RES,A1,A2)	(RES).a[0] = (A1).a[0] & A2.a[0]
#define OM_ATTS_OR(RES,A1,A2)	(RES).a[0] = (A1).a[0] | A2.a[0]
#define OM_ATTS_NOT(RES,A)	(RES).a[0] = ~(A).a[0]
#define OM_ATTS_SET(RES,A)	(RES).a[0] |= A.a[0]
#define OM_ATTS_CLR(RES,A)	(RES).a[0] &= ~A.a[0]
#define OM_ATTS_ARE_SET(RES,A)	((RES).a[0] & A.a[0])
#define OM_ATTS_ZERO(RES)	(RES).a[0] = 0

/* Macros that allow an element writer to access the attribute structure */
#define OM_ATT_SET(ATT,A) \
	(ATT).a[(A) / OM_NATT_BITS] |= (1 << ((A) % OM_NATT_BITS))
#define OM_ATT_CLR(ATT,A) \
	(ATT).a[(A) / OM_NATT_BITS] &= ~(1 << ((A) % OM_NATT_BITS))
#define OM_ATT_IS_SET(ATT,A) \
	((ATT).a[(A) / OM_NATT_BITS] & (1 << ((A) % OM_NATT_BITS)))

#define OM_OBJ_ATT_SET(E,A) OM_ATT_SET((E)->atts,A)
#define OM_OBJ_ATT_CLR(E,A) OM_ATT_CLR((E)->atts,A)
#define OM_OBJ_ATT_IS_SET(E,A) OM_ATT_IS_SET((E)->atts,A)

#define OM_VERBOSE_FUNC 	0x1
#define OM_VERBOSE_EVENT 	0x2
#define OM_VERBOSE_CTX		0x4
#define OM_VERBOSE_FILES	0x8
/* type checking is relatively expensive so turn it on with a debug flag */
#define OM_VERBOSE_TYPE_CHECK	0x10
#define OM_VERBOSE_LIB		0x20
#define OM_VERBOSE_PATHS	0x40
#define OM_VERBOSE_LINES	0x80
#define OM_VERBOSE_PROCS	0x100
#define OM_VERBOSE_ALL_EVENT    0x200	/* includes NE events */
#define OM_VERBOSE_ALL_FUNC	0x400 	/* includes NE functions */
#define OM_VERBOSE_RPC		0x800
#define OM_VERBOSE_TIME		0x1000
#define OM_VERBOSE_MEMORY 	0x2000
#define OM_VERBOSE_BUFFER	0x4000
#define OM_VERBOSE_WIDE		0x8000

#define OM_PATH		0
#define OM_VPATH	1
#define OM_BINPATH	2
#define OM_DATAPATH	3
#define OM_BUILDPATH	4
#define OM_RUNTIMEPATH  5
#define OM_NUM_PATHS    6  /* must be last */

#define OM_VCP_DEFAULT	0
#define OM_VCP_SUPPRESS 1
#define OM_VCP_PRESENT  2

/*
 * This defines the "standard" size for sub-array buffers that all
 * routines define.  They should deal with sub-arrays that are larger
 * than this, but perhaps optimize a case where malloc is not necessary
 * if the sub-array is smaller than this buffer.
 *
 * A get_array function will break up the array into chunks small enough
 * to fit into this buffer (if possible)
 */
#ifdef MSDOS
#define OM_SUB_ARRAY_BUF_SIZE	4096
#else
#define OM_SUB_ARRAY_BUF_SIZE	32768
#endif

typedef struct _OMobj *OMobj_id_type;

typedef int OMsys_process_id;

/*
 * This structure contains the information necessary to reference an element
 * from a process.  The proc id is a "global" system process id that
 * tells you what process contains the data.  If you don't already have
 * a connection to that process, you can get one from that id.
 *
 * The elem_id part is a 32 bit reference to the element from within
 * a process.  Right now it is actually a pointer to the element but it
 * could easily be changed to have a hash table or some other way to
 * perform this mapping on systems that can't map directly from an int
 * to a pointer.
 */
typedef struct _OMobj_id {
   OMobj_id_type elem_id;
   OMproc_id	 proc_id;
} OMobj_id;

typedef struct _OMloc_id {
   OMobj_id_type elem_id;
} OMloc_id;

#define OMmap_loc_to_obj(LOC,OBJ) \
   ((OBJ).elem_id = (LOC).elem_id, (OBJ).proc_id = OMlocal_proc_id, OBJ)

#define OMassign_loc_to_obj(OBJ,LOC) \
   ((OBJ).elem_id = (LOC).elem_id, (OBJ).proc_id = OMlocal_proc_id)

#define OMassign_obj_to_loc(LOC,OBJ) \
   ((LOC).elem_id = (OBJ).elem_id)

/* Used to store a list of element references */
typedef struct _OMobj_ref {
   OMobj_id    elem;
   unsigned int nofree:1;
   unsigned int ref_flag:1; /* flag used by ref's... specific to use */
   unsigned int ref_flag2:1;  /* another one */
   unsigned int ref_flag3:1;
   struct _OMobj_ref *next;
} OMobj_ref;

typedef unsigned int OMevent_mask;

/* Used to store a list of element references */
typedef struct _OMnotify_ref {
   OMobj_id    notifier;	/* Id of notifier object 	   */
   OMobj_id    templ;		/* Template id of this notifier    */
   unsigned int	mode:24;	/* Only needs a few bits...	   */
   unsigned int pending:1;
   int		refcnt;		/* ref cnt of identical refs 	   */
   struct _OMnotify_ref *next;
   OMevent_mask event_mask;
#ifdef OM_NOTIFY_DEBUG
   char func_path[256];
#endif
} OMnotify_ref;

typedef unsigned int OMobj_name;

typedef struct _OMprop {
   OMobj_id value;
   OMobj_name name;
   unsigned int nofree:1;
   struct _OMprop *next;
} OMprop;

typedef struct _OMmodify_list {
   OMobj_id func_id;
   OMobj_id templ_id;
   unsigned int write_mode:1;
} OMmodify_list;

typedef struct _OMobj_list_ref {
   OMobj_id obj_id;
   OMobj_name name;
} OMobj_list_ref;

typedef struct _OMobj_list {
   int refcnt;
   xp_long num_subs;
   OMobj_list_ref *sub_list;
} OMobj_list;

/*
 * This stuff is for storing info about an user c struct.
 */
#define OM_CSTRUCT_OFFSET(Type, Sub)	\
	((xp_ulong) &((Type *) 0)->Sub)

typedef struct _OMcstruct_ptrs {
    const char *var_name;		/* Name of struct elem */
    OMobj_name elem_name;		/* Quick handle for database */
    int type;				/* Type of elem */
    int size;				/* # of elems if an array, else 0 */
    int seq_type;			/* Type of sequence num check */
    unsigned long struct_offset;	/* Offset to elem in struct */
} OMcstruct_ptrs;

typedef struct _OMcstruct_desc OMcstruct_desc;	/* Descriptor for sub group */

typedef struct _OMcstruct_subs {
    OMcstruct_desc *desc;	        /* Descriptor for sub group */
    unsigned int bitmask_offset;	/* Offset into bitmask for sub group */
} OMcstruct_subs;

struct _OMcstruct_desc {
    int struct_size;
    int bitmask_size;
    OMptr (*constructor) (OMobj_id);
    OMpfi destructor;
    int num_ptrs;
    struct _OMcstruct_ptrs *ptrs;
    struct _OMcstruct_subs *subs;
};

typedef struct _OMdata_id {
    char name[64];
    int (*read_data) (void *conn, void **val, int);
    int (*write_data) (void *conn, void *val, int);
    int (*destroy_data) (void *val);
    int (*incr_refcnt) (void *val);
    struct _OMdata_id *next;
} OMdata_type, *OMdata_id;

/*
 * Structures for compiling a process
 */

#define OM_LANG_C	0
#define OM_LANG_CXX	1
#define OM_LANG_FORTRAN 2
#define OM_NUM_LANGS	3

typedef struct _OMlang {
   const char *prefix;
   int lang_type;
   const char *pre_inc, *post_inc;
   const char *src_suffix;
} OMlang;


#ifdef OM_DEFINE_GLOBALS
OMlang OM_langs[OM_NUM_LANGS] =
   {{"c", OM_LANG_C, "#include \"", "\"\n", ".c"},
    {"cxx", OM_LANG_CXX, "#ifdef __cplusplus\n#include \"", "\"\n#endif\n",
     ".cxx"},
     {"f", OM_LANG_FORTRAN, NULL, NULL, ".f"}};
#else
OM_EXTERN OMlang OM_langs[OM_NUM_LANGS];
#endif

/*
 * For each language, we have a current set of include files and
 * a set of source files.
 */
typedef struct _OMcomp_lang {
   int lang_type;	/* id of this language: OM_LANG_C, etc. */

   char **src_files;	/* list of src files for this language (cxx_src_files)*/
   int 	num_src_files;
} OMcomp_lang;

/*
 * When generating a process, we need to output a stream of data to manage
 * the current out_src_file and out_hdr_file.  This structure stores all
 * of this information.
 */
typedef struct _OMcomp_strm {
   IOstream *stream;
   char *name;		/* name of the out_xxx_file */
   int is_c;		/* are we currently using a C or C++ file */
   unsigned int need_cxx:1;  /* does this file need C++ yet?   */
   /*
    * Is this file <process>.h and therefore should we generate it
    * conditionally based on the state of the needed bit?  If this
    * file is included by other code, we have to generate it consistently
    * even if some of the object's defined in the header file are not
    * turned on.  This is because C++ header files leave turd references
    * if they are included, but classes are not referenced
    */
   unsigned int proc_relative:1;
   /*
    * name for the Init function for this src file
    */
   char init_name[256];
   /*
    * the index in to XP_BUILDPATH where this source file was found
    */
   int path_index;
} OMcomp_strm;

/*
 * This is the main data structure used internally for the process compile
 * operation.  It stores all information needed to generate the wrapper
 * code, makefiles, etc. for a process
 */
typedef struct _OMcomp_proc {
   OMobj_name proc_name;	/* process name 	*/
   char **link_files;		/* list of link files for this process */
   int 	num_link_files;

   char *init_code;		/* current pending buffer of init code  */
   int 	init_code_sz;
   int init_need_cxx;		/* is any init code C++ code in this buffer? */

   char *pre_init_code;		/* current pre_init_code buffer		 */
   int 	pre_init_code_sz;

   int link_need_cxx;		/* do we need to link with C++ for this proc? */
   int link_need_f;		/* do we need to link with F77 for this proc? */

   OMcomp_strm src;		/* current out_src_file stream of info...    */
   OMcomp_strm hdr;		/* current out_hdr_file stream of info...    */

   IOstream *cxx_src_stream;    /* current c++ src stream               */
   /*
    * Always points to <process.h> even when out_hdr_file has been specified
    */
   IOstream *init_hdr_stream;

   char *cur_src_file;		/* name of current src_file property...  */
   unsigned int src_set:1;	/* is src_file set?		         */
   unsigned int no_main:1;	/* has no_main=1 property been set?      */
   unsigned int in_dll:1;	/* has in_dll=1 property been set?       */

   int num_cur_funcs;		/* list of functions defined in cur_src_file*/
   char **cur_func_list;

   OMcomp_lang langs[OM_NUM_LANGS]; /* list of language specific info... */

   int num_named_things;	/* list of named things OMadd_named_... */
   char **named_names;

   IOstream *make_stream;	/* current make stream 		*/
   char *make_rule_buf;		/* buffer of rules to make by default */
   char *inc_dirs_buf;		/* list of include directories for this proc */

   int is_needed;		/* current state of is_needed attribute */

   int num_cxx_classes;		/* list of C++ classes generated       */
   OMobj_id *cxx_classes;
   OMobj_id *cxx_aliases;	/* list of aliases for these C++ classes
				   (used to implement classes that can be
				   skipped because they are empty) */

   int num_hdr_files;		/* list of header files specified   */
   char **hdr_files;
   int *hdr_langs;	   /* map of which language (C,C++) each hdr file is */

   int dyn_load;		/* exclude the gen of OMadd_named_funcs */
} OMcomp_proc;

/* --- hash utility structures --- */

typedef struct _OMint_hash_ent {
   int key;
   xp_long val;
} OMint_hash_ent;

typedef struct _OMint_hash_col {
   OMint_hash_ent *ent;
   xp_long nalloced, nused;
} OMint_hash_col;

#define OM_INT_HASH_SIZE 107
#define OM_INT_HASH_BLOCK 8

typedef struct _OMint_hash {
   OMint_hash_col hash_ent[OM_INT_HASH_SIZE];
} OMint_hash;

typedef struct _OMid_hash_ent {
   OMobj_id key_id;
   OMobj_id val_id;
   int heap_id;
} OMid_hash_ent;

typedef struct _OMid_hash_col {
   OMid_hash_ent *ent;
   int nalloced, nused;
} OMid_hash_col;

#define OM_ID_HASH_SIZE 709
#define OM_ID_HASH_BLOCK 8

typedef struct _OMid_hash {
   OMid_hash_col hash_ent[OM_ID_HASH_SIZE];
} OMid_hash;

/* --- binary V structures --- */

typedef struct _OMforward_ref {
   xp_long  obj_id_ptr;
   OMobj_id obj_id;
   HPheap *heap;
   int mode;
   OMobj_id arg_id;
   struct _OMforward_ref *next;
} OMforward_ref;

typedef struct _OMrestore_ref {
   OMobj_id *obj_id_ptr;
   OMobj_id obj_id;
   int mode;
   OMobj_id arg_id;
   struct _OMrestore_ref *next;
} OMrestore_ref;

typedef struct _OMbsave_proc {
   OMobj_id proc_id;
} OMbsave_proc;

typedef struct _OMbrestore_notify_obj {
   OMobj_id obj_id, notify_id;
   OMevent_mask mask;
   int mode;
} OMbrestore_notify_obj;

typedef struct _OMsave_bfile_obj {
   int num_obj_heaps;
   HPheap **obj_heaps;
   int *heap_proc_table;
   OMint_hash name_hash;
   OMid_hash id_hash;
   OMforward_ref *forward_refs;
   int num_procs;
   OMbsave_proc *procs;
   int num_extra_heaps;
   HPheap **extra_heaps;
   int nfree_ids;
   int nfree_ids_alloced;
   OMobj_id *free_ids;
} OMsave_bfile_obj;

typedef struct _OMrestore_bfile_obj {
   OMid_hash id_hash;
   int num_heaps;
   HPheap **obj_heaps;
   HPheap **mem_heaps;
   int *heap_proc_table;
   int num_procs;
   OMproc_id *proc_ids;
   OMrestore_ref *restore_refs;
   int nvirt_objs;
   OMobj_id *virt_objs;
   int restore_id;
   OMbrestore_notify_obj *notify_objs;
   int nnotify_objs;
   const char *file;
   xp_long total_size;
} OMrestore_bfile_obj;

/*
 * If a routine is not implemented for a particular element, it can put in
 * a routine that returns an error and returns an error id (or whatever).
 */
typedef struct _OMtype {
   char name[64]; /* the name of the type */
   int (*create_elem) (OMobj_id);
   int (*destroy_elem) (OMobj_id);

   int (*set_obj_type) (OMobj_id, struct _OMtype *);

   int (*open_elem) (OMobj_id);
   int (*close_elem) (OMobj_id);
   /*
    * Saves the element description into a buffer that is returned.
    */
   int (*save_elem) (OMobj_id, OMobj_id, int, int, char **, xp_long *);
   int (*save_elem_hdr) (OMobj_id, char *, int, int);

   int (*match_elem) (OMobj_id, OMobj_id, int);
   int (*is_matched_elem) (OMobj_id, OMobj_id, int);
   int (*merge_elem) (OMobj_id, OMobj_id, int);

   int  (*insert_subelem) (OMobj_id, xp_long, OMobj_id, OMobj_name, int);
   int  (*del_subelem) (OMobj_id, OMobj_id, int);
   int  (*upd_subelem) (OMobj_id, OMobj_id, OMobj_name, int);

   int  (*upd_elem_ref) (OMobj_id, OMobj_id, int);

   int	(*set_elem_parent) (OMobj_id, OMobj_id);

   /* Determine whether this element has the named sub-element or not */
   OMobj_id (*find_subelem) (OMobj_id, OMobj_name, int);

   OMobj_id (*get_obj_by_name) (OMobj_id, OMobj_name, int *,int);

   int 	  (*get_elem_seq) (OMobj_id, OMobj_id, int);

   int 	  (*get_obj_type) (OMobj_id, struct _OMtype **);

   void   (*set_int_val) (OMobj_id, int, int, int *);
   int 	  (*get_int_val) (OMobj_id, int *);
   void   (*set_long_val) (OMobj_id, xp_long, int, int *);
   int 	 (*get_long_val) (OMobj_id, xp_long *);
   int    (*set_real_val) (OMobj_id, double);
   int    (*get_real_val) (OMobj_id, double *);
   int    (*set_str_val) (OMobj_id, const char *);
   int    (*get_str_val) (OMobj_id, char **, xp_long, int);
   int    (*set_ptr_val) (OMobj_id, void *, int);
   int    (*get_ptr_val) (OMobj_id, void **, int);
   int    (*set_data_val) (OMobj_id, void *, OMdata_id, int);
   int    (*get_data_val) (OMobj_id, void **, OMdata_id *,int);
   int    (*set_func_val) (OMobj_id, OMpfi);
   int    (*get_func_val) (OMobj_id, OMpfi *);
   int    (*set_array) (OMobj_id, int, void *, xp_long, int);
   int    (*get_array) (OMobj_id, int *, char **, int *, xp_long *, int);
   int    (*get_sub_barray) (OMobj_id, int, xp_long *,xp_long *,xp_long *,
				   unsigned char *);
   int    (*get_sub_sarray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, short *);
   int    (*get_sub_iarray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, int *);
   int    (*get_sub_larray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, xp_long *);
   int    (*get_sub_rarray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, double *);
   int    (*get_sub_farray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, float *);

   int    (*set_sub_barray) (OMobj_id, int, xp_long *, xp_long *, xp_long *,
				    unsigned char *);
   int    (*set_sub_sarray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, short *);
   int    (*set_sub_iarray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, int *);
   int    (*set_sub_larray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, xp_long *);
   int    (*set_sub_farray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, float *);
   int    (*set_sub_rarray) (OMobj_id, int, xp_long *, xp_long *, xp_long *, double *);

   int    (*set_elem_val) (OMobj_id, OMobj_id, int);
   int    (*get_elem_val) (OMobj_id, OMobj_id *);

   int    (*set_elem_ref) (OMobj_id, OMobj_id, int);

   int    (*get_elem_pval) (OMobj_id, OMobj_id *, int);

   int    (*set_elem_params) (OMobj_id, OMobj_id);

   int    (*set_array_size) (OMobj_id, xp_long);
   int    (*get_array_size) (OMobj_id, xp_long *);
   int    (*get_array_dims) (OMobj_id, int *, xp_long *);
   int    (*set_array_val) (OMobj_id, xp_long, OMobj_id);
   int    (*get_array_val) (OMobj_id, xp_long, OMobj_id *, int);
   int    (*del_array_val) (OMobj_id, OMobj_id);
   int    (*get_iarray_val) (OMobj_id, xp_long, int *);
   int    (*get_larray_val) (OMobj_id, xp_long, xp_long *);
   int    (*get_rarray_val) (OMobj_id, xp_long, double *);

   int	  (*set_str_array_val) (OMobj_id, xp_long, const char *);
   int	  (*get_str_array_val) (OMobj_id, xp_long, char **, xp_long, int);

   int    (*get_num_subelems) (OMobj_id, xp_long *, int);
   int    (*get_array_subelem) (OMobj_id, xp_long, OMobj_id *,int);

   int    (*set_data_type) (OMobj_id, int );
   int    (*get_data_type) (OMobj_id, int *);

   int 	  (*set_elem_prop) (OMobj_id, OMobj_name, OMobj_id);
   OMobj_id (*get_elem_prop) (OMobj_id, OMobj_name, int);
   int 	  (*set_elem_iprop) (OMobj_id, OMobj_name, int);

   int 	  (*set_elem_att) (OMobj_id, OMobj_name, int, int);

   int 	  (*set_elem_ref_mode) (OMobj_id, int);
   int 	  (*get_elem_ref_mode) (OMobj_id, int *);

   int 	  (*add_elem_ref) (OMobj_id, OMobj_id, int);
   int 	  (*del_elem_ref) (OMobj_id, OMobj_id, int);
   int	  (*get_num_refs) (OMobj_id, xp_long *, int);
   int 	  (*get_array_ref) (OMobj_id, xp_long, OMobj_id *, int);
   int 	  (*insert_obj_ref) (OMobj_id, xp_long, OMobj_id, int);

   int	  (*struct_to_om) (OMobj_id, OMptr, OMptr, OMcstruct_desc *);
   int	  (*om_to_struct) (OMobj_id, int, OMptr, OMptr, OMcstruct_desc *);

   int    (*gen_code) (OMobj_id, OMcomp_proc *, int);
   int    (*compile_elem) (OMobj_id, int);

   /*
    * This routine is used to copy the bits from the second element into
    * the first element.  The first element is guaranteed to be local,
    * the second is not.
    */
   int (*copy_elem) (OMobj_id, OMobj_id, int);
   int (*inherit_class) (OMobj_id, OMobj_id);
   int (*is_subclass_of) (OMobj_id, OMobj_id);

   int (*get_num_classes) (OMobj_id, int *, int);
   int (*get_array_class) (OMobj_id, int, OMobj_id *, int);

   struct _OMtype *(*copy_elem_type) (OMobj_id, int);

   int (*expand_elem) (OMobj_id, int, OMobj_id **, int *);
   int (*invoke_elem) (OMobj_id, OMobj_id, unsigned int, OMobj_id);

   /*
    * Add and delete notification requests
    */
   int (*add_obj_notify_req) (OMobj_id, OMobj_id, OMobj_id,
				unsigned int, int);
   int (*del_obj_notify_req) (OMobj_id, OMobj_id, OMobj_id,
				unsigned int, int);
   int (*valid_elem) (OMobj_id, OMobj_id, int);
   int (*resolve_elem) (OMobj_id, int);
   int (*reset_elem) (OMobj_id, int);

   void (*push_elem_ctx) (OMobj_id, int, int, int, int, int*);
   void (*pop_elem_ctx) (OMobj_id, int, int*);

   int (*get_subobj_list) (OMobj_id, OMobj_list **, int);
   char *(*ret_obj_path_to) (OMobj_id, OMobj_id, char *, int, int);
   int (*set_obj_state) (OMobj_id, int, int);
   int (*get_obj_state) (OMobj_id, int *, int);
   int (*del_obj_refs_to) (OMobj_id, int);

   int (*queue_notifier) (OMobj_id, unsigned int, OMobj_id, int);

   int (*bsave_obj) (OMobj_id, OMsave_bfile_obj *, HPheap *,
			    OMobj_id *, int);
   int (*brestore_obj) (OMrestore_bfile_obj *,
			       OMobj_id, OMobj_id,
			       OMobj_id *, int);
   int (*set_needed) (OMobj_id, char *, int, int *, int);
   int (*cleanup_obj_proc_id) (OMobj_id, OMproc_id);

   int (*links_to) (OMobj_id obj_id, OMobj_id to_id, int mode);

   struct _OMtype *prop_type;
   struct _OMtype **sub_types;
   int nsub_types;
   OMprop *props;
   struct _OMtype *next;
   unsigned int copy_props:1;    /* copy properties during copy obj operation */
   unsigned int copy_atts:1;	 /* should attributes be copied (always 1?) */
   unsigned int no_invoke_ctx:1; /* don't do push_ctx for invoke operation */
   unsigned int is_link:1;	 /* true for name_objs' that link two
				   objects that are rooted */
   unsigned int merge_able:1;    /* can this base type be merged? */
   unsigned int inst_able:1;     /* can this base type be instanced? */
   unsigned int is_leaf:1;    	 /* does this base type not have subobjects */
   unsigned int is_dep_obj:1;	 /* create dependencies for this object? */
   unsigned int is_rdonly:1;	 /* does not implement set_value operations */
   unsigned int needs_indirect_id:1; /* must be created with indirect ids */
   unsigned int save_unformatted:1;  /* for comments objects - don't do
					normal header */
   unsigned int is_global:1;	/* true if object is "global" */
   unsigned int parent_notifies:1; /* true for data_method - propagates
				      notifies to its parent object */
   int struct_size;		/* size of the in mem struct for this object */
   int save_struct_size;	/* size of the bsave struct for this object */
   int struct_ptrs;		/* # of pointers contained in the structure */
   int stats_created, stats_destroyed; /* # created/destroyed of this type */
   unsigned int prop_event_mask; /* events to propagate for this object */
   unsigned int meth_event_mask; /* for methods--events requested for this
				    (OR'd method the "+" operation) */
} OMtype, *OMtype_id;


typedef struct _OMobj {
#include <avs/edf/om_elem.edf>
} OMobj;

typedef struct _OMptr_table {
    OMptr ptr;
    const char *name;
} OMptr_table;

typedef struct _OMfunc_table {
    OMpfi pfi;
    const char *name;
} OMfunc_table;

typedef struct _OMmsg_hndlr {
   OMobj_id hndlr_elem;
   unsigned int state_mode:3;
   struct _OMmsg_hndlr *next;
} OMmsg_hndlr, *OMmsg_hndlr_id;

#define OMis_local_obj(E)	((E).proc_id == OMlocal_proc_id)

#define OMis_null_obj(E)    ((void *)(E).elem_id == (void *)OMnull_obj.elem_id)

#define OMis_null_loc(E)    ((E).elem_id == OMnull_loc.elem_id)

#define OMis_indirect_id(E)	((xp_ulong)(E).elem_id & 1L)
#define OMequal_objs(E1,E2)  \
    ((E1).elem_id == (E2).elem_id && (E1).proc_id == (E2).proc_id)

#define OMmap_obj_to_id(P)  ((P))

/*
#define OMmap_id_to_obj(P) \
	(OMis_local_obj(P) ? 		\
         ((OMis_indirect_id(P)) ? OMmap_indirect_id((unsigned int)(P).elem_id):\
		 		  ((OMobj *)((P).elem_id))) : NULL)
*/

/*
 * For debugging, put in check code to ensure that it is the right type
 * before doing the element.
 */
#ifdef OM_DEBUG
#define OM_map_id_type_check(E,T,SZ) \
   (OMis_local_obj(E) && \
   (!(OM_verbose & OM_VERBOSE_TYPE_CHECK) || OMobj_is_type_of((E),T) == 1) && \
    (T)->struct_size == (SZ) ? \
   (OMobj *)(E).elem_id :  \
   (OMobj *)(ERRerror("OM id check",3,ERR_ORIG,	\
	    	  "type mismatch at line: %d, file: %s, elem: %s", \
	     	  __LINE__,__FILE__,				\
		  OMis_local_obj(E) ? OMret_obj_name(E) : "<remote>"),NULL))
#else
#define OM_map_id_type_check(E,T,SZ) ((OMobj *)(E).elem_id)
#endif

#define OMmap_id_to_obj_type(P,T,ST) \
      ((ST *) (OMis_indirect_id(P) ? \
        OMmap_indirect_id((xp_ulong)(P).elem_id) : \
        OM_map_id_type_check((P),T,sizeof(ST))))

#define OMmap_id_to_obj(P)   OMmap_id_to_obj_type(P,OM_type_obj,OMobj)

/*
 * Equivalent of the above but never performs checking... needed for
 * OMobj_is_type_of routine because it can't call itself.
 */
#define OMmap_id_to_obj_no_check(P) \
 ((OMobj *) (OMis_indirect_id(P) ? 	\
		OMmap_indirect_id((xp_ulong)(P).elem_id) : \
		(P).elem_id))
		
#define OM_BINV_EXT "vo"

#define OMobj_proc(E)		((E).proc_id)

#define OM_OBJ_NAME(E) \
       (OMis_local_obj(E) ? OMmap_id_to_obj(E)->name : OM_obj_name(E))

/* Go to great lengths to avoid a subroutine call here... */
#define OM_GET_OBJ_BY_NAME(E,NAME,CANCEL,MODE) \
   (OMis_local_obj(E) && OMmap_id_to_obj(E)->type->get_obj_by_name == NULL?\
    (OMmap_id_to_obj(E)->name == NAME ? E : OMnull_obj) : \
     OMget_obj_by_name(E,NAME,CANCEL,MODE))


#define OMtype_size(T)	(DTYPEtype_size[T])

#define OMget_state_mode()	OMstate.v.state_mode

#define OM_NULL_NAME	0

/*
 * This typedef is used by various element routines to pass around a
 * pointer to one of the get_sub_array routines to implement a more
 * generic method.
 */
typedef int (*OMsub_array_func) (OMobj_id,int,xp_long*,xp_long*,xp_long *,char *);

OM_EXTERN OMobj_id OMnull_obj;
OM_EXTERN OMobj_id OMinvalid_obj;
OM_EXTERN OMproc_id OMlocal_proc_id;
OM_EXTERN OMloc_id OMnull_loc;

OM_G_EXTERN OMobj_id OMroot_obj, OMinst_obj, OMtempl_obj, OMproc_obj,
		 OMproc_inst_obj, OMproc_templ_obj, OMsched_obj,
		 OMloc_templ_obj;

#define OM_CONST_MAX 32
OM_EXTERN OMobj_id OM_const_objs[OM_CONST_MAX];

#define OM_CONST_MAX 32
OM_EXTERN OMobj_id OM_const_objs[OM_CONST_MAX];

/* Defined in proc.c */
FUNC_PREFIX int  OMinit (char *, int, COMMaddr *);
FUNC_PREFIX void OMget_my_addrs (int *, COMMaddr **);
FUNC_PREFIX int  OMset_boss (int, COMMaddr *);
FUNC_PREFIX OMproc_id OMnew_client (int, COMMaddr *);
FUNC_PREFIX void OMget_proc_addrs (OMproc_id, int *, COMMaddr **);
FUNC_PREFIX void OMadd_proc_conn (COMMconn *, OMproc_id);
FUNC_PREFIX COMMconn *OMlookup_proc_conn (OMproc_id, int *);
FUNC_PREFIX void OMexit (int status);
FUNC_PREFIX void OMmain_uninit (int status);
FUNC_PREFIX void OMadd_exit_func (void (*func)(void *), void *arg);
FUNC_PREFIX void OMadd_cleanup_file (char *file);

/* Defined in elem.c */
FUNC_PREFIX OMobj_id OMcreate_obj (OMobj_name, OMtype_id, OMobj_id, OMobj_id,
				OMproc_id);
FUNC_PREFIX OMobj_id OMcreate_obj_mode (OMobj_name,OMtype_id,OMobj_id,OMobj_id,
				    OMproc_id, int);
FUNC_PREFIX int	OMdestroy_obj (OMobj_id, int);
FUNC_PREFIX int	OMopen_obj (OMobj_id);
FUNC_PREFIX int	OMclose_obj (OMobj_id);
FUNC_PREFIX int	OMsave_obj (OMobj_id, OMobj_id, int, int, char **, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMsave_obj_n (OMobj_id, OMobj_id, int, int, char **, int *);
#endif
FUNC_PREFIX int	OMsave_obj_hdr (OMobj_id, char *,int,int);
FUNC_PREFIX int OMadd_subobj (OMobj_id, OMobj_id);
FUNC_PREFIX int OMinsert_subobj (OMobj_id, xp_long, OMobj_id, int);
FUNC_PREFIX int OMdel_subobj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMupd_subobj (OMobj_id, OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMupd_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX OMobj_id OMfind_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX OMobj_id OMget_obj_by_name (OMobj_id, OMobj_name, int *, int);
FUNC_PREFIX int	OMis_global (OMobj_id);
FUNC_PREFIX OMobj_id OMfind_obj (OMobj_id, OMobj_name, int);
FUNC_PREFIX OMobj_id OMfind_obj_levels (OMobj_id, OMobj_name, int *, int);
FUNC_PREFIX int OMmatch_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMmerge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMmatch_props (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMset_obj_name (OMobj_id, OMobj_name);
FUNC_PREFIX int	OMget_obj_name (OMobj_id, OMobj_name *);
FUNC_PREFIX int	OMset_obj_parent (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMget_obj_parent (OMobj_id, OMobj_id *);
FUNC_PREFIX OMobj_id OMret_obj_parent (OMobj_id);
FUNC_PREFIX int	OMset_obj_type (OMobj_id, OMtype_id);
FUNC_PREFIX int	OMget_obj_type (OMobj_id, OMtype_id *);
FUNC_PREFIX int	OMget_obj_type_mode (OMobj_id, OMtype_id *, int);
FUNC_PREFIX int	OMset_obj_att (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMget_obj_att (OMobj_id, OMobj_name, int *);
FUNC_PREFIX int	OMset_obj_atts (OMobj_id, OMatts);
FUNC_PREFIX int	OMclr_obj_atts (OMobj_id, OMatts);
FUNC_PREFIX int	OMget_obj_atts (OMobj_id, OMatts);
FUNC_PREFIX int	OMget_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMset_int_val (OMobj_id, int);
FUNC_PREFIX int	OMget_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMset_long_val (OMobj_id, xp_long);
FUNC_PREFIX int	OMget_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMset_real_val (OMobj_id, double);
FUNC_PREFIX int	OMget_real_val (OMobj_id, double *);
FUNC_PREFIX int	OMset_str_val (OMobj_id, const char *);
FUNC_PREFIX int	OMget_str_val (OMobj_id, char **, xp_long);
FUNC_PREFIX char *OMret_str_val (OMobj_id, char *, xp_long);
FUNC_PREFIX char *OMret_name_str_val (OMobj_id, OMobj_name, char *, int);
FUNC_PREFIX int	OMget_str_val_mode (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int	OMset_ptr_val (OMobj_id, void *, int);
FUNC_PREFIX int	OMget_ptr_val (OMobj_id, void **, int);
FUNC_PREFIX OMobj_id OMret_obj_val (OMobj_id, int mode);
FUNC_PREFIX int	OMset_func_val (OMobj_id, OMpfi);
FUNC_PREFIX int	OMget_func_val (OMobj_id, OMpfi *);
FUNC_PREFIX int	OMset_array (OMobj_id, int , void *, xp_long , int);
FUNC_PREFIX int	OMget_array (OMobj_id, int *, char **, int *, xp_long *, int);
FUNC_PREFIX int	OMget_array_sz (OMobj_id, int *, char **, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_array_n (OMobj_id, int *, char **, int *, int *, int);
FUNC_PREFIX int	OMget_array_sz_n (OMobj_id, int *, char **, int *, int);
#endif
FUNC_PREFIX int	OMget_sub_barray (OMobj_id, int, xp_long *, xp_long *, xp_long *,
				  unsigned char *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_sub_barray_n (OMobj_id, int, int *, int *, int *,
				  unsigned char *);
#endif
FUNC_PREFIX int	OMget_sub_sarray (OMobj_id, int, xp_long *, xp_long *, xp_long *, short *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_sub_sarray_n (OMobj_id, int, int *, int *, int *, short *);
#endif
FUNC_PREFIX int	OMget_sub_iarray (OMobj_id, int, xp_long *, xp_long *, xp_long *, int *);

#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_sub_iarray_n (OMobj_id, int, int *, int *, int *, int *);
#endif
FUNC_PREFIX int	OMget_sub_larray (OMobj_id, int, xp_long *, xp_long *, xp_long *, xp_long *);
FUNC_PREFIX int	OMget_sub_rarray (OMobj_id, int, xp_long *,xp_long *, xp_long *, double *);

#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_sub_rarray_n (OMobj_id, int, int *,int *, int *, double *);
#endif
FUNC_PREFIX int	OMget_sub_farray (OMobj_id, int, xp_long *,xp_long *, xp_long *, float *);

#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_sub_farray_n (OMobj_id, int, int *,int *, int *, float *);
#endif
FUNC_PREFIX int	OMset_sub_barray (OMobj_id, int, xp_long *, xp_long *, xp_long *,
				 unsigned char *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMset_sub_barray_n (OMobj_id, int, int *, int *, int *,
				 unsigned char *);
#endif
FUNC_PREFIX int	OMset_sub_sarray (OMobj_id, int, xp_long *, xp_long *, xp_long *, short *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMset_sub_sarray_n (OMobj_id, int, int *, int *, int *, short *);
#endif
FUNC_PREFIX int	OMset_sub_iarray (OMobj_id, int, xp_long *, xp_long *, xp_long *, int *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMset_sub_iarray_n (OMobj_id, int, int *, int *, int *, int *);
#endif
FUNC_PREFIX int	OMset_sub_larray (OMobj_id, int, xp_long *, xp_long *, xp_long *, xp_long *);
FUNC_PREFIX int	OMset_sub_farray (OMobj_id, int, xp_long *, xp_long *, xp_long *, float *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMset_sub_farray_n (OMobj_id, int, int *, int *, int *, float *);
#endif
FUNC_PREFIX int	OMset_sub_rarray (OMobj_id, int, xp_long *, xp_long *, xp_long *, double *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMset_sub_rarray_n (OMobj_id, int, int *,int *, int *, double *);
#endif
FUNC_PREFIX int	OMset_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMset_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMget_obj_val (OMobj_id, OMobj_id *);
FUNC_PREFIX int	OMget_obj_val_user (OMobj_id, OMobj_id *);
FUNC_PREFIX int	OMget_obj_ref (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int	OMget_obj_pval (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int	OMset_obj_params (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMset_array_size (OMobj_id, xp_long );
FUNC_PREFIX int	OMget_array_size (OMobj_id, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_array_size_n (OMobj_id, int *);
#endif
FUNC_PREFIX int	OMget_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_array_dims_n (OMobj_id, int *, int *);
#endif
FUNC_PREFIX int	OMget_array_ndim (OMobj_id, int *);
FUNC_PREFIX int	OMset_array_val (OMobj_id, xp_long, OMobj_id);
FUNC_PREFIX int	OMget_array_val (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMdel_array_val (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMget_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMget_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int	OMget_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int	OMset_str_array_val (OMobj_id, xp_long, const char *);
FUNC_PREFIX char *OMret_str_array_val (OMobj_id, xp_long, char *, xp_long);
FUNC_PREFIX int	OMget_str_array_val (OMobj_id, xp_long, char **, xp_long);
FUNC_PREFIX int	OMget_str_array_val_mode (OMobj_id, xp_long, char **, xp_long, int);
FUNC_PREFIX int	OMget_num_subobjs (OMobj_id, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_num_subobjs_n (OMobj_id, int *);
#endif
FUNC_PREFIX int	OMget_num_subobjs_mode (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_num_subobjs_mode_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int	OMget_array_subobj (OMobj_id, xp_long, OMobj_id *,int);
FUNC_PREFIX int	OMget_subobj_list (OMobj_id obj, OMobj_list **list, int mode);
FUNC_PREFIX void OMfree_subobj_list (OMobj_list *list);

FUNC_PREFIX int	OMset_data_type (OMobj_id, int);
FUNC_PREFIX int	OMget_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMget_obj_ref_to_list (OMobj_id ref_elem_id,
				      OMobj_id *from_elem_id);

FUNC_PREFIX int OMadd_to_refcnt (OMobj_id, int);

FUNC_PREFIX int	OMadd_obj_ref_to (OMobj_id, OMobj_id, int mode);
FUNC_PREFIX int	OMdel_obj_ref_to (OMobj_id, OMobj_id);

FUNC_PREFIX int	OMdel_obj_refs_to (OMobj_id, int);

FUNC_PREFIX int	OMset_obj_prop (OMobj_id, OMobj_name, OMobj_id);
FUNC_PREFIX int	OMdel_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX OMobj_id OMget_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMset_obj_iprop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMset_obj_iarray_prop (OMobj_id, OMobj_name, int, int *);
FUNC_PREFIX int	OMset_obj_lprop (OMobj_id, OMobj_name, xp_long);
FUNC_PREFIX int	OMset_obj_rprop (OMobj_id, OMobj_name, double);
FUNC_PREFIX int	OMset_obj_sprop (OMobj_id, OMobj_name, const char *);
FUNC_PREFIX int	OMget_obj_iprop (OMobj_id, OMobj_name, int *);
FUNC_PREFIX int	OMget_obj_iprop_mode (OMobj_id, OMobj_name, int *, int);
FUNC_PREFIX int	OMget_obj_lprop (OMobj_id, OMobj_name, xp_long *);
FUNC_PREFIX int	OMget_obj_lprop_mode (OMobj_id, OMobj_name, xp_long *, int);
FUNC_PREFIX int	OMget_obj_rprop (OMobj_id, OMobj_name, double *);
FUNC_PREFIX int	OMget_obj_sprop (OMobj_id, OMobj_name, char **, int);
FUNC_PREFIX int	OMget_obj_sprop_mode (OMobj_id, OMobj_name, char **,int,int);
FUNC_PREFIX int	OMget_obj_bool_prop (OMobj_id, OMobj_name, int);

FUNC_PREFIX int	OMreset_obj_prop (OMobj_id, OMobj_name, OMobj_id);
FUNC_PREFIX int	OMreset_obj_sprop (OMobj_id, OMobj_name, const char *);
FUNC_PREFIX int	OMreset_obj_iprop (OMobj_id, OMobj_name, int);

FUNC_PREFIX int	OMset_obj_ref_mode (OMobj_id, int);
FUNC_PREFIX int	OMget_obj_ref_mode (OMobj_id, int *);

FUNC_PREFIX int	OMadd_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMdel_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMget_num_refs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMget_num_refs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMget_array_ref (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMinsert_obj_ref (OMobj_id, xp_long, OMobj_id, int);

FUNC_PREFIX OMobj_id OMcopy_obj (OMobj_id, OMobj_name,OMobj_id,OMproc_id,int);
FUNC_PREFIX OMobj_id OMcopy_obj_base (OMobj_id, OMobj_name, OMobj_id,
				   OMproc_id,int);
FUNC_PREFIX int OMinherit_class (OMobj_id, OMobj_id);
FUNC_PREFIX int OMis_subclass_of (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMget_num_classes (OMobj_id, int *, int);
FUNC_PREFIX int	OMget_array_class (OMobj_id, int, OMobj_id *, int);
FUNC_PREFIX int OMcopy_to_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMcopy_props (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMcopy_atts (OMobj_id, OMobj_id, int);

FUNC_PREFIX int OMinvoke_obj (OMobj_id, OMobj_id, unsigned int, OMobj_id);
FUNC_PREFIX int	OMinvalidate_refs (OMobj_id);

FUNC_PREFIX int	OMset_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMget_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int	OMset_obj_seq (OMobj_id, int);
FUNC_PREFIX int OMset_needed (OMobj_id, char *, int, int *, int);
FUNC_PREFIX int OMlinks_to (OMobj_id , OMobj_id, int );

/* Defined in type.c */
FUNC_PREFIX OMtype_id OMcreate_type (const char *, OMtype_id, int);
FUNC_PREFIX OMtype_id OMcreate_new_type (const char *, OMtype_id);
FUNC_PREFIX OMtype_id OMcreate_merged_type (OMtype_id, OMtype_id);
FUNC_PREFIX OMtype_id OMcreate_str_type (const char *);
FUNC_PREFIX void OMset_save_struct_size (OMtype_id, int, int);
FUNC_PREFIX void OMmerge_type (OMtype_id, OMtype_id);
FUNC_PREFIX void OMinherit_method (OMmethod_id, OMtype_id, OMtype_id);
FUNC_PREFIX void OMset_method (OMmethod_id, OMtype_id, OMpfi);
FUNC_PREFIX OMpfi OMget_super_method (OMmethod_id, OMtype_id, OMpfi);
FUNC_PREFIX OMtype_id OMstr_to_type (const char *);
FUNC_PREFIX int	OMset_type_prop (OMtype_id, OMobj_name, OMobj_id);
FUNC_PREFIX OMobj_id OMget_type_prop (OMtype_id, OMobj_name, int);
FUNC_PREFIX int	OMset_type_iprop (OMtype_id, OMobj_name, int);
FUNC_PREFIX int	OMset_type_iarray_prop (OMtype_id, OMobj_name, int, int *);
FUNC_PREFIX int	OMset_type_rprop (OMtype_id, OMobj_name, double);
FUNC_PREFIX int	OMset_type_sprop (OMtype_id, OMobj_name, const char *);
FUNC_PREFIX void OMprint_all_types (FILE *);
FUNC_PREFIX void OMprint_type (FILE *,OMtype_id, int);
FUNC_PREFIX int OMobj_is_type_of (OMobj_id elem_id, OMtype_id type_id);
FUNC_PREFIX int OMtype_is_type_of (OMtype_id, OMtype_id);

/* Defined om_init.c */
void	OMinit_base_types (void);

/* Defined in arr.c */
extern      int OMmatch_dims (int , xp_long *, int , xp_long *);
FUNC_PREFIX int	OMcvt_sub_array (OMobj_id elem_id, int indim, xp_long *idims,
				xp_long *imin_rng, xp_long *imax_rng, int ondim,
				xp_long *odims, char *array, int elsize,
				OMsub_array_func func);

#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMcvt_sub_array_n (OMobj_id elem_id, int indim, int *idims,
				int *imin_rng, int *imax_rng, int ondim,
				int *odims, char *array, int elsize,
				OMsub_array_func func);
#endif

/* Defined in parse.c */
FUNC_PREFIX int OMread_desc (OMobj_id, const char *, int);
FUNC_PREFIX OMobj_id OMload_obj (OMobj_id, const char *);
FUNC_PREFIX OMobj_id OMload_obj_mode (OMobj_id, const char *, int);
FUNC_PREFIX int	OMparse_stream (OMobj_id, FILE *, int);
FUNC_PREFIX int	OMparse_obj_val (OMobj_id, const char *);
FUNC_PREFIX int	OMparse_obj_ref (OMobj_id, const char *);
FUNC_PREFIX OMobj_id OMparse_val_to_obj (OMobj_id, const char *);
FUNC_PREFIX OMobj_id OMparse_dims_to_obj (OMobj_id, const char *);
FUNC_PREFIX int	OMparse_buffer (OMobj_id, const char *, int);
FUNC_PREFIX OMobj_id OMparse_buffer_one_obj (OMobj_id, const char *, int);
FUNC_PREFIX OMobj_id OMread_file_obj (OMobj_id, const char *file, OMobj_name name, int mode);

/* Defined in wrap.c */
FUNC_PREFIX int OMis_ancestor_of (OMobj_id elem1_id, OMobj_id elem2_id);

FUNC_PREFIX int	OMprint_array (FILE *fp, char *cbuf, xp_long *retlen, int level,
			      int dtype, char *array, int ndim, xp_long dims[],
			      int mode);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMprint_array_n (FILE *fp, char *cbuf, int *retlen, int level,
			      int dtype, char *array, int ndim, int dims[],
			      int mode);
#endif

FUNC_PREFIX char *OMoutput_string (char *, char *, char *, int);
FUNC_PREFIX int	OMlink_objs (OMobj_id in_elem, OMobj_id out_elem);
FUNC_PREFIX int	OMinsert_link_objs (OMobj_id in_elem, int ind, OMobj_id out_elem);
FUNC_PREFIX int	OMdel_subobjs (OMobj_id elem_id);
FUNC_PREFIX int	OMwrite_obj (OMobj_id elem_id, char *file, int mode);
FUNC_PREFIX int	OMsave_project (void);
FUNC_PREFIX int OMload_project (char *project, int derived);
FUNC_PREFIX int	OMupd_name_refs (OMobj_id elem_id);
FUNC_PREFIX int	OMsave_project_as (char *path_name);
FUNC_PREFIX int	OMuser_destroy_obj (OMobj_id elem_id);
FUNC_PREFIX int	OMuser_destroy_objs (int nobjs, OMobj_id *obj_id_list);
FUNC_PREFIX OMobj_id OMmake_subobj_rw (OMobj_id, OMobj_id);
FUNC_PREFIX void OMbegin_op (void);
FUNC_PREFIX void OMend_op (void);
FUNC_PREFIX int OMget_ports (OMobj_id,
		      void (*) (OMobj_id, int, void *),
		      void *, int);
FUNC_PREFIX int OMget_port_list (OMobj_id,
				int *num_ports, OMobj_id **port_list,
		      		int mode);
FUNC_PREFIX int OMget_port_list_levels (OMobj_id obj_id, int *num_ports,
				       OMobj_id **ports, int level, int mode);

FUNC_PREFIX int	OMget_running_obj_list (xp_long *, OMobj_id **);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_running_obj_list_n (int *, OMobj_id **);
#endif

FUNC_PREFIX OMobj_id OMlookup_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMset_name_int_val (OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMget_name_int_val (OMobj_id, OMobj_name, int *);
FUNC_PREFIX int OMset_name_long_val (OMobj_id, OMobj_name, xp_long);
FUNC_PREFIX int OMget_name_long_val (OMobj_id, OMobj_name, xp_long *);
FUNC_PREFIX int OMset_name_ptr_val (OMobj_id, OMobj_name, OMptr, int);
FUNC_PREFIX int OMget_name_ptr_val (OMobj_id, OMobj_name, OMptr *, int);
FUNC_PREFIX int OMset_name_real_val (OMobj_id, OMobj_name, double);
FUNC_PREFIX int OMget_name_real_val (OMobj_id, OMobj_name, double *);
FUNC_PREFIX int	OMset_name_str_val (OMobj_id, OMobj_name, const char *);
FUNC_PREFIX int	OMget_name_str_val (OMobj_id, OMobj_name, char **, xp_long);
FUNC_PREFIX int	OMset_name_array (OMobj_id, OMobj_name, int, char *, xp_long ,int);
FUNC_PREFIX int OMset_array_dims (OMobj_id elem_id,int ndims, xp_long *dims);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMset_array_dims_n (OMobj_id elem_id,int ndims, int *dims);
#endif

FUNC_PREFIX char * OMret_obj_name (OMobj_id);
FUNC_PREFIX char * OMret_obj_path (OMobj_id, char *, int);
FUNC_PREFIX char * OMget_obj_path_to (OMobj_id, OMobj_id, char *, int);
FUNC_PREFIX char * OMret_obj_path_to (OMobj_id, OMobj_id, char *, int, int);
FUNC_PREFIX char * OMret_obj_path_val (OMobj_id, char *, int);
FUNC_PREFIX OMobj_name OMget_uniq_name (OMobj_id parent, OMobj_name name,
				   int *ind);

FUNC_PREFIX char * OMret_obj_user_name (OMobj_id, char *, int);
FUNC_PREFIX int OMget_obj_user_name (OMobj_id, char **, int );
FUNC_PREFIX int	OMadd_array_val (OMobj_id, OMobj_id);
FUNC_PREFIX OMobj_id OMcreate_callback_obj (OMobj_name,OMpfi,OMtype_id,void *);
FUNC_PREFIX OMobj_id OMcreate_int_obj (OMobj_name, OMtype_id, OMobj_id, OMproc_id, int);
FUNC_PREFIX OMobj_id OMcreate_long_obj (OMobj_name, OMtype_id, OMobj_id, OMproc_id, xp_long);
FUNC_PREFIX OMobj_id OMcreate_ptr_obj (OMobj_name, OMtype_id, OMobj_id,
				OMproc_id, void *, int);
FUNC_PREFIX OMobj_id OMcreate_real_obj (OMobj_name, OMtype_id, OMobj_id,
				OMproc_id, double);
FUNC_PREFIX OMobj_id OMcreate_iarray_obj (OMobj_name, OMtype_id, OMobj_id,
				OMproc_id, int, int *);
FUNC_PREFIX OMobj_id OMcreate_str_obj (OMobj_name, OMtype_id, OMobj_id,
				OMproc_id, const char *);
FUNC_PREFIX OMobj_id OMcreate_obj_from_str (const char *, const char *, int *);
FUNC_PREFIX OMobj_id OMcreate_obj_from_path (const char *, const char *, OMobj_id);
FUNC_PREFIX OMobj_id OMcreate_obj_from_path_mode (const char *, const char *, OMobj_id, int);
FUNC_PREFIX int	OMget_list_prod (OMobj_id, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMget_list_prod_n (OMobj_id, int *);
#endif
FUNC_PREFIX OMobj_name OM_obj_name (OMobj_id);
FUNC_PREFIX int OMobj_set_ref_to (OMobj_id elem_id, OMobj_id ref_id,
				int add, int mode, int set_ref,
				int rdonly, int ref_mode);
FUNC_PREFIX int	OMpropagate_sub_notify_reqs (OMobj_id, OMobj_id, int, int);
FUNC_PREFIX int	OMpropagate_notify_reqs (OMobj_id, OMobj_id, int, int, int);
FUNC_PREFIX char *OMget_user_class_name (OMobj_id, char *, int);
FUNC_PREFIX int	OMequal_paths (OMobj_id elem1, OMobj_id elem2);
FUNC_PREFIX int	OMget_ref_to_list (OMobj_id, int *, OMobj_id **, int);
FUNC_PREFIX char *OMret_valid_obj_name (const char *, char *, int);
FUNC_PREFIX void *OMret_array_ptr (OMobj_id, int, xp_long *, int *);
FUNC_PREFIX void *OMret_name_array_ptr (OMobj_id, OMobj_name, int, xp_long *, int *);
FUNC_PREFIX void *OMret_typed_array_ptr (OMobj_id, int, int , xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX void *OMret_array_ptr_n (OMobj_id, int, int *, int *);
FUNC_PREFIX void *OMret_name_array_ptr_n (OMobj_id, OMobj_name, int, int *, int *);
FUNC_PREFIX void *OMret_typed_array_ptr_n (OMobj_id, int, int , int *);
#endif
FUNC_PREFIX int OMchanged (OMobj_id, int seq_num);
FUNC_PREFIX int OMchanged_name (OMobj_id, OMobj_name, int seq_num);
FUNC_PREFIX int OMcheck_gen_hdr (const char *file);
FUNC_PREFIX void OMwrite_gen_hdr (FILE *fp, const char *prefix, const char *postfix);
FUNC_PREFIX int OMis_disabled (OMobj_id);
FUNC_PREFIX void OMlic_set_err_callback(void *, void *);

/* Defined in name.c */
extern      int OMis_valid_obj (OMobj_id);
FUNC_PREFIX OMobj_name OMstr_to_name (const char *);
FUNC_PREFIX OMobj_name OMstr_lookup_name (const char *);
FUNC_PREFIX int	OMhash (const char *,int);
FUNC_PREFIX char *OMname_to_str (OMobj_name);
FUNC_PREFIX char *OMnotify_mode_to_str (int, char*);
FUNC_PREFIX OMobj_id OMstr_to_obj (const char *);
FUNC_PREFIX void OMobj_to_str (OMobj_id, char *);
FUNC_PREFIX OMobj *OMmap_indirect_id (xp_ulong);
FUNC_PREFIX OMptr OMname_to_ptr (OMobj_name);
FUNC_PREFIX OMobj_name OMptr_to_name (OMptr);
FUNC_PREFIX void OMadd_named_ptrs (OMptr_table *, unsigned int);
FUNC_PREFIX void OMadd_named_ptr (OMptr, OMobj_name);
FUNC_PREFIX OMpfi OMname_to_func (OMobj_name);
FUNC_PREFIX OMpfi OMname_to_dynlib_func (OMobj_name);
FUNC_PREFIX void *OMname_to_dynlib_id (OMobj_name);
FUNC_PREFIX OMobj_name OMfunc_to_name (OMpfi);
FUNC_PREFIX void OMadd_named_funcs (OMfunc_table *, unsigned int);
FUNC_PREFIX void OMadd_named_func (OMpfi, OMobj_name);
FUNC_PREFIX void OMadd_named_dynlib_func (OMpfi, OMobj_name, void *lib_id);
FUNC_PREFIX void OMremove_named_dynlib_func (OMobj_name, void *lib_id);
FUNC_PREFIX OMatts OMcreate_att (OMobj_name, unsigned int, unsigned int, OMpfi);
FUNC_PREFIX int	OMname_to_att (OMobj_name);
FUNC_PREFIX OMobj_name OMatt_to_name (int);
FUNC_PREFIX unsigned int OMatt_flags (int);
FUNC_PREFIX unsigned int OMatt_group (int);
FUNC_PREFIX OMpfi OMatt_funcs (int);
FUNC_PREFIX int	OMis_att (OMobj_name);
FUNC_PREFIX char *OMevent_to_str (unsigned int);
FUNC_PREFIX char *OMevents_to_str (unsigned int, char *, int);
FUNC_PREFIX unsigned int OMstr_to_verbose_flag (const char *);
FUNC_PREFIX int	OMlookup_prop (OMobj_name name,
			      int *flags,
			      int (**set_func) (OMobj_id, OMobj_name,
						       OMobj_id, int));

/* Defined in notify.c */
FUNC_PREFIX int	OMadd_notify_req (OMobj_id, OMobj_id, OMobj_id, OMobj_id,
				 unsigned int, int);
FUNC_PREFIX int	OMdel_notify_req (OMobj_id, OMobj_id, OMobj_id, OMobj_id,
				 unsigned int, int);
FUNC_PREFIX int	OMadd_obj_notify_req (OMobj_id, OMobj_id, OMobj_id,
				 unsigned int, int);
FUNC_PREFIX int	OMdel_obj_notify_req (OMobj_id, OMobj_id, OMobj_id,
				 unsigned int, int);
FUNC_PREFIX int	OMsend_event (OMobj_id, unsigned int);
FUNC_PREFIX int	OMvalid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMresolve_obj (OMobj_id, int);
FUNC_PREFIX int	OMreset_obj (OMobj_id, int);
FUNC_PREFIX unsigned int OMpush_ctx (OMobj_id, int, int, int);
FUNC_PREFIX int	OMpop_ctx (OMobj_id);
FUNC_PREFIX void OMset_state_to_usr (int);
FUNC_PREFIX int	OMset_state_mode (int);
FUNC_PREFIX int	OMqueue_notify (OMobj_id, OMobj_id,unsigned int,OMobj_id,int);
FUNC_PREFIX int	OMqueue_notifier (OMobj_id, unsigned int, OMobj_id, int);
FUNC_PREFIX OMobj_id OMget_func_notifier (OMobj_id func_id, OMobj_id arg_id);
FUNC_PREFIX int OMset_notifier_dep (OMobj_id, OMobj_id, OMobj_id, int, int);
FUNC_PREFIX int	OMflush_notifies (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMflush_notifies_mask (OMobj_id, OMobj_id, OMevent_mask, int);
FUNC_PREFIX int	OMget_cur_seq (OMobj_id);

FUNC_PREFIX int	OMstatus_check (int, const char *, int *);
FUNC_PREFIX int OMpush_status_range (int, int);
FUNC_PREFIX int OMpop_status_range (void);

/* Defined in sys.c */
FUNC_PREFIX int	OMinit_system (char *);
FUNC_PREFIX int OMbegin_init (int *, char **);
FUNC_PREFIX int OMend_init (int *, char **);
FUNC_PREFIX void OMmain_loop (int novcp);
FUNC_PREFIX void OMevent_loop (void);
FUNC_PREFIX int	OMload_templates (const char *,int);
FUNC_PREFIX int	OMload_library (const char *, OMobj_name, const char *);
FUNC_PREFIX int	OMload_instances (const char *);
FUNC_PREFIX int	OMload_root (const char *);
FUNC_PREFIX OMobj_id OMnew_instance (OMobj_id);
FUNC_PREFIX OMobj_id OMcreate_app (OMobj_id, OMobj_name, int);
FUNC_PREFIX OMsys_process_id OMadd_process (OMobj_id, char *,char *, char **,
					void (*)(int, void *), void *);
FUNC_PREFIX int	OMdel_process (OMsys_process_id);
FUNC_PREFIX int	OMis_main_process (void);
FUNC_PREFIX char *OMversion_string (void);
FUNC_PREFIX void OMset_init_state (int);
FUNC_PREFIX void OMprocess_exit (OMproc_id, int);

/* Defined in virt.c */
FUNC_PREFIX int OMadd_virtual_obj (OMobj_id, OMobj_id);
FUNC_PREFIX OMobj_id OMfind_virt_obj (OMobj_id, OMobj_name, int);

/* Defined in om_comm.c */
FUNC_PREFIX void OMadd_command_parser (int (*)(char *, char *, OMobj_id));
FUNC_PREFIX OMobj_id OMfind_str_subobj (OMobj_id, const char *, int);

/* Defined in paths.c */
FUNC_PREFIX char * OMadd_to_path (int which, char *path);
FUNC_PREFIX int    OMget_num_paths (int which);
FUNC_PREFIX char * OMget_path (int which);
FUNC_PREFIX char * OMget_path_index (int which, int path_index, char *);
FUNC_PREFIX char * OMget_install_dir (void);
FUNC_PREFIX void   OMinit_install_dirs (char *argv0);

/* Defined in om_misc.c */
FUNC_PREFIX void OMset_verbose (unsigned int, int, FILE *);
FUNC_PREFIX void OMprint_obj (OMobj_id);
FUNC_PREFIX void OMprint_obj_mode (OMobj_id, FILE *, int);
FUNC_PREFIX void OMprint_path (OMobj_id);
FUNC_PREFIX void OMedit_obj (OMobj_id);
FUNC_PREFIX void OMedit_root_obj (void);

OM_EXTERN OMtype_id OM_type_obj; /* The root type for all elements */
OM_EXTERN int OM_verbose;

typedef union _OMstate_type {
   int all;
   struct _info {
#ifdef AVS_LITTLEENDIAN
     /* This bitfield is incorporated directly into the
      * remote protocol with no encoding other than byte swapping.
      * Without taking this extra precaution, the bitfields
      * don't line up.
      */
      unsigned int valid_ctx:25;	/* this is the current ctx_index  */
      unsigned int errors_squashed:1;   /* are errors currently squashed? */
      unsigned int error_check:1;       /* do we perform error checking now? */
      unsigned int state_mode:3;	/* current state mode         */
      unsigned int hndlr_active:1;	/* is journalling active?     */
      unsigned int hndlr_elem:1;	/* is journalling turned on?  */
#else
      unsigned int hndlr_elem:1;	/* is journalling turned on?  */
      unsigned int hndlr_active:1;	/* is journalling active?     */
      unsigned int state_mode:3;	/* current state mode         */
      unsigned int error_check:1;       /* do we perform error checking now? */
      unsigned int errors_squashed:1;   /* are errors currently squashed? */
      unsigned int valid_ctx:25;	/* this is the current ctx_index  */
#endif
   } v;
} OMstate_type;

OM_EXTERN OMstate_type OMstate;

OM_EXTERN OMobj_id OM_hndlr_obj;

OM_EXTERN OMmsg_hndlr *OM_global_msg_hndlrs;

/* Defined in msg.c */
FUNC_PREFIX int OMadd_global_msg_hndlr (OMobj_id, int, int);
FUNC_PREFIX int OMdel_global_msg_hndlr (OMobj_id, int, int);

/* Defined in preproc.c */
FUNC_PREFIX void OMadd_define (const char *, const char *);
FUNC_PREFIX int OMis_defined (const char *Str);

/* Defined in dgroup.c */
FUNC_PREFIX int OMcstruct_update_om (OMptr ptr, OMptr bitmask);
FUNC_PREFIX int OMcstruct_resolve_ptr (OMptr ptr, OMptr bitmask);
FUNC_PREFIX int OMcstruct_resolve_ptr_seqnum (OMptr ptr, OMptr bitmask, int seqnum);
FUNC_PREFIX OMobj_id OMcstruct_lookup_ptr (OMptr ptr);
FUNC_PREFIX void *OMret_omx_ptr (OMobj_id, int );
FUNC_PREFIX int OMset_omx_ptr (OMobj_id, void *, int);

/* defined in sched.c */
FUNC_PREFIX int OMadd_func_dep (OMobj_id, OMobj_id, int, int);
FUNC_PREFIX int OMdel_func_dep (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMlookup_func_dep (OMobj_id, OMobj_id, int);

/* defined in process.c */
FUNC_PREFIX int OMset_remote_obj (OMproc_id, OMobj_id, OMobj_id, OMobj_id, int);
FUNC_PREFIX void OMset_my_proc_name (OMobj_name proc_name);
FUNC_PREFIX OMobj_id OMdefault_process (void);

/* defined in compile.c */
FUNC_PREFIX char *OMget_project_path (int path_index, char *buf);
FUNC_PREFIX int OMproject_is_editable (char *path);
FUNC_PREFIX int OMproject_is_compileable (void);
FUNC_PREFIX void OMget_src_files (OMobj_id elem_id, int *nfiles, char **files,
			     int max_files);
FUNC_PREFIX int OMcompile_obj (OMobj_id elem_id, int);
FUNC_PREFIX int OMgen_code (OMobj_id elem_id, OMcomp_proc *proc, int mode);
FUNC_PREFIX int OMbuild_project_subset (char *,int,OMobj_id *,int, OMobj_id *,int);

/* defined in xp_init.c and mnini.c */
#ifdef MSDOS

/* maximum number of argc/v args */
#define OM_MAX_ARGS 30

int PASCAL OMmain_init(HINSTANCE, HINSTANCE, LPSTR, int);
void OMpre_init (HINSTANCE, HINSTANCE, LPSTR, int,
		 int *, char **, char **, int *, int *);
void OMbase_init (int, char **, int *);
void OMfinish_init (int, char **, char **, int *, int);
#else
int OMmain_init (int argc, char **argv);
void OMpre_init (int *argc, char **argv,
			char **app, int *vcp, int *do_exit);
void OMbase_init (int argc, char **argv, int *do_exit);
void OMfinish_init (int argc, char **argv,
			char **app, int *vcp, int do_exit);
#endif

/* defined in sys.c */
#ifdef WIN32
#define plat_WIN32S 1
#define plat_WIN95  2
#define plat_WINNT  3

extern   void OMGetOSVersion (LPINT pPlatform, LPINT pMajor, LPINT pMinor);

#endif /* WIN32 */

/* defined in binv.c */
FUNC_PREFIX int OMbsave_objs (xp_long nobjs, OMobj_id *obj_id_list, int nexs,
			 OMobj_id *ex_id_list, const char *file_name, int mode);
FUNC_PREFIX HPheap *OMbgen_objs (xp_long nobjs, OMobj_id *obj_id_list, int nexs,
			    OMobj_id *ex_id_list, int *num_extra,
			    HPheap ***extra_heaps, int mode);
FUNC_PREFIX int OMbrestore_objs (OMobj_id parent_id, HPheap *file_heap,
				const char *file, int mode);
FUNC_PREFIX int OMbrestore_objs_list (OMobj_id parent_id, HPheap *file_heap,
				const char *file, xp_long *ret_nobjs,
				OMobj_id **ret_obj_list, int mode);
FUNC_PREFIX int OMbrestore_stream (OMobj_id parent_id, FILE *fp,
				const char *file, int mode);

FUNC_PREFIX OMobj_id OMget_local_copy (OMobj_id, int );

FUNC_PREFIX int OMbrestore_mem (OMobj_id parent_id, char *ptr, int mode);
FUNC_PREFIX int OMopen_file (OMobj_id obj_id, const char *user_file, int mode);

/* Defined in msg.c */
FUNC_PREFIX void OMstart_journal_op (char *, int *);
FUNC_PREFIX void OMstart_journal_op_exec (char *, int *, int);
FUNC_PREFIX void OMend_journal_op (int *);
FUNC_PREFIX int OMjournal_enabled(void);
FUNC_PREFIX void OMoutput_journal_op (char *journal_string);

/* Defined in excxx.c */
FUNC_PREFIX char *OMret_obj_cxx_name (OMcomp_proc *, OMobj_id, char *, int);
FUNC_PREFIX int OMget_user_classes(OMobj_id obj_id, OMobj_id *base_classes, int *num_base_classes, int max_num, int mode, int class_mode);

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
   #define	OMsave_obj			OMsave_obj_n
   #define 	OMget_array			OMget_array_n
   #define	OMget_array_sz			OMget_array_sz_n
   #define 	OMget_sub_barray		OMget_sub_barray_n
   #define 	OMget_sub_sarray		OMget_sub_sarray_n
   #define 	OMget_sub_iarray		OMget_sub_iarray_n
   #define 	OMget_sub_rarray		OMget_sub_rarray_n
   #define 	OMget_sub_farray		OMget_sub_farray_n
   #define	OMset_sub_barray		OMset_sub_barray_n
   #define	OMset_sub_sarray		OMset_sub_sarray_n
   #define	OMset_sub_iarray		OMset_sub_iarray_n
   #define	OMset_sub_farray		OMset_sub_farray_n
   #define	OMset_sub_rarray		OMset_sub_rarray_n
   #define	OMget_array_size 		OMget_array_size_n
   #define	OMget_array_dims		OMget_array_dims_n
   #define	OMget_num_subobjs		OMget_num_subobjs_n
   #define	OMget_num_subobjs_mode	OMget_num_subobjs_mode_n
   #define	OMget_num_refs			OMget_num_refs_n
   #define	OMcvt_sub_array		OMcvt_sub_array_n
   #define	OMprint_array			OMprint_array_n
   #define	OMget_running_obj_list	OMget_running_obj_list_n
   #define	OMset_array_dims		OMset_array_dims_n
   #define	OMget_list_prod		OMget_list_prod_n
   #define	OMret_array_ptr		OMret_array_ptr_n
   #define	OMret_name_array_ptr	OMret_name_array_ptr_n
   #define	OMret_typed_array_ptr	OMret_typed_array_ptr_n
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
