/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/om_type.h#1 $
*/
#ifndef OM_TYPE_INCLUDED
#define OM_TYPE_INCLUDED
/*
 * This file contains definitions required by code that defines or
 * manipulates base types.
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef  FUNC_PREFIX
#undef  FUNC_PREFIX
#define FUNC_PREFIX DLL_EXPORT
#endif

#ifdef OM_TYPE_DEFINE_GLOBALS
#define OM_TYPE_EXTERN
#else
#ifdef XP_INTERNAL_GLOBALS
#define OM_TYPE_EXTERN extern
#else
#define OM_TYPE_EXTERN DLL_IMPORT
#undef  FUNC_PREFIX
#define FUNC_PREFIX DLL_IMPORT
#endif
#endif

OM_TYPE_EXTERN
OMtype_id OM_type_comp, OM_type_macro,
	  OM_type_prim, OM_type_list, OM_type_nplist, OM_type_val_list,
	  OM_type_ex_list, OM_type_array_list, OM_type_library, OM_type_arith,
	  OM_type_iarith, OM_type_larith,
	  OM_type_add, OM_type_sub, OM_type_multiply, OM_type_divide,
	  OM_type_modulo, OM_type_and, OM_type_or, OM_type_xor,
	  OM_type_add_rw, OM_type_multiply_rw,
	  OM_type_equals, OM_type_not_equals,OM_type_less_than, OM_type_gt_than,
	  OM_type_lt_equals, OM_type_gt_equals, OM_type_andand, OM_type_oror,
	  OM_type_raw_int, OM_type_const_raw_int, OM_type_null_dim,
	  OM_type_modulo, OM_type_and, OM_type_or, OM_type_xor,
	  OM_type_not, OM_type_complement,
	  OM_type_raw_int, OM_type_const_raw_int,
	  OM_type_raw_long, OM_type_const_raw_long,
	  OM_type_raw_real, OM_type_raw_str, OM_type_raw_ptr,
	  OM_type_comment,
	  OM_type_raw_array, OM_type_ref_obj,
#if 0
	  OM_type_ptr_obj,
#endif
	  OM_type_raw_obj, OM_type_name_obj, OM_type_op,
	  OM_type_func, OM_type_afunc, OM_type_base_func,
	  OM_type_inst_func, OM_type_atts, OM_type_group, OM_type_file_group,
	  OM_type_char, OM_type_byte, OM_type_short, OM_type_int, OM_type_long,
	  OM_type_boolean,
	  OM_type_float, OM_type_double, OM_type_string, OM_type_ptr,
	  OM_type_val_func, OM_type_merge, OM_type_method, OM_type_data_method,
	  OM_type_omethod, OM_type_fmethod,
	  OM_type_link, OM_type_ilink, OM_type_olink,
	  OM_type_mlink, OM_type_imlink, OM_type_omlink, OM_type_vmlink,
	  OM_type_iarray_func, OM_type_larray_func, OM_type_rarray_func, OM_type_farray_func,
	  OM_type_real_func, OM_type_range,
	  OM_type_sort, OM_type_prod, OM_type_sum, OM_type_array_size,
	  OM_type_switch, OM_type_cmethod, OM_type_cxxmethod,
	  OM_type_buffer, OM_type_buffered, OM_type_param_list,
	  OM_type_meth_param, OM_type_bin_buffer, OM_type_standin,
	  OM_type_scheduler, OM_type_notifier,
	  OM_type_root, OM_type_application, OM_type_module, OM_type_enum;

OM_TYPE_EXTERN
OMtype_id OM_type_global, OM_type_flibrary, OM_type_process;

OM_TYPE_EXTERN
OMobj_name OM_name_min, OM_name_max, OM_name_value, OM_name_type,
	    OM_name_dims, OM_name_params, OM_name_members, OM_name_ctx,
	    OM_name_call_data, OM_name_uparrow, OM_name_abspath,
	    OM_name_values, OM_name_choices;

OM_TYPE_EXTERN
OMobj_name OM_prop_type, OM_prop_path_name, OM_prop_host_name, OM_prop_debug,
	    OM_prop_struct_name, OM_prop_struct_bitmask, OM_prop_cfunction,
	    OM_prop_constructor_func, OM_prop_destructor_func,
	    OM_prop_src_dir, OM_prop_inc_dir, OM_prop_inc_files,
	    OM_prop_out_inc_file,
	    OM_prop_cptr, OM_prop_cptr_list, OM_prop_init_func,
	    OM_prop_modified, OM_prop_unmanaged;

/* Use internal names to prevent conflicts with user names */
#define OM_NAME_DIMS "_DB_dims"
#define OM_NAME_TYPE "_DB_type"
#define OM_NAME_VALUE "_DB_value"
#define OM_NAME_PARAMS "_DB_params"
#define OM_NAME_MEMBERS "_DB_members"
#define OM_NAME_CTX "_DB_ctx"
#define OM_NAME_ABSPATH "_DB_abspath"

#define OM_PROP_TYPE "_OM_prop_type"

/*
 * Value types for prim objects storing their values locally.
 * A value type of 0 either means that the value is unset or
 * that it is set to an OMobj_id instead of a primitive value
 */
#define OM_VAL_TYPE_INT 1
#define OM_VAL_TYPE_LONG 2
#define OM_VAL_TYPE_STRING 3
#define OM_VAL_TYPE_REAL 4
#define OM_VAL_TYPE_PTR 5

/*
 * Structures used in element type definitions.
 */
typedef struct _OMname_ref {
   OMobj_name name;
   OMobj_id cache_val; /* cached value... */
   OMobj_id dims;      /* any dims specified */
   unsigned int ptr_val:1;  /* True if this path-entry is a ref.. not val */
   unsigned int path_list:1;
   unsigned int dims_ref:1; /* array list paths don't re-add the notify */
   unsigned int nofree:1;
   struct _OMname_ref *next;
   union {
      struct _OM_nm_sclr {
	 OMobj_id cache_arr_val;/* array value */
      } n;
      struct _OM_nm_arry {
	 xp_long sz;
	 struct _OMname_ref *list_paths;
      } a;
   } n;
} OMname_ref;

typedef struct _OMsave_name_ref {
   DTlong name;
   OMobj_id cache_val; /* cached value... */
   OMobj_id dims;      /* any dims specified */
   DTint path_info; /* ptr_val, path_list, dims_ref */
   DTlong next;
   union {
      struct _OM_snm_sclr {
	 OMobj_id cache_arr_val;/* array value */
      } n;
      struct _OM_snm_arry {
	 xp_long sz;
	 DTlong list_paths;
      } a;
   } n;
} OMsave_name_ref;

/* Used to store a list of element references that also store the name */
typedef struct _OMlist_obj_ref {
   OMobj_id    elem;
   OMobj_name  name;
   unsigned int sub_libs:1;
   unsigned int nofree:1;
   unsigned int ref_child:1;
} OMlist_obj_ref;

typedef struct _OM_list_upd_struct {
   OMobj_id elem_id;
} OM_list_upd_struct;

typedef struct _OMproc_func {
   OMobj_name name;
   unsigned int ex_mask;
   int refcnt;
} OMproc_func;

typedef struct _OMproc_obj_ref {
   OMobj_id elem_id;
   OMobj_id parent_id;
   OMobj_id templ_id;
   unsigned int derived:1;
   struct _OMproc_obj_ref *next;
} OMproc_obj_ref;

/* ---------------- Element structures ---------------- */

typedef struct _OMraw_int_obj {
#include <avs/edf/om_rint.edf>
} OMraw_int_obj;

typedef struct _OMraw_long_obj {
#include <avs/edf/om_rlong.edf>
} OMraw_long_obj;

typedef struct _OMraw_str_obj {
#include <avs/edf/om_rstr.edf>
} OMraw_str_obj;

typedef struct _OMraw_real_obj {
#include <avs/edf/om_rreal.edf>
} OMraw_real_obj;

typedef struct _OMraw_array_obj {
#include <avs/edf/om_array.edf>
} OMraw_array_obj;

typedef struct _OMraw_ptr_obj {
#include <avs/edf/om_rptr.edf>
} OMraw_ptr_obj;

typedef struct _OMlist_obj {
#include <avs/edf/om_list.edf>
} OMlist_obj;

typedef struct _OMcomp_obj {
#include <avs/edf/om_comp.edf>
} OMcomp_obj;

typedef struct _OMgroup_obj {
#include <avs/edf/om_grp.edf>
} OMgroup_obj;

typedef struct _OMname_obj {
#include <avs/edf/om_name.edf>
} OMname_obj;

typedef struct _OMmlink_obj {
#include <avs/edf/om_mlink.edf>
} OMmlink_obj;

typedef struct _OMfunc_obj {
#include <avs/edf/om_func.edf>
} OMfunc_obj;

typedef struct _OMvirt_obj {
#include <avs/edf/om_virt.edf>
} OMvirt_obj;

typedef struct _OMmeth_obj {
#include <avs/edf/om_meth.edf>
} OMmeth_obj;

typedef struct _OMprocess_obj {
#include <avs/edf/om_proc.edf>
} OMprocess_obj;

typedef struct _OMraw_obj {
#include <avs/edf/om_robj.edf>
} OMraw_obj;

typedef struct _OMbuffer_obj {
#include <avs/edf/om_elem.edf>
   OMtype_id bf_base_type;
   int bf_nbase_objs;
   OMobj_id *bf_base_objs;
   char *bf_buffer;
   int bf_start_line;
   char *bf_file;
   int bf_ref_mode;
   unsigned int bf_base_alloced:1;
} OMbuffer_obj;

/* -------------------- Binary Save Structures ----------------- */

#include <avs/dtx.h>

typedef struct _OMsobj {
#include <avs/edf/sm_elem.edf>
} OMsobj;

typedef struct _OMcomp_sobj {
#include <avs/edf/sm_comp.edf>
} OMcomp_sobj;

typedef struct _OMprim_sobj {
#include <avs/edf/sm_prim.edf>
} OMprim_sobj;

typedef struct _OMgroup_sobj {
#include <avs/edf/sm_grp.edf>
} OMgroup_sobj;

typedef struct _OMraw_int_sobj {
#include <avs/edf/sm_rint.edf>
} OMraw_int_sobj;

typedef struct _OMraw_long_sobj {
#include <avs/edf/sm_rlong.edf>
} OMraw_long_sobj;

typedef struct _OMname_sobj {
#include <avs/edf/sm_name.edf>
} OMname_sobj;

typedef struct _OMlist_sobj {
#include <avs/edf/sm_list.edf>
} OMlist_sobj;

typedef struct _OMraw_real_sobj {
#include <avs/edf/sm_rreal.edf>
} OMraw_real_sobj;

typedef struct _OMraw_str_sobj {
#include <avs/edf/sm_rstr.edf>
} OMraw_str_sobj;

typedef struct _OMraw_array_sobj {
#include <avs/edf/sm_array.edf>
} OMraw_array_sobj;

typedef struct _OMfunc_sobj {
#include <avs/edf/sm_func.edf>
} OMfunc_sobj;

typedef struct _OMmeth_sobj {
#include <avs/edf/sm_meth.edf>
} OMmeth_sobj;

typedef struct _OMraw_sobj {
#include <avs/edf/sm_robj.edf>
} OMraw_sobj;

typedef struct _OMmlink_sobj {
#include <avs/edf/sm_mlink.edf>
} OMmlink_sobj;

typedef struct _OMbuffer_sobj {
#include <avs/edf/sm_elem.edf>
   DTlong bf_base_type;
   DTint bf_nbase_objs;
   DTlong bf_base_objs;
   DTlong bf_buffer;
   DTint bf_start_line;
   DTlong bf_file;
   DTint bf_ref_mode;
} OMbuffer_sobj;

/* --------------------- Element Methods ------------------------ */

FUNC_PREFIX int OMobj_get_subobj_list (OMobj_id, OMobj_list **, int);
FUNC_PREFIX void OMobj_push_obj_ctx_clnt (OMobj_id, int, int, int, int, int *);
FUNC_PREFIX void OMobj_pop_obj_ctx_clnt (OMobj_id, int, int *);
FUNC_PREFIX int	OMobj_close_obj (OMobj_id);
FUNC_PREFIX int	OMobj_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX int	OMobj_compile_obj (OMobj_id, int);
FUNC_PREFIX char *OMobj_ret_obj_path_to (OMobj_id , OMobj_id, char *, int, int);
FUNC_PREFIX int	OMobj_get_array_size (OMobj_id, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMobj_get_array_size_n (OMobj_id, int *);
#endif
FUNC_PREFIX int	OMobj_del_obj_refs_to (OMobj_id, int);
FUNC_PREFIX int OMobj_bsave_obj (OMobj_id obj_id, OMsave_bfile_obj *file_obj,
			        HPheap *curr_heap, OMobj_id *ret_heap_id,
				int mode);
FUNC_PREFIX int OMobj_set_needed (OMobj_id, char *, int, int *, int);
FUNC_PREFIX int	OMobj_add_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMobj_cleanup_obj_proc_id (OMobj_id, OMproc_id);
FUNC_PREFIX int OMobj_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMobj_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMobj_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int	OMobj_links_to (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMobj_get_dynlib_func_val (OMobj_id, char *, OMpfi *);

FUNC_PREFIX int OMcomp_create_obj (OMobj_id);
FUNC_PREFIX int OMcomp_set_obj_type (OMobj_id, OMtype_id);
FUNC_PREFIX int OMcomp_save_obj (OMobj_id, OMobj_id, int, int, char **, xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMcomp_save_obj_n (OMobj_id, OMobj_id, int, int, char **, int*);
#endif
FUNC_PREFIX int OMcomp_insert_subobj (OMobj_id, xp_long, OMobj_id, OMobj_name,int);
FUNC_PREFIX int OMcomp_del_subobj (OMobj_id, OMobj_id,int);
FUNC_PREFIX OMobj_id OMcomp_find_subobj (OMobj_id, OMobj_name,int);
FUNC_PREFIX int OMcomp_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMcomp_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMcomp_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int OMcomp_set_str_array_val (OMobj_id, xp_long, const char *);
FUNC_PREFIX int OMcomp_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);
FUNC_PREFIX int OMcomp_get_num_subobjs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMcomp_get_num_subobjs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMcomp_get_array_subobj (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMcomp_get_num_refs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMcomp_get_num_refs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int	OMcomp_del_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMcomp_get_array_ref (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMcomp_get_obj_ref_mode (OMobj_id, int *);
FUNC_PREFIX int	OMcomp_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMcomp_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int OMcomp_set_obj_prop (OMobj_id, OMobj_name, OMobj_id);
FUNC_PREFIX int OMcomp_bsave_obj (OMobj_id obj_id, OMsave_bfile_obj *file_obj,
			     HPheap *curr_heap,
			     OMobj_id *ret_heap_id, int mode);
FUNC_PREFIX int OMcomp_brestore_obj (OMrestore_bfile_obj *file_obj,
				    OMobj_id parent_id, OMobj_id heap_id,
				    OMobj_id *ret_obj_id, int mode);

FUNC_PREFIX int OMgroup_create_obj (OMobj_id);
FUNC_PREFIX int OMgroup_destroy_obj (OMobj_id);
FUNC_PREFIX int OMgroup_save_obj (OMobj_id, OMobj_id, int, int, char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMgroup_save_obj_n (OMobj_id, OMobj_id, int, int, char **,int *);
#endif
FUNC_PREFIX int OMgroup_save_obj_hdr (OMobj_id, char *, int, int);
FUNC_PREFIX int OMgroup_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgroup_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMgroup_insert_subobj (OMobj_id, xp_long, OMobj_id,OMobj_name,int);
FUNC_PREFIX int OMgroup_del_subobj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgroup_upd_subobj (OMobj_id, OMobj_id, OMobj_name,int);
FUNC_PREFIX OMobj_id OMgroup_find_subobj (OMobj_id, OMobj_name,int);
FUNC_PREFIX int OMgroup_get_num_subobjs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMgroup_get_num_subobjs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMgroup_get_array_subobj (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMgroup_get_subobj_list (OMobj_id, OMobj_list **, int);
FUNC_PREFIX OMobj_id OMgroup_get_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMgroup_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgroup_inherit_class (OMobj_id, OMobj_id);
FUNC_PREFIX int OMgroup_is_subclass_of (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMgroup_get_num_classes (OMobj_id, int *, int);
FUNC_PREFIX int	OMgroup_get_array_class (OMobj_id, int, OMobj_id *, int);
FUNC_PREFIX int OMgroup_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMgroup_set_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMgroup_get_obj_val (OMobj_id, OMobj_id *);
FUNC_PREFIX int OMgroup_get_obj_pval (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMgroup_set_array_val (OMobj_id, xp_long, OMobj_id);
FUNC_PREFIX int OMgroup_get_array_val (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int OMgroup_del_array_val (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMgroup_add_obj_notify_req (OMobj_id, OMobj_id, OMobj_id,
				      unsigned int, int);
FUNC_PREFIX int	OMgroup_del_obj_notify_req (OMobj_id, OMobj_id, OMobj_id,
				      unsigned int, int);
FUNC_PREFIX int	OMgroup_reset_obj (OMobj_id, int);
FUNC_PREFIX int	OMgroup_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMgroup_set_obj_att (OMobj_id, OMobj_name, int, int);
FUNC_PREFIX int OMgroup_set_obj_prop (OMobj_id, OMobj_name, OMobj_id);
FUNC_PREFIX int OMgroup_set_obj_iprop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMgroup_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX char *OMgroup_ret_obj_path_to (OMobj_id, OMobj_id, char *, int, int);
FUNC_PREFIX int	OMgroup_del_obj_refs_to (OMobj_id, int);
FUNC_PREFIX int	OMgroup_set_obj_ref_mode (OMobj_id, int);
FUNC_PREFIX int OMgroup_bsave_obj (OMobj_id obj_id, OMsave_bfile_obj *file_obj,
			         HPheap *curr_heap,
				 OMobj_id *ret_heap_id, int mode);
FUNC_PREFIX int OMgroup_brestore_obj (OMrestore_bfile_obj *file_obj,
				     OMobj_id parent_id, OMobj_id heap_id,
				     OMobj_id *ret_obj_id, int mode);
FUNC_PREFIX int OMgroup_set_needed (OMobj_id, char *, int, int *, int);
FUNC_PREFIX int	OMgroup_cleanup_obj_proc_id (OMobj_id, OMproc_id);

FUNC_PREFIX int OMfile_group_save_obj (OMobj_id, OMobj_id, int, int, char **, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMfile_group_save_obj_n (OMobj_id, OMobj_id, int, int, char **, int *);
#endif

FUNC_PREFIX int OMroot_insert_subobj (OMobj_id, xp_long, OMobj_id, OMobj_name,int);
FUNC_PREFIX int OMfile_group_get_num_subobjs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMfile_group_get_num_subobjs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMfile_group_get_array_subobj (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX OMobj_id OMfile_group_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMfile_group_get_subobj_list (OMobj_id, OMobj_list **, int);
FUNC_PREFIX int OMfile_group_set_needed (OMobj_id, char *, int, int *, int);
FUNC_PREFIX int	OMfile_group_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX int	OMfile_group_reset_obj (OMobj_id, int);
FUNC_PREFIX OMobj_id OMfile_group_get_obj_by_name (OMobj_id, OMobj_name, int *, int);

FUNC_PREFIX int OMprim_destroy_obj (OMobj_id);
FUNC_PREFIX int OMprim_insert_subobj (OMobj_id, xp_long, OMobj_id,OMobj_name,int);
FUNC_PREFIX int OMprim_copy_obj (OMobj_id,OMobj_id,int);
FUNC_PREFIX int	OMprim_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMprim_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMprim_insert_obj_ref (OMobj_id, xp_long, OMobj_id, int);
FUNC_PREFIX OMobj_id OMprim_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMprim_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX void OMprim_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMprim_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMprim_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMprim_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX void OMboolean_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMboolean_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMprim_set_real_val (OMobj_id, double);
FUNC_PREFIX int OMprim_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMprim_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int OMprim_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int OMprim_set_ptr_val (OMobj_id, void *, int);
FUNC_PREFIX int OMprim_get_ptr_val (OMobj_id, void **, int);
FUNC_PREFIX int OMprim_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMprim_set_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMprim_get_obj_val (OMobj_id, OMobj_id *);
FUNC_PREFIX int OMprim_get_obj_pval (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMprim_set_array (OMobj_id, int, char *, xp_long, int);
FUNC_PREFIX int OMprim_get_array (OMobj_id, int *, char **,int *, xp_long *,int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMprim_get_array_n (OMobj_id, int *, char **,int *, int *,int);
#endif
FUNC_PREFIX int	OMprim_set_data_type (OMobj_id, int);
FUNC_PREFIX int	OMprim_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMprim_set_obj_ref_mode (OMobj_id, int);
FUNC_PREFIX int	OMprim_add_obj_notify_req (OMobj_id, OMobj_id,
				      OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMprim_del_obj_notify_req (OMobj_id, OMobj_id,
				      OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMprim_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMprim_resolve_obj (OMobj_id, int);

FUNC_PREFIX int	OMprim_get_sub_barray (OMobj_id, int, xp_long*,xp_long*,xp_long*,
					  unsigned char*);
FUNC_PREFIX int	OMprim_get_sub_sarray (OMobj_id, int, xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMprim_get_sub_iarray (OMobj_id, int, xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMprim_get_sub_larray (OMobj_id, int, xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMprim_get_sub_farray (OMobj_id, int, xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMprim_get_sub_rarray (OMobj_id, int, xp_long*,xp_long*,xp_long*,double*);
FUNC_PREFIX int	OMprim_set_sub_barray (OMobj_id, int, xp_long*,xp_long*,xp_long*,
					  unsigned char*);
FUNC_PREFIX int	OMprim_set_sub_sarray (OMobj_id, int, xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMprim_set_sub_iarray (OMobj_id, int, xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMprim_set_sub_larray (OMobj_id, int, xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMprim_set_sub_farray (OMobj_id, int, xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMprim_set_sub_rarray (OMobj_id, int, xp_long*,xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMprim_get_sub_barray_n (OMobj_id, int, int*,int*,int*,
					  unsigned char*);
FUNC_PREFIX int	OMprim_get_sub_sarray_n (OMobj_id, int, int*,int*,int*,short*);
FUNC_PREFIX int	OMprim_get_sub_iarray_n (OMobj_id, int, int*,int*,int*,int*);
FUNC_PREFIX int	OMprim_get_sub_farray_n (OMobj_id, int, int*,int*,int*,float*);
FUNC_PREFIX int	OMprim_get_sub_rarray_n (OMobj_id, int, int*,int*,int*,double*);
FUNC_PREFIX int	OMprim_set_sub_barray_n (OMobj_id, int, int*,int*,int*,
					  unsigned char*);
FUNC_PREFIX int	OMprim_set_sub_sarray_n (OMobj_id, int, int*,int*,int*,short*);
FUNC_PREFIX int	OMprim_set_sub_iarray_n (OMobj_id, int, int*,int*,int*,int*);
FUNC_PREFIX int	OMprim_set_sub_farray_n (OMobj_id, int, int*,int*,int*,float*);
FUNC_PREFIX int	OMprim_set_sub_rarray_n (OMobj_id, int, int*,int*,int*,double*);
#endif

FUNC_PREFIX int OMprim_bsave_obj (OMobj_id obj_id, OMsave_bfile_obj *file_obj,
			        HPheap *curr_heap, OMobj_id *ret_heap_id,
				int mode);
FUNC_PREFIX int OMprim_brestore_obj (OMrestore_bfile_obj *file_obj,
				    OMobj_id parent_id, OMobj_id heap_id,
				    OMobj_id *ret_obj_id, int mode);
FUNC_PREFIX int	OMprim_links_to (OMobj_id, OMobj_id, int);

FUNC_PREFIX int	OMptr_get_array_val (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX void OMptr_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX void OMptr_set_long_val (OMobj_id, xp_long, int, int *);

FUNC_PREFIX int OMlist_destroy_obj (OMobj_id);
FUNC_PREFIX int OMlist_insert_subobj (OMobj_id, xp_long, OMobj_id, OMobj_name,int);
FUNC_PREFIX int OMex_list_insert_subobj (OMobj_id,xp_long,OMobj_id,OMobj_name,int);
FUNC_PREFIX int OMlist_del_subobj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMlist_upd_subobj (OMobj_id, OMobj_id, OMobj_name, int);
FUNC_PREFIX OMobj_id OMlist_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMlist_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMlist_get_num_subobjs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMlist_get_num_subobjs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMlist_get_array_subobj (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMlist_get_subobj_list (OMobj_id, OMobj_list **, int);
FUNC_PREFIX int OMlist_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMlist_set_array (OMobj_id, int, char *, xp_long, int);
FUNC_PREFIX int OMlist_get_array (OMobj_id, int *, char **, int *, xp_long *,int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMlist_get_array_n (OMobj_id, int *, char **, int *, int *,int);
#endif
FUNC_PREFIX int OMlist_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMlist_get_array_size (OMobj_id, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMlist_get_array_size_n (OMobj_id, int *);
#endif
FUNC_PREFIX int OMlist_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMlist_get_array_dims_n (OMobj_id, int *, int *);
#endif
FUNC_PREFIX int OMlist_set_array_val (OMobj_id, xp_long, OMobj_id);
FUNC_PREFIX int OMlist_get_array_val (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int OMlist_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMlist_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMlist_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int	OMlist_set_str_array_val (OMobj_id, xp_long, const char *);
FUNC_PREFIX int	OMlist_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);
FUNC_PREFIX int	OMlist_get_obj_data (OMobj_id, int,
				void (*)(char *, int, char *, int,int,int,int),
				char *);
FUNC_PREFIX int OMlist_bsave_obj (OMobj_id obj_id, OMsave_bfile_obj *file_obj,
			     HPheap *curr_heap,
			     OMobj_id *ret_heap_id, int mode);
FUNC_PREFIX int OMlist_brestore_obj (OMrestore_bfile_obj *file_obj,
				    OMobj_id parent_id, OMobj_id heap_id,
				    OMobj_id *ret_obj_id, int mode);

FUNC_PREFIX int OMnplist_destroy_obj (OMobj_id);
FUNC_PREFIX int OMnplist_set_array_val (OMobj_id, xp_long, OMobj_id);

FUNC_PREFIX OMobj_id OMvlist_find_subobj (OMobj_id, OMobj_name,int);

FUNC_PREFIX int OMflibrary_save_obj (OMobj_id, OMobj_id,int,int,char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMflibrary_save_obj_n (OMobj_id, OMobj_id,int,int,char **,int *);
#endif

FUNC_PREFIX int	OMmacro_create_obj (OMobj_id);
FUNC_PREFIX int	OMmacro_close_obj (OMobj_id);

/* Method for all arithmetic operations */
FUNC_PREFIX int OMarith_get_data_type (OMobj_id, int *);
FUNC_PREFIX int OMarith_get_array_size (OMobj_id, xp_long *);
FUNC_PREFIX int	OMarith_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMarith_get_array_dims_n (OMobj_id, int *, int *);
#endif
FUNC_PREFIX int	OMarith_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMarith_save_obj (OMobj_id, OMobj_id, int, int, char **, xp_long*);
FUNC_PREFIX int OMuarith_save_obj (OMobj_id, OMobj_id, int, int,char **, xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMarith_save_obj_n (OMobj_id, OMobj_id, int, int, char **, int*);
FUNC_PREFIX int OMuarith_save_obj_n (OMobj_id, OMobj_id, int, int,char **, int*);
#endif

FUNC_PREFIX int	OMadd_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMadd_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMadd_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMadd_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int OMadd_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);
FUNC_PREFIX int	OMadd_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMadd_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int	OMadd_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int	OMadd_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMadd_get_sub_larray (OMobj_id, int, xp_long*, xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMadd_get_sub_rarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMadd_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
FUNC_PREFIX int	OMadd_get_sub_rarray_n (OMobj_id, int, int*, int*,int*,double*);
#endif
FUNC_PREFIX void OMadd_rw_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX void OMadd_rw_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMadd_rw_set_real_val (OMobj_id, double);

FUNC_PREFIX int	OMsub_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMsub_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMsub_get_real_val (OMobj_id, double *);
FUNC_PREFIX int	OMsub_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMsub_get_sub_larray (OMobj_id, int, xp_long*, xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMsub_get_sub_rarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMsub_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
FUNC_PREFIX int	OMsub_get_sub_rarray_n (OMobj_id, int, int*, int*,int*,double*);
#endif
FUNC_PREFIX int	OMsub_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMsub_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int	OMsub_get_rarray_val (OMobj_id, xp_long, double *);

FUNC_PREFIX int	OMmultiply_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMmultiply_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMmultiply_get_real_val (OMobj_id, double *);
FUNC_PREFIX int	OMmultiply_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMmultiply_get_sub_larray (OMobj_id, int, xp_long*, xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMmultiply_get_sub_rarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMmultiply_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
FUNC_PREFIX int	OMmultiply_get_sub_rarray_n (OMobj_id, int, int*, int*,int*,double*);
#endif
FUNC_PREFIX int	OMmultiply_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMmultiply_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int	OMmultiply_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX void OMmultiply_rw_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX void OMmultiply_rw_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMmultiply_rw_set_real_val (OMobj_id, double);

FUNC_PREFIX int	OMdivide_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMdivide_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMdivide_get_real_val (OMobj_id, double *);
FUNC_PREFIX int	OMdivide_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMdivide_get_sub_larray (OMobj_id, int, xp_long*, xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMdivide_get_sub_rarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMdivide_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
FUNC_PREFIX int	OMdivide_get_sub_rarray_n (OMobj_id, int, int*, int*,int*,double*);
#endif
FUNC_PREFIX int	OMdivide_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMdivide_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int	OMdivide_get_rarray_val (OMobj_id, xp_long, double *);

FUNC_PREFIX int	OMmodulo_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMmodulo_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMmodulo_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMmodulo_get_sub_larray   (OMobj_id, int, xp_long*, xp_long*,xp_long*,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMmodulo_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif
FUNC_PREFIX int	OMmodulo_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMmodulo_get_larray_val (OMobj_id, xp_long, xp_long *);

FUNC_PREFIX int	OMand_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMand_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMand_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMand_get_sub_larray (OMobj_id, int, xp_long*, xp_long*, xp_long*, xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMand_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif
FUNC_PREFIX int	OMand_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMand_get_larray_val (OMobj_id, xp_long, xp_long *);

FUNC_PREFIX int	OMor_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMor_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMor_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMor_get_sub_larray (OMobj_id, int, xp_long*, xp_long*, xp_long*, xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMor_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif
FUNC_PREFIX int	OMor_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMor_get_larray_val (OMobj_id, xp_long, xp_long *);

FUNC_PREFIX int	OMxor_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMxor_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMxor_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMxor_get_sub_larray (OMobj_id, int, xp_long*, xp_long*, xp_long*, xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMxor_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif
FUNC_PREFIX int	OMxor_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int	OMxor_get_larray_val (OMobj_id, xp_long, xp_long *);

FUNC_PREFIX int	OMequals_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMequals_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMequals_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif

FUNC_PREFIX int	OMnot_equals_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMnot_equals_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMnot_equals_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif

FUNC_PREFIX int	OMless_than_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMless_than_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMless_than_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif


FUNC_PREFIX int	OMgt_than_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMgt_than_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMgt_than_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif


FUNC_PREFIX int	OMlt_equals_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMlt_equals_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMlt_equals_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif


FUNC_PREFIX int	OMgt_equals_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMgt_equals_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMgt_equals_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif


FUNC_PREFIX int	OMandand_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMandand_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMandand_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif

FUNC_PREFIX int	OMoror_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMoror_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMoror_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif

FUNC_PREFIX void OMnot_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int	OMnot_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMnot_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMnot_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif

FUNC_PREFIX int	OMcomplement_get_int_val (OMobj_id, int *);
FUNC_PREFIX int	OMcomplement_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMcomplement_get_sub_iarray (OMobj_id, int, xp_long*, xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMcomplement_get_sub_larray   (OMobj_id, int, xp_long*, xp_long*,xp_long*,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMcomplement_get_sub_iarray_n (OMobj_id, int, int*, int*,int*,int*);
#endif

FUNC_PREFIX int OMscalar_get_array (OMobj_id, int *, char **,int *, xp_long*,int);
FUNC_PREFIX int	OMscalar_get_sub_barray (OMobj_id, int,xp_long*,xp_long*,xp_long*,
					  unsigned char *);
FUNC_PREFIX int	OMscalar_get_sub_sarray (OMobj_id, int,xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMscalar_get_sub_iarray (OMobj_id, int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMscalar_get_sub_larray   (OMobj_id, int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMscalar_get_sub_farray (OMobj_id, int,xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMscalar_get_sub_rarray (OMobj_id, int,xp_long*,xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMscalar_get_array_n (OMobj_id, int *, char **,int *, int*,int);
FUNC_PREFIX int	OMscalar_get_sub_barray_n (OMobj_id, int,int*,int*,int*,
					  unsigned char *);
FUNC_PREFIX int	OMscalar_get_sub_sarray_n (OMobj_id, int,int*,int*,int*,short*);
FUNC_PREFIX int	OMscalar_get_sub_iarray_n (OMobj_id, int,int*,int*,int*,int*);
FUNC_PREFIX int	OMscalar_get_sub_farray_n (OMobj_id, int,int*,int*,int*,float*);
FUNC_PREFIX int	OMscalar_get_sub_rarray_n (OMobj_id, int,int*,int*,int*,double*);
#endif
FUNC_PREFIX int OMscalar_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMscalar_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMscalar_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int	OMscalar_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMscalar_get_array_dims_n (OMobj_id, int *, int *);
#endif

FUNC_PREFIX int OMraw_int_save_obj (OMobj_id, OMobj_id, int,int,char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMraw_int_save_obj_n (OMobj_id, OMobj_id, int,int,char **,int *);
#endif
FUNC_PREFIX void OMraw_int_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMraw_int_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMraw_int_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMraw_int_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMraw_int_set_real_val (OMobj_id, double);
FUNC_PREFIX int OMraw_int_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMraw_int_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_int_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMraw_int_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMraw_int_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int OMraw_int_bsave_obj (OMobj_id obj_id,
				OMsave_bfile_obj *file_obj, HPheap *curr_heap,
				OMobj_id *ret_heap_id, int mode);
FUNC_PREFIX int OMraw_int_brestore_obj (OMrestore_bfile_obj *file_obj,
				OMobj_id parent_id, OMobj_id heap_id,
				OMobj_id *ret_obj_id, int mode);

FUNC_PREFIX int     OMconst_raw_int_copy_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int     OMconst_raw_int_copy_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int     OMconst_raw_long_copy_obj (OMobj_id, OMobj_id, int);

/* 64-bit porting. long declarations */
FUNC_PREFIX int OMraw_long_save_obj (OMobj_id, OMobj_id,int,int,char **,xp_long*);
FUNC_PREFIX void OMraw_long_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMraw_long_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMraw_long_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMraw_long_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMraw_long_set_real_val (OMobj_id, double);
FUNC_PREFIX int OMraw_long_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMraw_long_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_long_copy_obj (OMobj_id, OMobj_id,int);
FUNC_PREFIX int	OMraw_long_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMraw_long_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int OMraw_long_bsave_obj (OMobj_id , OMsave_bfile_obj *,
				HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMraw_long_brestore_obj (OMrestore_bfile_obj *,
					OMobj_id, OMobj_id, OMobj_id *, int);

FUNC_PREFIX int OMraw_real_save_obj (OMobj_id, OMobj_id,int,int,char **,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMraw_real_save_obj_n (OMobj_id, OMobj_id,int,int,char **,int*);
#endif
FUNC_PREFIX void OMraw_real_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMraw_real_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMraw_real_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMraw_real_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMraw_real_set_real_val (OMobj_id, double);
FUNC_PREFIX int OMraw_real_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMraw_real_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_real_copy_obj (OMobj_id, OMobj_id,int);
FUNC_PREFIX int	OMraw_real_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMraw_real_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int OMraw_real_bsave_obj (OMobj_id , OMsave_bfile_obj *,
				HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMraw_real_brestore_obj (OMrestore_bfile_obj *,
					OMobj_id, OMobj_id, OMobj_id *, int);

FUNC_PREFIX int OMraw_str_destroy_obj (OMobj_id);
FUNC_PREFIX int OMraw_str_save_obj (OMobj_id, OMobj_id, int,int,char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMraw_str_save_obj_n (OMobj_id, OMobj_id, int,int,char **,int *);
#endif
FUNC_PREFIX int OMraw_str_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_str_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int OMraw_str_get_str_val (OMobj_id, char **,xp_long, int);
FUNC_PREFIX int	OMraw_str_get_func_val (OMobj_id, OMpfi *);
FUNC_PREFIX int	OMraw_str_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_str_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				      OMobj_id);
FUNC_PREFIX int OMraw_str_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_str_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMraw_str_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMraw_str_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int OMraw_str_bsave_obj (OMobj_id , OMsave_bfile_obj *,
			     HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMraw_str_brestore_obj (OMrestore_bfile_obj *,
				    OMobj_id, OMobj_id, OMobj_id *, int);

FUNC_PREFIX int OMcomment_save_obj_hdr (OMobj_id, char *,int,int);
FUNC_PREFIX int OMcomment_save_obj (OMobj_id, OMobj_id, int,int,char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMcomment_save_obj_n (OMobj_id, OMobj_id, int,int,char **,int *);
#endif

FUNC_PREFIX int	OMraw_ptr_set_ptr_val (OMobj_id, void *, int);
FUNC_PREFIX int	OMraw_ptr_get_ptr_val (OMobj_id, void **, int);
FUNC_PREFIX int	OMraw_ptr_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMraw_ptr_valid_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int OMraw_array_create_obj (OMobj_id);
FUNC_PREFIX int OMraw_array_destroy_obj (OMobj_id);
FUNC_PREFIX int OMraw_array_save_obj (OMobj_id, OMobj_id,int,int,char**,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMraw_array_save_obj_n (OMobj_id, OMobj_id,int,int,char**,int*);
#endif
FUNC_PREFIX int OMraw_array_match_obj (OMobj_id, OMobj_id,int);
FUNC_PREFIX int	OMraw_array_insert_subobj (OMobj_id, xp_long, OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMraw_array_get_data_type (OMobj_id,int *);
FUNC_PREFIX int OMraw_array_set_array (OMobj_id,int,char *,xp_long,int);
FUNC_PREFIX int OMraw_array_get_array (OMobj_id,int *,char **,int *, xp_long*,int);
FUNC_PREFIX int OMraw_array_get_array_size (OMobj_id, xp_long *);
FUNC_PREFIX int OMraw_array_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMraw_array_get_array_n (OMobj_id,int *,char **,int *, int*,int);
FUNC_PREFIX int OMraw_array_get_array_size_n (OMobj_id, int *);
FUNC_PREFIX int OMraw_array_get_array_dims_n (OMobj_id, int *, int *);
#endif
FUNC_PREFIX int OMraw_array_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMraw_array_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMraw_array_get_rarray_val (OMobj_id, xp_long, double *);
FUNC_PREFIX int OMraw_array_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_array_copy_obj (OMobj_id,OMobj_id,int);
FUNC_PREFIX int	OMraw_array_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMraw_array_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int OMraw_array_bsave_obj (OMobj_id , OMsave_bfile_obj *,
					HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMraw_array_brestore_obj (OMrestore_bfile_obj *,
					OMobj_id, OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMraw_array_get_str_array_val (OMobj_id, xp_long, char **,xp_long,int);

FUNC_PREFIX int OMraw_obj_destroy_obj (OMobj_id);
FUNC_PREFIX int OMraw_obj_save_obj (OMobj_id, OMobj_id, int, int, char**,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMraw_obj_save_obj_n (OMobj_id, OMobj_id, int, int, char**,int*);
#endif
FUNC_PREFIX int OMraw_obj_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMraw_obj_get_obj_pval (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMraw_obj_copy_obj (OMobj_id,OMobj_id,int);
FUNC_PREFIX int	OMraw_obj_set_obj_state (OMobj_id, int, int);
FUNC_PREFIX int	OMraw_obj_get_obj_state (OMobj_id, int *, int);
FUNC_PREFIX int	OMraw_obj_add_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMraw_obj_del_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int OMraw_obj_bsave_obj (OMobj_id, OMsave_bfile_obj *,
				HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMraw_obj_brestore_obj (OMrestore_bfile_obj *,
				OMobj_id, OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMmlink_bsave_obj (OMobj_id, OMsave_bfile_obj *,
				HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMmlink_brestore_obj (OMrestore_bfile_obj *,
				OMobj_id, OMobj_id, OMobj_id *, int);

FUNC_PREFIX int OMname_obj_create_obj (OMobj_id);
FUNC_PREFIX int OMname_obj_destroy_obj (OMobj_id);
FUNC_PREFIX int OMname_obj_save_obj (OMobj_id, OMobj_id, int, int,char**,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMname_obj_save_obj_n (OMobj_id, OMobj_id, int, int,char**,int*);
#endif
FUNC_PREFIX int OMname_obj_upd_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMname_obj_insert_subobj (OMobj_id, xp_long, OMobj_id,
					OMobj_name, int);
FUNC_PREFIX int OMname_obj_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMname_obj_get_obj_pval (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMname_obj_get_obj_val (OMobj_id, OMobj_id *);
FUNC_PREFIX int OMname_obj_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMname_obj_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMname_obj_get_real_val (OMobj_id, double *);
FUNC_PREFIX void OMname_obj_set_int_val (OMobj_id,int, int, int *);
FUNC_PREFIX void OMname_obj_set_long_val (OMobj_id,xp_long, int, int *);
FUNC_PREFIX int OMname_obj_set_real_val (OMobj_id, double );
FUNC_PREFIX int	OMname_obj_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int	OMname_obj_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int	OMname_obj_get_str_array_val (OMobj_id, xp_long, char **, xp_long,int);
FUNC_PREFIX int	OMname_obj_get_obj_seq (OMobj_id, OMobj_id, int );
FUNC_PREFIX int OMname_obj_get_data_type (OMobj_id,int *);
FUNC_PREFIX int	OMname_obj_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMname_obj_get_array_dims_n (OMobj_id, int *, int *);
#endif
FUNC_PREFIX int OMname_obj_get_array (OMobj_id, int *,char **,int *, xp_long*,int);
FUNC_PREFIX int OMname_obj_set_array (OMobj_id, int, char *,xp_long, int);
FUNC_PREFIX int OMname_obj_get_iarray_val (OMobj_id, xp_long , int *);
FUNC_PREFIX int OMname_obj_get_larray_val (OMobj_id, xp_long , xp_long *);
FUNC_PREFIX int	OMname_obj_get_sub_barray (OMobj_id,int,xp_long*,xp_long*,
					   xp_long*, unsigned char*);
FUNC_PREFIX int	OMname_obj_get_sub_sarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMname_obj_get_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMname_obj_get_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMname_obj_get_sub_farray (OMobj_id,int,xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMname_obj_get_sub_rarray (OMobj_id,int,xp_long*,xp_long*,
					   xp_long*, double*);
FUNC_PREFIX int	OMname_obj_set_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMname_obj_set_sub_larray (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMname_obj_set_sub_rarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMname_obj_get_array_n (OMobj_id, int *,char **,int *, int*,int);
FUNC_PREFIX int	OMname_obj_get_sub_barray_n (OMobj_id,int,int*,int*,
					   int*, unsigned char*);
FUNC_PREFIX int	OMname_obj_get_sub_sarray_n (OMobj_id,int,int*,int*,int*,short*);
FUNC_PREFIX int	OMname_obj_get_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int	OMname_obj_get_sub_farray_n (OMobj_id,int,int*,int*,int*,float*);
FUNC_PREFIX int	OMname_obj_get_sub_rarray_n (OMobj_id,int,int*,int*,
					   int*, double*);
FUNC_PREFIX int	OMname_obj_set_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int	OMname_obj_set_sub_rarray_n (OMobj_id,int,int*,int*,int*,double*);
#endif
FUNC_PREFIX int	OMname_obj_links_to (OMobj_id, OMobj_id, int);

FUNC_PREFIX int OMname_obj_copy_obj (OMobj_id,OMobj_id,int);
FUNC_PREFIX int	OMname_obj_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMname_obj_set_obj_prop (OMobj_id, OMobj_name, OMobj_id);
FUNC_PREFIX int OMname_obj_set_obj_iprop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMname_obj_add_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMname_obj_del_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int OMname_obj_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMname_obj_resolve_obj (OMobj_id, int);
FUNC_PREFIX int OMname_obj_queue_notifier (OMobj_id,unsigned int,OMobj_id,int);
FUNC_PREFIX int OMname_obj_bsave_obj (OMobj_id, OMsave_bfile_obj *,
			     	     HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMname_obj_brestore_obj (OMrestore_bfile_obj *,
				        OMobj_id, OMobj_id, OMobj_id *, int);
FUNC_PREFIX int	OMname_obj_cleanup_obj_proc_id (OMobj_id, OMproc_id);

FUNC_PREFIX int	OMfunc_destroy_obj (OMobj_id);
FUNC_PREFIX int OMfunc_save_obj (OMobj_id, OMobj_id, int,int,char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMfunc_save_obj_n (OMobj_id, OMobj_id, int,int,char **,int *);
#endif
FUNC_PREFIX int OMfunc_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMfunc_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMfunc_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int	OMfunc_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int	OMfunc_set_func_val (OMobj_id, OMpfi);
FUNC_PREFIX int	OMfunc_get_func_val (OMobj_id, OMpfi *);
FUNC_PREFIX int OMfunc_invoke_obj (OMobj_id, OMobj_id, unsigned int, OMobj_id);
FUNC_PREFIX int	OMfunc_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMfunc_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX int OMfunc_bsave_obj (OMobj_id , OMsave_bfile_obj *,
			     HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMfunc_brestore_obj (OMrestore_bfile_obj *,
				    OMobj_id, OMobj_id, OMobj_id *, int);

FUNC_PREFIX int	OMmethod_create_obj (OMobj_id);
FUNC_PREFIX int	OMmethod_destroy_obj (OMobj_id);
FUNC_PREFIX int OMmethod_save_obj (OMobj_id,OMobj_id,int,int,char **,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMmethod_save_obj_n (OMobj_id,OMobj_id,int,int,char **,int *);
#endif
FUNC_PREFIX int	OMmethod_set_obj_parent (OMobj_id, OMobj_id);
FUNC_PREFIX int OMmethod_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMmethod_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMmethod_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				     OMobj_id);
FUNC_PREFIX int OMmethod_set_obj_prop (OMobj_id, OMobj_name, OMobj_id);
FUNC_PREFIX OMobj_id OMmethod_get_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMmethod_get_func_val (OMobj_id, OMpfi *);
FUNC_PREFIX int	OMmethod_get_dynlib_func_val (OMobj_id, char *, OMpfi *);
FUNC_PREFIX int	OMmethod_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMmethod_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX int OMmethod_set_obj_att (OMobj_id, OMobj_name, int, int);
FUNC_PREFIX int OMmethod_resolve_obj (OMobj_id, int );
FUNC_PREFIX int OMmethod_bsave_obj (OMobj_id , OMsave_bfile_obj *,
			     HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMmethod_brestore_obj (OMrestore_bfile_obj *,
				    OMobj_id, OMobj_id, OMobj_id *, int);
FUNC_PREFIX int OMmethod_set_obj_params (OMobj_id, OMobj_id);

FUNC_PREFIX int OMomethod_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				     OMobj_id);
FUNC_PREFIX int	OMomethod_gen_code (OMobj_id, OMcomp_proc *, int);

FUNC_PREFIX int OMfmethod_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				     OMobj_id);
FUNC_PREFIX int	OMfmethod_gen_code (OMobj_id, OMcomp_proc *, int);

FUNC_PREFIX int	OMdata_method_create_obj (OMobj_id);
FUNC_PREFIX int	OMdata_method_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX int	OMdata_method_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMdata_method_add_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMdata_method_del_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);

FUNC_PREFIX int OMcmethod_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				      OMobj_id);
FUNC_PREFIX int	OMcmethod_gen_code (OMobj_id, OMcomp_proc *, int);

FUNC_PREFIX int	OMcxxmethod_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int	OMcxxmethod_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int	OMcxxmethod_set_func_val (OMobj_id, OMpfi);
FUNC_PREFIX int	OMcxxmethod_get_func_val (OMobj_id, OMpfi *);
FUNC_PREFIX int OMcxxmethod_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				      OMobj_id);
FUNC_PREFIX int	OMcxxmethod_gen_code (OMobj_id, OMcomp_proc *, int);

FUNC_PREFIX int OMafunc_invoke_obj (OMobj_id, OMobj_id, unsigned int,
				    OMobj_id);
FUNC_PREFIX int	OMafunc_valid_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int OMbase_func_save_obj (OMobj_id, OMobj_id, int, int, char **, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMbase_func_save_obj_n (OMobj_id, OMobj_id, int, int, char **, int *);
#endif

FUNC_PREFIX int OMval_func_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMval_func_get_array_dims (OMobj_id, int *, xp_long *);
FUNC_PREFIX int OMval_func_save_obj (OMobj_id, OMobj_id, int, int, char **, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMval_func_get_array_dims_n (OMobj_id, int *, int *);
FUNC_PREFIX int OMval_func_save_obj_n (OMobj_id, OMobj_id, int, int, char **, int *);
#endif

FUNC_PREFIX int	OMval_func_links_to (OMobj_id, OMobj_id, int);

FUNC_PREFIX int OMprod_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMprod_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMprod_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMsum_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMsum_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMsum_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMarray_size_get_int_val (OMobj_id, int *); /* remove after porting func.c - satya */
FUNC_PREFIX int OMarray_size_get_long_val (OMobj_id, xp_long *);

FUNC_PREFIX int	OMiarray_func_get_sub_iarray (OMobj_id,int,xp_long*,xp_long*,
					    xp_long*,int*);
FUNC_PREFIX int	OMlarray_func_get_sub_larray   (OMobj_id,int,xp_long*,xp_long*,
					    xp_long*,xp_long*);
FUNC_PREFIX int	OMrarray_func_get_sub_rarray (OMobj_id,int,xp_long*,xp_long*,
					     xp_long*,double*);
FUNC_PREFIX int	OMfarray_func_get_sub_farray (OMobj_id,int,xp_long*,xp_long*,
					     xp_long*,float*);
FUNC_PREFIX int OMsub_array_get_array (OMobj_id,int *,char **,int *, xp_long*,int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMiarray_func_get_sub_iarray_n (OMobj_id,int,int*,int*,
					       int*,int*);
FUNC_PREFIX int	OMrarray_func_get_sub_rarray_n (OMobj_id,int,int*,int*,
					       int*,double*);
FUNC_PREFIX int	OMfarray_func_get_sub_farray_n (OMobj_id,int,int*,int*,
					       int*,float*);
FUNC_PREFIX int OMsub_array_get_array_n (OMobj_id,int *,char **,int *, int*,int);
#endif
FUNC_PREFIX int OMsub_array_set_array (OMobj_id,int,char *,xp_long,int);

/*
 * These routines implement the "sub array" functions using the get_array
 * routine.
 */
FUNC_PREFIX int	OMarray_get_sub_barray (OMobj_id,int,xp_long*,xp_long*,
					   xp_long*,unsigned char*);
FUNC_PREFIX int	OMarray_get_sub_sarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMarray_get_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMarray_get_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMarray_get_sub_farray (OMobj_id,int,xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMarray_get_sub_rarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,double*);

FUNC_PREFIX int	OMraw_array_get_sub_barray (OMobj_id,int,xp_long*,xp_long*,
					   xp_long*,unsigned char*);
FUNC_PREFIX int	OMraw_array_get_sub_sarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMraw_array_get_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMraw_array_get_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMraw_array_get_sub_farray (OMobj_id,int,xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMraw_array_get_sub_rarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,double*);

FUNC_PREFIX int	OMarray_set_sub_barray (OMobj_id,int,xp_long*,xp_long*,xp_long*,
					unsigned char*);
FUNC_PREFIX int	OMarray_set_sub_sarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMarray_set_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMarray_set_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMarray_set_sub_farray (OMobj_id,int,xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMarray_set_sub_rarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,double*);

/* These force the type in the sub-array argument */
FUNC_PREFIX int OMisub_array_get_array (OMobj_id,int *,char **,int *,xp_long*,int);
FUNC_PREFIX int OMlsub_array_get_array   (OMobj_id,int *,char **,int *,xp_long*,int);
FUNC_PREFIX int OMrsub_array_get_array (OMobj_id,int *,char **,int *,xp_long*,int);
FUNC_PREFIX int OMfsub_array_get_array (OMobj_id,int *,char **,int *,xp_long*,int);
/* This uses the get_sub_rarray method and converts the result */
FUNC_PREFIX int	OMrarray_get_sub_iarray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, int *);
FUNC_PREFIX int	OMrarray_get_sub_larray   (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, xp_long *);
FUNC_PREFIX int	OMrarray_get_sub_farray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, float *);
FUNC_PREFIX int	OMiarray_get_sub_barray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, unsigned char*);
FUNC_PREFIX int	OMiarray_get_sub_sarray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, short*);
FUNC_PREFIX int	OMiarray_get_sub_larray   (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, xp_long*);
FUNC_PREFIX int	OMiarray_get_sub_rarray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, double*);
FUNC_PREFIX int	OMlarray_get_sub_iarray   (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, int *);
FUNC_PREFIX int	OMlarray_get_sub_rarray   (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, double*);
FUNC_PREFIX int	OMfarray_get_sub_rarray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, double*);
FUNC_PREFIX int OMrarray_get_iarray_val   (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMrarray_get_larray_val   (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int	OMiarray_set_sub_barray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, unsigned char *);
FUNC_PREFIX int	OMiarray_set_sub_sarray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, short *);
FUNC_PREFIX int	OMrarray_set_sub_farray (OMobj_id, int, xp_long *, xp_long *,
					  xp_long *, float *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMarray_get_sub_barray_n (OMobj_id,int,int*,int*,
					   int*,unsigned char*);
FUNC_PREFIX int	OMarray_get_sub_sarray_n (OMobj_id,int,int*,int*,int*,short*);
FUNC_PREFIX int	OMarray_get_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int	OMarray_get_sub_farray_n (OMobj_id,int,int*,int*,int*,float*);
FUNC_PREFIX int	OMarray_get_sub_rarray_n (OMobj_id,int,int*,int*,int*,double*);

FUNC_PREFIX int	OMraw_array_get_sub_barray_n (OMobj_id,int,int*,int*,
					     int*,unsigned char*);
FUNC_PREFIX int	OMraw_array_get_sub_sarray_n (OMobj_id,int,int*,int*,int*,short*);
FUNC_PREFIX int	OMraw_array_get_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int	OMraw_array_get_sub_farray_n (OMobj_id,int,int*,int*,int*,float*);
FUNC_PREFIX int	OMraw_array_get_sub_rarray_n (OMobj_id,int,int*,int*,int*,double*);

FUNC_PREFIX int	OMarray_set_sub_barray_n (OMobj_id,int,int*,int*,int*,
					 unsigned char*);
FUNC_PREFIX int	OMarray_set_sub_sarray_n (OMobj_id,int,int*,int*,int*,short*);
FUNC_PREFIX int	OMarray_set_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int	OMarray_set_sub_farray_n (OMobj_id,int,int*,int*,int*,float*);
FUNC_PREFIX int	OMarray_set_sub_rarray_n (OMobj_id,int,int*,int*,int*,double*);

/* These force the type in the sub-array argument */
FUNC_PREFIX int OMisub_array_get_array_n (OMobj_id,int *,char **,int *,int*,int);
FUNC_PREFIX int OMrsub_array_get_array_n (OMobj_id,int *,char **,int *,int*,int);
FUNC_PREFIX int OMfsub_array_get_array_n (OMobj_id,int *,char **,int *,int*,int);
/* This uses the get_sub_rarray method and converts the result */
FUNC_PREFIX int	OMrarray_get_sub_iarray_n (OMobj_id, int, int *, int *,
					  int *, int *);
FUNC_PREFIX int	OMrarray_get_sub_farray_n (OMobj_id, int, int *, int *,
					  int *, float *);
FUNC_PREFIX int	OMiarray_get_sub_barray_n (OMobj_id, int, int *, int *,
					  int *, unsigned char*);
FUNC_PREFIX int	OMiarray_get_sub_sarray_n (OMobj_id, int, int *, int *,
					  int *, short*);
FUNC_PREFIX int	OMiarray_get_sub_rarray_n (OMobj_id, int, int *, int *,
					  int *, double*);
FUNC_PREFIX int	OMfarray_get_sub_rarray_n (OMobj_id, int, int *, int *,
					  int *, double*);
FUNC_PREFIX int	OMiarray_set_sub_barray_n (OMobj_id, int, int *, int *,
					  int *, unsigned char *);
FUNC_PREFIX int	OMiarray_set_sub_sarray_n (OMobj_id, int, int *, int *,
					  int *, short *);
FUNC_PREFIX int	OMrarray_set_sub_farray_n (OMobj_id, int, int *, int *,
					  int *, float *);
#endif
FUNC_PREFIX int	OMreal_func_get_real_val (OMobj_id, double *);

/* General Functions (no class specific data is required) */
FUNC_PREFIX int OMscalar_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);

FUNC_PREFIX int OMchar_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMchar_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMchar_set_int_val (OMobj_id, int, int, int *);

FUNC_PREFIX int OMbyte_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMbyte_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMbyte_set_int_val (OMobj_id, int, int, int *);

FUNC_PREFIX int OMshort_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMshort_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMshort_set_int_val (OMobj_id, int, int, int *);

FUNC_PREFIX int OMfloat_get_data_type (OMobj_id, int *);

FUNC_PREFIX int OMint_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMint_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMint_get_data_type (OMobj_id, int *);
FUNC_PREFIX void OMint_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int	OMint_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMint_set_real_val (OMobj_id, double);
FUNC_PREFIX int	OMint_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMint_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int OMint_get_str_array_val (OMobj_id, xp_long, char **, xp_long,int);
FUNC_PREFIX int OMint_set_str_val (OMobj_id, const char *);

/* 64-bit porting. long declarations */
FUNC_PREFIX int OMlong_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMlong_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMlong_get_data_type (OMobj_id, int *);
FUNC_PREFIX void OMlong_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int	OMlong_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMlong_set_real_val (OMobj_id, double);
FUNC_PREFIX int	OMlong_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMlong_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int OMlong_get_str_array_val (OMobj_id, xp_long, char **, xp_long,int);
FUNC_PREFIX int OMlong_set_str_val (OMobj_id, const char *);

FUNC_PREFIX int OMreal_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMreal_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX void OMreal_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int	OMreal_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMreal_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int	OMreal_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMreal_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMreal_get_str_val (OMobj_id, char **, xp_long, int);
FUNC_PREFIX int	OMreal_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);
FUNC_PREFIX int	OMreal_set_str_val (OMobj_id, const char *);

FUNC_PREFIX int OMstr_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMstr_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMstr_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMstr_set_obj_val (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMstr_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);

FUNC_PREFIX int OMptr_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX OMobj_id OMptr_obj_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMptr_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMptr_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMptr_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMptr_set_obj_att (OMobj_id, OMobj_name, int, int);

FUNC_PREFIX int OMunset_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMunset_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMunset_get_real_val (OMobj_id, double *);
FUNC_PREFIX int	OMunset_get_str_val (OMobj_id, char **, xp_long , int);
FUNC_PREFIX int OMunset_get_array (OMobj_id, int *, char **, int *, xp_long *,int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMunset_get_array_n (OMobj_id, int *, char **, int *, int *,int);
#endif

FUNC_PREFIX int OMenum_get_int_val (OMobj_id, int *);
FUNC_PREFIX int OMenum_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int	OMenum_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int	OMenum_get_str_val (OMobj_id, char **, xp_long , int);
FUNC_PREFIX int OMenum_set_real_val (OMobj_id, double);
FUNC_PREFIX void OMenum_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX void OMenum_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMenum_merge_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int OMarray_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMarray_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMarray_set_array_size (OMobj_id, xp_long);
FUNC_PREFIX int OMarray_get_array_size (OMobj_id, xp_long *);
FUNC_PREFIX int OMarray_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMarray_get_array_size_n (OMobj_id, int *);
FUNC_PREFIX int OMarray_get_array_dims_n (OMobj_id, int *, int *);
#endif
/* Not methods... util routines implemented for array elements */
FUNC_PREFIX int OMarray_get_my_array_size (OMobj_id, xp_long *);
FUNC_PREFIX int OMarray_get_my_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMarray_get_my_array_size_n (OMobj_id, int *);
FUNC_PREFIX int OMarray_get_my_array_dims_n (OMobj_id, int *, int *);
#endif

FUNC_PREFIX int OMarray_group_save_obj (OMobj_id, OMobj_id, int, int,
					char **, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMarray_group_save_obj_n (OMobj_id, OMobj_id, int, int,
					char **, int *);
#endif

FUNC_PREFIX int OMarray_group_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMarray_group_get_num_refs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMarray_group_get_num_refs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int	OMarray_group_insert_obj_ref (OMobj_id, xp_long, OMobj_id, int);
FUNC_PREFIX int	OMarray_group_del_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMarray_group_get_array_ref (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMarray_group_add_obj_notify_req (OMobj_id,
				OMobj_id, OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMarray_group_del_obj_notify_req (OMobj_id,
				OMobj_id, OMobj_id, unsigned int, int);

FUNC_PREFIX int OMrange_save_obj (OMobj_id, OMobj_id,int,int,char **,xp_long*);
FUNC_PREFIX int OMgen_list_save_obj (OMobj_id, OMobj_id,int,int,char **,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMrange_save_obj_n (OMobj_id, OMobj_id,int,int,char **,int*);
FUNC_PREFIX int OMgen_list_save_obj_n (OMobj_id, OMobj_id,int,int,char **,int*);
#endif

FUNC_PREFIX int OMgen_list_set_obj_params (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMgen_list_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgen_list_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgen_list_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgen_list_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMgen_list_get_obj_val (OMobj_id, OMobj_id *);
FUNC_PREFIX int	OMgen_list_add_obj_notify_req (OMobj_id, OMobj_id,
					  OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMgen_list_del_obj_notify_req (OMobj_id, OMobj_id,
					  OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMgen_list_resolve_obj (OMobj_id, int);
FUNC_PREFIX int	OMgen_list_get_data_type (OMobj_id, int *);
FUNC_PREFIX int	OMgen_list_set_obj_att (OMobj_id, OMobj_name, int, int);
FUNC_PREFIX int OMgen_list_set_needed (OMobj_id, char *, int, int *, int);
FUNC_PREFIX int	OMgen_list_del_obj_refs_to (OMobj_id, int);
FUNC_PREFIX int	OMgen_list_cleanup_obj_proc_id (OMobj_id, OMproc_id);

FUNC_PREFIX int OMlist_array_update (void *, void *, int, size_t, int);

FUNC_PREFIX int	OMlist0_get_data_type (OMobj_id, int *);

FUNC_PREFIX int	OMval_list_insert_subobj (OMobj_id, xp_long, OMobj_id,
					  OMobj_name, int);
FUNC_PREFIX int	OMval_list_del_subobj (OMobj_id, OMobj_id, int);


FUNC_PREFIX int OMarr_val_add_obj_notify_req (OMobj_id, OMobj_id,
				          OMobj_id, unsigned int, int);
FUNC_PREFIX int OMarr_val_del_obj_notify_req (OMobj_id, OMobj_id,
				          OMobj_id, unsigned int, int);
FUNC_PREFIX int OMarr_val_get_obj_seq (OMobj_id, OMobj_id, int );
FUNC_PREFIX int OMarr_val_insert_subobj (OMobj_id, xp_long, OMobj_id,
					OMobj_name, int);
FUNC_PREFIX int OMarr_val_del_subobj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int	OMparam_list_insert_subobj (OMobj_id, xp_long, OMobj_id,
					   OMobj_name, int);
FUNC_PREFIX int	OMparam_list_del_subobj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMparam_list_add_obj_notify_req (OMobj_id,OMobj_id,
					    OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMparam_list_del_obj_notify_req (OMobj_id,OMobj_id,
					    OMobj_id, unsigned int, int);

FUNC_PREFIX int	OMmeth_param_add_obj_notify_req (OMobj_id,OMobj_id,
					    OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMmeth_param_del_obj_notify_req (OMobj_id,OMobj_id,
					    OMobj_id, unsigned int, int);
FUNC_PREFIX int OMmeth_param_valid_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int	OMarray_list_insert_subobj (OMobj_id, xp_long, OMobj_id,
					   OMobj_name, int);
FUNC_PREFIX int	OMarray_list_del_subobj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMarray_list_add_obj_notify_req (OMobj_id,OMobj_id,
					    OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMarray_list_del_obj_notify_req (OMobj_id,OMobj_id,
					    OMobj_id, unsigned int, int);
FUNC_PREFIX int OMarray_list_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMarray_list_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMarray_list_get_array (OMobj_id, int *, char **, int *, xp_long *, int);
FUNC_PREFIX int OMarray_list_get_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int OMarray_list_get_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int OMarray_list_get_sub_rarray (OMobj_id,int,xp_long*,xp_long*,
					    xp_long*,double*);
FUNC_PREFIX int OMarray_list_set_sub_barray (OMobj_id,int,xp_long*,xp_long*,xp_long*,
					    unsigned char*);
FUNC_PREFIX int OMarray_list_set_sub_sarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,
					    short*);
FUNC_PREFIX int OMarray_list_set_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int OMarray_list_set_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int OMarray_list_set_sub_farray (OMobj_id,int,xp_long*,xp_long*,xp_long*,
					    float*);
FUNC_PREFIX int OMarray_list_set_sub_rarray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMarray_list_get_array_n (OMobj_id, int *, char **, int *, int *, int);
FUNC_PREFIX int OMarray_list_get_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int OMarray_list_get_sub_rarray_n (OMobj_id,int,int*,int*,
					      int*,double*);
FUNC_PREFIX int OMarray_list_set_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int OMarray_list_set_sub_rarray_n (OMobj_id, int, int*, int*,
					      int*, double*);
#endif

FUNC_PREFIX int	OMarray_list_valid_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int	OMsort_insert_subobj (OMobj_id, xp_long, OMobj_id,
				      OMobj_name, int);

FUNC_PREFIX int	OMinst_create_set_obj_parent (OMobj_id, OMobj_id);

FUNC_PREFIX int	OMval_get_num_refs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMval_get_num_refs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int	OMval_get_array_ref (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMval_insert_obj_ref (OMobj_id, xp_long, OMobj_id, int);
FUNC_PREFIX int	OMval_del_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMval_resolve_obj (OMobj_id, int);

FUNC_PREFIX OMobj_id OMlibrary_get_obj_by_name (OMobj_id, OMobj_name, int *, int);
FUNC_PREFIX int	OMlibrary_insert_subobj (OMobj_id, xp_long, OMobj_id,
					 OMobj_name, int);
FUNC_PREFIX int	OMlibrary_insert_subobj (OMobj_id, xp_long, OMobj_id,
					 OMobj_name, int);
FUNC_PREFIX int OMlibrary_set_obj_att (OMobj_id, OMobj_name, int, int);
FUNC_PREFIX int OMlibrary_set_obj_iprop (OMobj_id, OMobj_name, int);

/* Generic reference element methods -- perform the op on the value element */

FUNC_PREFIX int OMref_obj_save_obj (OMobj_id,OMobj_id,int,int,char**,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMref_obj_save_obj_n (OMobj_id,OMobj_id,int,int,char**,int *);
#endif

FUNC_PREFIX int OMref_obj_insert_subobj (OMobj_id, xp_long, OMobj_id,
					 OMobj_name, int);
FUNC_PREFIX int OMref_obj_del_subobj (OMobj_id, OMobj_id, int);
FUNC_PREFIX OMobj_id OMref_obj_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMref_obj_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMref_obj_is_matched_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMref_obj_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMref_obj_get_obj_val (OMobj_id, OMobj_id *);
FUNC_PREFIX int	OMref_obj_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX void OMref_obj_set_int_val (OMobj_id, int, int, int *);
FUNC_PREFIX int OMref_obj_get_int_val (OMobj_id, int *);
FUNC_PREFIX void OMref_obj_set_long_val (OMobj_id, xp_long, int, int *);
FUNC_PREFIX int OMref_obj_get_long_val (OMobj_id, xp_long *);
FUNC_PREFIX int OMref_obj_set_real_val (OMobj_id, double);
FUNC_PREFIX int OMref_obj_get_real_val (OMobj_id, double *);
FUNC_PREFIX int OMref_obj_set_str_val (OMobj_id, const char *);
FUNC_PREFIX int OMref_obj_get_str_val (OMobj_id, char **,xp_long, int);
FUNC_PREFIX int OMref_obj_set_ptr_val (OMobj_id, void *, int);
FUNC_PREFIX int OMref_obj_get_ptr_val (OMobj_id, void **,int);
FUNC_PREFIX int OMref_obj_set_array (OMobj_id, int, char *, xp_long, int);

FUNC_PREFIX int OMref_obj_get_array (OMobj_id, int *, char **,int *,xp_long *,int);
FUNC_PREFIX int	OMref_obj_get_sub_barray (OMobj_id, int, xp_long*, xp_long*, xp_long*,
					    unsigned char*);
FUNC_PREFIX int	OMref_obj_get_sub_sarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,short*);
FUNC_PREFIX int	OMref_obj_get_sub_iarray (OMobj_id,int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMref_obj_get_sub_larray   (OMobj_id,int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMref_obj_get_sub_farray (OMobj_id,int,xp_long*,xp_long*,xp_long*,float*);
FUNC_PREFIX int	OMref_obj_get_sub_rarray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, double*);
FUNC_PREFIX int	OMref_obj_set_sub_barray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, unsigned char*);
FUNC_PREFIX int	OMref_obj_set_sub_sarray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, short*);
FUNC_PREFIX int	OMref_obj_set_sub_iarray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, int*);
FUNC_PREFIX int	OMref_obj_set_sub_larray   (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, xp_long*);
FUNC_PREFIX int	OMref_obj_set_sub_farray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, float*);
FUNC_PREFIX int	OMref_obj_set_sub_rarray (OMobj_id, int, xp_long*, xp_long*,
					    xp_long*, double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMref_obj_get_array_n (OMobj_id, int *, char **,int *,int *,int);
FUNC_PREFIX int	OMref_obj_get_sub_barray_n (OMobj_id, int, int*, int*, int*,
					  unsigned char*);
FUNC_PREFIX int	OMref_obj_get_sub_sarray_n (OMobj_id,int,int*,int*,int*,short*);
FUNC_PREFIX int	OMref_obj_get_sub_iarray_n (OMobj_id,int,int*,int*,int*,int*);
FUNC_PREFIX int	OMref_obj_get_sub_farray_n (OMobj_id,int,int*,int*,int*,float*);
FUNC_PREFIX int	OMref_obj_get_sub_rarray_n (OMobj_id, int, int*, int*,
					    int*, double*);
FUNC_PREFIX int	OMref_obj_set_sub_barray_n (OMobj_id, int, int*, int*,
					    int*, unsigned char*);
FUNC_PREFIX int	OMref_obj_set_sub_sarray_n (OMobj_id, int, int*, int*,
					    int*, short*);
FUNC_PREFIX int	OMref_obj_set_sub_iarray_n (OMobj_id, int, int*, int*,
					    int*, int*);
FUNC_PREFIX int	OMref_obj_set_sub_farray_n (OMobj_id, int, int*, int*,
					    int*, float*);
FUNC_PREFIX int	OMref_obj_set_sub_rarray_n (OMobj_id, int, int*, int*,
					    int*, double*);
#endif

FUNC_PREFIX int OMref_obj_set_array_size (OMobj_id, xp_long);

FUNC_PREFIX int OMref_obj_get_array_size (OMobj_id, xp_long *);
FUNC_PREFIX int OMref_obj_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMref_obj_get_array_size_n (OMobj_id, int *);
FUNC_PREFIX int OMref_obj_get_array_dims_n (OMobj_id, int *, int *);
#endif

FUNC_PREFIX int OMref_obj_set_array_val (OMobj_id, xp_long, OMobj_id);
FUNC_PREFIX int OMref_obj_get_array_val (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int OMref_obj_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMref_obj_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMref_obj_set_str_array_val (OMobj_id, xp_long, const char *);
FUNC_PREFIX int OMref_obj_get_str_array_val (OMobj_id, xp_long, char **, xp_long, int);

FUNC_PREFIX int OMref_obj_get_num_subobjs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMref_obj_get_num_subobjs_n (OMobj_id, int *, int);
#endif

FUNC_PREFIX int OMref_obj_get_array_subobj (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMref_obj_get_data_type (OMobj_id, int *);
FUNC_PREFIX OMobj_id OMref_obj_get_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMref_obj_get_num_refs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMref_obj_get_num_refs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int	OMref_obj_get_array_ref (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMref_obj_add_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMref_obj_del_obj_notify_req (OMobj_id, OMobj_id,
					OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMref_obj_valid_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMref_obj_is_subclass_of (OMobj_id, OMobj_id);
FUNC_PREFIX int	OMref_obj_get_num_classes (OMobj_id, int *, int);
FUNC_PREFIX int	OMref_obj_get_array_class (OMobj_id, int, OMobj_id *, int);
FUNC_PREFIX int	OMref_obj_reset_obj (OMobj_id, int);
FUNC_PREFIX int	OMref_obj_cleanup_obj_proc_id (OMobj_id, OMproc_id);

FUNC_PREFIX int	OMref_to_match_obj (OMobj_id, OMobj_id, int);

FUNC_PREFIX int	OMlink_match_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMlink_is_matched_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX OMobj_id OMlink_get_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMlink_set_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMlink_save_obj (OMobj_id,OMobj_id,int,int,char **,xp_long*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMlink_save_obj_n (OMobj_id,OMobj_id,int,int,char **,int*);
#endif

FUNC_PREFIX int	OMmlink_is_matched_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMmlink_destroy_obj (OMobj_id);
FUNC_PREFIX OMobj_id OMmlink_get_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int OMmlink_insert_obj_ref (OMobj_id, xp_long, OMobj_id, int);
FUNC_PREFIX int OMmlink_del_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMmlink_save_obj (OMobj_id,OMobj_id,int,int,char**,xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMmlink_save_obj_n (OMobj_id,OMobj_id,int,int,char**,int *);
#endif
FUNC_PREFIX int OMmlink_set_obj_ref (OMobj_id, OMobj_id, int);
FUNC_PREFIX int OMmlink_get_obj_pval (OMobj_id, OMobj_id *, int);
FUNC_PREFIX int	OMmlink_get_num_refs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMmlink_get_num_refs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMmlink_get_array_ref (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX int	OMmlink_set_array_size (OMobj_id, xp_long);

FUNC_PREFIX int	OMmlink_get_array_size (OMobj_id, xp_long *);
FUNC_PREFIX int	OMmlink_get_array_dims (OMobj_id, int *, xp_long *);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMmlink_get_array_size_n (OMobj_id, int *);
FUNC_PREFIX int	OMmlink_get_array_dims_n (OMobj_id, int *, int *);
#endif

FUNC_PREFIX int	OMmlink_copy_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMmlink_resolve_obj (OMobj_id, int);
FUNC_PREFIX int OMmlink_get_str_array_val (OMobj_id, xp_long, char **, xp_long,int);

FUNC_PREFIX int OMmlink_get_array (OMobj_id, int *,char **,int *, xp_long *,int);
FUNC_PREFIX int	OMmlink_get_sub_iarray (OMobj_id, int,xp_long*,xp_long*,xp_long*,int*);
FUNC_PREFIX int	OMmlink_get_sub_larray   (OMobj_id, int,xp_long*,xp_long*,xp_long*,xp_long*);
FUNC_PREFIX int	OMmlink_get_sub_rarray (OMobj_id, int,xp_long*,xp_long*,xp_long*,double*);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMmlink_get_array_n (OMobj_id, int *,char **,int *, int *,int);
FUNC_PREFIX int	OMmlink_get_sub_iarray_n (OMobj_id, int,int*,int*,int*,int*);
FUNC_PREFIX int	OMmlink_get_sub_rarray_n (OMobj_id, int,int*,int*,int*,double*);
#endif

FUNC_PREFIX int OMmlink_get_iarray_val (OMobj_id, xp_long, int *);
FUNC_PREFIX int OMmlink_get_larray_val (OMobj_id, xp_long, xp_long *);
FUNC_PREFIX int OMmlink_get_rarray_val (OMobj_id, xp_long, double *);

FUNC_PREFIX int	OMmerge_get_num_classes (OMobj_id, int *, int);
FUNC_PREFIX int	OMmerge_get_array_class (OMobj_id, int, OMobj_id *, int);
FUNC_PREFIX int OMmerge_get_num_subobjs (OMobj_id, xp_long *, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int OMmerge_get_num_subobjs_n (OMobj_id, int *, int);
#endif
FUNC_PREFIX int OMmerge_get_array_subobj (OMobj_id, xp_long, OMobj_id *, int);
FUNC_PREFIX OMobj_id OMmerge_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMmerge_add_obj_notify_req (OMobj_id,
				OMobj_id, OMobj_id, unsigned int, int);
FUNC_PREFIX int	OMmerge_del_obj_notify_req (OMobj_id,
				OMobj_id, OMobj_id, unsigned int, int);

FUNC_PREFIX OMobj_id OMremote_func_get_obj_prop (OMobj_id, OMobj_name, int);

FUNC_PREFIX int OMprocess_create_obj (OMobj_id);
FUNC_PREFIX int	OMprocess_destroy_obj (OMobj_id);
FUNC_PREFIX int	OMprocess_resolve_obj (OMobj_id,int);
FUNC_PREFIX int	OMprocess_get_obj_seq (OMobj_id, OMobj_id, int);
FUNC_PREFIX int	OMprocess_compile_obj (OMobj_id, int);

FUNC_PREFIX int OMstandin_insert_subobj (OMobj_id, xp_long, OMobj_id,
					 OMobj_name, int);
FUNC_PREFIX int	OMstandin_get_num_subobjs (OMobj_id, xp_long*, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMstandin_get_num_subobjs_n (OMobj_id, int*, int);
#endif
FUNC_PREFIX OMobj_id OMstandin_find_subobj (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMstandin_merge_obj (OMobj_id, OMobj_id, int);
FUNC_PREFIX OMtype_id OMstandin_copy_obj_type (OMobj_id, int);
FUNC_PREFIX int	OMstandin_gen_code (OMobj_id, OMcomp_proc *, int);
FUNC_PREFIX int OMstandin_set_needed (OMobj_id, char *, int, int *, int);
FUNC_PREFIX OMobj_id OMstandin_get_obj_prop (OMobj_id, OMobj_name, int);
FUNC_PREFIX int	OMstandin_resolve_obj (OMobj_id, int mode);

FUNC_PREFIX int	OMbuffer_get_num_subobjs (OMobj_id, xp_long*, int);
#ifdef WORDLENGTH_64
FUNC_PREFIX int	OMbuffer_get_num_subobjs_n (OMobj_id, int*, int);
#endif
FUNC_PREFIX int	OMbuffer_open_obj (OMobj_id);
FUNC_PREFIX int	OMbuffer_get_obj_type (OMobj_id, OMtype_id *);
FUNC_PREFIX int OMbuffer_destroy_obj (OMobj_id);
FUNC_PREFIX int OMbuffer_set_obj_ref_mode (OMobj_id, int);
FUNC_PREFIX int OMbuffer_bsave_obj (OMobj_id , OMsave_bfile_obj *,
			     HPheap *, OMobj_id *, int);
FUNC_PREFIX int OMbuffer_brestore_obj (OMrestore_bfile_obj *,
				    OMobj_id, OMobj_id, OMobj_id *, int);
FUNC_PREFIX OMobj_id OMbuffer_get_obj_by_name (OMobj_id, OMobj_name, int *, int);

FUNC_PREFIX int	OMbin_buffer_open_obj (OMobj_id);
FUNC_PREFIX int	OMbin_buffer_get_obj_type (OMobj_id, OMtype_id *);
FUNC_PREFIX OMobj_id OMbin_buffer_get_obj_by_name (OMobj_id, OMobj_name, int *, int);

FUNC_PREFIX int OMevent_queue_notifier (OMobj_id, unsigned int, OMobj_id, int);

FUNC_PREFIX OMobj_id OMvalidate_virt_obj (OMobj_id, OMobj_id, OMobj_name, int);

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
   #define	OMobj_get_array_size 		OMobj_get_array_size_n
   #define	OMcomp_save_obj			OMcomp_save_obj_n
   #define	OMcomp_get_num_subobjs		OMcomp_get_num_subobjs_n
   #define	OMcomp_get_num_refs			OMcomp_get_num_refs_n
   #define	OMgroup_save_obj			OMgroup_save_obj_n
   #define	OMgroup_get_num_subobjs		OMgroup_get_num_subobjs_n
   #define	OMfile_group_save_obj		OMfile_group_save_obj_n
   #define	OMfile_group_get_num_subobjs	OMfile_group_get_num_subobjs_n

   #define	OMprim_get_array			OMprim_get_array_n
   #define	OMprim_get_sub_barray		OMprim_get_sub_barray_n
   #define	OMprim_get_sub_sarray		OMprim_get_sub_sarray_n
   #define	OMprim_get_sub_iarray		OMprim_get_sub_iarray_n
   #define	OMprim_get_sub_farray		OMprim_get_sub_farray_n
   #define	OMprim_get_sub_rarray		OMprim_get_sub_rarray_n
   #define	OMprim_set_sub_barray		OMprim_set_sub_barray_n
   #define	OMprim_set_sub_sarray		OMprim_set_sub_sarray_n
   #define	OMprim_set_sub_iarray		OMprim_set_sub_iarray_n
   #define	OMprim_set_sub_farray		OMprim_set_sub_farray_n
   #define	OMprim_set_sub_rarray		OMprim_set_sub_rarray_n

   #define	OMlist_get_num_subobjs		OMlist_get_num_subobjs_n
   #define	OMlist_get_array			OMlist_get_array_n
   #define	OMlist_get_array_size 		OMlist_get_array_size_n
   #define	OMlist_get_array_dims		OMlist_get_array_dims_n

   #define	OMflibrary_save_obj			OMflibrary_save_obj_n

   #define	OMarith_get_array_dims		OMarith_get_array_dims_n
   #define	OMarith_save_obj			OMarith_save_obj_n
   #define	OMuarith_save_obj			OMuarith_save_obj_n
   #define	OMadd_get_sub_iarray		OMadd_get_sub_iarray_n
   #define	OMadd_get_sub_rarray		OMadd_get_sub_rarray_n
   #define	OMsub_get_sub_iarray		OMsub_get_sub_iarray_n
   #define	OMsub_get_sub_rarray		OMsub_get_sub_rarray_n
   #define	OMmultiply_get_sub_iarray	OMmultiply_get_sub_iarray_n
   #define	OMmultiply_get_sub_rarray	OMmultiply_get_sub_rarray_n
   #define	OMdivide_get_sub_iarray		OMdivide_get_sub_iarray_n
   #define	OMdivide_get_sub_rarray		OMdivide_get_sub_rarray_n
   #define	OMmodulo_get_sub_iarray		OMmodulo_get_sub_iarray_n
   #define	OMand_get_sub_iarray		OMand_get_sub_iarray_n
   #define	OMor_get_sub_iarray			OMor_get_sub_iarray_n
   #define	OMxor_get_sub_iarray		OMxor_get_sub_iarray_n
   #define	OMequals_get_sub_iarray		OMequals_get_sub_iarray_n
   #define	OMnot_equals_get_sub_iarray	OMnot_equals_get_sub_iarray_n
   #define	OMless_than_get_sub_iarray	OMless_than_get_sub_iarray_n
   #define	OMgt_than_get_sub_iarray	OMgt_than_get_sub_iarray_n
   #define	OMlt_equals_get_sub_iarray	OMlt_equals_get_sub_iarray_n
   #define	OMgt_equals_get_sub_iarray	OMgt_equals_get_sub_iarray_n
   #define	OMandand_get_sub_iarray		OMandand_get_sub_iarray_n
   #define	OMoror_get_sub_iarray		OMoror_get_sub_iarray_n
   #define	OMnot_get_sub_iarray		OMnot_get_sub_iarray_n
   #define	OMcomplement_get_sub_iarray	OMcomplement_get_sub_iarray_n

   #define	OMscalar_get_array			OMscalar_get_array_n
   #define	OMscalar_get_sub_barray		OMscalar_get_sub_barray_n
   #define	OMscalar_get_sub_sarray		OMscalar_get_sub_sarray_n
   #define	OMscalar_get_sub_iarray		OMscalar_get_sub_iarray_n
   #define	OMscalar_get_sub_farray		OMscalar_get_sub_farray_n
   #define	OMscalar_get_sub_rarray		OMscalar_get_sub_rarray_n
   #define	OMscalar_get_array_dims		OMscalar_get_array_dims_n

   #define	OMraw_int_save_obj			OMraw_int_save_obj_n
   #define	OMraw_real_save_obj			OMraw_real_save_obj_n
   #define	OMraw_str_save_obj			OMraw_str_save_obj_n
   #define	OMcomment_save_obj			OMcomment_save_obj_n
   #define	OMraw_array_save_obj		OMraw_array_save_obj_n
   #define	OMraw_array_get_array		OMraw_array_get_array_n
   #define	OMraw_array_get_array_size 	OMraw_array_get_array_size_n
   #define	OMraw_array_get_array_dims	OMraw_array_get_array_dims_n
   #define	OMraw_obj_save_obj			OMraw_obj_save_obj_n

   #define	OMname_obj_save_obj			OMname_obj_save_obj_n
   #define	OMname_obj_get_array_dims	OMname_obj_get_array_dims_n
   #define	OMname_obj_get_array		OMname_obj_get_array_n
   #define	OMname_obj_get_sub_barray	OMname_obj_get_sub_barray_n
   #define	OMname_obj_get_sub_sarray	OMname_obj_get_sub_sarray_n
   #define	OMname_obj_get_sub_iarray	OMname_obj_get_sub_iarray_n
   #define	OMname_obj_get_sub_farray	OMname_obj_get_sub_farray_n
   #define	OMname_obj_get_sub_rarray	OMname_obj_get_sub_rarray_n
   #define	OMname_obj_set_sub_iarray	OMname_obj_set_sub_iarray_n
   #define	OMname_obj_set_sub_rarray	OMname_obj_set_sub_rarray_n

   #define	OMfunc_save_obj			OMfunc_save_obj_n
   #define	OMmethod_save_obj			OMmethod_save_obj_n
   #define	OMbase_func_save_obj		OMbase_func_save_obj_n
   #define	OMval_func_get_array_dims	OMval_func_get_array_dims_n
   #define	OMval_func_save_obj			OMval_func_save_obj_n
   #define	OMiarray_func_get_sub_iarray	OMiarray_func_get_sub_iarray_n
   #define	OMrarray_func_get_sub_rarray	OMrarray_func_get_sub_rarray_n
   #define	OMfarray_func_get_sub_farray	OMfarray_func_get_sub_farray_n
   #define	OMsub_array_get_array		OMsub_array_get_array_n

   #define	OMarray_get_sub_barray		OMarray_get_sub_barray_n
   #define	OMarray_get_sub_sarray		OMarray_get_sub_sarray_n
   #define	OMarray_get_sub_iarray		OMarray_get_sub_iarray_n
   #define	OMarray_get_sub_farray		OMarray_get_sub_farray_n
   #define	OMarray_get_sub_rarray		OMarray_get_sub_rarray_n
   #define	OMraw_array_get_sub_barray	OMraw_array_get_sub_barray_n
   #define	OMraw_array_get_sub_sarray	OMraw_array_get_sub_sarray_n
   #define	OMraw_array_get_sub_iarray	OMraw_array_get_sub_iarray_n
   #define	OMraw_array_get_sub_farray	OMraw_array_get_sub_farray_n
   #define	OMraw_array_get_sub_rarray	OMraw_array_get_sub_rarray_n
   #define	OMarray_set_sub_barray		OMarray_set_sub_barray_n
   #define	OMarray_set_sub_sarray		OMarray_set_sub_sarray_n
   #define	OMarray_set_sub_iarray		OMarray_set_sub_iarray_n
   #define	OMarray_set_sub_farray		OMarray_set_sub_farray_n
   #define	OMarray_set_sub_rarray		OMarray_set_sub_rarray_n
   #define	OMisub_array_get_array		OMisub_array_get_array_n
   #define	OMrsub_array_get_array		OMrsub_array_get_array_n
   #define	OMfsub_array_get_array		OMfsub_array_get_array_n
   #define	OMrarray_get_sub_iarray		OMrarray_get_sub_iarray_n
   #define	OMrarray_get_sub_farray		OMrarray_get_sub_farray_n
   #define	OMiarray_get_sub_barray		OMiarray_get_sub_barray_n
   #define	OMiarray_get_sub_sarray		OMiarray_get_sub_sarray_n
   #define	OMiarray_get_sub_rarray		OMiarray_get_sub_rarray_n
   #define	OMfarray_get_sub_rarray		OMfarray_get_sub_rarray_n
   #define	OMiarray_set_sub_barray		OMiarray_set_sub_barray_n
   #define	OMiarray_set_sub_sarray		OMiarray_set_sub_sarray_n
   #define	OMrarray_set_sub_farray		OMrarray_set_sub_farray_n
   #define	OMunset_get_array			OMunset_get_array_n
   #define	OMarray_get_array_size 		OMarray_get_array_size_n
   #define	OMarray_get_array_dims		OMarray_get_array_dims_n
   #define	OMarray_get_my_array_size	OMarray_get_my_array_size_n
   #define	OMarray_get_my_array_dims	OMarray_get_my_array_dims_n
   #define	OMarray_group_save_obj		OMarray_group_save_obj_n
   #define	OMarray_group_get_num_refs	OMarray_group_get_num_refs_n

   #define	OMrange_save_obj			OMrange_save_obj_n
   #define	OMgen_list_save_obj			OMgen_list_save_obj_n

   #define	OMarray_list_get_array		OMarray_list_get_array_n
   #define	OMarray_list_get_sub_iarray	OMarray_list_get_sub_iarray_n
   #define	OMarray_list_get_sub_rarray	OMarray_list_get_sub_rarray_n
   #define	OMarray_list_set_sub_iarray	OMarray_list_set_sub_iarray_n
   #define	OMarray_list_set_sub_rarray	OMarray_list_set_sub_rarray_n

   #define	OMval_get_num_refs			OMval_get_num_refs_n

   #define	OMref_obj_save_obj			OMref_obj_save_obj_n
   #define	OMref_obj_get_array			OMref_obj_get_array_n
   #define	OMref_obj_get_sub_barray		OMref_obj_get_sub_barray_n
   #define	OMref_obj_get_sub_sarray		OMref_obj_get_sub_sarray_n
   #define	OMref_obj_get_sub_iarray		OMref_obj_get_sub_iarray_n
   #define	OMref_obj_get_sub_farray		OMref_obj_get_sub_farray_n
   #define	OMref_obj_get_sub_rarray		OMref_obj_get_sub_rarray_n
   #define	OMref_obj_set_sub_barray		OMref_obj_set_sub_barray_n
   #define	OMref_obj_set_sub_sarray		OMref_obj_set_sub_sarray_n
   #define	OMref_obj_set_sub_iarray		OMref_obj_set_sub_iarray_n
   #define	OMref_obj_set_sub_farray		OMref_obj_set_sub_farray_n
   #define	OMref_obj_set_sub_rarray		OMref_obj_set_sub_rarray_n
   #define	OMref_obj_get_array_size 	OMref_obj_get_array_size_n
   #define	OMref_obj_get_array_dims		OMref_obj_get_array_dims_n
   #define	OMref_obj_get_num_subobjs	OMref_obj_get_num_subobjs_n
   #define	OMref_obj_get_num_refs		OMref_obj_get_num_refs_n


   #define	OMlink_save_obj			OMlink_save_obj_n
   #define	OMmlink_save_obj			OMmlink_save_obj_n
   #define	OMmlink_get_array			OMmlink_get_array_n
   #define	OMmlink_get_sub_iarray		OMmlink_get_sub_iarray_n
   #define	OMmlink_get_sub_rarray		OMmlink_get_sub_rarray_n
   #define	OMmlink_get_num_refs		OMmlink_get_num_refs_n
   #define	OMmlink_get_array_size 		OMmlink_get_array_size_n
   #define	OMmlink_get_array_dims		OMmlink_get_array_dims_n

   #define	OMmerge_get_num_subobjs		OMmerge_get_num_subobjs_n
   #define	OMstandin_get_num_subobjs	OMstandin_get_num_subobjs_n
   #define	OMbuffer_get_num_subobjs		OMbuffer_get_num_subobjs_n
#endif

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* OM_TYPE_INCLUDED */
