/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/port.h#1 $
*/
#ifndef PORT_HEADER_IS_INCLUDED
#define PORT_HEADER_IS_INCLUDED

#define XP_F77_PROTO(L,U) L ## _
#define XP_F77_DECL(L,U) L ## _

#define PTARGS(A)	A

/*
 * Use the "stdarg" package instead of varargs to implement variable
 * argument functions.
 */
#define STDARG

/*
 * Some functions handcode their arguments...
 */
#define USE_PROTOS

/* Globally include these standard system header files. Some of our
 * own autogenerated C++ code will fail at compile time without string.h.
 */
#include <string.h>
#include <stdio.h>

/* define symbols for global declarations and referencing of global
   variables. */

#define IMPORT      extern
#define EXPORT

#define IMPORT_GLOBAL extern
#define EXPORT_GLOBAL

#define USE_SOCKETS
#define USE_UNIX

/*
 * These are the various data representations that can be used
 * for communication between the AVS kernel and modules.
 */
#define COMM_XDR_CHAR	0		/* ASCII */

#define COMM_XDR_INT	0		/* 32 bit bigendian */
#define COMM_LE32_INT	1		/* 32 bit littleendian */
#define COMM_BE64_INT	2		/* 64 bit bigendian */

#define COMM_XDR_INT64	0		/* 32 bit bigendian */
#define COMM_LE32_INT64	1		/* 32 bit littleendian */
#define COMM_BE64_INT64	2		/* 64 bit bigendian */

#define COMM_XDR_LONG	0		/* 32 bit bigendian */
#define COMM_LE32_LONG	1		/* 32 bit littleendian */
#define COMM_BE64_LONG	2		/* 64 bit bigendian */

#define COMM_XDR_FLOAT	0		/* IEEE */
#define COMM_REV_FLOAT	1		/* IEEE, reversed byte order */
#define COMM_CRAY_FLOAT	2		/* Cray */
#define COMM_VAX_FLOAT	3		/* VAX F */
#define COMM_SX3_FLOAT1	4		/* NEC SX-3 float1 */
#define COMM_SX3_FLOAT2	5		/* NEC SX-3 float2 */

#define COMM_XDR_DOUBLE	0		/* IEEE */
#define COMM_REV_DOUBLE	1		/* IEEE, reversed byte order */
#define COMM_CRAY_DOUBLE	2		/* Cray */
#define COMM_VAX_DOUBLE	3		/* VAX D */
#define COMM_SX3_DOUBLE1	4		/* NEC SX-3 double1 */
#define COMM_SX3_DOUBLE2	5		/* NEC SX-3 double2 */

/* Added for AVS compatibility -- garyo */
#define COMM_XDR_SHORT	0	/* 32 bit (YES!) bigendian */
#define COMM_BE16_SHORT	1	/* 16 bit bigendian */
#define COMM_LE16_SHORT	2	/* 16 bit littleendian */
#define COMM_BE64_SHORT	3	/* 64 bit bigendian */

#define AVS_BIGENDIAN
/*
 * If you defined "SHARED_MEMORY" to be 1 it compiles the code
 * to enable it.  If you redefine this to be 0, it will be off by default
 * unless you turn it on either using the global variable: AVSuse_shared_memory
 * or equivalently by using the -shm option.
 */
#define DEFAULT_SHARED_MEMORY 1
/*
 * Some systems may have problems with mapping shared memory read-only.
 * Since downstream modules should not write into their input ports, we
 * normally map it as read-only.  Some systems, however, don't allow you
 * to write this data into a socket (i.e. to the X server).  If your
 * display image module dies on an XIO error, try setting this to 0.
 */
#define DEFAULT_SHM_RDONLY    1

/*
 * These next three comments help us pick appropriate addresses for
 * choosing where to map shared memory segments in our address space.
 * If you specify "0" is means that you trust the OS to handle this for you
 * properly.  If you don't trust your OS to do something that isn't mindless
 * you should set them to be a lower number than the largest stack you'd
 * expect and higher than the largest data segment you'd expect.  Increment
 * can be positive or negative.  Because of this, END_ADDR should be exactly
 * equal to a multiple of START_ADDR (we stop checking when the address ==
 * END_ADDR.  The code that uses this is in field.c and ucd_struct.c in
 * kernel/libflow.
 *
 * XXX - this is not fully implemented yet!
 */
#define SHM_START_ADDR 	      0
#define SHM_INCREMENT	      0
#define SHM_END_ADDR	      0


/*
 * By default, we use VARARGS to parse arguments from AVScorout_input and
 * AVScorout_output.  If your system doesn't support VARARGS, you can try
 * undefining this value and we have a hack that might work.
 */
#define USE_VARARGS

/*
 * If your system defines "SYSV" but also is more efficient with the
 * vfork system call rather than the fork system call then you should
 * define "USE_VFORK"
 */
/* #define USE_VFORK */

/*
 * This is used as the first argument to the "select" system call.
 * It normally is set to be the maximum number of file descriptors
 * that a system supports.
 */
#define AVS_NFDS (sizeof(fd_set)*8)

/* We use this file to get the value for FIONREAD and perhaps others.. */
#define FILIO_H

#define SELECT_H <sys/select.h>

#define AVS_PATH_MAX     1024     /* The number of bytes in a pathname */

/* Some systems, e.g. SunOS4, don't have memmove: bcopy is the equiv...
 * BUT the src and dst args are reversed; if you must use bcopy put the
 * following in your slot (to overwrite the memmove def)
 *
#define MEMMOVE(DST, SRC, LEN) bcopy(SRC, DST, LEN)
 */
#define MEMMOVE(DST, SRC, LEN) memmove(DST, SRC, LEN)

/*
 * generic dynamic library open, lookup, error, close defs
 */
#if !defined(__hpux)
#define DL_BIND RTLD_LAZY
#define DL_OPEN(LIB, MODE, HANDLE) \
			HANDLE = dlopen(LIB, MODE)
#define DL_LOOKUP(HANDLE, NAME, TYPE, FUNC) \
			FUNC = (TYPE) dlsym(HANDLE, NAME)
#define DL_ERROR()		dlerror()
#define DL_CLOSE(HANDLE)	dlclose(HANDLE)
#endif

/*
 * generic prefix for DLL functions, data
 */
#define DLL_EXPORT
#define DLL_IMPORT extern

/**********************************************************************/

#ifdef _AIX

/* Header file for dynamic linking facilities (use generic macros,
   defined above as DL_OPEN, etc).
 */
#include <dlfcn.h>

#undef FILIO_H

/* IBM /usr/lpp/xlC/include/math.h now defines this macro
   #ifndef _ABS
   #define _ABS(A) ((A)>0?(A):-(A))
   #endif
*/

/*
 * If you define NO_ALARM, you will not use "sigalarms" to deal with the
 * status bar widget.  This shouldn't affect the status bar too much but
 * is not quite as well tested as the default.  Some systems have problems
 * with using SIGALRM because it can screw up execution of the program.
 */
#define NO_ALARM

/* This system supports "waitpid" rather than "wait3" */
#define WAITPID

#define USE_VFORK

#ifndef BSD
#define BSD 0
#endif

#ifndef _BSD
#define _BSD 0
#endif

#undef AVS_LITTLEENDIAN
#define AVS_BIGENDIAN

#define LUI_GAMMA 2.2

#define SHARED_MEMORY 1

#define ALLOC_LOCAL(A) malloc(A)
#define FREE_LOCAL(P)  free(P)

/* Allows some Fortran binding functions to return char* values */
#define PT_F77_CHAR_RETURN 1

/* PT_F77_C_STR is the arg type passing a char* between C and Fortran */
/* It can be a char* or a struct. */

typedef char* PT_F77_C_STR;

/*
 * The IBM does not use the _ in naming fortran routines unless you
 * give the -qextname option (which we do not do currently)
 */
#undef XP_F77_PROTO
#define XP_F77_PROTO(L,U) L
#undef XP_F77_DECL
#define XP_F77_DECL(L,U) L

#ifndef SHMMGR
#define SHMMGR
#endif

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

#endif /* _AIX */

/**********************************************************************/

#ifdef __sgi

/* Header file for dynamic linking facilities (use generic macros,
   defined above as DL_OPEN, etc). */

#include <dlfcn.h>

#undef FILIO_H
#define NO_SELECT_H
#define HAS_GL_TRANS
#define HAS_GL_SPHERES
#define HAS_GL_TEXTURE

/* define simple symbol as alternative to __sgi   */
/* some compiler flags will force this definition */

#ifndef sgi
#define sgi
#endif

/* No longer use irix6 to mean the 64 ABI,
 * allow irix6 to mean IRIX 6.X (if needed).
 */

#if defined( _ABI64) && (_MIPS_SIM == _ABI64)
#define irix_64
#define irix6_n64
#define WORDLENGTH_64
#endif

#if defined(_ABIO32) && (_MIPS_SIM == _ABIO32)
#define irix_32
#define irix6_o32
#endif

#if defined( _ABIN32) && (_MIPS_SIM == _ABIN32)
#define irix_32
#define irix6_n32
#endif

/*
 * If you define NO_ALARM, you will not use "sigalarms" to deal with the
 * status bar widget.  This shouldn't affect the status bar too much but
 * is not quite as well tested as the default.  Some systems have problems
 * with using SIGALRM because it can screw up execution of the program.
 */
#define NO_ALARM

/* This system supports "waitpid" rather than "wait3" */
#define WAITPID

#ifndef BSD
#define BSD
#endif

#define SIGSET

#ifndef _BSD
#define _BSD
#endif

#undef AVS_LITTLEENDIAN
#define AVS_BIGENDIAN

/* This file defines things like MAXFLOAT on this platform */
#include <values.h>

#define SHARED_MEMORY 1

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

#define ALLOC_LOCAL(A) malloc(A)
#define FREE_LOCAL(P)  free(P)

/* Allows some Fortran binding functions to return char* values */
#define PT_F77_CHAR_RETURN 1

/* PT_F77_C_STR is the arg type passing a char* between C and Fortran */
/* It can be a char* or a struct. */

typedef char* PT_F77_C_STR;

#ifndef SHMMGR
#define SHMMGR
#endif

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

#define LUI_GAMMA 1.0

#endif /* __sgi */

/**********************************************************************/

#ifdef __sun

/*
 * We need this in order to get the real signal management facility
 * that does not get reset after a signal is delivered.  On sunos4
 * by default, this is "signal" (the default if we don't use this)
 * but since we use the compatiblility version of libc.a, we need
 * this flag.
 *
 * This also gets set for solaris 2.0
 */
#define SIGSET

/*
 * These functions are part of strict ANSI
 */
#if __STDC__ - 0 != 0

extern char *strdup(const char *);

/*
 * We need to include thread.h so that the 'errno' variable is handled
 * properly if calls are made to libraries from within a "threaded"
 * environment.  Note: we also need _REENTRANT to be defined at top level.
 */
#include <thread.h>

#endif

#define FCNTL_H

#define NO_SELECT_H

#include <time.h>

/*
 * If you define NO_ALARM, you will not use "sigalarms" to deal with the
 * status bar widget.  This shouldn't affect the status bar too much but
 * is not quite as well tested as the default.  Some systems have problems
 * with using SIGALRM because it can screw up execution of the program.
 */
#define NO_ALARM

/* This system supports "waitpid" rather than "wait3" */
#define WAITPID

#define USE_VFORK

/* object center expects this to have a value */
#ifndef BSD
#define BSD 1
#endif

#ifndef _BSD
#define _BSD 1
#endif

#include <float.h>

#ifndef FLT_MIN
#include <values.h>
#define FLT_MIN MINFLOAT
#endif

#if defined(__STDC__) && (__STDC__ == 1)
/* Pure ANSI-C mode doesn't provide these symbols.  However,
 * These symbols generate warnings from the C++ compiler
 * when this file is included in C++ code ahead of math.h.
 */

#ifndef M_PI
#define M_PI 3.141592653589793238462643383279
#endif

#ifndef MAXFLOAT
#define MAXFLOAT FLT_MAX
#endif

#ifndef _ABS
#define _ABS(A) ((A)>0?(A):-(A))
#endif

#endif /* pure ANSI-C mode */

#define SHARED_MEMORY 1

#define LUI_GAMMA 2.22

#define ALLOC_LOCAL(A) malloc(A)
#define FREE_LOCAL(P)  free(P)

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

/* Allows some Fortran binding functions to return char* values */
#define PT_F77_CHAR_RETURN 1

/* PT_F77_C_STR is the arg type passing a char* between C and Fortran */
/* It can be a char* or a struct. */

typedef char* PT_F77_C_STR;

#ifndef SHMMGR
#define SHMMGR
#endif

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

/* dynamic lib stuff... */
#include <dlfcn.h>

#ifdef __sparcv9
#define WORDLENGTH_64
#endif

#endif /* Sun/Solaris */

/**********************************************************************/

#if defined(hpux) || defined(__hpux)

#undef XP_F77_PROTO
#define XP_F77_PROTO(L,U) L
#undef XP_F77_DECL
#define XP_F77_DECL(L,U) L

#undef FILIO_H

#define NO_SELECT_H

/*
 * If you define NO_ALARM, you will not use "sigalarms" to deal with the
 * status bar widget.  This shouldn't affect the status bar too much but
 * is not quite as well tested as the default.  Some systems have problems
 * with using SIGALRM because it can screw up execution of the program.
 */
#define NO_ALARM

/* refers to the hp-apollo systems */
#define hp hp

/* This system supports "waitpid" rather than "wait3" */
#define WAITPID

#define USE_VFORK

/* Use sigset for lasting signals on the HP */
#define SIGSET

#ifndef BSD
#define BSD
#endif

#ifndef _BSD
#define _BSD
#endif

#define SHARED_MEMORY 1

#define LUI_GAMMA 1.75

#define ALLOC_LOCAL(A) malloc(A)
#define FREE_LOCAL(P)  free(P)

typedef char* PT_F77_C_STR;

#ifndef SHMMGR
#define SHMMGR
#endif

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

/*
 * dynamic library open, lookup, error, close defs
 */
#include <dl.h>

/* conflicting symbols in some versions of dl.h */
#undef DL_BIND
#undef DL_OPEN
#undef DL_LOOKUP
#undef DL_ERROR
#undef DL_CLOSE

#define DL_BIND DYNAMIC_PATH|BIND_IMMEDIATE
#define DL_OPEN(LIB, MODE, HANDLE)	HANDLE = shl_load(LIB, MODE, 0L)
#define DL_LOOKUP(HANDLE, NAME, TYPE, FUNC) \
			shl_findsym(&HANDLE, NAME, TYPE_PROCEDURE, (TYPE) &FUNC)
#define DL_ERROR()		(char *)(perror(NULL), "DL_FUNCTION_FAILED")
#define DL_CLOSE(HANDLE)	shl_unload(HANDLE)


#ifdef hp11 /* Not in math.h for hp11 */
#ifndef _ABS
#define _ABS(A) ((A)>0?(A):-(A))
#endif
#endif

#ifdef __LP64__
#define WORDLENGTH_64
#endif

#endif /* hp   */

/*********************** ALPHA OSF/Digital UNIX/Tru64 *****************/

#if defined (__alpha) && defined(__osf__)

/* create a less clumsy define for __alpha && __osf__ */
#define alpha_osf

/*
 * Sometime we get "Interrupted system call" errors and sometimes we don't.
 */
#define NO_ALARM

#define NO_SELECT_H
#undef FILIO_H
#define USE_VFORK

#ifndef BSD
#define BSD
#endif

#undef AVS_BIGENDIAN
#define AVS_LITTLEENDIAN

#define COMM_MY_INT         COMM_LE32_INT
#define COMM_MY_INT64       COMM_LE32_INT64
#define COMM_MY_LONG        COMM_LE32_LONG
#define COMM_MY_FLOAT       COMM_REV_FLOAT
#define COMM_MY_DOUBLE      COMM_REV_DOUBLE

#define LUI_GAMMA 1.7

/* all alpha osfs have 64-bit words */
#define WORDLENGTH_64

/* Shared memory is available for interprocess communication. */

#define SHARED_MEMORY 1

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

/* PT_F77_C_STR is the arg type passing a char* between C and Fortran */
/* It can be a char* or a struct. */

typedef char* PT_F77_C_STR;

#ifndef SHMMGR
#define SHMMGR
#endif

/* This file defines things like MAXFLOAT on this platform */
#include <values.h>

/* dynamic lib stuff... */
#include <dlfcn.h>

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

#endif /* ALPHA/OSF */

/*********************** Linux ****************************************/

#ifdef __linux__

#include <sys/types.h>  /* 64-bit porting. Included to support 'xp_long' */
#include <dlfcn.h>

#ifndef MAXFLOAT
#define MAXFLOAT FLT_MAX
#endif

/* Do any of the platforms use this anymore? */
#ifdef FILIO_H
#undef FILIO_H
#endif

#ifndef __const
#define __const const
#endif

#define LUI_GAMMA 2.0

#ifndef _ABS
#define _ABS(A) ((A)>0?(A):-(A))
#endif

#if defined(__LP64__)   || \
    defined(__ia64__)   || defined(__ia64) || \
    defined(__x86_64__) || defined(__x86_64)
#define WORDLENGTH_64
#endif

#ifdef AVS_BIGENDIAN
#undef AVS_BIGENDIAN
#endif
#define AVS_LITTLEENDIAN

#define COMM_MY_INT		COMM_LE32_INT
#define COMM_MY_INT64   COMM_LE32_INT64
#define COMM_MY_LONG	COMM_LE32_LONG
#define COMM_MY_FLOAT	COMM_REV_FLOAT
#define COMM_MY_DOUBLE	COMM_REV_DOUBLE

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

#endif

/*********************** Darwin/Mac OS X ******************************/

#if defined(__APPLE__) && defined(__MACH__)

/* Header file for dynamic linking facilities (use generic macros,
   defined above as DL_OPEN, etc).
 */
#include <dlfcn.h>

#define XP_DARWIN

#ifndef BSD
#define BSD 1
#endif

#define LUI_GAMMA 2.0

#ifndef _ABS
#define _ABS(A) ((A)>0?(A):-(A))
#endif

#if defined (__ppc__)
/* On PPC anyway, Darwin is big-endian.  */
#undef AVS_LITTLEENDIAN
#define AVS_BIGENDIAN
#elif defined (__i386__)
/* Little-endian on Intel. */
#undef AVS_BIGENDIAN
#define AVS_LITTLEENDIAN
#define COMM_MY_INT		COMM_LE32_INT
#define COMM_MY_INT64	COMM_LE32_INT64
#define COMM_MY_LONG	COMM_LE32_LONG
#define COMM_MY_FLOAT	COMM_REV_FLOAT
#define COMM_MY_DOUBLE	COMM_REV_DOUBLE
#endif

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

/* Regular expression library type. */
/* Standardize on POSIX regular expressions. */
#define USE_REGEXEC

#endif

/*********************** Windows **************************************/

#ifdef MSDOS
#include <stdlib.h>
#include <sys/types.h> /* 64-bit changes. Included to support time_t off_t definitions */

/* PC fortran uses upper-case symbol name? */
#undef XP_F77_PROTO
#define XP_F77_PROTO(L,U) U
#undef XP_F77_DECL
#if _MSC_VER >= 1300
#define XP_F77_DECL(L,U) U
#else
#define XP_F77_DECL(L,U) __stdcall U
#endif

#undef AVS_BIGENDIAN
#define AVS_LITTLEENDIAN

#define COMM_MY_INT		COMM_LE32_INT
#define COMM_MY_INT64	COMM_LE32_INT64
#define COMM_MY_LONG	COMM_LE32_LONG
#define COMM_MY_FLOAT	COMM_REV_FLOAT
#define COMM_MY_DOUBLE	COMM_REV_DOUBLE

/* Use calls to alloca() in the OM in order to reduce OM stack space usage */
#define OM_ALLOCA 1

#ifdef FILIO_H
#undef FILIO_H
#endif

#ifdef USE_UNIX
#undef USE_UNIX
#endif

#ifndef USE_SOCKETS
#define USE_SOCKETS
#endif

#ifndef M_PI
#define M_PI	3.141592652589793238462643383279
#endif

#define MAXFLOAT FLT_MAX

#define NO_SELECT_H
#define EWOULDBLOCK 0

#ifndef USE_PROTOS
#define USE_PROTOS
#endif

#ifndef _ABS
#define _ABS(A) ((A)>0?(A):-(A))
#endif

#define ShiftMask	0x1
#define ControlMask	0x2

#define LUI_GAMMA	1.8

#ifndef __cplusplus
#define putenv _putenv
#define getcwd _getcwd
#define open _open
#define close _close
#define read _read
#define write _write
#define unlink _unlink
#define stat _stat
#endif

#define strdup _strdup
#define crypt(str, hash) strdup(str)
#define getpid _getpid
#define hypot _hypot
#define random rand
#define popen _popen
#define pclose _pclose

/*
 * dynamic library open, lookup, error, close defs
 */
#undef DL_OPEN
#undef DL_LOOKUP
#undef DL_ERROR
#undef DL_CLOSE

#define DL_OPEN(LIB, MODE, HANDLE) \
				HANDLE = LoadLibrary(LIB)
#define DL_LOOKUP(HANDLE, NAME, TYPE, FUNC) \
				FUNC = (TYPE) GetProcAddress(HANDLE, NAME)
#define DL_ERROR() \
				(char *)(perror(NULL), "DL_FUNCTION_FAILED")
#define DL_CLOSE(HANDLE) \
				FreeLibrary(HANDLE)

/*
 * DLL prefix for functions, data
 */
#ifndef XP_STATIC_BUILD
#undef DLL_EXPORT
#define DLL_EXPORT __declspec(dllexport)

#undef DLL_IMPORT
#define DLL_IMPORT __declspec(dllimport)
#endif

#endif /* Windows */
/*************************************************************/
/**********************************************************************/

/* Provide generic definitions for those not already defined          */

/* For systems that have alloca, it is more efficient to use it than malloc */
#ifndef ALLOC_LOCAL
#define ALLOC_LOCAL(A)  malloc(A)
#define FREE_LOCAL(P)   free(P)
#endif /* ALLOC_LOCAL */


/*
 * Most machines (Sun/SPARC, IRIX/MIPS) have XDR as native format.
 * Intel and DEC Alpha have opposite byte order.
 * Cray has own floating point format and everything is 64 bits.
 */

#ifndef COMM_MY_CHAR
#define COMM_MY_CHAR COMM_XDR_CHAR
#endif

#ifndef COMM_MY_INT
#define COMM_MY_INT COMM_XDR_INT
#endif

#ifndef COMM_MY_INT64
#define COMM_MY_INT64 COMM_XDR_INT64
#endif

#ifndef COMM_MY_LONG
#define COMM_MY_LONG COMM_XDR_LONG
#endif

#ifndef COMM_MY_FLOAT
#define COMM_MY_FLOAT COMM_XDR_FLOAT
#endif

#ifndef COMM_MY_DOUBLE
#define COMM_MY_DOUBLE COMM_XDR_DOUBLE
#endif

#ifndef COMM_MY_SHORT
#define COMM_MY_SHORT COMM_XDR_SHORT
#endif


/* Tell lint to ignore unused arguments - should be optimized out by compiler*/
/* Should follow local declarations, doesn't need to be terminated with ; */
#ifndef UNUSED_ARG
#define UNUSED_ARG(A)
#endif /* UNUSED_ARG */

/* Fortran string decoding
 * Default assumes that the string length is passed as an separate int argument
 */

#ifndef PT_F77_STRING
#define PT_F77_STRING(raw_value, raw_len, value, len) \
  {value = raw_value; len = raw_len;}
#endif

#ifndef PT_F77_LOAD_C_STR
#define PT_F77_LOAD_C_STR(value, c_str_value, c_str_len) \
  { c_str_value = value; c_str_len = strlen(value);}
#endif

#ifndef PT_F77_PASS_C_STR
/* Define how to pass Fortran a char string from C */
#define PT_F77_PASS_C_STR(c_str) (c_str)
#endif

/* Allows some Fortran binding functions to return char* values */
#ifndef PT_F77_CHAR_RETURN
#define PT_F77_CHAR_RETURN 0
#endif

/* Fortran manipulation functions to find string terminator and copy to C string */
/* Used for fixed size strings using F77_STRING_COPY instead of allocating storage */
#define F77_MAX_STRLEN 128

#define F77_STRING_ALLOC(raw_value,raw_len,local_value)\
{ int tlen; char *tvalue = 0; \
  f77_trim_string(raw_value,raw_len,&tvalue,&tlen); \
  local_value = (char*) ALLOC_LOCAL(tlen+1); \
  memcpy(local_value,tvalue,tlen); \
  local_value[tlen] = '\0'; }

#define F77_STRING_ALLOC_BUF(raw_value,raw_len,local_value)\
{ int tlen; char *tvalue = 0; \
  PT_F77_STRING(raw_value, raw_len, tvalue, tlen) \
  local_value = (char*) ALLOC_LOCAL(tlen+1); \
  local_value[0] = '\0'; }

#define F77_STRING_COPY(raw_value,raw_len,local_value)\
{ int tlen; char *tvalue = 0; \
  f77_trim_string(raw_value,raw_len,&tvalue,&tlen); \
  strncpy(local_value,tvalue,tlen); \
  local_value[tlen] = '\0'; }

#define F77_STRING_FREE(P) \
  if (P != 0) FREE_LOCAL(P)

/******************/

/* Byte offset index */
#define AVS_ALPHA_BYTE 	0
#define AVS_RED_BYTE  	1
#define AVS_GREEN_BYTE	2
#define AVS_BLUE_BYTE	3

#ifdef AVS_BIGENDIAN

#define AVS_ALPHA_MASK 	0xff000000
#define AVS_RED_MASK 	0x00ff0000
#define AVS_GREEN_MASK	0x0000ff00
#define AVS_BLUE_MASK	0x000000ff

#define AVS_ALPHA_SHIFT 24
#define AVS_RED_SHIFT	16
#define AVS_GREEN_SHIFT 8
#define AVS_BLUE_SHIFT  0

#else

#define AVS_ALPHA_MASK 	0x000000ff
#define AVS_RED_MASK 	0x0000ff00
#define AVS_GREEN_MASK	0x00ff0000
#define AVS_BLUE_MASK	0xff000000

#define AVS_ALPHA_SHIFT 0
#define AVS_RED_SHIFT	8
#define AVS_GREEN_SHIFT 16
#define AVS_BLUE_SHIFT  24

#endif


#ifdef WORDLENGTH_64

#define AVS_SWAP_INT(a)  ( (((a) << 24) & 0xff000000) | \
			   (((a) <<  8) & 0x00ff0000) | \
			   (((a) >>  8) & 0x0000ff00) | \
	     (((unsigned int)(a) >> 24) & 0x000000ff)   )

#define AVS_SWAP_WORD(a) ( (((a) << 56) & (0xff00000000000000)) | \
			   (((a) << 40) & (0x00ff000000000000)) | \
			   (((a) << 24) & (0x0000ff0000000000)) | \
			   (((a) <<  8) & (0x000000ff00000000)) | \
			   (((a) >>  8) & (0x00000000ff000000)) | \
			   (((a) >> 24) & (0x0000000000ff0000)) | \
	 		   (((a) >> 40) & (0x000000000000ff00)) | \
	    (((unsigned long)(a) >> 56) & (0x00000000000000ff      ))   )

#else /* WORDLENGTH_32 */

#define AVS_SWAP_WORD(a) ( (((a) << 24) & 0xff000000) | \
			   (((a) <<  8) & 0x00ff0000) | \
			   (((a) >>  8) & 0x0000ff00) | \
	    (((unsigned long)(a) >> 24) & 0x000000ff)   )

#define AVS_SWAP_INT(a) AVS_SWAP_WORD(a)

#endif

/*
 * This macro takes an integer offset and 'aligns' it to the strictest
 * alignment required by the target machine.
 * On all current target machines, alignment on double (8 bytes) is sufficie
nt.
 */
#define UT_ALIGN(nbytes) \
((nbytes) + ((sizeof(double) - ((nbytes) % sizeof(double))) % sizeof(double)))


#if (COMM_MY_FLOAT == COMM_XDR_FLOAT) || (COMM_MY_FLOAT == COMM_REV_FLOAT)
#define AVS_IEEEFP
#endif

/*
 * If this isn't a "bsd" system, define the use of FCNTL by default.
 * Allow someone to override this by defining FILE_H.
 */
#ifndef BSD
#if !defined(FCNTL_H) && !defined(FILE_H)
#define FCNTL_H
#endif
#endif

/**********************************************************************/

#ifdef MSDOS

#define SIO_R_BIN	"rb"
#define SIO_W_BIN	"wb"
#define SIO_A_BIN	"ab"
#define SIO_RU_BIN	"r+b"
#define SIO_WU_BIN	"w+b"
#define SIO_AU_BIN	"a+b"

#define SIO_R_TXT	"rt"
#define SIO_W_TXT	"wt"
#define SIO_A_TXT	"at"
#define SIO_RU_TXT	"r+t"
#define SIO_WU_TXT	"w+t"
#define SIO_AU_TXT	"a+t"

#else	/* !MSDOS */

#define SIO_R_BIN	"r"
#define SIO_W_BIN	"w"
#define SIO_A_BIN	"a"
#define SIO_RU_BIN	"r+"
#define SIO_WU_BIN	"w+"
#define SIO_AU_BIN	"a+"

#define SIO_R_TXT	"r"
#define SIO_W_TXT	"w"
#define SIO_A_TXT	"a"
#define SIO_RU_TXT	"r+"
#define SIO_WU_TXT	"w+"
#define SIO_AU_TXT	"a+"

#endif


#define XP_HAS_BYTE
typedef unsigned char xp_byte;

#define XP_HAS_LONG

/* 64-bit porting. Introduction of new long data type for AVS/Express. */
#ifdef WORDLENGTH_64             /* 64-bit platforms */
#ifdef MSDOS  /* Win64 */                
  typedef __int64 xp_long;
  typedef unsigned __int64 xp_ulong;
#else         /* Other platforms */                       
  typedef long xp_long;       
  typedef unsigned long xp_ulong;
#endif
#else                            /* 32-bit platforms */
  typedef int xp_long;
  typedef unsigned int xp_ulong;
#endif

/* 64-bit porting. Limits for the AVS datatypes */
#ifdef WORDLENGTH_64
#define AVS_INT_MIN  -2147483647
#define AVS_LONG_MIN -9223372036854775807
#define AVS_INT_MAX  +2147483647
#define AVS_LONG_MAX +9223372036854775807
#else
#define AVS_INT_MIN  -2147483647
#define AVS_LONG_MIN -2147483647
#define AVS_INT_MAX  +2147483647
#define AVS_LONG_MAX +2147483647
#endif

#endif /* PORT_HEADER_IS_INCLUDED */
