/*
			Copyright (c) 2001 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/portxdr.h#1 $
*/

#ifndef XP_PORTXDR_H
#define XP_PORTXDR_H

/*
   Definitions for platforms that have have explicit XDR get/put
   int operations.  These platforms usually extend struct xdr_ops
   (Alpha is the exception), but do so in different ways, which
   causes porting problems.  When adding a new 64-bit platform, you
   need to study the definition of struct xdr_ops in /usr/include/rpc/xdr.h
   and modify the places in our code where struct xdr_ops is used to
   add the platform-depdendent ifdefs.

   Alpha is odd in that it has no get/put for longs, only for ints.
   Thats more consistent with the way that XDR actually works, but
   its different from everybody else's implementation.

   inline_t is the return type of the XDR inline operator.
*/

#ifdef WORDLENGTH_64

#if defined(__sun) || defined(__linux__)
#define XP_XDR_GETINT(x,y) XDR_GETINT32(x,y)
#define XP_XDR_PUTINT(x,y) XDR_PUTINT32(x,y)
#define XP_XDR_INT_OPS 1
#define XP_XDR_LONG_OPS 1
#define XP_XDR_INT64(x,y)  xdr_int64_t(x,y)
#define XP_XDR_UINT64(x,y) xdr_uint64_t(x,y)
typedef int inline_t;
#elif defined(alpha_osf)
/* Despite the names, on Alpha these operators take ints. */
#define XP_XDR_GETINT(x,y) XDR_GETLONG(x,y)
#define XP_XDR_PUTINT(x,y) XDR_PUTLONG(x,y)
#define XP_XDR_INT_OPS 1
#define XP_XDR_INT64(x,y)  xdr_hyper(x,y)
#define XP_XDR_UINT64(x,y) xdr_u_hyper(x,y)
typedef int inline_t;
#elif defined(__sgi)
#define XP_XDR_GETINT(x,y) XDR_GETINT(x,y)
#define XP_XDR_PUTINT(x,y) XDR_PUTINT(x,y)
#define XP_XDR_INT_OPS 1
#define XP_XDR_LONG_OPS 1
typedef long inline_t;
#elif defined(__hpux)
/* no get/put int operators in 64-bit mode */
#define XP_XDR_LONG_OPS 1
#define XP_XDR_INT64(x,y)  xdr_hyper(x,y)
#define XP_XDR_UINT64(x,y) xdr_u_hyper(x,y)
typedef long inline_t;
#elif defined(_AIX)
/* no get/put int operators in 64-bit mode */
#define XP_XDR_LONG_OPS 1
/* does have GET/PUT HYPER */
#define XP_XDR_INT64(x,y)  xdr_hyper(x,y)
#define XP_XDR_UINT64(x,y) xdr_u_hyper(x,y)
typedef long inline_t;
#endif

#else /* !WORDLENGTH_64 */

/* On 32-bit machines it should be safe to mix pointers to
   long with pointers to int.
*/
#define XP_XDR_GETINT(x,y) XDR_GETLONG(x,(long *)y)
#define XP_XDR_PUTINT(x,y) XDR_PUTLONG(x,(long *)y)
#define XP_XDR_INT_OPS 1
#define XP_XDR_LONG_OPS 1
typedef long inline_t;

#endif

#if defined(__sun) || defined(__hpux)
#define XP_XDR_CONTROL_OPS 1
#endif

#endif /* XP_PORTXDR_H */
