/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/pt_bsd_t.h#1 $
*/
/* This is a temporary file to isolate the inclusion of a section of
 * the 4.3BSD types.h file which is included
 *     in the stellar sys/types.h file
 *     and on the titan as bsd/types.h
 * Unfortunately the combination of sys/types.h and bsd/types.h does't work
 * So temporarily this is system dependent
 */

#ifndef _AVS_PT_BSD_TYPES_HEADER
#define _AVS_PT_BSD_TYPES_HEADER

#ifndef NBBY

#include SELECT_H

#ifdef __cplusplus
extern "C" {
#endif

#if 0

/**********************************************************************/
/*
 * The following is included from 4.3BSD types.h to support the
 * select system call.
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */

#define NBBY 8			/* no. of bits in a byte */

#ifndef	FD_SETSIZE
#define	FD_SETSIZE	256
#endif


typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	memset((char *)(p), '\0', sizeof(*(p)))

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif

#endif _AVS_PT_BSD_TYPES_HEADER
