/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/strmio.h#1 $
*/
#ifndef XP_STRMIO_INCLUDED
#define XP_STRMIO_INCLUDED

#include <stdio.h>
#include <avs/port.h>

#define IO_STREAM_BUFSIZE 	2048

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _IO_file_stream {
    FILE *fp;
} IO_file_stream;

typedef struct _IO_mem_stream {
    char *ptr;
    xp_long size_alloced;
    xp_long size_used;
} IO_mem_stream;

#define IO_STREAM_FP	1
#define IO_STREAM_MEM 	2

typedef struct _IOstream {
    int type;
    union {
       IO_file_stream fs;
       IO_mem_stream ms;
    } v;
    unsigned int trigger:1;
    char *trigger_buf;
    xp_long trigger_size;
} IOstream;

IOstream *IOstream_file_open (const char *file);
IOstream *IOstream_file_append (const char *file);
IOstream *IOstream_mem_open (void);
int IOstream_mem_compare (IOstream *stream, const char *file);
int IOstream_mem_write (IOstream *stream, const char *file);
void IOstream_close (IOstream *stream);
void IOstream_flush (IOstream *stream);

void IOstream_triggered_output (IOstream *stream,...);
int IOstream_trigger_cancel (IOstream *stream);

void IOstream_output (IOstream *stream,...);
char * IOint_to_str (int ival, char *buf);
char * IOlong_to_str (xp_long lval, char *buf);

#ifdef __cplusplus
} /* end of extern C */
#endif

#endif
