/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/ucd_topo.h#1 $
*/

#ifndef _UCD_TOPO_H_defined
#define _UCD_TOPO_H_defined

/*-----------------------------------------------------------------
 *        Cell topolgy  definition
 *-----------------------------------------------------------------*/

static int tri_topo[] = {3, 0, 1, 2}, 
	
	quad_topo[] = {4, 0, 1, 2, 3},
	
	tet_topo[] = {3, 1, 2, 0, 
			      3, 2, 3, 0, 
			      3, 3, 1, 0, 
			      3, 1, 3, 2},
	
	pyr_topo[] = {3, 0, 1, 2,
			      3, 0, 2, 3,
			      3, 0, 3, 4,
			      3, 4, 1, 0,
			      4, 1, 4, 3, 2},
	
	prism_topo[] = {3, 5, 4, 3,
				3, 0, 1, 2,
				4, 1, 4, 5, 2,
				4, 1, 0, 3, 4,
				4, 0, 2, 5, 3},
	
	hex_topo[] = {4, 0, 1, 2, 3, 
			      4, 1, 5, 6, 2, 
			      4, 3, 2, 6, 7,
			      4, 0, 3, 7, 4, 
			      4, 0, 4, 5, 1, 
			      4, 4, 7, 6, 5};

static int *cell_topos[] = {0, 0, tri_topo, quad_topo, tet_topo, pyr_topo, 
				     prism_topo, hex_topo};

static int tri_me[] = {3, 0, 1, 2}, 
	
	quad_me[] = {4, 0, 1, 2, 3},
	
	tet_me[] = {3, 3, 1, 0, 
			    3, 4, 2, 1, 
			    3, 5, 0, 2, 
			    3, 5, 4, 3},
	
	pyr_me[] = {3, 0, 4, 1,
			    3, 1, 5, 2,
			    3, 2, 6, 3,
			    3, 7, 0, 3,
			    4, 7, 6, 5, 4},
	
	prism_me[] = {3, 4, 3, 5,
			      3, 0, 1, 2,
			      4, 6, 4, 8, 1,
			      4, 0, 7, 3, 6,
			      4, 2, 8, 5, 7},
	
	hex_me[] = {4, 0, 1, 2, 3, 
			    4, 9, 5, 10, 1, 
			    4, 2, 10, 6, 11,
			    4, 3, 11, 7, 8, 
			    4, 8, 4, 9, 0, 
			    4, 7, 6, 5, 4};


static int *cell_mes[] = {0, 0, tri_me, quad_me, tet_me, pyr_me, 
				  prism_me, hex_me};

static float line_uvw_par[] = {0.0, 0.0, 0.0,
			       1.0, 0.0, 0.0};

static float tri_uvw_par[] = {1.0, 0.0, 0.0,
			      0.0, 1.0, 0.0,
			      0.0, 0.0, 0.0};

static float quad_uvw_par[] = {-1.0, -1.0,  0.0,
			        1.0, -1.0,  0.0,
			        1.0,  1.0,  0.0,
			       -1.0,  1.0,  0,0};

static float tet_uvw_par[] =  { 0.0,  0.0,  0.0,
			        0.0,  0.0,  1.0,
			        1.0,  0.0,  0.0,
			        0.0,  1.0,  0,0};

static float hex_uvw_par[] =  {-1.0,  1.0,  1.0,
			       -1.0, -1.0,  1.0,
			        1.0, -1.0,  1.0,
			        1.0,  1.0,  1,0,
			       -1.0,  1.0, -1.0,
			       -1.0, -1.0, -1.0,
			        1.0, -1.0, -1.0,
			        1.0,  1.0, -1,0};

static float pyr_uvw_par[]=   { 0.0,  0.0,  1.0,
			        1.0,  1.0, -1.0,
			       -1.0,  1.0, -1.0,
			       -1.0, -1.0, -1.0,
			        1.0, -1.0, -1.0};

static float prism_uvw_par[]= { 1.0,  0.0,  1.0,
			        0.0,  1.0,  1.0,
			        0.0,  0.0,  1.0,
				1.0,  0.0, -1.0,
			        0.0,  1.0, -1.0,
			        0.0,  0.0, -1.0};


static float *UCDcell_uvw[] = {NULL, line_uvw_par, tri_uvw_par, quad_uvw_par,
				tet_uvw_par, pyr_uvw_par, prism_uvw_par, hex_uvw_par};

#endif /* _UCD_TOPO_H_defined */
