/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/wt.h#1 $
*/

/* Header file for the WT subsystem */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_WT_INCLUDED
#define XP_WT_INCLUDED

/*---------------------------------------------------------------------*/

/* Header files */

#include <avs/wt_type.h>

/*--------------------------------------------------------------------*/
/*                       Function prototypes                          */
/*--------------------------------------------------------------------*/

#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif

/* From bmp.c */

void *
WTopen_bmp_file (
    const char *filename,
    int   access);

void
WTclose_bmp_file (
    void  *bmp);

WTstatus
WTget_bmp_width (
    void  *bmp,
    int   *width);

WTstatus
WTget_bmp_height (
    void  *bmp,
    int   *height);

WTstatus
WTget_bmp_ARGB_image (
    void           *bmp,
    unsigned char  **data);

/* From context.c */

WTdisp *
WTcreate_disp (
    WTsys_wind  ref_wind);

void
WTset_disp_pixel_func (
    WTdisp        *disp,
    WTpixel_func  func,
    void          *data);

WTpixel
WTget_pixel (
    WTdisp   *disp,
    WTcolor  color);

void
WTget_pixel_rgb_values (
    WTdisp   *disp,
    WTpixel  pixel,
    WTcoord  *r,
    WTcoord  *g,
    WTcoord  *b);

void
WTadd_root_window (
    WTdisp  *disp,
    WTwind  *window);

void
WTdelete_root_window (
    WTdisp  *disp,
    WTwind  *window);

void
WThide_pending (
    WTdisp  *disp);

void
WTshow_pending (
    WTdisp  *disp);

/* From cursor.c */

void
WTset_cursor (
    WTsys_wind      sys_wind,
    WTcursor_class  cursor_class);

/* From decor.c */

WTdecor_ptr
WTinstall_decor (
    WTdisp         *disp,
    WTdecor_class  decor_class,
    WTpixel        bg_pixel,
    WTsys_wind     ref_wind,
    WTcoord        bevel_thickness);

void
WTuninstall_decor (
    WTdecor_ptr  decor);

void
WTset_wind_decor (
    WTwind       *window,
    WTdecor_ptr  decor);

void
WTadd_decor_event_handler (
    WTwind  *window);

void
WTdraw_bevel_rect (
    WTwind       *window,
    WTdecor_ptr  decor, 
    WTcoord  x,
    WTcoord  y, 
    WTcoord  width,
    WTcoord  height,
    WTcoord  thickness,
    int      reverse);

void
WTdraw_separator (
    WTwind       *window,
    WTdecor_ptr  decor,
    int      horiz,
    WTcoord  min,
    WTcoord  max, 
    WTcoord  loc,
    WTcoord  thickness);

void
WTdraw_border (
    WTwind       *window,
    WTdecor_ptr  decor,
    WTcoord  x,
    WTcoord  y,
    WTcoord  width,
    WTcoord  height);

WTpixel
WTget_decor_bg_pixel (
    WTdecor_ptr  decor);

WTpixel
WTget_decor_fg_pixel (
    WTdecor_ptr  decor);

WTpixel
WTget_decor_top_pixel (
    WTdecor_ptr  decor);

WTpixel
WTget_decor_bottom_pixel (
    WTdecor_ptr  decor);

WTpixel
WTget_decor_highlight_pixel (
    WTdecor_ptr  decor);

WTpixel
WTget_decor_bevel_thickness (
    WTdecor_ptr  decor);

/* From ev_hndlr.c */

void
WTadd_event_handler (
    WTwind                *window,
    unsigned int          mask,
    WTevent_handler_func  func,
    void                  *arg);

void
WTdelete_event_handler (
    WTwind                *window,
    unsigned int           mask,
    WTevent_handler_func  func,
    void                  *arg);

void
WTdelete_all_event_handlers (
    WTwind  *window);

void
WTadd_callback (
    WTwind             *window,
    WTcallback_reason  reason,
    WTcallback_func    func,
    void               *arg);

void
WTdelete_callback (
    WTwind             *window,
    WTcallback_reason  reason,
    WTcallback_func    func,
    void               *arg);

void
WTset_timer (
    WTwind                *window,
    unsigned int          interval,
    WTevent_handler_func  func,
    void                  *arg);

void
WTclear_timer (
    WTwind  *window);

/* From event.c */

void
WTdeliver_button_press_event (
    WTwind       *window,
    int           x,
    int           y,
    unsigned int  button,
    int           shift,
    int           control,
    int           dclick,
    time_t		  time);

void
WTdeliver_button_motion_event (
    WTwind       *window,
    int           x,
    int           y,
    time_t		  time);

void
WTdeliver_button_release_event (
    WTwind       *window,
    int           x,
    int           y,
    unsigned int  button,
    time_t		  time);

void
WTdeliver_expose_event (
    WTwind  *window);

void
WTdeliver_resize_event (
    WTwind  *window,
    int     x,
    int     y,
    int     width,
    int     height);

void
WTdeliver_visibility_event (
    WTwind  *window,
    int      visibility);

void
WTdeliver_enter_event (
    WTwind  *window);

void
WTdeliver_leave_event (
    WTwind  *window);

void
WTdeliver_timer_event (
    WTwind  *window);

void
WTcall_callback (
    WTwind             *window,
    WTcallback_reason  reason,
    void               *arg);

void
WTset_event_pre_handler (
    WTevent_handler_func  func,
    void                  *arg);

void
WTset_event_post_handler (
    WTevent_handler_func  func,
    void                  *arg);

/* From ned.c */

WTwind *
WTcreate_wind (
    WTdisp       *disp,
    WTwind       *parent,
    WTsys_wind   parent_sys_wind,
    WTwind_type  *type,
    WTcoord      x,
    WTcoord      y,
    WTcoord      width,
    WTcoord      height,
    WTcoord      offx,
    WTcoord      offy,
    double        scale,
    WTdecor_ptr  decor);

void
WTrealize_wind (
    WTwind  *wind);

void
WTdestroy_wind (
    WTwind  *wind);

void
WTactually_destroy_wind (
    WTwind  *wind);

void
WTset_wind_background (
    WTwind   *window,
    WTpixel  pixel);

void
WTset_wind_background_pixmap (
    WTwind        *window,
    WTpixmap_ptr  pixmap);

void
WTenable_wind (
    WTwind   *window,
    int      state);

void
WTadd_wind_udata (
    WTwind   *wind,
    void     *uptr,
    char     *name);

void *
WTget_wind_udata (
    WTwind   *wind,
    char     *name,
    int      parent);

void
WTmap_wind (
    WTwind   *wind,
    int      state);

int
WTraise_wind (
    WTwind  *wind,
    int     force);

void
WTtranslate_wind (
    WTwind   *wind,
    int      mode,
    WTcoord  tx,
    WTcoord  ty);

void
WTscale_wind (
    WTwind   *wind,
    int      mode,
    float    scale,
    WTcoord  cx,
    WTcoord  cy);

void
WTupd_scale (
    WTwind  *wind);

void
WThighlight_wind (
    WTwind  *wind,
    int      state);

void
WTmove_wind (
    WTwind   *wind,
    int      mode,
    WTcoord  x,
    WTcoord  y);

void
WTresize_wind (
    WTwind   *wind,
    int      mode,
    WTcoord  w,
    WTcoord  h);

void
WTreshape_wind (
    WTwind   *wind,
    WTcoord  x,
    WTcoord  y,
    WTcoord  w,
    WTcoord  h);

int
WTfind_wind_by_xy (
    WTwind   *wind,
    int       xi,
    int       yi,
    WTwind   **chld_wind,
    WTcoord  *ch_x,
    WTcoord  *ch_y);

WTcoord 
WTmap_to_ancestor_x (
    WTwind   *wind,
    WTwind   *pwind,
    WTcoord  x);

WTcoord 
WTmap_to_ancestor_y (
    WTwind   *wind,
    WTwind   *pwind,
    WTcoord  y);

WTcoord 
WTmap_to_ancestor_w (
    WTwind   *wind,
    WTwind   *pwind,
    WTcoord  w);

WTcoord 
WTmap_to_ancestor_h (
    WTwind   *wind,
    WTwind   *pwind,
    WTcoord  h);

void
WTset_focus (
    WTwind  *window);

void
WTmap_ancestor_xy (
    WTwind   *from_wind,
    WTcoord  from_x,
    WTcoord  from_y,
    WTwind   *to_wind,
    WTcoord  *to_x,
    WTcoord  *to_y);

void
WTmap_to_ancestor_xy (
    WTwind   *from_wind,
    WTcoord  from_x,
    WTcoord  from_y,
    WTwind   *to_wind,
    WTcoord  *to_x,
    WTcoord  *to_y);

void
WTget_window_pixel_geom (
    WTwind       *window,
    int           *x,
    int           *y,
    unsigned int  *width,
    unsigned int  *height);

void
WTmap_position (
    WTwind   *window,
    WTcoord  x,
    WTcoord  y,
    int      *xi,
    int      *yi);

void
WTunmap_position (
    WTwind   *window,
    int      xi,
    int      yi,
    WTcoord  *x,
    WTcoord  *y);

WTwind *
WTsys_wind_to_window (
    WTsys_wind  sys_wind);

void
WTerase_window_bg (
    WTwind  *window);

/* From optmenu.c */

void
WTsetup_option_menu (
    WTwind  *window,
    char     **strings,
    int      num_strings);

void
WTselect_option_menu_item (
    WTwind  *window,
    int      item);

/* From pixel.c */

WTpixel
WTdefault_pixel_func (
    WTdisp   *disp,
    WTcolor  color,
    void     *data);

/* From pixmap.c */

WTpixmap_ptr
WTinstall_pixmap (
    WTdisp         *disp,
    char           *name,
    WTpixmap_type  type);

int
WTpixmap_matches (
    WTpixmap_ptr   pixmap,
    WTdisp         *disp,
    char           *name,
    WTpixmap_type  type);

void
WTpixmap_size (
    WTpixmap_ptr  pixmap,
    int            *width,
    int            *height);

void
WTdraw_pixmap (
    WTpixmap_ptr  pixmap,
    WTwind        *wind,
    WTcoord       x,
    WTcoord       y);

void
WTupdate_direct_pixmaps (
    WTdisp  *disp);

#ifdef MSDOS

HBRUSH
WTget_pixmap_hbrush (
    WTpixmap_ptr  pixmap);

#else

Pixmap
WTget_X_pixmap (
    WTpixmap_ptr  pixmap);

#endif

WTpixel
WTget_main_pixmap_pixel (
    WTpixmap_ptr  pixmap);

char *
WTget_pixmap_filename (
    const char *name);

void
WTset_pixmap_path (
    char  *path);

/* From popupmnu.c */

WTpopup_menu
WTcreate_popup_menu (
    WTwind         *window,
    WTfontset_ptr  fontset);

void
WTappend_menu (
    WTpopup_menu  menu,
    int            flags,
    int            id,
    const char     *string);

void
WTtrack_popup_menu (
    WTpopup_menu  menu,
    WTwind        *window,
    int            x,
    int            y);

/* From prim.c */

void
WTclear_wind (
    WTwind  *window,
    int      refresh);

void
WTrefresh_wind (
    WTwind  *window);

void
WTdraw_rect_pixel (
    WTwind   *window,
    WTpixel  pixel, 
    WTcoord  x1,
    WTcoord  y1,
    WTcoord  x2,
    WTcoord  y2);

void
WTdraw_rect (
    WTwind   *window,
    WTcolor  color, 
    WTcoord  x1,
    WTcoord  y1,
    WTcoord  x2,
    WTcoord  y2);

void
WTdraw_polygon_pixel (
    WTwind   *window,
    WTpixel  pixel,
    WTvec2   *verts,
    int      num_verts);

void
WTdraw_polygon (
    WTwind   *window,
    WTcolor  color,
    WTvec2   *verts,
    int      num_verts);

void
WTdraw_polyline_pixel (
    WTwind   *window,
    WTpixel  pixel,
    WTcoord  line_width,
    WTvec2   *verts,
    int      num_verts);

void
WTdraw_polyline (
    WTwind   *window,
    WTcolor  color,
    WTcoord  line_width,
    WTvec2   *verts,
    int      num_verts);

void
WTdraw_rainbow_polyline (
    WTwind   *window,
    WTcolor  *colors,
    int       num_colors,
    WTcoord  line_width,
    WTvec2   *verts,
    int       num_verts);

void
WTdraw_xor_box (
    WTwind   *window,
    WTcolor  color,
    WTcoord  x,
    WTcoord  y,
    WTcoord  width,
    WTcoord  height);

void
WTinstall_rubberband (
    WTwind   *window,
    WTcolor  color,
    WTcoord  x,
    WTcoord  y,
    WTcoord  width,
    WTcoord  height);

void
WTuninstall_rubberband (
    WTwind   *window,
    WTcolor  color,
    WTcoord  x,
    WTcoord  y,
    WTcoord  width,
    WTcoord  height);

void
WTflush (
    WTwind  *window);

void
WTsync (
    int  state);

void
WTsync_flush (
    WTwind  *window);

/* From scrllbar.c */

void
WTupdate_scrollbar (
    WTwind  *window);

/* From text.c */

WTfontset_ptr
WTinstall_fontset (
    WTsys_disp         sys_disp,
    WTfont_attributes  *attributes,
    unsigned int       mask);

WTfontset_ptr
WTinstall_scaled_fontset (
    WTfontset_ptr  src_fontset,
    int            height);

void
WTdestroy_display_font_info (
    WTsys_disp  sys_disp);

void
WTdraw_text (
    WTwind                *window,
    WTfontset_ptr         fontset,
    WTcoord               x,
    WTcoord               y,
    const char            *string,
    WTtext_justification  justification,
    int                   unhighlight);

int
WTtext_width (
    WTfontset_ptr  fontset,
    const char     *string);

int
WTget_font_height (
    WTfontset_ptr  fontset);

#ifdef WIN32

HFONT
WTget_hfont (
    WTfontset_ptr  fontset);

#else /* not WIN32 */

XFontSet
WTget_xfontset (
    WTfontset_ptr  fontset);

XmFontList
WTget_xmfontlist (
    WTfontset_ptr  fontset);

/* Backward-compatibility functions from text.c */

XFontSet
V2Dget_xfontset (
    Display       *disp,
    unsigned int  height,
    const char    *user_font);

XmFontList
UIget_xmfontlist (
    Display       *disp,
    unsigned int  height,
    const char    *user_font);

int
WTtext_width_default (
    const char  *string);

char *
WTget_default_font (
    LocaleCSet cset);

/* End of backward-compatibility functions from text.c */

#endif /* not WIN32 */

/* From typein.c */

char *
WTget_typein_string (
    WTwind  *window);

void
WTset_typein_string (
    WTwind      *window,
    const char  *string);

void
WTset_typein_insert_position (
    WTwind  *window,
    xp_long     position);

void
WTset_typein_selection (
    WTwind  *window,
    xp_long     start,
    xp_long     end);

int
WTtypein_modified (
    WTwind  *window);

/* From window.c */

int
WTis_wind_descendant (
    WTwind  *wind,
    WTwind  *parent);

void
WTconvert_position (
    WTwind   *from_wind,
    WTcoord  from_x,
    WTcoord  from_y,
    WTwind   *to_wind,
    WTcoord  *to_x,
    WTcoord  *to_y);

#ifndef MSDOS
void
WTset_xmtext_string (
    Widget      w,
    const char  *string);
#endif

void
WThandle_sys_wind_destroy (
    WTwind  *window);

void
WTset_palette_handler (
    void (*func)(WTsys_wind, WTsys_pal) );

void
WTset_palette (
    WTsys_wind wind,
    WTsys_pal  pal );

#ifdef MSDOS

/* From wndproc.c */

LRESULT CALLBACK
WTwnd_proc (
    HWND    hwnd,
    UINT    message,
    WPARAM  wParam,
    LPARAM  lParam);

VOID CALLBACK
WTtimer_handler (
    HWND   hwnd,
    UINT   msg,
    UINT   id,
    DWORD  time);

void
WTrelease_capture (void);

#else /* not MSDOS */

/* From xevent.c */

void
WTxevent_handler (
    Widget     w,
    XtPointer  client_data,
    XEvent     *event,
    Boolean    *continue_dispatch);

void
WTtimer_handler (
    char  *client_data);

/* From xutil.c */

int WTexpose_events_queued (
    Display  *display,
    Window   window);

#endif  /* not MSDOS */

#ifdef __cplusplus
}  /* End extern "C" */
#endif

/*--------------------------------------------------------------------*/

#endif /* XP_WT_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
