/*
                        Copyright (c) 1996 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/wt_o_typ.h#1 $
*/

/* Header file containing type definitions for the WT_OBJS kit */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_WT_O_TYPE_INCLUDED
#define XP_WT_O_TYPE_INCLUDED

/*---------------------------------------------------------------------*/

/* Header files */

#include <avs/wt.h>
#include <avs/om.h>

/* For virtual palette definitions.  NB:  Only pal.h should be required */

#include <avs/gd.h>

/*--------------------------------------------------------------------*/
/*                      Constants and macros                          */
/*--------------------------------------------------------------------*/

/* Default size of color cube in virtual palette */

#define WT_COLOR_CUBE_SIZE  5

/*--------------------------------------------------------------------*/
/*                         Enumerated types                           */
/*--------------------------------------------------------------------*/

typedef enum {
    WT_REASON_PRE_PAL_REFRESH,
    WT_REASON_POST_PAL_REFRESH
} WText_context_callback_reason;

/*--------------------------------------------------------------------*/
/*                           Type definitions                         */
/*--------------------------------------------------------------------*/

/* Forward references to data structure types */

typedef struct _WText_display_context   WText_display_context;
typedef struct _WText_context_callback  WText_context_callback;

/* Palette refresh callback function */

typedef void (*WText_context_callback_func) (
    WText_display_context          *context,
    WText_context_callback_reason  reason,
    void                           *client_data,
    void                           *call_data);

/* Item on palette refresh callback list */

struct _WText_context_callback {
    WText_context_callback_reason  reason;
    WText_context_callback_func    func;
    void                           *arg;
    WText_context_callback         *next;
};

/* Extended display context that includes a virtual palette */

struct _WText_display_context {
    WTdisp                  *disp;
    PALvirt                 *virtpal;
    WTpixel                 gray_pixel;
    int                     use_gray_pixel;
    WText_context_callback  *callbacks;
    int                     ref_count;
    WText_display_context   *next;
};

/*--------------------------------------------------------------------*/

#endif /* XP_WT_O_TYPE_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
