/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/wt_objs.h#1 $
*/

/* Header file for wt_obj functions */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_WT_OBJS_INCLUDED
#define XP_WT_OBJS_INCLUDED

/*---------------------------------------------------------------------*/

/* Header files */

#include <avs/wt_o_typ.h>

/*--------------------------------------------------------------------*/
/*                       Function prototypes                          */
/*--------------------------------------------------------------------*/

#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif

/* From ext_ctx.c */

WText_display_context *
WTcreate_ext_display_context (
    WTsys_wind  ref_wind);

void
WTdestroy_ext_display_context (
    WText_display_context  *context);

void
WTinstall_virtpal_cmap (
    WText_display_context  *context,
    WTsys_wind             sys_wind);

void
WTadd_ext_context_callback (
    WText_display_context          *context,
    WText_context_callback_reason  reason,
    WText_context_callback_func    func,
    void                           *arg);

void
WTdelete_ext_context_callback (
    WText_display_context          *context,
    WText_context_callback_reason  reason,
    WText_context_callback_func    func,
    void                           *arg);

/* From fnt_fmly.c */

int
WTload_font (
    OMobj_id  obj_id);

/* From fnt_load.c */

int
WTload_fonts (
    OMobj_id fonts_id);

#ifdef __cplusplus
}  /* End extern "C" */
#endif

/*--------------------------------------------------------------------*/

#endif /* XP_WT_OBJS_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
