/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/xyz.h#1 $
*/

/*****************************************************************************/
/* xyz library header                                                        */
/*****************************************************************************/

#define XYZ_REALLOC	0x01
#define XYZ_CAP_END	0x02
#define XYZ_CYCLE	0x04

#define XYZget_xyz(BLK, ind, X, Y, Z)              \
 {                                                 \
   X = (float)(*((float *)(BLK->data + ind) + 0)); \
   Y = (float)(*((float *)(BLK->data + ind) + 1)); \
   Z = (float)(*((float *)(BLK->data + ind) + 2)); \
 }

#define XYZset_xyz(BLK, ind, X, Y, Z)              \
 {                                                 \
   *((float *)(BLK->data + ind) + 0) = X;          \
   *((float *)(BLK->data + ind) + 1) = Y;          \
   *((float *)(BLK->data + ind) + 2) = Z;          \
 }

typedef float FLOAT3[3];

typedef struct xyz_block {
    int block_size;
    int total_size;
    int count;
    FLOAT3 *data;
} XYZ_BLOCK;

XYZ_BLOCK 
  *XYZalloc(),
  **XYZalloc_array();
