#			Copyright (c) 1993 by
#			Advanced Visual Systems Inc.
#			All Rights Reserved
#
#	This software comprises unpublished confidential information of
#	Advanced Visual Systems Inc. and may not be used, copied or made
#	available to anyone, except in accordance with the license
#	under which it is furnished.
#
#	This file is under Perforce control
#	$Id: //depot/express/fcs70/include/stdinc.mk#1 $
#
###############################################################################
#
# Standard include file for Express lib and project Makefiles
#
#
# This Makefile defines variables which are common to all processes.
# Process-specific make variables should be entered in templ.v instead.
# 
# Everything in here is designed to be able to be overridden or augmented
# by the machine-specific stdinc.mk or the project Makefile.
###############################################################################

###############################################################################
# Programs used by commands in the Makefile
###############################################################################
SHELL		= /bin/sh
F77		= f77
RM		= /bin/rm -f
CC		= cc
M4		= m4
CPLUS		= CC
AR		= ar
ARFLAGS		= crl
LD		= ld

# -p option to cp preserves date
CP		= cp -p
# On some SYSV systems this will be overridden to 'echo', since they
# don't need to ranlib libraries.
RL		= ranlib

MAKE_EXECUTABLE	= chmod +x

###############################################################################
# Files
###############################################################################
LIBLMGR		= /usr/license/lmgr/port/lmgr.a
# Note that this pwd is evaluated when $(SRCDIR) is used, not when this is read.
SRCDIR		= `pwd`

###############################################################################
# Compile/link flags
#
# Note that these are arranged such that flags specified in the project's
# Makefile (the PROJ_* flags) override machine-specific flags (MACH_*),
# which in turn override the defaults (XP_*).  For includes, since the
# first one found determines where the file comes from, PROJ comes first.
# For defines, the last one takes precedence, so PROJ comes last.  And so
# on for the others.
#
# Note that we don't define any libdirs here; that should be done in
# templ.v, since linking is done via express.mk which is auto-generated
# from templ.v.  Machine-specific libs added by the $(MACHINE)/stdinc.mk
# are added to the end of the link line, along with $(XP_LIBS).  Project libs
# should be specified in templ.v as usual.
###############################################################################

CPPFLAGS	=$(PROJ_INCLUDES) $(MACH_INCLUDES) $(XP_INCLUDES) \
		 $(XP_DEFINES) $(MACH_DEFINES) $(PROJ_DEFINES) \
		 $(POST_CPPFLAGS)

# C
CFLAGS		=$(XPG) $(XP_CFLAGS) $(MACH_CFLAGS) $(PROJ_CFLAGS) \
		 $(MISC_FLAGS)

# C++
CXXFLAGS	=$(XPG) $(XP_CXXFLAGS) $(MACH_CXXFLAGS) $(PROJ_CXXFLAGS) \
		 $(CXXTEMPLFLAGS) $(MISC_FLAGS)

# Fortran
FFLAGS		=$(XPG) $(XP_FFLAGS) $(MACH_FFLAGS) $(PROJ_FFLAGS) \
		 $(MISC_FLAGS)

# C linker flags
C_LDFLAGS	= $(CFLAGS) $(PROJ_CLDFLAGS) $(MACH_CLDFLAGS) \
		  $(XP_CLDFLAGS) $(XP_LIBDIRS)

# C++ linker flags
CXX_LDFLAGS	= $(CXXFLAGS) $(PROJ_CXXLDFLAGS) $(MACH_CXXLDFLAGS) \
		  $(XP_CXXLDFLAGS) $(XP_LIBDIRS) $(MAYBE_LINK_SHARED_FLAG)

# This is the default; feel free to override as needed for debugging.
G		= -O
# what flag to use for debugging
GOPT		= -g

###############################################################################
# Express-specific compile/link flags
###############################################################################
XP_INCLUDES	= $(XP_INC_OPTS)
XP_DEFINES	= -DEXPRESS
XP_LIBDIRS	= $(XP_LIB_OPTS)

###############################################################################
# Libraries
###############################################################################

RENFLAGS	= SW_RENDERER VX_KIT VRML_RENDERER VPS_RENDERER
CONFIGFLAGS	= ACKIT NETCDF_KIT HDF5_KIT GIS_KIT READ_URL ANIM_KIT MAVS_KIT REDUCT_KIT

OBJFILES	=

LLIB		= unset
DLLDMP		= unset
DLLDEF		= unset
DLLEXP		= unset
DLLIB		= unset
DLLIBNAME	= $(DLLIB).$(DLLIB_SUFFIX)
EXPORTLIB	= DummyLib
XP_LIBS		= $(MAYBE_LINK_SHARED_FLAG) \
		  -lomx -lom -lcomm -ltool -llic \
		  $(LINK_SHARED_FLAG) $(LASTLIBS)
# for base only:
XP_C_LIBS	= $(MAYBE_LINK_SHARED_FLAG) \
		  -lom -lcomm -ltool -llic \
		  $(LINK_SHARED_FLAG) $(LASTLIBS)
XP_F77_LIBS	= -lomf $(F77LIBS)
MAINC		= -lmnc
MAINCXX		= -lmncxx
LLIBDIR		= $(XP_ROOT)/lib/$(MACHINE)
WINLIBS		= $(LINK_SHARED_FLAG) \
		$(XMLIBS) $(XLIBS) \
		$(MAYBE_LINK_SHARED_FLAG)

# Default location for the C++ template repository
CXXTEMPLPATH = $(LLIBDIR)
CXXTEMPLDIR	= ptrepos
CXXTEMPLFLAGS	= -ptr$(CXXTEMPLPATH)/$(CXXTEMPLDIR)
TEMPLATES	= #Undefined except on DEC Alpha Unix

###############################################################################
# Rule definitions:
###############################################################################

C_FLAGS		= $(CPPFLAGS) $(CFLAGS) $(G)
COMPILE_C	= $(CC) $(C_FLAGS)

# some compilers require GOPT before optimization...
COMPILE_C_G	= $(CC) $(GOPT) $(CPPFLAGS) $(CFLAGS)

CPLUS_FLAGS	= $(CPPFLAGS) $(CXXFLAGS) $(G)
COMPILE_CXX     = $(CPLUS) $(CPLUS_FLAGS)

F77_FLAGS	= $(CPPFLAGS) $(FFLAGS) $(G)
COMPILE_F77	= $(F77) $(F77_FLAGS)

# Needs CPPFLAGS because of templates
LINK_CXX	= $(PURIFY) $(PURECOV) $(CPLUS) $(CPPFLAGS) $(CXX_LDFLAGS)
LINK_C		= $(PURIFY) $(PURECOV) $(CC) $(C_LDFLAGS)

# An operation on the executable to be performed after linking
# The default is for nothing to be done
XP_POSTLINK     = @echo

# These commands are issued in express.mk to build .o files which are
# linked directly into express.
XP_C_COMPILE_CMD = \
	$(CC) $(C_FLAGS) -c -o $@

XP_CXX_COMPILE_CMD = \
	$(CPLUS) $(CPLUS_FLAGS) -c -o $@

XP_F77_COMPILE_CMD = \
	$(COMPILE_F77) -c -o $@

########################################################################
# Shared Libraries
########################################################################

# Most systems can compile into the executable a path to use when searching
# for shared libs at run-time.  This sometimes is used in addition to
# LD_LIBRARY_PATH (which is called SHLIB_PATH on some machines, I think).
# There shouldn't be any spaces in this.
#DLLIB_RUNTIME_PATH=lib/$(MACHINE):../lib/$(MACHINE):../../lib/$(MACHINE):$(XP_LIB_DIR)
DLLIB_RUNTIME_PATH=lib/$(MACHINE):../lib/$(MACHINE):../../lib/$(MACHINE)
# By default, use ld to build shared libs.  Some machines may vary.
SHLIB_LD=$(LD)
# This must extract all the .o files from the lib into the current dir.
# Note: on machines that truncate file names in libs, you may want to use
# bin/xp_extractlib instead of ar x.
SHLIB_EXTRACT_LIBFILES=$(AR) x
# Here are two common ways of generating shared libs in Unix.

# This one takes the .a apart into .o files, and makes the shared lib
# from the objects.  Generally will need some customization of DLFLAGS
# in the machinc.mk file.
# We use trap here to make sure the temp dir is always deleted.
# Systems that are known to use this: hp, hp2, s2, sun.
# Warning: ! is a directive to the PC nmake program; don't use it in
# shell test expressions (even if the PC won't evaluate those
# expressions).
GENERATE_DLLIB_FROM_OBJS_COMMAND = \
	if [ X$(DLLIB) = "Xunset" -o -n "$(NO_DLLIBS)" ] ; then : ; else \
	  trap 'cd /; $(RM) -r $(XP_LIB_DIR)/make_tmp$$$$' 0 1 2 3 15; \
	  cd $(XP_LIB_DIR) ; \
	  $(RM) -r make_tmp$$$$; \
	  mkdir make_tmp$$$$ ; cd make_tmp$$$$ ; \
	  $(SHLIB_EXTRACT_LIBFILES) $(LIB_TO_MAKE_DLLIB_FROM); \
	  $(SHLIB_LD) $(DLFLAGS) -o $@ $(DLFLAGS2) *.o; \
	  $(MAKE_EXECUTABLE) $@; \
	  if [ -n "$(DLLIB_ALTNAME)" -a -n "$(DLLIB_USE_ALTNAME)" ] ; then \
		ln -s $@ $(DLLIB_ALTNAME) ; \
		$(MAKE_EXECUTABLE) $(DLLIB_ALTNAME); \
	  fi ; \
	  cd ..; $(RM) -r make_tmp$$$$; \
	fi
# This is used above as the name of the lib from which the shared lib is
# made.  Only used on machines which use the above rule.
LIB_TO_MAKE_DLLIB_FROM=$(LLIB)

# This one is used on systems that can make the shared lib directly
# from the .a library.  Generally will need some customization of DLFLAGS
# in the machinc.mk file.
# Systems that are known to use this: alpha, sgi, sg6.
# Note that IRIX 5.3 needs to have the so_locations file in place with
# a certain directive in it before running this command on large libs
# like libgdif.so.  See include/sgi/machinc.mk for that directive.
GENERATE_DLLIB_FROM_LIB_COMMAND = \
	if [ X$(DLLIB) = "Xunset" -o -n "$(NO_DLLIBS)" ] ; then : ; else \
	  cd $(XP_LIB_DIR) ; \
	  $(SHLIB_LD) $(DLFLAGS) -o $@; \
	  $(MAKE_EXECUTABLE) $@; \
	  if [ -n "$(DLLIB_ALTNAME)" ] ; then \
		ln -s $@ $(DLLIB_ALTNAME) ; \
		$(MAKE_EXECUTABLE) $(DLLIB_ALTNAME); \
	  fi ; \
	fi

# This is invoked by the DLLIB rule in stdrule.mk.
# This value is just the default.
# It can be overridden either piecemeal, by defining DLFLAGS etc., or
# completely, by redefining this macro in machinc.mk either to one of
# the above macros or to something completely unique.  $@ will be the
# name of the shared lib, and $(LLIB) will be the name of the existing
# static lib.
GENERATE_DLLIB_COMMAND = $(GENERATE_DLLIB_FROM_OBJS_COMMAND)

# Set these to "" unless you know that LINK_SHARED_FLAG will find a shared
# lib if it exists, and the static one otherwise.
LINK_STATIC_FLAG	= -Bstatic
LINK_SHARED_FLAG	= -Bdynamic
# Use this in the actual Makefile, so it will be controlled by NO_DLLIBS.
# It's not pretty I know, but generic make is not as smart as the shell.
# This generally isn't overridden (except on the PC, which has a different
# shell).
MAYBE_LINK_SHARED_FLAG	= `if [ -n "$(NO_DLLIBS)" ]; \
			   then echo $(LINK_STATIC_FLAG); \
			   else echo $(LINK_SHARED_FLAG); fi`

F77_BIND_FLAGS=-case lower -suffix _ +external

# end of stdinc.mk
