/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/ip_lib/ip.h#1 $
*/
#include <sys/types.h>

#include "vff_defs.h"
#include <avs/port.h>
#include <avs/gd_ren.h>

#ifndef FALSE
#define	FALSE	0
#define	TRUE	!FALSE
#endif

#ifndef uchar
#define	uchar	unsigned char
#endif

#ifndef __suniplib_h
#define __suniplib_h

#ifdef VMS
#ifndef HUGE_VAL
#define HUGE_VAL HUGE
#endif

/*
 * For VMS, some types that may not be defined yet but they might be
 * defined in socket.h is included.
 */

#ifndef __SOCKET_TYPEDEFS

#ifndef CADDR_T
typedef char * caddr_t;
#define CADDR_T
#endif

typedef unsigned short u_short;

typedef unsigned long u_long;

typedef unsigned char u_char;

#define __SOCKET_TYPEDEFS
#endif /* socket */
#endif /* VMS */

#ifdef MSDOS
typedef char *caddr_t;
#endif

/* return codes */
#define	ipSUCCESS	0
#define	ipFAILURE	1
#define	ipMACHDEP	2
#define ipNOTIMP	3
#define ipBOUNDS	4
#define ipDIVZERO	5

/* data types */
#define	ipBYTE		0
#define	ipSHORT		1
#define ipINT		2
#define	ipFLOAT		3
#define ipDOUBLE	4
#define	ipCOMPLEX	5

/* fft output types */
#define ipPOWER		0
#define ipLOGPOWER	1
#define ipPHASE		2
#define ipREAL		3
#define ipIMAGINARY	4

/* mconvolve outputs */
#define	ipQUAD_SUM	0
#define	ipMAX_VALUE	1
#define	ipINDEX		2

/* roi types */
#define ipIMAGE_ROI	1

/* bands */
#define ipALLBANDS	-1

/* interpolation codes */
#define ipDV_INT	0
#define ipNN_INT	1
#define ipBL_INT	2
#define	ipBC_INT	3
#define	ipAS_INT	4

/* check codes (for ip_image_compare) */
#define ipCK_WIDTH     	 0x0001
#define ipCK_HEIGHT    	 0x0002
#define ipCK_SIZE      	 (ipCK_WIDTH|ipCK_HEIGHT)
#define ipCK_NBANDS    	 0x0004
#define ipCK_PIXTYPE   	 0x0008
#define ipCK_CONTIGUOUS  0x0010
#define ipCK_PROCESSOR   0x0020
#define ipCK_CONGRUENT  (ipCK_SIZE|ipCK_NBANDS|ipCK_PIXTYPE|ipCK_PROCESSOR)

/* warp types */
#define	ipSLINEAR	0
#define	ipNLINEAR	1
#define	ipSQUADRATIC	2
#define	ipNQUADRATIC	3

/* reflection directions */
#define	ipHORIZ		0
#define	ipVERT		1
#define	ipTRANS		2
#define	ipATRANS	3
#define	ipCCW90		4
#define	ipCCW180	5
#define	ipCCW270	6

/* status bits */
#define	ipMOVED_CHILD	0x01
#define ipTILED_IMAGE   0x0002
#define ipMAPPED_DATA   0x0004
#define ipEXTERNAL_DATA 0x0008

#define	ipNDIM		4	/* # of dimensions */

/* data structures */
typedef struct ip_Image {
    int         pid;		/* id of current residence */
    int         pixtype;	/* data type */
    int         status;		/* misc. status bits */
    int         x, y, z;	/* position (relative to parent) */
    int         xsize;		/* dimension sizes */
    int		ysize;
    int		zsize;
    int         nbands;		/* number of bands */
    struct ip_Image
               *band;		/* pointer to list of bands */
    struct ip_Image
               *band_parent;	/* pointer to the base image */
    int         nchildren;
    struct ip_Image
              **child;		/* pointer to list of children pointers */
    struct ip_Image
               *parent;		/* pointer to the parent image */
    caddr_t     machdep;	/* device specific information */

    /* the following are reserved for future use */
    float       moffset[ipNDIM];/* offset into source */
    float       mscale[ipNDIM];	/* scale factor */
    char       *units[ipNDIM];	/* unit name */
    char       *comment;	/* image history */
    vff_Object *vff_hdr;	/* header from loaded vff file */
    char        time[30];	/* time data field */
    int		map_size;	/* size for mmap'ed files */
    char       *map_loc;	/* start for mmap */
    int		xtsize, ytsize; /* tile sizes in x and y */
}           ip_Image;


/*
 *  Macros to allow access to the various parts of the
 *		image structure.  Use these instead of directly
 *		accessing structure members, since some parts
 *      of the structure may change.  There are already
 *		subroutines to allow access to the nth child or
 *		nth band.
 */

 /* returns one of the defined image data types */
#define	Im_pixtype(A)	((A)->pixtype)

 /* x, y, z position */
#define	Im_xpos(A)	((A)->x)
#define	Im_ypos(A)	((A)->y)
#define	Im_zpos(A)	((A)->z)

 /* width, height, depth */
#define	Im_xsize(A)	((A)->xsize)
#define	Im_ysize(A)	((A)->ysize)
#define	Im_zsize(A)	((A)->zsize)

 /* number of bands */
#define	Im_nbands(A)	((A)->nbands)

 /* number of children */
#define	Im_nchildren(A)	((A)->nchildren)

 /* base image from a single band */
#define	Im_band_parent(A)	((A)->band_parent)

 /* immediate parent from a subimage */
#define	Im_parent(A)	((A)->parent)

 /* accelerator image lives on */
#define	Im_accel(A)	((A)->pid)

 /* comment associated with an image */
#define Im_comment(A)	((A)->comment)

 /* vff header associated with an image */
#define Im_vffhdr(A)	(ip_base_image(A)->vff_hdr)

/* function declarations which return images */
ip_Image *ip_create (int xsize, int ysize, int nbands, int data_type);
ip_Image *ip_createp (int xsize, int ysize, int nbands, int data_type, int pid, int zero_flag);
ip_Image *ip_create_hdr (int xsize, int ysize, int nbands, int data_type, caddr_t data_ptr);
ip_Image *ip_create_hdrp (int xsize, int ysize, int nbands, int data_type, caddr_t data_ptr, int pid, int zero_flag);
ip_Image *ip_ccreate (ip_Image *parent, int x, int y, int xsize, int ysize);
#if 0
ip_Image *ip_load_filep();
ip_Image *ip_load_file();
#endif
ip_Image *ip_getband (ip_Image *image, int band_num);
ip_Image *ip_getchild (ip_Image *im, int n);
ip_Image *ip_base_image (ip_Image *s);
ip_Image *ip_base_band (ip_Image *s);


/* region of interest structure */
typedef struct ip_Roi {
    int         type;		/* roi type */
    int         xsize;		/* dimension sizes */
    int		ysize;
    int		zsize;
    int		pid;		/* where the data is located */
    int		xoff, yoff, zoff; /* offset from image origin */
    char       *data;		/* pointer to roi data */
}           ip_Roi;

/* data types for kernels */
#define KERNEL_INT	0
#define	KERNEL_FLOAT	1
#define	KERNEL_ONE	1073741824.0	/* bias for fixed type */

typedef struct ip_Kernel {
    int         width, height, depth, data_type;
    float      *value;
}           ip_Kernel;

typedef struct ip_Sel {
    int         width, height, depth;
    int		*value;
}           ip_Sel;

typedef struct ip_Tiepoint {
    float       xin, yin, zin;
    float       xout, yout, zout;
}           ip_Tiepoint;

typedef struct ip_Proc {
    int         (*init) ();	/* initialize device */
    int         (*allocate) ();	/* allocate image */
    int         (*dispose) ();	/* deallocate image */
    int         (*write) ();	/* move buffer to image */
    int         (*read) ();	/* move image to buffer */
    int         (*write_line) ();
    int         (*read_line) ();
    int         (*query) ();	/* get device information */

    int         (*display) ();
    int         (*undisplay) ();

    int         (*move) ();
    int         (*copy) ();
    int         (*image_gen) ();
    int         (*image_set) ();
    int         (*getpixel) ();
    int         (*putpixel) ();

    int         (*lookup) ();
    int         (*add) ();
    int         (*subtract) ();
    int         (*multiply) ();
    int         (*divide) ();
    int         (*add_const) ();
    int         (*mul_const) ();
    int         (*shift) ();
    int         (*abs) ();
    int         (*maximum) ();
    int         (*max_const) ();
    int         (*minimum) ();
    int         (*min_const) ();
    int         (*rescale) ();
    int         (*linremap) ();

    int         (*flog) ();
    int         (*flog10) ();
    int         (*fsqrt) ();
    int         (*fexp) ();
    int         (*frecip) ();
    int         (*fcos) ();
    int         (*fsin) ();
    int         (*fatan) ();

    int         (*not_func) ();
    int         (*and_func) ();
    int         (*and_const) ();
    int         (*or_func) ();
    int         (*or_const) ();
    int         (*nand_func) ();
    int         (*nor_func) ();
    int         (*xor_func) ();
    int         (*xor_const) ();

    int         (*reflect) ();
    int         (*rotate) ();
    int         (*warp) ();
    int		(*twarp) ();
    int		(*calc_coeff) ();
    int         (*zoom) ();
    int         (*regist) ();

    int         (*convolve) ();
    int		(*mconvolve) ();
    int         (*median) ();

    int         (*threshold) ();
    int         (*morph) ();
    int		(*erode) ();
    int		(*dilate) ();

    int         (*fft) ();
    int         (*ifft) ();
    int         (*fft_pack) ();
    int         (*fft_unpack) ();
    int         (*fft_complex) ();
    int         (*ifft_complex) ();
    int         (*fft_display) ();
    int         (*fft_mul) ();

    int         (*histogram) ();
    int         (*extrema) ();
    int         (*hmoments) ();
    int         (*smoments) ();
    int         (*merge) ();
    int         (*blend) ();
    int         (*lincomb) ();
    int		(*drawline) ();
    int		(*contour) ();
    int		(*drawtext) ();
}           ip_Proc;

typedef struct ip_Accel {
    ip_Proc    *proc;		/* function addresses */
    caddr_t     device;		/* device specific information */
}           ip_Accel;

/* processors
 *
 * note: XIL is not a "processor", but a SunOS 5 specific imaging
 *       library.  It is convenient to use the ip_Accel method to
 *       call XIL functions when appropriate instead of the host
 *       equivalents
 */
#define	ipMAXPROCS	16	/* maximum number of accelerators */
#define ip_HOST		0	/* define host as 1st accelerator */
#define ip_TAAC1    	1	/* define taac as 2nd accelerator */
#define ip_VX		2	/* define vx   as 3rd accelerator */

/*
 * Need to alias ip_XIL to ip_HOST on non xil machines
 */
#ifndef XIL_RENDERER
#define ip_XIL          ip_HOST	/* define xil  as 4th accelerator */
#else
#define ip_XIL          3       /* define xil  as 4th accelerator */
#endif

/* globals */
IMPORT int ip_Default_Device;		/* default accelerator   */
IMPORT ip_Accel ip_accel[ipMAXPROCS];	/* array of accelerators */
IMPORT int ip_error;

/* macro for accessing info about the device that the image lives on */
#define Im_dev_info(A)	(ip_accel[Im_accel(A)].device)

/* defines for morphological stuff */
#define	MASK_VAL	128
#define	BIT0		0x001
#define	BIT1		0x002
#define	BIT2		0x004
#define	BIT3		0x008
#define	BIT4		0x010
#define	BIT5		0x020
#define	BIT6		0x040
#define	BIT7		0x080
#define	BIT8		0x100
#define	BIT9		0x200
#define BIT10		0x400

#define	MT_MAGIC	0x23455432

typedef struct ip_Mtable {
    int         nbits;
    char        name[40];
    uchar      *table;
}           ip_Mtable;

/* defines for edge enhancement algorithms */
#define		ipPREWITT		1
#define		ipROBERTS		2
#define		ipCOMPASS		3
#define		ipFREI_CHEN		4
#define		ipMARR_HILDRETH		5
#define		ipNEVATIA_BABU		6
#define		ipROBINSON3		7
#define		ipROBINSON5		8
#define		ipMACLEOD		9
#define		ipARGYLE		10
#define		ipKIRSCH		11
#define		ipBOXCAR		12
#define		ipSOBEL			13
#define		ipD_OF_G		14
#define		ipWTD_LINE		15
#define		ipUNWTD_LINE		16

/* defines for fonts */
#define		ipFONT_Hlv8	0
#define		ipFONT_Hlv10	1
#define		ipFONT_Hlv12	2
#define		ipFONT_Hlv14	3
#define		ipFONT_Hlv18	4
#define		ipFONT_Hlv24	5

/* interface func protos */
int ip_add (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_add_const (ip_Image *, ip_Image *, float, ip_Roi *);
int ip_subtract (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_multiply (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_mul_const (ip_Image *, ip_Image *, float, ip_Roi *);
int ip_divide (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_max (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_max_const (ip_Image *, ip_Image *, float, ip_Roi *);
int ip_min (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_min_const (ip_Image *, ip_Image *, float, ip_Roi *);
int ip_shift (ip_Image *, ip_Image *, int, ip_Roi *);
int ip_not (ip_Image *, ip_Image *, ip_Roi *);
int ip_and (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_and_const (ip_Image *, ip_Image *, int, ip_Roi *);
int ip_or (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_or_const (ip_Image *, ip_Image *, int, ip_Roi *);
int ip_nand (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_nor (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_xor (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_xor_const (ip_Image *, ip_Image *, int, ip_Roi *);
int ip_reflect (ip_Image *, ip_Image *, int);
int ip_rotate (ip_Image *, ip_Image *, double, int);
int ip_calc_coeffs (ip_Tiepoint *, int, float *, float *, int);
int ip_warp (ip_Image *, ip_Image *, int, float *, float *, int);
int ip_zoom (ip_Image *, ip_Image *, float, float, float, float, int);
int ip_convolve (ip_Image *, ip_Image *, ip_Kernel *, ip_Roi *);
int ip_median (ip_Image *, ip_Image *, ip_Sel *, ip_Roi *);
int ip_threshold (ip_Image *, ip_Image *, float, float, int, ip_Roi *);
int ip_morph (ip_Image *, ip_Image *, ip_Mtable *, ip_Mtable *, ip_Roi *);
int ip_fft (ip_Image *, ip_Image *);
int ip_ifft (ip_Image *, ip_Image *);
int ip_fft_pack (ip_Image *, ip_Image *, ip_Image *, int);
int ip_fft_unpack (ip_Image *, ip_Image *, ip_Image *, int);
int ip_fft_complex (ip_Image *, ip_Image *, ip_Image *, ip_Image *);
int ip_ifft_complex (ip_Image *, ip_Image *, ip_Image *, ip_Image *);
int ip_fft_display (ip_Image *, ip_Image *, ip_Image *, int);
int ip_fft_mul (ip_Image *, ip_Image *, ip_Image *);
int ip_histogram (ip_Image *, int *, int, float, float, ip_Roi *);
int ip_extrema (ip_Image *, float *, float *, ip_Roi *);
int ip_hmoments (ip_Image *, int, float *, ip_Roi *);
int ip_smoments (ip_Image *, int, float *, ip_Roi *);
int ip_lookup (ip_Image *, ip_Image *, int *, int, int, ip_Roi *);
int ip_merge (ip_Image *, ip_Image *, ip_Image *, ip_Roi *);
int ip_blend (ip_Image *, ip_Image *, ip_Image *, ip_Image *);
int ip_lincomb (ip_Image *, ip_Image *, float *, float *, ip_Roi *);
int ip_abs (ip_Image *, ip_Image *, ip_Roi *);
int ip_flog (ip_Image *, ip_Image *, ip_Roi *);
int ip_fsqrt (ip_Image *, ip_Image *, ip_Roi *);
int ip_fexp (ip_Image *, ip_Image *, ip_Roi *);
int ip_frecip (ip_Image *, ip_Image *, ip_Roi *);
int ip_fcos (ip_Image *, ip_Image *, ip_Roi *);
int ip_flog10 (ip_Image *, ip_Image *, ip_Roi *);
int ip_fatan (ip_Image *, ip_Image *, ip_Roi *);
int ip_fsin (ip_Image *, ip_Image *, ip_Roi *);
int ip_linremap (ip_Image *, ip_Image *, float, float, ip_Roi *);
int ip_register (ip_Image *, ip_Image *, int, int, int, int, int, int, float *, float *, float *);
int ip_read_line (ip_Image *, int, int, int, int, caddr_t);
int ip_write_line (ip_Image *, int, int, int, int, caddr_t);
int ip_drawline (ip_Image *, int, int, int, int, caddr_t);
int ip_drawtext (ip_Image *, int, int, caddr_t, char *, int);
int ip_mconvolve (ip_Image *, ip_Image *, int, ip_Kernel **, int, float, ip_Roi *);
int ip_twarp (ip_Image *, ip_Image *, ip_Image *, float, float, int, ip_Roi *);
int ip_contour (ip_Image *, ip_Image *, int, float *);
int ip_erode (ip_Image *, ip_Image *, ip_Sel *, ip_Roi *);
int ip_dilate (ip_Image *, ip_Image *, ip_Sel *, ip_Roi *);
int ip_edge (ip_Image *, ip_Image *, int, float, float, ip_Roi *);
int ip_compare_xp (ip_Image *, ip_Image *, int *, int *);
int ip_compare (ip_Image *, ip_Image *);
int ip_rescale (ip_Image *, ip_Image *, float, float, float, float, ip_Roi *);
int ip_image_check (ip_Image *, ip_Image *, int);
int ip_copy (ip_Image *, ip_Image *, ip_Roi *);
ip_Kernel *ip_load_kernel (const char *);
int ip_destroy_kernel (ip_Kernel *);
ip_Sel *ip_load_sel (const char *);
int ip_destroy_sel (ip_Sel *);
ip_Roi *ip_roi_from_image (ip_Image *);
int ip_destroy_roi (ip_Roi *);
ip_Mtable *ip_load_mtable (const char *);
int ip_destroy_mtable (ip_Mtable *);
int ip_variance (ip_Image *, float *, float *, float *, ip_Roi *);
int ip_translate (ip_Image *, ip_Image *, int, int);
int ip_image_gen (ip_Image *, int, caddr_t, ip_Roi *);

/* unused utilities */
int         ip_save_kernel (ip_Kernel *ker, const char *name);
int         ip_move_roi (ip_Roi *r, int xoff, int yoff);
int         ip_get_accel (void);
int         ip_set_accel (int accel);
int	    ip_save_sel (ip_Sel *sel, const char *name);
ip_Sel	   *ip_screate_rect (int xsize, int ysize);
int	    ip_fread (ip_Image *image, FILE *fp);
int	    ip_fwrite (ip_Image *image, FILE *fp);
#if 0
void	    ip_mmap_image();
void	    ip_munmap_image();
#endif

#endif
