/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/ip_lib/ip/device.h#1 $
*/
#ifdef sol2

/* defined in misc/xilfunc.c */
extern ip_Proc        ip_xil_proc;
extern int            ipG_use_xil;
extern int            ipG_xil_try_it;
extern int            ipG_report_time;
extern int            ipG_time_both;
extern int            ipG_unavailable;
#endif


#define	uchar	unsigned char
#define	host_Device	char

typedef struct host_Image {
    int         nbp;		/* number of bytes per pixel */
    int         vspan;		/* inherited from top-most parent; how many
				 * pixels to bypass to go vertically */
    int         offset;		/* offset in the pixel in bytes */
    uchar      *data;		/* pointer to beginning of first pixel */
}           host_Image;

IMPORT ip_Proc host_proc;

/*
 * useful host macros; point at device-dependent part of struct,
 *  point at start of data, point at start of pixel at
 *  location x,y
 */

#define	dev(A)		((host_Image *)((A)->machdep))
#define Imdata(A)	((host_Image *)((A)->machdep))->data
#define Impoint(A,x,y)	(Imdata(A) + dev(A)->nbp * ((x) + dev(A)->vspan * (y)))

/*
 * macros to allow access to device-dependent part of host
 *   image structure.  Im_point depends on pixel-sequential 
 *   image data format.  It returns a pointer to the beginning 
 *   of the first band for the desired pixel.
 */

/* Point to the device dependent part */
#define	Im_dev(A)	((host_Image *)((A)->machdep))

/* Number of BYTES to advance to next pixel */
#define	Im_nbp(A)	(Im_dev(A)->nbp)

/* Number of PIXELS to advance to next line */
#define	Im_vpix(A)	(Im_dev(A)->vspan)

/* Number of BYTES to advance to next line */
#define	Im_vstride(A)	(Im_vpix(A)*Im_nbp(A))

/* Point to the beginning of image data */
#define Im_data(A)	((host_Image *)((A)->machdep))->data

/* Point to specific pixel in the image*/
#define Im_point(A,x,y) (Im_data(A) + Im_nbp(A) * ((x) + Im_vpix(A) * (y)))

/*
 * system includes may also declare this... I'm pretty sure that these
 * declarations will be the same but to be sure that this code runs
 * ok, we should use our declaration.
 */
#ifdef  MAXSHORT
#undef  MAXSHORT
#endif
#define MAXSHORT	32767

#ifdef  MINSHORT
#undef  MINSHORT
#endif
#define MINSHORT	-32768

#ifdef  MAXBYTE
#undef  MAXBYTE
#endif
#define MAXBYTE		255


/* this is the device-dependent part of the null implementation */
#define	null_Device	char
IMPORT ip_Proc null_proc;
