/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/celldata.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define MAX_LABEL_SIZE  1024
#define ERR_RETURN(A) ERRerror("FUNCcopy_cell_data",0,ERR_ORIG, A); return(0);

/* 64-bit porting. Directly Modified */
int FUNCcopy_cell_data (OMobj_id in, OMobj_id in_set, OMobj_id out_set,
                        xp_long ncells, xp_long *cell_list,
                        int ncomp, int *comp, xp_long start)
{
	int    stat, i, in_ncomp, veclen, dtype, null_flag, data_id;
	xp_long size, in_ncells;
	char   *cell_data, *out_cell_data;
	char   label[MAX_LABEL_SIZE], units[MAX_LABEL_SIZE];
	double null_value, min, max;

	if (FLDget_cell_data_ncomp (in_set, &in_ncomp) != 1) {
		return(0);
	}
	if (FLDget_ncells(in_set, &in_ncells) != 1) {
		ERR_RETURN("cannot get ncells");
	}
	for (i=0; i< ncomp; i++) {
		if (comp[i] >= in_ncomp)
			continue;

		if (FLDget_cell_data_veclen(in_set, comp[i], &veclen) != 1) {
			ERR_RETURN("Error getting cell veclen");
		}
		stat = FLDget_cell_data_label(in_set, comp[i], label, MAX_LABEL_SIZE);
		if (stat < 0)
			return(stat);
		else if (stat == 0)
			strcpy(label, "");
		stat = FLDget_cell_data_units(in_set, comp[i], units, MAX_LABEL_SIZE);
		if (stat < 0)
			return(stat);
		else if (stat == 0)
			strcpy(units, "");
		if (FLDset_cell_data_comp (out_set, i, veclen, label, units) != 1) {
			ERR_RETURN("Error setting cell data component");
		}
		if (FLDget_cell_data_id(in_set, comp[i], &data_id) == 1)
			FLDset_cell_data_id(out_set, i, data_id);
		if (FLDget_cell_data(in_set, comp[i], &dtype, &cell_data,
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("Error getting cell data");
		}
		if (FLDget_cell_data(out_set, i, &dtype, &out_cell_data,
				     &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error setting cell data");
		}
		UTILcopy_array_list(in_ncells, veclen, dtype, cell_data, ncells,
				    cell_list, out_cell_data+start*DTYPEtype_size[dtype]*veclen);

		if (FLDget_cell_null_data(in_set, comp[i], &null_flag, (char *)&null_value) != 1) {
			ERR_RETURN("cannot get cell null data");
		}
		if (null_flag) {
			if (FLDset_cell_null_data(out_set, i, (char *)&null_value, dtype) != 1) {
				ERR_RETURN("Error setting cell null value");
			}
		}
		else {
			if (FLDset_cell_null_flag(out_set, i, 0) != 1) {
				ERR_RETURN("Error setting cell null flag");
			}
		}
		if (FLDget_cell_data_minmax_total(in, comp[i],
						  (char *)&min, (char *)&max) != 1) {
			ERR_RETURN("Error getting cell minmax");
		}
		if (FLDset_cell_data_minmax(out_set, i,
					    (char *)&min, (char *)&max, dtype) != 1) {
			ERR_RETURN("Error setting cell minmax");
		}
		ARRfree(cell_data);
		ARRfree(out_cell_data);
	}
	return(1);
}
