/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/combcomp.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>

#define ERR_RETURN(A) ERRerror("combine_data",1,ERR_ORIG, A); return(0);

/* 64-bit porting. Only Modified Internally */
int DVcomb_comp_update(OMobj_id elem_id)
{
	OMobj_id nd1, nd2, out, out_nd, e1, e2, tmp;
	int *comp1, *comp2, stat, type, rcomp1, rcomp2;
	xp_long i, ncomp1, ncomp2;

	nd1 = OMfind_subobj(elem_id,OMstr_to_name("nd1"),OM_OBJ_RD);
	if (OMis_null_obj(nd1))
		return(0);
	nd2 = OMfind_subobj(elem_id,OMstr_to_name("nd2"),OM_OBJ_RD);
	if (OMis_null_obj(nd2))
		return(0);
	out = OMfind_subobj(elem_id,OMstr_to_name("out"),OM_OBJ_RW);
	if (OMis_null_obj(out))
		return(0);
	e1 = OMfind_subobj(elem_id,OMstr_to_name("comp1"),OM_OBJ_RD);
	if (OMis_null_obj(e1))
		return(0);
	e2 = OMfind_subobj(elem_id,OMstr_to_name("comp2"),OM_OBJ_RD);
	if (OMis_null_obj(e2))
		return(0);
	type = OM_TYPE_INT;
	ncomp1 = 0;
	comp1 = (int *)NULL;
	stat = OMget_array_sz(e1, &type, (char **)(&comp1), &ncomp1, OM_GET_ARRAY_RD);
	if (stat != 1)
		return(1);
	ncomp2 = 0;
	comp2 = (int *)NULL;
	stat = OMget_array_sz(e2, &type, (char **)(&comp2), &ncomp2, OM_GET_ARRAY_RD);
	if (stat != 1)
		return(1);

	if (FLDget_node_data_ncomp(nd1, &rcomp1) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (FLDget_node_data_ncomp(nd2, &rcomp2) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	for (i=0; i<ncomp1; i++) {
		if (comp1[i] >= rcomp1) {
			if (FLDset_nnodes(out, 0) != 1) {
				ERR_RETURN("cannot set nnodes");
			}
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			ERR_RETURN("requested component does not exist, combine is not performed");
		}
	}
	for (i=0; i<ncomp2; i++) {
		if (comp2[i] >= rcomp2) {
			if (FLDset_nnodes(out, 0) != 1) {
				ERR_RETURN("cannot set nnodes");
			}
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			ERR_RETURN("requested component does not exist, combine is not performed");
		}
	}
	e1 = OMfind_subobj(nd1, OMstr_to_name("node_data"),OM_OBJ_RD);
	if (OMis_null_obj(e1))
		return(0);
	e2 = OMfind_subobj(nd2, OMstr_to_name("node_data"),OM_OBJ_RD);
	if (OMis_null_obj(e2))
		return(0);
	out_nd = OMfind_subobj(out, OMstr_to_name("node_data"),OM_OBJ_RW);
	if (OMis_null_obj(out_nd))
		return(0);
	/* Delete the old value */
	OMset_obj_ref(out_nd, OMnull_obj, 0);
	for (i=0; i< ncomp1; i++) {
		if ((stat = OMget_array_val(e1, comp1[i], &tmp, OM_OBJ_RD)) != 1)
			return(stat);
		if (stat = OMget_obj_val(tmp, &tmp) != 1)
			return(stat);
		if ((stat = OMadd_obj_ref(out_nd, tmp, 0)) != 1)
			return(stat);
	};
	for (i=0; i< ncomp2; i++) {
		if ((stat = OMget_array_val(e2, comp2[i], &tmp, OM_OBJ_RD)) != 1)
			return(stat);
		if (stat = OMget_obj_val(tmp, &tmp) != 1)
			return(stat);
		if ((stat = OMadd_obj_ref(out_nd, tmp, 0)) != 1)
			return(stat);
	};

	ARRfree(comp1);
	ARRfree(comp2);
	return(1);
}
