/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/div.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("div", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024
#define NPOINTS  1024

int FUNCdiv (OMobj_id in, int comp, OMobj_id out);

int DVdivrg_update(OMobj_id elem_id)
{
	OMobj_id in, out, elm;
	int comp;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out_nd"), OM_OBJ_RD);

	elm = OMfind_subobj(elem_id, OMstr_to_name("comp"), OM_OBJ_RD);
	OMget_int_val(elm, &comp);
	if (FUNCdiv(in, comp, out)) {
		return(1);
	}
	else return(0);
}

/* 64-bit porting. Only Modified Internally */
int FUNCdiv (OMobj_id in, int comp, OMobj_id out)
{
	xp_long nnodes;
	int   nspace, stat, out_type;
	xp_long size;
	int   veclen, ncomp;
	char  *node_data, *out_node_data;
	char  *mesh_info;
	int   dtype, null_flag;
	char  units[MAX_NAME_SIZE], label[MAX_NAME_SIZE];
	double null_value;

	/********************************/
	/*   Free pre-allocated arrays  */
	/********************************/
	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}


	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (nnodes == 0 || ncomp == 0) {
		return(1);
	}
	if (comp >= ncomp) {
		ERR_RETURN("requested component does not exist, div is not calculated");
	}
	if (FLDget_node_data_veclen(in, comp, &veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (veclen != 3) {
		ERR_RETURN("component is not 3-vector, div is not calculated");
	}

	if (FLDget_node_data(in, comp, &dtype, &node_data, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}
	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}

	/**** OUT DATA ***/
	if (FLDset_nnodes(out, nnodes) != 1) {
		ERR_RETURN("cannot set nnodes");
	}
	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	strcpy(units, "");
	strcpy(label, "div");

	if (FLDset_node_data_comp (out, 0, 1, label, units) != 1) {
		ERR_RETURN("Error setting node component");
	}
	out_type = DTYPE_FLOAT;
	if (FLDget_node_data(out, 0, &out_type, (char **)&out_node_data,
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("cannot get node data");
	}

	stat = UTILdiv(mesh_info, node_data, veclen, dtype,
			null_flag, (char *)&null_value, (float *)out_node_data);
	if (stat != 1) {
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		FLDfree_mesh_info (mesh_info);
		ARRfree(node_data);
		ARRfree(out_node_data);
		ERR_RETURN("div is not computed");
	}

	FLDfree_mesh_info (mesh_info);
	ARRfree(node_data);
	ARRfree(out_node_data);
	return(1);
}

