/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/dmath.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>

#define ERR_RETURN(A) ERRerror("data_math",1,ERR_ORIG, A); return(0);
#define MAX_STR_SIZE 1024

static char form[256]="in%d.node_data[0].values";


int DVdata_math_update(OMobj_id elem_id)
{
	OMobj_id out_id, op_id, id, type_id, sub_elem_id;
	char  *oper, *p, sym, *str, num[2], string[MAX_STR_SIZE];
	int type, stat, n, len;


	op_id = OMfind_subobj(elem_id, OMstr_to_name("operation"), OM_OBJ_RD);
	type_id = OMfind_subobj(elem_id, OMstr_to_name("data_type"), OM_OBJ_RD);
	out_id = OMfind_subobj(elem_id, OMstr_to_name("out_nd"), OM_OBJ_RW);
	if (OMis_null_obj(op_id))
		return(0);
	if (OMis_null_obj(type_id))
		return(0);
	if (OMis_null_obj(out_id))
		return(0);
	oper = NULL;
	stat = OMget_str_val(op_id, &oper, 0);
	if (stat != 1 || oper == NULL)
		return(0);

	stat = OMget_int_val(type_id, &type);
	if (stat != 1)
		return(0);

	sym = '#';
	p = oper;
	str = string;
	strcpy(str,"cache(");
	len = 6;
	while (*p) {
		if (*p == sym) {
			p++;
			num[0] = *p;
			num[1] = 0;
			sscanf(num, "%1d", &n);
			if (n<1 || n>4) {
				ERR_RETURN("Bad port index must be [1-4]");
			}
			if (len + strlen(form) > MAX_STR_SIZE) {
				ERR_RETURN("Expression is too long");
			}

			sprintf(str+len, form, n);
			len = len + (int)strlen(form)-1;

		}
		else {
			if (len  >= MAX_STR_SIZE) {
				ERR_RETURN("Expression is too long");
			}
			str[len++] = *p;
		}
		p++;
	}
	str[len]= *p;
	strcat(str,")");

	id = OMfind_subobj (out_id, OMstr_to_name("node_data"),
			     OM_OBJ_RW);
	if (OMis_null_obj(id))
		return(0);
	if (OMget_array_val(id, 0, &sub_elem_id, OM_OBJ_RW) < 0)
		return(0);
	if (OMis_null_obj(sub_elem_id))
		return(0);

	id = OMfind_subobj(sub_elem_id, OMstr_to_name("values"),
				 OM_OBJ_RW);
	if (OMis_null_obj(id))
		return(0);
	stat = OMset_data_type(id,type);
	if (stat != 1)
		return(stat);
	stat = OMparse_obj_ref(id,string);
	if (stat != 1)
		return(stat);
	if (oper)
		free(oper);
	return(1);
}

