/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/drw_line.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/mat.h>
#include <avs/gd.h>

#define ERR_RETURN(A) ERRerror("create_line", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCcreate_line (float *point, float *xform, int new, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVcreate_line_update(OMobj_id elem_id)
{
	OMobj_id in, out, xfm_id, id;
	int type, stat, pick, new, seq0, seq1;
	xp_long size;
	float *xyz, xform[4][4];

	id = OMfind_subobj(elem_id, OMstr_to_name("pick"), OM_OBJ_RW);
	stat = OMget_int_val(id, &pick);
	if (stat !=1)
		return(0);

	seq1 = OMget_obj_seq(id, OMnull_obj, OM_SEQ_VAL);
	id = OMfind_subobj(elem_id, OMstr_to_name("upd_create_line"), OM_OBJ_RD);
	seq0 = OMget_obj_seq(id, OMnull_obj, OM_SEQ_VAL);

	if (seq1 >= seq0)
		return(0);

	stat = OMget_name_int_val (elem_id, OMstr_to_name("new"), &new);
	if (stat !=1)
		return(0);
	if (new) {
		OMset_name_int_val (elem_id, OMstr_to_name("new_cell"), 1);
		OMset_name_int_val (elem_id, OMstr_to_name("new"), 0);
		return(0);
	}
	stat = OMget_name_int_val (elem_id, OMstr_to_name("new_cell"), &new);
	if (stat !=1)
		return(0);
	if (pick == 0)
		return(0);
	in = OMfind_subobj(elem_id, OMstr_to_name("picked_xyz"), OM_OBJ_RD);
	xfm_id = OMfind_subobj(elem_id, OMstr_to_name("picked_xform"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

	if (OMis_null_obj(in) || OMis_null_obj(out) || OMis_null_obj(xfm_id)) {
		return(0);
	}
	/* obtain the new coordinate information */
	type = OM_TYPE_FLOAT;
	xyz = (float *)0;
	size = 0;
	if (OMget_array_sz( in, &type, (char **)(&xyz), &size, OM_GET_ARRAY_RD ) != 1 ){
		ERR_RETURN("cannot get xyz");
	}
	GDxform_get_comp_matrix(xfm_id, (float *)xform);
	stat = FUNCcreate_line (xyz, (float *)xform, new, out);
	if (stat) {
		if (new) {
			stat = OMset_name_int_val (elem_id, OMstr_to_name("new_cell"), 0);
			if (stat !=1) {
				ERR_RETURN("cannot set new");
			}
		}
	}
	ARRfree(xyz);
	return(stat);
}

/* 64-bit porting. Only Modified Internally */
int FUNCcreate_line (float *point, float *xform, int new, OMobj_id out)
{
	OMobj_id cell_set;
	float xyz[3], *current_line; /* for the read */
	float *new_line; /* to increment */
	int nspace;
	xp_long nnodes, ncells, size;
    xp_long *out_nlist, *node_list;

	memcpy(xyz, point, 3*sizeof(float));
	MATvec3_mat4_multiply(xyz, (Matr4 *)xform);
	if (FLDget_nspace( out, &nspace) != 1) {
		ERR_RETURN("cannot get nspace" );
	}

        /* test to determine if this is the first time */
	if (FLDget_nnodes( out, &nnodes ) == 0 || nnodes == 0){
		nnodes = 2;
		ncells=1;
		if (FLDset_nnodes(out, nnodes )  != 1 ){
                	ERR_RETURN("cannot set nnodes" );
	        }
		new_line = (float *)ARRalloc(NULL, DTYPE_FLOAT, nspace*nnodes, NULL);
		if (new_line == NULL) {
			ERR_RETURN("cannot allocate data");
		}
		memcpy( new_line, xyz, sizeof (float) * nspace );
	        memcpy( new_line+nspace, xyz, sizeof(float)*nspace);
	        if (FLDset_coord(out, new_line, nnodes*nspace, OM_SET_ARRAY_FREE) != 1 ){
			ERR_RETURN("cannot set coord");
		}
		/* DO CONNECTIVITY */
		if (FLDget_cell_set(out, 0, &cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDset_npolys(cell_set, 1) != 1) {
			ERR_RETURN("cannot set ncells" );
		}
		out_nlist = (xp_long *)ARRalloc(NULL, DTYPE_LONG, 2*ncells, NULL);
		if (out_nlist == NULL) {
			ERR_RETURN("cannot allocate data");
		}
		out_nlist[0] = 0; out_nlist[1] = nnodes-1;
		if (FLDset_poly_connect(cell_set, out_nlist, 2,
					OM_SET_ARRAY_FREE) != 1) {
			ERR_RETURN("Error setting cell connect list");
		}
	}
	else {
	        if (FLDget_coord(out, &current_line, &size, OM_GET_ARRAY_RD ) != 1 ) {
                	ERR_RETURN ("cannot get coord");
		}
		nnodes++;
		if (new) {
			nnodes++;
			new_line = (float *)ARRalloc(NULL, DTYPE_FLOAT, nspace*nnodes, NULL);
			if (new_line == NULL) {
				ERR_RETURN("cannot allocate data");
			}
			memcpy( new_line, current_line, sizeof (float)*nspace*(nnodes-2) );
			memcpy( &new_line[nspace*(nnodes-2)], xyz, sizeof (float) * nspace );
			memcpy( &new_line[nspace*(nnodes-1)], xyz, sizeof (float) * nspace );
		}
		else {
			new_line = (float *)ARRalloc(NULL, DTYPE_FLOAT, nspace*nnodes, NULL);
			if (new_line == NULL) {
				ERR_RETURN("cannot allocate data");
			}
			memcpy( new_line, current_line, sizeof (float)*nspace*(nnodes-1) );
			memcpy( &new_line[nspace*(nnodes-1)], xyz, sizeof (float) * nspace );
		}
		ARRfree(current_line);
		if (FLDset_nnodes(out, nnodes )  != 1 ){
			ERR_RETURN ("cannot set nnodes");
		}
	        if (FLDset_coord(out, new_line, nnodes*nspace, OM_SET_ARRAY_FREE) != 1 ){
			ERR_RETURN("cannot set coord");
		}
		/* DO CONNECTIVITY */
		if (FLDget_cell_set(out, 0, &cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDget_npolys(cell_set, &ncells) != 1) {
			ERR_RETURN("cannot get ncells" );
		}
		if (FLDget_poly_connect(cell_set, &node_list, &size, OM_GET_ARRAY_RW) != 1) {
			ERR_RETURN("cannot get cell connectivity");
		}
		if (new) {
			ncells++;
			if (FLDset_npolys(cell_set, ncells) != 1) {
				ERR_RETURN("cannot set ncells" );
			}
			out_nlist = (xp_long *)ARRalloc(NULL, DTYPE_LONG, 2*ncells, NULL);
			if (out_nlist == NULL) {
				ERR_RETURN("cannot allocate data");
			}

			memcpy(out_nlist, node_list, 2*(ncells-1)*sizeof(xp_long));
			ARRfree(node_list);
			out_nlist[2*(ncells-1)] = nnodes-2;
			out_nlist[2*(ncells-1)+1] = nnodes-1;
			if (FLDset_poly_connect(cell_set, out_nlist, 2*ncells,
						OM_SET_ARRAY_FREE) != 1) {
				ERR_RETURN("Error setting cell connect list");
			}
		}
		else {
			node_list[2*(ncells-1)+1] = nnodes-1;
			ARRfree(node_list);
		}
	}
	return(1);
}


