/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/expl_mat.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>

#define ERR_RETURN(A) ERRerror("explode_mat", 0, ERR_ORIG, A); return(0);
#define MAX_CELL_SETS 256

int FUNCexplode_mat (OMobj_id in, int prop, OMobj_id nfld_id, OMobj_id out);

int DVexplode_mat_update(OMobj_id elem_id)
{
	OMobj_id in, out, nfld_id, prop_id;
	int prop, stat;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out_sets"), OM_OBJ_RW);
	prop_id = OMfind_subobj(elem_id, OMstr_to_name("property"), OM_OBJ_RD);
	nfld_id = OMfind_subobj(elem_id, OMstr_to_name("nfld"), OM_OBJ_RD);
	stat = OMget_int_val(prop_id, &prop);
	if (stat !=1) return(0);
	if (FUNCexplode_mat(in, prop, nfld_id, out)) {
		return(1);
	}
	else return(0);
}

int FUNCexplode_mat (OMobj_id in, int prop, OMobj_id nfld_id, OMobj_id out)
{
	int  stat, nsets, nfld, *set_ind, i, cs, size, found, nprops;
	float *fld_prop, *props;
	OMobj_id   cell_set, fld, out_set;

	nfld = 0;

	if (FLDget_ncell_sets(in, &nsets) != 1) {
		ERR_RETURN("cannot get nsets");
	}
	if (nsets == 0) {
		if (OMset_int_val(nfld_id, nfld) != 1) {
			ERR_RETURN("cannot set number of output fields");
		}
		return(0);
	}
	set_ind = (int *)malloc(nsets*sizeof(int));
	fld_prop = (float *)malloc(nsets*sizeof(float));
	for (cs=0; cs<nsets; cs++)
		set_ind[cs] = -1;

	for (cs=0; cs<nsets; cs++) {
		if (FLDget_cell_set(in, cs, &cell_set) != 1) {
			ERR_RETURN("cannot get cell set");
		}
		if (FLDget_cell_nprops(cell_set, &nprops) !=1)
			nprops = 0;
		if (nprops == 0)
			continue;
		if (FLDget_cell_props(cell_set, &props, &size, OM_GET_ARRAY_RD)!=1) {
			ERR_RETURN("cannot get cell property");
		}
		if (prop >= nprops)
			continue;
		if (nfld == 0) {
			set_ind[cs] = nfld;
			fld_prop[nfld] = props[prop];
			nfld++;
		}
		else {
			for (i=0, found=0; i<nfld; i++) {
				if (fld_prop[i] == props[prop]) {
					set_ind[cs] = i;
					found = 1;
					break;
				}
			}
			if (!found) {
				set_ind[cs] = nfld;
				fld_prop[nfld] = props[prop];
				nfld++;
			}
		}
		ARRfree(props);
	}

	if (OMset_int_val(nfld_id, nfld) != 1) {
		ERR_RETURN("cannot set number of output fields");
	}

	for (i=0; i<nfld; i++) {
		if (OMget_array_val(out, i, &fld, OM_OBJ_RW) != 1) {
			ERR_RETURN("Error getting output field sub-array");
		}

		out_set = OMfind_subobj(fld, OMstr_to_name("cell_set"),OM_OBJ_RW);
		if (OMis_null_obj(out_set)) {
			ERR_RETURN("cannot find out_sets object");
		}
		stat = OMset_obj_ref(out_set, OMnull_obj, 0);
		if (stat != 1) {
			ERR_RETURN("cannot reset out_sets object");
		}

		for (cs=0; cs<nsets; cs++) {
			if (set_ind[cs] == i) {
				if (FLDget_cell_set(in, cs, &cell_set) != 1) {
					ERR_RETURN("cannot get cell set");
				}
				if ((stat = OMadd_obj_ref(out_set, cell_set, 0)) != 1) {
					ERR_RETURN("cannot add cell set reference");
				}
			}
		}
	}
	free((char *)set_ind);
	free((char *)fld_prop);
	return(1);
}

