/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/expl_xfm.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>

#define ERR_RETURN(A) ERRerror("explode_xform", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024
#define NPOINTS  1024

static float IXFORM[16] = {1.0, 0.0, 0.0, 0.0,
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 1.0, 0.0,
			   0.0, 0.0, 0.0, 1.0};

/* 64-bit porting. Only Modified Internally */
int DVexplode_xform_update(OMobj_id elem_id)
{
	OMobj_id in, out, elm, fld;
	double x_factor, y_factor, z_factor;
	float  factor[3];
	float mat[16], xlate[3], *center, center0[3];
	float min_ext0[3], max_ext0[3], min_ext[3], max_ext[3];
	xp_long nfld, i;
	int j, stat;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

	stat = OMget_array_size(in, &nfld);
	if (stat != 1 || nfld == 0)
		return(0);

	elm = OMfind_subobj(elem_id, OMstr_to_name("x_factor"), OM_OBJ_RD);
	stat = OMget_real_val(elm, &x_factor);
	if (stat != 1) {
		ERR_RETURN("cannot get x_factor");
	}
	elm = OMfind_subobj(elem_id, OMstr_to_name("y_factor"), OM_OBJ_RD);
	stat = OMget_real_val(elm, &y_factor);
	if (stat != 1) {
		ERR_RETURN("cannot get y_factor");
	}
	elm = OMfind_subobj(elem_id, OMstr_to_name("z_factor"), OM_OBJ_RD);
	stat = OMget_real_val(elm, &z_factor);
	if (stat != 1) {
		ERR_RETURN("cannot get z_factor");
	}

	center = (float *)malloc(3*nfld*sizeof(float));

	factor[0] = x_factor;
	factor[1] = y_factor;
	factor[2] = z_factor;

	for (i=0; i<3; i++) {
		min_ext[i]=0;
		max_ext[i]=0;
	}
	for (i=0; i<nfld; i++) {
		if (OMget_array_val(in, i, &fld, OM_OBJ_RD) != 1) {
			ERR_RETURN("Error getting input field sub-array");
		}
		/*
		 * Currently the OM is not properly validating inputs of
		 * modules that input an array of fields so we must just
		 * do the return ourselves.
		 */
		if (FLDget_coord_extent(fld, min_ext, max_ext) != 1) {
			return(0);
		}

		for (j=0; j<3; j++)
			center[i*3+j] = 0.5*(min_ext[j] + max_ext[j]);

		if (i==0) {
			for (j=0; j<3; j++) {
				min_ext0[j] = min_ext[j];
				max_ext0[j] = max_ext[j];
			}
		}
		else {
			for (j=0; j<3; j++) {
				if (min_ext[j] < min_ext0[j])
					min_ext0[j] = min_ext[j];
				if (max_ext[j] > max_ext0[j])
					max_ext0[j] = max_ext[j];
			}
		}
	}
	for (j=0; j<3; j++)
		center0[j] = 0.5*(max_ext0[j] + min_ext0[j]);

	for (i=0; i<nfld; i++) {
		if (OMget_array_val(out, i, &fld, OM_OBJ_RW) != 1) {
			ERR_RETURN("Error getting output field sub-array");
		}
		for (j=0; j<3; j++)
			xlate[j] = factor[j]*(center[i*3+j] - center0[j]);
		memcpy(mat, IXFORM, 16*sizeof(float));
		memcpy(mat+12, xlate, 3*sizeof(float));
		if (FLDset_xform(fld, mat) != 1) {
			ERR_RETURN("cannot set xform for output field");
		}
	}

	free(center);
	return(1);
}
