/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/extr_cll.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>

#define ERR_RETURN(A) ERRerror("extract cell data",1,ERR_ORIG, A); return(0);

/* 64-bit porting. Only Modified Internally */
int DVextr_cell_comp_update(OMobj_id elem_id)
{
	OMobj_id out_sets, out, out_set, sets, e;
	int    stat;
	xp_long i, size;

	out_sets = OMfind_subobj(elem_id, OMstr_to_name("out_sets"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out_cd"), OM_OBJ_RW);
	sets = OMfind_subobj(out, OMstr_to_name("cell_set"), OM_OBJ_RW);

	stat = OMset_obj_ref(sets, OMnull_obj, 0);
	if (stat != 1) {
		ERR_RETURN("cannot set out cell set to NULL");
	}
	stat = OMget_array_size(out_sets, &size);
	if (stat != 1)
		return(0);
	for (i=0; i<size; i++) {

		if ((stat = OMget_array_val(out_sets, i, &e, OM_OBJ_RW)) != 1) {
			ERR_RETURN("cannot get array sub-element of out_sets");
		}
		out_set = OMfind_subobj(e, OMstr_to_name("out_set"), OM_OBJ_RD);
		if (OMis_null_obj(out_set)) {
			ERR_RETURN("cannot find out_set");
		}
		if ((stat = OMadd_obj_ref(sets, out_set, 0)) != 1) {
			ERR_RETURN("cannot add ref");
		}
	}
	return(1);
}



