/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/filter.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/dtype.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("filter_1d", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCfilter_1d (OMobj_id in, int nkern, float *kernels, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVfilter_1d_update(OMobj_id elem_id)
{
	OMobj_id in, out,e_id;
	int  stat, type;
	xp_long size;
	float *kernels;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("kernels"),
				 OM_OBJ_RD);
	kernels = NULL;
	size = 0;
	type = DTYPE_FLOAT;
	stat = OMget_array_sz(e_id, &type, (char **)&kernels, &size,
			   OM_GET_ARRAY_RD);
	if (stat != 1)
		return(0);

	stat = FUNCfilter_1d(in, (int)size, kernels, out);
	ARRfree(kernels);
	if (stat == 1) return(1);
	else return(0);
}

/* 64-bit porting. Only Modified Internally */
int FUNCfilter_1d (OMobj_id in, int nkern, float *kernels, OMobj_id out)
{
	int   stat, veclen;
	xp_long nnodes, size;
	int   data_type, null_flag;
	char   *in_node_data, *out_node_data;
	double null_value;

	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDget_node_data_veclen(in, 0, &veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (FLDset_node_data_veclen(out, 0, veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (FLDget_node_data(in, 0, &data_type, &in_node_data,
			     &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_null_data(in, 0, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}
	if (FLDget_node_data(out, 0, &data_type, &out_node_data,
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting node data");
	}

	stat = UTILfilter_1d(nkern, kernels, nnodes, veclen, data_type,
			      in_node_data, out_node_data);
	if (stat != 1) {
		ERR_RETURN("Error filtering data");
	}
	if(null_flag) {
		if (FLDset_node_null_data(out, 0, (char *)&null_value, data_type) != 1) {
			ERR_RETURN("Error setting null value");
		}
	}
	else {
		if (FLDset_node_null_flag(out, 0, 0) != 1) {
			ERR_RETURN("Error setting null flag");
		}
	}
	if (FLDcopy_node_minmax(in, out, 0, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	if (FLDcopy_node_minmax_vec(in, out, 0, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	ARRfree(in_node_data);
	ARRfree(out_node_data);
	return(1);
}

