/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/fit_poly.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("least_squares", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCleast_squares (OMobj_id in, xp_long order, double *coeff, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVleast_squares_update(OMobj_id elem_id)
{
	OMobj_id in, out, elm;
	int stat, type, order;
	xp_long size;
	double *coeff;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
	elm = OMfind_subobj(elem_id, OMstr_to_name("order"), OM_OBJ_RD);
	OMget_int_val(elm, &order);

	elm = OMfind_subobj(elem_id, OMstr_to_name("coeff"), OM_OBJ_RW);
	size = 0;
	type = DTYPE_DOUBLE;
	coeff = NULL;
	stat = OMget_array_sz(elm, &type, (char **)(&coeff),
		    &size, OM_GET_ARRAY_RW);

	stat = FUNCleast_squares(in, order, coeff, out);
	ARRfree(coeff);
	if (stat == 1) return(1);
	else return(0);
}

/* 64-bit porting. Directly Modified */
int FUNCleast_squares (OMobj_id in, xp_long order, double *coeff, OMobj_id out)
{
	xp_long nnodes, size;
	int    nspace, veclen, type, stat;
	float  *coord;
	char   *node_data, *out_node_data;

	/*--------------------------------------*/
	/*  Make out to be the same as in       */
	/*--------------------------------------*/
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (order >= nnodes) {
		ERR_RETURN("order should be less then number of points; least_squares fitting is not performed");
	}
	if (order < 1) {
		ERR_RETURN("order should be greater 0; least_squares fitting is not performed");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_coord(in, &coord, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get coordinates");
	}
	if (nspace != 1) {
		ERR_RETURN("nspace should be 1; least_squares fitting is not performed");
	}
	if (FLDget_node_data_veclen(in, 0, &veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (veclen != 1) {
		ERR_RETURN("veclen should be 1; least_squares fitting is not performed");
	}
	if (FLDget_node_data(in, 0, &type, &node_data,
			     &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}

	stat = UTILleast_squares(nnodes, coord, type, node_data, order+1, coeff);

	ARRfree(node_data);
	if (stat != 1) {
		ARRfree(coord);
		ERR_RETURN("singular matrix; least_squares fitting is not performed");
	}

	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDset_node_data_veclen(out, 0, veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	type = DTYPE_DOUBLE;
	if (FLDget_node_data(out, 0, &type, &out_node_data,
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting node data");
	}

	UTILeval_polynom(order+1, coeff, nnodes, coord, out_node_data, type);

	ARRfree(coord);
	ARRfree(out_node_data);
	return(1);
}

